/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.gui.fieldeditors;

import java.awt.Color;
import java.awt.Dimension;
import java.lang.reflect.InvocationTargetException;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import net.sf.jabref.Globals;
import net.sf.jabref.gui.GUIGlobals;
import net.sf.jabref.gui.autocompleter.AutoCompleteListener;
import net.sf.jabref.gui.fieldeditors.FieldEditor;
import net.sf.jabref.gui.fieldeditors.FieldEditorFocusListener;
import net.sf.jabref.gui.fieldeditors.FieldNameLabel;
import net.sf.jabref.gui.fieldeditors.JTextAreaWithHighlighting;
import net.sf.jabref.gui.fieldeditors.contextmenu.FieldTextMenu;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TextArea
extends JTextAreaWithHighlighting
implements FieldEditor {
    private static final Log LOGGER = LogFactory.getLog(TextArea.class);
    private final JScrollPane scrollPane;
    private final FieldNameLabel label;
    private String fieldName;
    private AutoCompleteListener autoCompleteListener;

    public TextArea(String fieldName, String content) {
        this(fieldName, content, "");
    }

    public TextArea(String fieldName, String content, String title) {
        super(content, title);
        this.updateFont();
        this.addFocusListener(Globals.getFocusListener());
        this.addFocusListener(new FieldEditorFocusListener());
        this.scrollPane = new JScrollPane(this, 20, 31);
        this.scrollPane.setMinimumSize(new Dimension(200, 1));
        this.setLineWrap(true);
        this.setWrapStyleWord(true);
        this.fieldName = fieldName;
        this.label = new FieldNameLabel(fieldName);
        this.setBackground(GUIGlobals.validFieldBackgroundColor);
        this.setForeground(GUIGlobals.editorTextColor);
        FieldTextMenu popMenu = new FieldTextMenu(this);
        this.addMouseListener(popMenu);
        this.label.addMouseListener(popMenu);
    }

    @Override
    public Dimension getPreferredScrollableViewportSize() {
        return this.getPreferredSize();
    }

    @Override
    public String getFieldName() {
        return this.fieldName;
    }

    public void setFieldName(String newName) {
        this.fieldName = newName;
    }

    @Override
    public JLabel getLabel() {
        return this.label;
    }

    @Override
    public void setLabelColor(Color color) {
        this.label.setForeground(color);
    }

    @Override
    public JComponent getPane() {
        return this.scrollPane;
    }

    @Override
    public JComponent getTextComponent() {
        return this;
    }

    @Override
    public void setActiveBackgroundColor() {
        this.setBackgroundColor(GUIGlobals.activeBackgroundColor);
    }

    @Override
    public void setValidBackgroundColor() {
        this.setBackgroundColor(GUIGlobals.validFieldBackgroundColor);
    }

    @Override
    public void setInvalidBackgroundColor() {
        this.setBackgroundColor(GUIGlobals.invalidFieldBackgroundColor);
    }

    private void setBackgroundColor(Color color) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.setBackground(color);
        } else {
            try {
                SwingUtilities.invokeAndWait(() -> this.setBackground(color));
            }
            catch (InterruptedException | InvocationTargetException e) {
                LOGGER.info("Problem setting background color", e);
            }
        }
    }

    @Override
    public void updateFontColor() {
        this.setForeground(GUIGlobals.editorTextColor);
    }

    @Override
    public void updateFont() {
        this.setFont(GUIGlobals.currentFont);
    }

    @Override
    public void paste(String textToInsert) {
        this.replaceSelection(textToInsert);
    }

    @Override
    public void undo() {
    }

    @Override
    public void redo() {
    }

    @Override
    public void setAutoCompleteListener(AutoCompleteListener listener) {
        this.autoCompleteListener = listener;
    }

    @Override
    public void clearAutoCompleteSuggestion() {
        if (this.autoCompleteListener != null) {
            this.autoCompleteListener.clearCurrentSuggestion(this);
        }
    }
}

