/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.gui.fieldeditors;

import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.io.IOException;
import java.io.StringWriter;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.TransferHandler;
import javax.swing.text.BadLocationException;
import net.sf.jabref.gui.EntryContainer;
import net.sf.jabref.gui.JabRefFrame;
import net.sf.jabref.gui.fieldeditors.FileListEditorTransferHandler;
import net.sf.jabref.gui.fieldeditors.HtmlTransferable;
import net.sf.jabref.logic.l10n.Localization;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PreviewPanelTransferHandler
extends FileListEditorTransferHandler {
    private static final Log LOGGER = LogFactory.getLog(PreviewPanelTransferHandler.class);

    public PreviewPanelTransferHandler(JabRefFrame frame, EntryContainer entryContainer, TransferHandler textTransferHandler) {
        super(frame, entryContainer, textTransferHandler);
    }

    @Override
    public int getSourceActions(JComponent component) {
        return 1;
    }

    @Override
    protected Transferable createTransferable(JComponent component) {
        if (component instanceof JEditorPane) {
            JEditorPane editorPane = (JEditorPane)component;
            StringWriter stringWriter = new StringWriter();
            try {
                editorPane.getEditorKit().write(stringWriter, editorPane.getDocument(), editorPane.getSelectionStart(), editorPane.getSelectionEnd());
            }
            catch (IOException | BadLocationException e) {
                LOGGER.warn("Cannot write preview", e);
            }
            return new HtmlTransferable(stringWriter.toString(), editorPane.getSelectedText());
        }
        return new StringSelection(Localization.lang("Operation not supported", new String[0]));
    }
}

