/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.gui.fieldeditors;

import java.awt.event.ActionEvent;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.AbstractAction;
import javax.swing.KeyStroke;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultHighlighter;
import javax.swing.text.Document;
import javax.swing.text.Highlighter;
import javax.swing.text.Keymap;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoManager;
import net.sf.jabref.Globals;
import net.sf.jabref.gui.actions.PasteAction;
import net.sf.jabref.gui.keyboard.KeyBinding;
import net.sf.jabref.gui.util.component.JTextAreaWithPlaceholder;
import net.sf.jabref.logic.search.SearchQueryHighlightListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JTextAreaWithHighlighting
extends JTextAreaWithPlaceholder
implements SearchQueryHighlightListener {
    private static final Log LOGGER = LogFactory.getLog(JTextAreaWithHighlighting.class);
    private Optional<Pattern> highlightPattern = Optional.empty();
    private UndoManager undo;

    public JTextAreaWithHighlighting() {
        this("");
    }

    public JTextAreaWithHighlighting(String text) {
        this(text, "");
    }

    public JTextAreaWithHighlighting(String text, String placeholder) {
        super(text, placeholder);
        this.setupUndoRedo();
        this.setupPasteListener();
    }

    private void setupPasteListener() {
        this.getActionMap().put("paste", new PasteAction(this));
        this.getInputMap().put(Globals.getKeyPrefs().getKey(KeyBinding.PASTE), "paste");
    }

    private void setupUndoRedo() {
        this.undo = new UndoManager();
        Document doc = this.getDocument();
        doc.addUndoableEditListener(evt -> this.undo.addEdit(evt.getEdit()));
        this.getActionMap().put("Undo", new AbstractAction("Undo"){

            @Override
            public void actionPerformed(ActionEvent evt) {
                try {
                    if (JTextAreaWithHighlighting.this.undo.canUndo()) {
                        JTextAreaWithHighlighting.this.undo.undo();
                    }
                }
                catch (CannotUndoException cannotUndoException) {
                    // empty catch block
                }
            }
        });
        this.getInputMap().put(Globals.getKeyPrefs().getKey(KeyBinding.UNDO), "Undo");
        this.getActionMap().put("Redo", new AbstractAction("redo"){

            @Override
            public void actionPerformed(ActionEvent evt) {
                try {
                    if (JTextAreaWithHighlighting.this.undo.canRedo()) {
                        JTextAreaWithHighlighting.this.undo.redo();
                    }
                }
                catch (CannotRedoException cannotRedoException) {
                    // empty catch block
                }
            }
        });
        boolean bind = true;
        KeyStroke redoKey = Globals.getKeyPrefs().getKey(KeyBinding.REDO);
        if (Globals.prefs.getBoolean("editorEMACSkeyBindings")) {
            int i;
            Keymap keymap = this.getKeymap();
            KeyStroke[] keys = keymap.getBoundKeyStrokes();
            for (i = 0; i < keys.length && !keys[i].equals(redoKey); ++i) {
            }
            if (i < keys.length) {
                bind = false;
            }
        }
        if (bind) {
            this.getInputMap().put(redoKey, "Redo");
        }
    }

    private void highLight() {
        Highlighter highlighter = this.getHighlighter();
        highlighter.removeAllHighlights();
        if (this.highlightPattern == null || !this.highlightPattern.isPresent()) {
            return;
        }
        String content = this.getText();
        if (content.isEmpty()) {
            return;
        }
        this.highlightPattern.ifPresent(pattern -> {
            Matcher matcher = pattern.matcher(content);
            while (matcher.find()) {
                try {
                    highlighter.addHighlight(matcher.start(), matcher.end(), DefaultHighlighter.DefaultPainter);
                }
                catch (BadLocationException ble) {
                    LOGGER.warn("Highlighting not possible, bad location", ble);
                }
            }
        });
    }

    @Override
    public void setText(String text) {
        super.setText(text);
        this.highLight();
        if (this.undo != null) {
            this.undo.discardAllEdits();
        }
    }

    @Override
    public void highlightPattern(Optional<Pattern> highlightPattern) {
        this.highlightPattern = highlightPattern;
        this.highLight();
    }
}

