/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.gui.fieldeditors;

import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import net.sf.jabref.gui.EntryContainer;
import net.sf.jabref.gui.JabRefFrame;
import net.sf.jabref.gui.externalfiles.DroppedFileHandler;
import net.sf.jabref.gui.externalfiletype.ExternalFileType;
import net.sf.jabref.gui.externalfiletype.ExternalFileTypes;
import net.sf.jabref.gui.groups.EntryTableTransferHandler;
import net.sf.jabref.logic.util.io.FileUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

class FileListEditorTransferHandler
extends TransferHandler {
    private DataFlavor urlFlavor;
    private final DataFlavor stringFlavor;
    private final JabRefFrame frame;
    private final EntryContainer entryContainer;
    private final TransferHandler textTransferHandler;
    private DroppedFileHandler droppedFileHandler;
    private static final Log LOGGER = LogFactory.getLog(FileListEditorTransferHandler.class);

    public FileListEditorTransferHandler(JabRefFrame frame, EntryContainer entryContainer, TransferHandler textTransferHandler) {
        this.frame = frame;
        this.entryContainer = entryContainer;
        this.textTransferHandler = textTransferHandler;
        this.stringFlavor = DataFlavor.stringFlavor;
        try {
            this.urlFlavor = new DataFlavor("application/x-java-url; class=java.net.URL");
        }
        catch (ClassNotFoundException e) {
            LOGGER.info("Unable to configure drag and drop for file link table", e);
        }
    }

    @Override
    public int getSourceActions(JComponent c) {
        return 0x40000001;
    }

    @Override
    public void exportToClipboard(JComponent comp, Clipboard clip, int action) {
        if (this.textTransferHandler != null) {
            this.textTransferHandler.exportToClipboard(comp, clip, action);
        }
    }

    @Override
    public boolean importData(JComponent comp, Transferable t) {
        DataFlavor[] inflavs;
        try {
            ArrayList<File> files = new ArrayList<File>();
            if (t.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                List transferedFiles = (List)t.getTransferData(DataFlavor.javaFileListFlavor);
                files.addAll(transferedFiles);
            }
            if (t.isDataFlavorSupported(this.urlFlavor)) {
                URL dropLink = (URL)t.getTransferData(this.urlFlavor);
                LOGGER.debug("URL: " + dropLink);
            }
            if (t.isDataFlavorSupported(this.stringFlavor)) {
                String dropStr = (String)t.getTransferData(this.stringFlavor);
                files.addAll(EntryTableTransferHandler.getFilesFromDraggedFilesString(dropStr));
            }
            SwingUtilities.invokeLater(() -> {
                for (File file : files) {
                    String name = file.getAbsolutePath();
                    FileUtil.getFileExtension(name).ifPresent(extension -> ExternalFileTypes.getInstance().getExternalFileTypeByExt((String)extension).ifPresent(fileType -> {
                        if (this.droppedFileHandler == null) {
                            this.droppedFileHandler = new DroppedFileHandler(this.frame, this.frame.getCurrentBasePanel());
                        }
                        this.droppedFileHandler.handleDroppedfile(name, (ExternalFileType)fileType, this.entryContainer.getEntry());
                    }));
                }
            });
            if (!files.isEmpty()) {
                return true;
            }
        }
        catch (IOException ioe) {
            LOGGER.warn("Failed to read dropped data. ", ioe);
        }
        catch (UnsupportedFlavorException | ClassCastException ufe) {
            LOGGER.warn("Drop type error. ", ufe);
        }
        StringBuilder logMessage = new StringBuilder("Cannot transfer input:");
        for (DataFlavor inflav : inflavs = t.getTransferDataFlavors()) {
            logMessage.append(' ').append(inflav);
        }
        LOGGER.warn(logMessage.toString());
        return false;
    }

    @Override
    public boolean canImport(JComponent comp, DataFlavor[] transferFlavors) {
        for (DataFlavor inflav : transferFlavors) {
            if (!inflav.match(this.urlFlavor) && !inflav.match(this.stringFlavor) && !inflav.match(DataFlavor.javaFileListFlavor)) continue;
            return true;
        }
        return false;
    }
}

