/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.gui.fieldeditors;

import com.jgoodies.forms.builder.FormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.table.TableCellRenderer;
import net.sf.jabref.Globals;
import net.sf.jabref.JabRefExecutorService;
import net.sf.jabref.gui.IconTheme;
import net.sf.jabref.gui.JabRefFrame;
import net.sf.jabref.gui.autocompleter.AutoCompleteListener;
import net.sf.jabref.gui.desktop.JabRefDesktop;
import net.sf.jabref.gui.entryeditor.EntryEditor;
import net.sf.jabref.gui.externalfiles.AutoSetLinks;
import net.sf.jabref.gui.externalfiles.DownloadExternalFile;
import net.sf.jabref.gui.externalfiles.MoveFileAction;
import net.sf.jabref.gui.externalfiletype.ExternalFileType;
import net.sf.jabref.gui.externalfiletype.ExternalFileTypes;
import net.sf.jabref.gui.fieldeditors.FieldEditor;
import net.sf.jabref.gui.fieldeditors.FieldNameLabel;
import net.sf.jabref.gui.fieldeditors.FileListEditorTransferHandler;
import net.sf.jabref.gui.filelist.FileListEntry;
import net.sf.jabref.gui.filelist.FileListEntryEditor;
import net.sf.jabref.gui.filelist.FileListTableModel;
import net.sf.jabref.gui.keyboard.KeyBinding;
import net.sf.jabref.gui.util.GUIUtil;
import net.sf.jabref.logic.l10n.Localization;
import net.sf.jabref.logic.util.io.FileUtil;
import net.sf.jabref.model.database.BibDatabaseContext;
import net.sf.jabref.model.entry.BibEntry;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FileListEditor
extends JTable
implements FieldEditor,
DownloadExternalFile.DownloadCallback {
    private static final Log LOGGER = LogFactory.getLog(FileListEditor.class);
    private final FieldNameLabel label;
    private FileListEntryEditor editor;
    private final JabRefFrame frame;
    private final BibDatabaseContext databaseContext;
    private final String fieldName;
    private final EntryEditor entryEditor;
    private final JPanel panel;
    private final FileListTableModel tableModel;
    private final JButton auto;
    private final JPopupMenu menu = new JPopupMenu();

    public FileListEditor(JabRefFrame frame, BibDatabaseContext databaseContext, String fieldName, String content, EntryEditor entryEditor) {
        this.frame = frame;
        this.databaseContext = databaseContext;
        this.fieldName = fieldName;
        this.entryEditor = entryEditor;
        this.label = new FieldNameLabel(fieldName);
        this.tableModel = new FileListTableModel();
        this.setText(content);
        this.setModel(this.tableModel);
        JScrollPane sPane = new JScrollPane(this);
        this.setTableHeader(null);
        this.addMouseListener(new TableClickListener());
        GUIUtil.correctRowHeight(this);
        JButton add = new JButton(IconTheme.JabRefIcon.ADD_NOBOX.getSmallIcon());
        add.setToolTipText(Localization.lang("New file link (INSERT)", new String[0]));
        JButton remove = new JButton(IconTheme.JabRefIcon.REMOVE_NOBOX.getSmallIcon());
        remove.setToolTipText(Localization.lang("Remove file link (DELETE)", new String[0]));
        JButton up = new JButton(IconTheme.JabRefIcon.UP.getSmallIcon());
        JButton down = new JButton(IconTheme.JabRefIcon.DOWN.getSmallIcon());
        this.auto = new JButton(Localization.lang("Get fulltext", new String[0]));
        JButton download = new JButton(Localization.lang("Download from URL", new String[0]));
        add.setMargin(new Insets(0, 0, 0, 0));
        remove.setMargin(new Insets(0, 0, 0, 0));
        up.setMargin(new Insets(0, 0, 0, 0));
        down.setMargin(new Insets(0, 0, 0, 0));
        add.addActionListener(e -> this.addEntry());
        remove.addActionListener(e -> this.removeEntries());
        up.addActionListener(e -> this.moveEntry(-1));
        down.addActionListener(e -> this.moveEntry(1));
        this.auto.addActionListener(e -> this.autoSetLinks());
        download.addActionListener(e -> this.downloadFile());
        FormBuilder builder = FormBuilder.create().layout(new FormLayout("fill:pref,1dlu,fill:pref,1dlu,fill:pref", "fill:pref,fill:pref"));
        builder.add(up).xy(1, 1);
        builder.add(add).xy(3, 1);
        builder.add(this.auto).xy(5, 1);
        builder.add(down).xy(1, 2);
        builder.add(remove).xy(3, 2);
        builder.add(download).xy(5, 2);
        this.panel = new JPanel();
        this.panel.setLayout(new BorderLayout());
        this.panel.add((Component)sPane, "Center");
        this.panel.add((Component)builder.getPanel(), "East");
        FileListEditorTransferHandler transferHandler = new FileListEditorTransferHandler(frame, entryEditor, null);
        this.setTransferHandler(transferHandler);
        this.panel.setTransferHandler(transferHandler);
        this.getInputMap().put(KeyStroke.getKeyStroke("DELETE"), "delete");
        this.getActionMap().put("delete", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int row = FileListEditor.this.getSelectedRow();
                FileListEditor.this.removeEntries();
                row = Math.min(row, FileListEditor.this.getRowCount() - 1);
                if (row >= 0) {
                    FileListEditor.this.setRowSelectionInterval(row, row);
                }
            }
        });
        this.getInputMap().put(KeyStroke.getKeyStroke("INSERT"), "insert");
        this.getActionMap().put("insert", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FileListEditor.this.addEntry();
            }
        });
        this.getInputMap().put(Globals.getKeyPrefs().getKey(KeyBinding.FILE_LIST_EDITOR_MOVE_ENTRY_UP), "move up");
        this.getActionMap().put("move up", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FileListEditor.this.moveEntry(-1);
            }
        });
        this.getInputMap().put(Globals.getKeyPrefs().getKey(KeyBinding.FILE_LIST_EDITOR_MOVE_ENTRY_DOWN), "move down");
        this.getActionMap().put("move down", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FileListEditor.this.moveEntry(1);
            }
        });
        JMenuItem openLink = new JMenuItem(Localization.lang("Open", new String[0]));
        this.menu.add(openLink);
        openLink.addActionListener(e -> this.openSelectedFile());
        JMenuItem openFolder = new JMenuItem(Localization.lang("Open folder", new String[0]));
        this.menu.add(openFolder);
        openFolder.addActionListener(e -> {
            int row = this.getSelectedRow();
            if (row >= 0) {
                FileListEntry entry = this.tableModel.getEntry(row);
                try {
                    String path = "";
                    if (Paths.get(entry.link, new String[0]).isAbsolute()) {
                        path = Paths.get(entry.link, new String[0]).toString();
                    } else {
                        for (String folder : databaseContext.getFileDirectory(Globals.prefs.getFileDirectoryPreferences())) {
                            Path file = Paths.get(folder, entry.link);
                            if (!Files.exists(file, new LinkOption[0])) continue;
                            path = file.toString();
                            break;
                        }
                    }
                    if (!path.isEmpty()) {
                        JabRefDesktop.openFolderAndSelectFile(path);
                    } else {
                        JOptionPane.showMessageDialog(frame, Localization.lang("File not found", new String[0]), Localization.lang("Error", new String[0]), 0);
                    }
                }
                catch (IOException ex) {
                    LOGGER.debug("Cannot open folder", ex);
                }
            }
        });
        JMenuItem rename = new JMenuItem(Localization.lang("Move/Rename file", new String[0]));
        this.menu.add(rename);
        rename.addActionListener(new MoveFileAction(frame, entryEditor, this, false));
        JMenuItem moveToFileDir = new JMenuItem(Localization.lang("Move file to file directory", new String[0]));
        this.menu.add(moveToFileDir);
        moveToFileDir.addActionListener(new MoveFileAction(frame, entryEditor, this, true));
        JMenuItem deleteFile = new JMenuItem(Localization.lang("Delete local file", new String[0]));
        this.menu.add(deleteFile);
        deleteFile.addActionListener(e -> {
            int row = this.getSelectedRow();
            if (row != -1) {
                FileListEntry entry = this.tableModel.getEntry(row);
                Optional<File> file = FileUtil.expandFilename(databaseContext, entry.link, Globals.prefs.getFileDirectoryPreferences());
                try {
                    if (file.isPresent()) {
                        Files.delete(file.get().toPath());
                    }
                    this.removeEntries();
                }
                catch (IOException ex) {
                    JOptionPane.showMessageDialog(frame, Localization.lang("File permission error", new String[0]), Localization.lang("Cannot delete file", new String[0]), 0);
                    LOGGER.warn("File permission error while deleting: " + entry.link, ex);
                }
            }
        });
        this.adjustColumnWidth();
    }

    public void adjustColumnWidth() {
        for (int column = 0; column < this.getColumnCount(); ++column) {
            int width = 0;
            for (int row = 0; row < this.getRowCount(); ++row) {
                TableCellRenderer renderer = this.getCellRenderer(row, column);
                Component comp = this.prepareRenderer(renderer, row, column);
                width = Math.max(comp.getPreferredSize().width, width);
            }
            this.columnModel.getColumn(column).setPreferredWidth(width);
        }
    }

    private void openSelectedFile() {
        int row = this.getSelectedRow();
        if (row >= 0) {
            FileListEntry entry = this.tableModel.getEntry(row);
            try {
                Optional<ExternalFileType> type = ExternalFileTypes.getInstance().getExternalFileTypeByName(entry.type.get().getName());
                JabRefDesktop.openExternalFileAnyFormat(this.databaseContext, entry.link, type.isPresent() ? type : entry.type);
            }
            catch (IOException e) {
                LOGGER.warn("Cannot open selected file.", e);
            }
        }
    }

    public FileListTableModel getTableModel() {
        return this.tableModel;
    }

    @Override
    public String getFieldName() {
        return this.fieldName;
    }

    @Override
    public JComponent getPane() {
        return this.panel;
    }

    @Override
    public JComponent getTextComponent() {
        return this;
    }

    @Override
    public JLabel getLabel() {
        return this.label;
    }

    @Override
    public void setLabelColor(Color color) {
        this.label.setForeground(color);
    }

    @Override
    public String getText() {
        return this.tableModel.getStringRepresentation();
    }

    @Override
    public void setText(String newText) {
        this.tableModel.setContent(newText);
    }

    @Override
    public void append(String text) {
    }

    @Override
    public void updateFont() {
    }

    @Override
    public void paste(String textToInsert) {
    }

    @Override
    public String getSelectedText() {
        return null;
    }

    private void addEntry(String initialLink) {
        FileListEntry entry;
        int row = this.getSelectedRow();
        if (row == -1) {
            row = 0;
        }
        if (this.editListEntry(entry = new FileListEntry("", initialLink), true)) {
            this.tableModel.addEntry(row, entry);
        }
        this.entryEditor.updateField(this);
        this.adjustColumnWidth();
    }

    private void addEntry() {
        List<String> defaultDirectory = this.databaseContext.getFileDirectory(Globals.prefs.getFileDirectoryPreferences());
        if (defaultDirectory.isEmpty() || defaultDirectory.get(0) == null) {
            this.addEntry("");
        } else {
            this.addEntry(defaultDirectory.get(0));
        }
    }

    private void removeEntries() {
        int[] rows = this.getSelectedRows();
        if (rows != null) {
            for (int i = rows.length - 1; i >= 0; --i) {
                this.tableModel.removeEntry(rows[i]);
            }
        }
        this.entryEditor.updateField(this);
        this.adjustColumnWidth();
    }

    private void moveEntry(int i) {
        int[] sel = this.getSelectedRows();
        if (sel.length != 1 || this.tableModel.getRowCount() < 2) {
            return;
        }
        int toIdx = sel[0] + i;
        if (toIdx >= this.tableModel.getRowCount()) {
            toIdx -= this.tableModel.getRowCount();
        }
        if (toIdx < 0) {
            toIdx += this.tableModel.getRowCount();
        }
        FileListEntry entry = this.tableModel.getEntry(sel[0]);
        this.tableModel.removeEntry(sel[0]);
        this.tableModel.addEntry(toIdx, entry);
        this.entryEditor.updateField(this);
        this.setRowSelectionInterval(toIdx, toIdx);
        this.adjustColumnWidth();
    }

    private boolean editListEntry(FileListEntry entry, boolean openBrowse) {
        if (this.editor == null) {
            this.editor = new FileListEntryEditor(this.frame, entry, false, true, this.databaseContext);
        } else {
            this.editor.setEntry(entry);
        }
        this.editor.setVisible(true, openBrowse);
        if (this.editor.okPressed()) {
            this.tableModel.fireTableDataChanged();
        }
        this.entryEditor.updateField(this);
        this.adjustColumnWidth();
        return this.editor.okPressed();
    }

    public void autoSetLinks() {
        this.auto.setEnabled(false);
        ArrayList<BibEntry> entries = new ArrayList<BibEntry>(this.frame.getCurrentBasePanel().getSelectedEntries());
        JDialog dialog = new JDialog((Frame)this.frame, true);
        JabRefExecutorService.INSTANCE.execute(AutoSetLinks.autoSetLinks(entries, null, null, this.tableModel, this.databaseContext, e -> {
            this.auto.setEnabled(true);
            if (e.getID() > 0) {
                this.entryEditor.updateField(this);
                this.adjustColumnWidth();
                this.frame.output(Localization.lang("Finished automatically setting external links.", new String[0]));
            } else {
                this.frame.output(Localization.lang("Finished automatically setting external links.", new String[0]) + " " + Localization.lang("No files found.", new String[0]));
                this.frame.getCurrentBasePanel().runCommand("downloadFullText");
            }
            this.auto.setEnabled(true);
        }, dialog));
    }

    private void downloadFile() {
        int answer;
        Optional<String> bibtexKey = this.entryEditor.getEntry().getCiteKeyOptional();
        if (!bibtexKey.isPresent() && (answer = JOptionPane.showConfirmDialog(this.frame, Localization.lang("This entry has no BibTeX key. Generate key now?", new String[0]), Localization.lang("Download file", new String[0]), 2, 3)) == 0) {
            EntryEditor.GenerateKeyAction l = this.entryEditor.getGenerateKeyAction();
            l.actionPerformed(null);
            bibtexKey = this.entryEditor.getEntry().getCiteKeyOptional();
        }
        DownloadExternalFile def = new DownloadExternalFile(this.frame, this.frame.getCurrentBasePanel().getBibDatabaseContext(), this.entryEditor.getEntry());
        try {
            def.download(this);
        }
        catch (IOException ex) {
            LOGGER.warn("Cannot download.", ex);
        }
    }

    @Override
    public void downloadComplete(FileListEntry file) {
        this.tableModel.addEntry(this.tableModel.getRowCount(), file);
        this.entryEditor.updateField(this);
        this.adjustColumnWidth();
    }

    @Override
    public void undo() {
    }

    @Override
    public void redo() {
    }

    @Override
    public void setAutoCompleteListener(AutoCompleteListener listener) {
    }

    @Override
    public void clearAutoCompleteSuggestion() {
    }

    @Override
    public void setActiveBackgroundColor() {
    }

    @Override
    public void setValidBackgroundColor() {
    }

    @Override
    public void setInvalidBackgroundColor() {
    }

    @Override
    public void updateFontColor() {
    }

    class TableClickListener
    extends MouseAdapter {
        TableClickListener() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (e.getButton() == 1 && e.getClickCount() == 2) {
                int row = FileListEditor.this.rowAtPoint(e.getPoint());
                if (row >= 0) {
                    FileListEntry entry = FileListEditor.this.tableModel.getEntry(row);
                    FileListEditor.this.editListEntry(entry, false);
                }
            } else if (e.isPopupTrigger()) {
                this.processPopupTrigger(e);
            }
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (e.isPopupTrigger()) {
                this.processPopupTrigger(e);
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (e.isPopupTrigger()) {
                this.processPopupTrigger(e);
            }
        }

        private void processPopupTrigger(MouseEvent e) {
            int row = FileListEditor.this.rowAtPoint(e.getPoint());
            if (row >= 0) {
                FileListEditor.this.setRowSelectionInterval(row, row);
                FileListEditor.this.menu.show(FileListEditor.this, e.getX(), e.getY());
            }
        }
    }
}

