/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.gui.fieldeditors;

import com.jgoodies.forms.builder.FormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import net.sf.jabref.Globals;
import net.sf.jabref.gui.IconTheme;
import net.sf.jabref.gui.JabRefFrame;
import net.sf.jabref.gui.autocompleter.AutoCompleteListener;
import net.sf.jabref.gui.entryeditor.EntryEditor;
import net.sf.jabref.gui.fieldeditors.FieldEditor;
import net.sf.jabref.gui.fieldeditors.FieldNameLabel;
import net.sf.jabref.gui.keyboard.KeyBinding;
import net.sf.jabref.logic.l10n.Localization;
import net.sf.jabref.logic.layout.Layout;
import net.sf.jabref.logic.layout.LayoutHelper;
import net.sf.jabref.model.database.BibDatabase;
import net.sf.jabref.model.database.BibDatabaseContext;
import net.sf.jabref.model.entry.BibEntry;
import net.sf.jabref.model.entry.EntryLinkList;
import net.sf.jabref.model.entry.ParsedEntryLink;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class EntryLinkListEditor
extends JTable
implements FieldEditor {
    private static final Log LOGGER = LogFactory.getLog(EntryLinkListEditor.class);
    private final FieldNameLabel label;
    private final JabRefFrame frame;
    private final BibDatabaseContext databaseContext;
    private final String fieldName;
    private final EntryEditor entryEditor;
    private final JPanel panel;
    private final EntryLinkListTableModel tableModel;
    private final JPopupMenu menu = new JPopupMenu();
    private final boolean singleEntry;
    private final JButton add = new JButton(IconTheme.JabRefIcon.ADD_NOBOX.getSmallIcon());
    private final JButton remove = new JButton(IconTheme.JabRefIcon.REMOVE_NOBOX.getSmallIcon());
    private static final String layoutFormat = "\\begin{author}\\format[Authors(2,1),LatexToUnicode]{\\author}\\end{author}\\begin{title}, \"\\format[LatexToUnicode]{\\title}\"\\end{title}\\begin{year}, \\year\\end{year}";

    public EntryLinkListEditor(JabRefFrame frame, BibDatabaseContext databaseContext, String fieldName, String content, EntryEditor entryEditor, boolean singleEntry) {
        this.frame = frame;
        this.databaseContext = databaseContext;
        this.fieldName = fieldName;
        this.entryEditor = entryEditor;
        this.singleEntry = singleEntry;
        this.label = new FieldNameLabel(fieldName);
        this.tableModel = new EntryLinkListTableModel(EntryLinkList.parse(content, databaseContext.getDatabase()));
        this.setText(content);
        this.setModel(this.tableModel);
        JScrollPane sPane = new JScrollPane(this);
        this.setTableHeader(null);
        this.addMouseListener(new TableClickListener());
        this.add.setToolTipText("New entry link (INSERT)");
        this.remove.setToolTipText("Remove entry link (DELETE)");
        this.add.setMargin(new Insets(0, 0, 0, 0));
        this.remove.setMargin(new Insets(0, 0, 0, 0));
        this.add.addActionListener(e -> this.addEntry());
        this.remove.addActionListener(e -> this.removeEntries());
        FormBuilder builder = FormBuilder.create().layout(new FormLayout("fill:pref:grow,1dlu,fill:pref:grow", "fill:pref,fill:pref,1dlu,fill:pref"));
        if (!singleEntry) {
            JButton up = new JButton(IconTheme.JabRefIcon.UP.getSmallIcon());
            JButton down = new JButton(IconTheme.JabRefIcon.DOWN.getSmallIcon());
            up.setMargin(new Insets(0, 0, 0, 0));
            down.setMargin(new Insets(0, 0, 0, 0));
            up.addActionListener(e -> this.moveEntry(-1));
            down.addActionListener(e -> this.moveEntry(1));
            builder.add(up).xy(1, 1);
            builder.add(down).xy(1, 2);
        }
        builder.add(this.add).xy(3, 1);
        builder.add(this.remove).xy(3, 2);
        JButton button = new JButton(Localization.lang("Select", new String[0]));
        button.addActionListener(e -> this.selectEntry());
        builder.add(button).xyw(1, 4, 3);
        this.panel = new JPanel();
        this.panel.setLayout(new BorderLayout());
        this.panel.add((Component)sPane, "Center");
        this.panel.add((Component)builder.getPanel(), "East");
        this.getInputMap().put(KeyStroke.getKeyStroke("DELETE"), "delete");
        this.getActionMap().put("delete", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int row = EntryLinkListEditor.this.getSelectedRow();
                EntryLinkListEditor.this.removeEntries();
                row = Math.min(row, EntryLinkListEditor.this.getRowCount() - 1);
                if (row >= 0) {
                    EntryLinkListEditor.this.setRowSelectionInterval(row, row);
                }
            }
        });
        this.getInputMap().put(KeyStroke.getKeyStroke("INSERT"), "insert");
        this.getActionMap().put("insert", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int row = EntryLinkListEditor.this.getSelectedRow();
                EntryLinkListEditor.this.addEntry();
                EntryLinkListEditor.this.setRowSelectionInterval(row, row);
            }
        });
        this.getInputMap().put(Globals.getKeyPrefs().getKey(KeyBinding.FILE_LIST_EDITOR_MOVE_ENTRY_UP), "move up");
        this.getActionMap().put("move up", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                EntryLinkListEditor.this.moveEntry(-1);
            }
        });
        this.getInputMap().put(Globals.getKeyPrefs().getKey(KeyBinding.FILE_LIST_EDITOR_MOVE_ENTRY_DOWN), "move down");
        this.getActionMap().put("move down", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                EntryLinkListEditor.this.moveEntry(1);
            }
        });
        JMenuItem openLink = new JMenuItem(Localization.lang("Select", new String[0]));
        this.menu.add(openLink);
        openLink.addActionListener(e -> this.selectEntry());
        FontMetrics metrics = this.getFontMetrics(this.getFont());
        this.setRowHeight(Math.max(this.getRowHeight(), metrics.getHeight()));
        this.updateButtonStates();
    }

    private void selectEntry() {
        int selectedRow = this.getSelectedRow();
        if (selectedRow != -1) {
            String crossref = this.tableModel.getEntry(selectedRow).getKey();
            this.frame.getCurrentBasePanel().getDatabase().getEntryByKey(crossref).ifPresent(entry -> this.frame.getCurrentBasePanel().highlightEntry((BibEntry)entry));
        }
    }

    public void adjustColumnWidth() {
        for (int column = 0; column < this.getColumnCount(); ++column) {
            int width = 0;
            for (int row = 0; row < this.getRowCount(); ++row) {
                TableCellRenderer renderer = this.getCellRenderer(row, column);
                Component comp = this.prepareRenderer(renderer, row, column);
                width = Math.max(comp.getPreferredSize().width, width);
            }
            this.columnModel.getColumn(column).setPreferredWidth(width);
        }
    }

    @Override
    public String getFieldName() {
        return this.fieldName;
    }

    @Override
    public JComponent getPane() {
        return this.panel;
    }

    @Override
    public JComponent getTextComponent() {
        return this;
    }

    @Override
    public JLabel getLabel() {
        return this.label;
    }

    @Override
    public void setLabelColor(Color color) {
        this.label.setForeground(color);
    }

    @Override
    public String getText() {
        return this.tableModel.getText();
    }

    @Override
    public void setText(String newText) {
        this.tableModel.setContent(EntryLinkList.parse(newText, this.databaseContext.getDatabase()));
        this.adjustColumnWidth();
        this.updateButtonStates();
    }

    @Override
    public void append(String text) {
    }

    @Override
    public void updateFont() {
    }

    @Override
    public void paste(String textToInsert) {
    }

    @Override
    public String getSelectedText() {
        return null;
    }

    private void addEntry() {
        int row = this.getSelectedRow();
        if (row == -1) {
            row = 0;
        }
        ParsedEntryLink entry = new ParsedEntryLink("", this.databaseContext.getDatabase());
        this.tableModel.addEntry(row, entry);
        this.entryEditor.updateField(this);
        this.adjustColumnWidth();
        this.updateButtonStates();
    }

    private void removeEntries() {
        int[] rows = this.getSelectedRows();
        if (rows != null) {
            for (int i = rows.length - 1; i >= 0; --i) {
                this.tableModel.removeEntry(rows[i]);
            }
        }
        this.entryEditor.updateField(this);
        this.adjustColumnWidth();
        this.updateButtonStates();
    }

    private void updateButtonStates() {
        if (this.singleEntry) {
            if (this.tableModel.isEmpty()) {
                this.add.setEnabled(true);
                this.remove.setEnabled(false);
            } else {
                this.add.setEnabled(false);
                this.remove.setEnabled(true);
            }
        }
    }

    private void moveEntry(int i) {
        int[] sel = this.getSelectedRows();
        if (sel.length != 1 || this.tableModel.getRowCount() < 2) {
            return;
        }
        int toIdx = sel[0] + i;
        if (toIdx >= this.tableModel.getRowCount()) {
            toIdx -= this.tableModel.getRowCount();
        }
        if (toIdx < 0) {
            toIdx += this.tableModel.getRowCount();
        }
        ParsedEntryLink entry = this.tableModel.getEntry(sel[0]);
        this.tableModel.removeEntry(sel[0]);
        this.tableModel.addEntry(toIdx, entry);
        this.entryEditor.updateField(this);
        this.setRowSelectionInterval(toIdx, toIdx);
        this.adjustColumnWidth();
    }

    @Override
    public void undo() {
    }

    @Override
    public void redo() {
    }

    @Override
    public void setAutoCompleteListener(AutoCompleteListener listener) {
    }

    @Override
    public void clearAutoCompleteSuggestion() {
    }

    @Override
    public void setActiveBackgroundColor() {
    }

    @Override
    public void setValidBackgroundColor() {
    }

    @Override
    public void setInvalidBackgroundColor() {
    }

    @Override
    public void updateFontColor() {
    }

    private static String formatEntry(BibEntry entry, BibDatabase database) {
        StringReader sr = new StringReader(layoutFormat);
        try {
            Layout layout = new LayoutHelper(sr, Globals.prefs.getLayoutFormatterPreferences(Globals.journalAbbreviationLoader)).getLayoutFromText();
            return layout.doLayout(entry, database);
        }
        catch (IOException e) {
            LOGGER.warn("Problem generating entry layout", e);
            return "";
        }
    }

    private class EntryLinkListTableModel
    extends DefaultTableModel {
        private final List<ParsedEntryLink> internalList = Collections.synchronizedList(new ArrayList());

        public EntryLinkListTableModel(List<ParsedEntryLink> originalList) {
            this.addEntries(originalList);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String getText() {
            List<ParsedEntryLink> list = this.internalList;
            synchronized (list) {
                String result = EntryLinkList.serialize(this.internalList);
                return result;
            }
        }

        public void addEntries(List<ParsedEntryLink> newList) {
            this.internalList.addAll(newList);
            if (SwingUtilities.isEventDispatchThread()) {
                this.fireTableDataChanged();
            } else {
                SwingUtilities.invokeLater(() -> this.fireTableDataChanged());
            }
        }

        public void setContent(List<ParsedEntryLink> newList) {
            this.internalList.clear();
            this.internalList.addAll(newList);
            if (SwingUtilities.isEventDispatchThread()) {
                this.fireTableDataChanged();
            } else {
                SwingUtilities.invokeLater(() -> this.fireTableDataChanged());
            }
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int getRowCount() {
            if (this.internalList == null) {
                return 0;
            }
            List<ParsedEntryLink> list = this.internalList;
            synchronized (list) {
                return this.internalList.size();
            }
        }

        public Class<String> getColumnClass(int columnIndex) {
            return String.class;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            List<ParsedEntryLink> list = this.internalList;
            synchronized (list) {
                ParsedEntryLink entry = this.internalList.get(rowIndex);
                switch (columnIndex) {
                    case 0: {
                        return entry.getKey();
                    }
                    case 1: {
                        return entry.getLinkedEntry().map(bibEntry -> EntryLinkListEditor.formatEntry(bibEntry, entry.getDataBase())).orElse("Unknown entry");
                    }
                }
                return null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ParsedEntryLink getEntry(int index) {
            List<ParsedEntryLink> list = this.internalList;
            synchronized (list) {
                return this.internalList.get(index);
            }
        }

        public void removeEntry(int index) {
            this.internalList.remove(index);
            if (SwingUtilities.isEventDispatchThread()) {
                this.fireTableRowsDeleted(index, index);
            } else {
                SwingUtilities.invokeLater(() -> this.fireTableRowsDeleted(index, index));
            }
        }

        public boolean isEmpty() {
            return this.internalList.isEmpty();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addEntry(int index, ParsedEntryLink entry) {
            List<ParsedEntryLink> list = this.internalList;
            synchronized (list) {
                this.internalList.add(index, entry);
                if (SwingUtilities.isEventDispatchThread()) {
                    this.fireTableDataChanged();
                } else {
                    SwingUtilities.invokeLater(() -> this.fireTableDataChanged());
                }
            }
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            return column == 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            List<ParsedEntryLink> list = this.internalList;
            synchronized (list) {
                if (columnIndex == 0) {
                    this.internalList.get(rowIndex).setKey((String)aValue);
                    if (SwingUtilities.isEventDispatchThread()) {
                        this.fireTableRowsUpdated(rowIndex, rowIndex);
                    } else {
                        SwingUtilities.invokeLater(() -> this.fireTableRowsUpdated(rowIndex, rowIndex));
                    }
                }
            }
        }
    }

    class TableClickListener
    extends MouseAdapter {
        TableClickListener() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (e.getButton() == 1 && e.getClickCount() == 2) {
                Optional<BibEntry> entry;
                int row = EntryLinkListEditor.this.rowAtPoint(e.getPoint());
                if (row >= 0 && (entry = EntryLinkListEditor.this.tableModel.getEntry(row).getLinkedEntry()).isPresent()) {
                    EntryLinkListEditor.this.frame.getCurrentBasePanel().highlightEntry(entry.get());
                }
            } else if (e.isPopupTrigger()) {
                this.processPopupTrigger(e);
            }
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (e.isPopupTrigger()) {
                this.processPopupTrigger(e);
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (e.isPopupTrigger()) {
                this.processPopupTrigger(e);
            }
        }

        private void processPopupTrigger(MouseEvent e) {
            int row = EntryLinkListEditor.this.rowAtPoint(e.getPoint());
            if (row >= 0) {
                EntryLinkListEditor.this.setRowSelectionInterval(row, row);
                EntryLinkListEditor.this.menu.show(EntryLinkListEditor.this, e.getX(), e.getY());
            }
        }
    }
}

