/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.gui.externalfiletype;

import com.jgoodies.forms.builder.ButtonBarBuilder;
import com.jgoodies.forms.builder.ButtonStackBuilder;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import net.sf.jabref.Globals;
import net.sf.jabref.gui.IconTheme;
import net.sf.jabref.gui.JabRefFrame;
import net.sf.jabref.gui.actions.MnemonicAwareAction;
import net.sf.jabref.gui.externalfiletype.ExternalFileType;
import net.sf.jabref.gui.externalfiletype.ExternalFileTypeEntryEditor;
import net.sf.jabref.gui.externalfiletype.ExternalFileTypes;
import net.sf.jabref.gui.keyboard.KeyBinding;
import net.sf.jabref.gui.util.GUIUtil;
import net.sf.jabref.logic.l10n.Localization;

public class ExternalFileTypeEditor
extends JDialog {
    private JFrame frame;
    private JDialog dialog;
    private List<ExternalFileType> fileTypes;
    private JTable table;
    private ExternalFileTypeEntryEditor entryEditor;
    private FileTypeTableModel tableModel;
    private final JButton ok = new JButton(Localization.lang("OK", new String[0]));
    private final JButton cancel = new JButton(Localization.lang("Cancel", new String[0]));
    private final JButton add = new JButton(IconTheme.JabRefIcon.ADD_NOBOX.getIcon());
    private final JButton remove = new JButton(IconTheme.JabRefIcon.REMOVE_NOBOX.getIcon());
    private final JButton edit = new JButton(IconTheme.JabRefIcon.EDIT.getIcon());
    private final JButton toDefaults = new JButton(Localization.lang("Default", new String[0]));
    private final EditListener editListener = new EditListener();

    private ExternalFileTypeEditor(JFrame frame) {
        super(frame, Localization.lang("Manage external file types", new String[0]), true);
        this.frame = frame;
        this.init();
    }

    private ExternalFileTypeEditor(JDialog dialog) {
        super(dialog, Localization.lang("Manage external file types", new String[0]), true);
        this.dialog = dialog;
        this.init();
    }

    private void setValues() {
        this.fileTypes.clear();
        Set<ExternalFileType> types = ExternalFileTypes.getInstance().getExternalFileTypeSelection();
        for (ExternalFileType type : types) {
            this.fileTypes.add(type.copy());
        }
        Collections.sort(this.fileTypes);
    }

    private void storeSettings() {
        ExternalFileTypes.getInstance().setExternalFileTypes(this.fileTypes);
    }

    private void init() {
        this.ok.addActionListener(e -> {
            this.storeSettings();
            this.dispose();
        });
        AbstractAction cancelAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ExternalFileTypeEditor.this.dispose();
            }
        };
        this.cancel.addActionListener(cancelAction);
        this.toDefaults.addActionListener(e -> {
            List<ExternalFileType> list = ExternalFileTypes.getDefaultExternalFileTypes();
            this.fileTypes.clear();
            this.fileTypes.addAll(list);
            Collections.sort(this.fileTypes);
            this.tableModel.fireTableDataChanged();
        });
        this.add.addActionListener(e -> {
            ExternalFileType type = new ExternalFileType("", "", "", "", "new", IconTheme.JabRefIcon.FILE.getSmallIcon());
            this.getEditor(type).setVisible(true);
            if (this.entryEditor.okPressed()) {
                this.fileTypes.add(type);
                this.tableModel.fireTableDataChanged();
            }
        });
        this.remove.addActionListener(e -> {
            int[] rows = this.table.getSelectedRows();
            if (rows.length == 0) {
                return;
            }
            for (int i = rows.length - 1; i >= 0; --i) {
                this.fileTypes.remove(rows[i]);
            }
            this.tableModel.fireTableDataChanged();
            if (!this.fileTypes.isEmpty()) {
                int row = Math.min(rows[0], this.fileTypes.size() - 1);
                this.table.setRowSelectionInterval(row, row);
            }
        });
        this.edit.addActionListener(this.editListener);
        this.fileTypes = new ArrayList<ExternalFileType>();
        this.setValues();
        this.tableModel = new FileTypeTableModel();
        this.table = new JTable(this.tableModel);
        this.table.setDefaultRenderer(ImageIcon.class, new IconRenderer());
        this.table.addMouseListener(new TableClickListener());
        this.table.getColumnModel().getColumn(0).setMaxWidth(24);
        this.table.getColumnModel().getColumn(0).setMinWidth(24);
        this.table.getColumnModel().getColumn(1).setMinWidth(170);
        this.table.getColumnModel().getColumn(2).setMinWidth(60);
        this.table.getColumnModel().getColumn(3).setMinWidth(100);
        this.table.getColumnModel().getColumn(0).setResizable(false);
        GUIUtil.correctRowHeight(this.table);
        JScrollPane sp = new JScrollPane(this.table);
        JPanel upper = new JPanel();
        upper.setLayout(new BorderLayout());
        upper.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        upper.add((Component)sp, "Center");
        this.getContentPane().add((Component)upper, "Center");
        ButtonStackBuilder bs = new ButtonStackBuilder();
        bs.addButton((JComponent)this.add);
        bs.addButton((JComponent)this.remove);
        bs.addButton((JComponent)this.edit);
        bs.addRelatedGap();
        bs.addButton((JComponent)this.toDefaults);
        upper.add((Component)bs.getPanel(), "East");
        ButtonBarBuilder bb = new ButtonBarBuilder();
        bb.addGlue();
        bb.addButton((JComponent)this.ok);
        bb.addButton((JComponent)this.cancel);
        bb.addGlue();
        bb.getPanel().setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.getContentPane().add((Component)bb.getPanel(), "South");
        this.pack();
        ActionMap am = upper.getActionMap();
        InputMap im = upper.getInputMap(2);
        im.put(Globals.getKeyPrefs().getKey(KeyBinding.CLOSE_DIALOG), "close");
        am.put("close", cancelAction);
        am = bb.getPanel().getActionMap();
        im = bb.getPanel().getInputMap(2);
        im.put(Globals.getKeyPrefs().getKey(KeyBinding.CLOSE_DIALOG), "close");
        am.put("close", cancelAction);
        if (this.frame == null) {
            this.setLocationRelativeTo(this.dialog);
        } else {
            this.setLocationRelativeTo(this.frame);
        }
    }

    private ExternalFileTypeEntryEditor getEditor(ExternalFileType type) {
        if (this.entryEditor == null) {
            this.entryEditor = new ExternalFileTypeEntryEditor(this, type);
        } else {
            this.entryEditor.setEntry(type);
        }
        return this.entryEditor;
    }

    public static AbstractAction getAction(JabRefFrame frame) {
        return new EditExternalFileTypesAction(frame);
    }

    public static AbstractAction getAction(JDialog dialog) {
        return new EditExternalFileTypesAction(dialog);
    }

    public static class EditExternalFileTypesAction
    extends MnemonicAwareAction {
        private JabRefFrame frame;
        private JDialog dialog;
        private ExternalFileTypeEditor editor;

        public EditExternalFileTypesAction(JabRefFrame frame) {
            this.putValue("Name", Localization.menuTitle("Manage external file types", new String[0]));
            this.frame = frame;
        }

        public EditExternalFileTypesAction(JDialog dialog) {
            this.putValue("Name", Localization.menuTitle("Manage external file types", new String[0]));
            this.dialog = dialog;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (this.editor == null) {
                this.editor = this.frame == null ? new ExternalFileTypeEditor(this.dialog) : new ExternalFileTypeEditor(this.frame);
            }
            this.editor.setValues();
            this.editor.setVisible(true);
            if (this.frame != null && this.frame.getCurrentBasePanel() != null) {
                this.frame.getCurrentBasePanel().getMainTable().repaint();
            }
        }
    }

    class TableClickListener
    extends MouseAdapter {
        TableClickListener() {
        }

        private void handleClick(MouseEvent e) {
            if (e.getClickCount() == 2) {
                ExternalFileTypeEditor.this.editListener.actionPerformed(null);
            }
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            this.handleClick(e);
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.handleClick(e);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.handleClick(e);
        }
    }

    private class FileTypeTableModel
    extends AbstractTableModel {
        private FileTypeTableModel() {
        }

        @Override
        public int getColumnCount() {
            return 5;
        }

        @Override
        public int getRowCount() {
            return ExternalFileTypeEditor.this.fileTypes.size();
        }

        @Override
        public String getColumnName(int column) {
            switch (column) {
                case 0: {
                    return " ";
                }
                case 1: {
                    return Localization.lang("Name", new String[0]);
                }
                case 2: {
                    return Localization.lang("Extension", new String[0]);
                }
                case 3: {
                    return Localization.lang("MIME type", new String[0]);
                }
            }
            return Localization.lang("Application", new String[0]);
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            if (columnIndex == 0) {
                return ImageIcon.class;
            }
            return String.class;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            ExternalFileType type = (ExternalFileType)ExternalFileTypeEditor.this.fileTypes.get(rowIndex);
            switch (columnIndex) {
                case 0: {
                    return type.getIcon();
                }
                case 1: {
                    return type.getName();
                }
                case 2: {
                    return type.getExtension();
                }
                case 3: {
                    return type.getMimeType();
                }
            }
            return type.getOpenWithApplication();
        }
    }

    static class IconRenderer
    implements TableCellRenderer {
        private final JLabel lab = new JLabel();

        IconRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable tab, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            this.lab.setText(null);
            this.lab.setIcon((Icon)value);
            return this.lab;
        }
    }

    class EditListener
    implements ActionListener {
        EditListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int[] rows = ExternalFileTypeEditor.this.table.getSelectedRows();
            if (rows.length != 1) {
                return;
            }
            ExternalFileTypeEditor.this.getEditor((ExternalFileType)ExternalFileTypeEditor.this.fileTypes.get(rows[0])).setVisible(true);
            if (ExternalFileTypeEditor.this.entryEditor.okPressed()) {
                ExternalFileTypeEditor.this.tableModel.fireTableDataChanged();
            }
        }
    }
}

