/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.gui.externalfiletype;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.Optional;
import javax.swing.Icon;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import net.sf.jabref.gui.JabRefFrame;
import net.sf.jabref.gui.desktop.JabRefDesktop;
import net.sf.jabref.gui.externalfiletype.ExternalFileType;
import net.sf.jabref.gui.externalfiletype.ExternalFileTypes;
import net.sf.jabref.gui.externalfiletype.UnknownExternalFileType;
import net.sf.jabref.logic.l10n.Localization;
import net.sf.jabref.model.database.BibDatabaseContext;
import net.sf.jabref.model.entry.BibEntry;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ExternalFileMenuItem
extends JMenuItem
implements ActionListener {
    private static final Log LOGGER = LogFactory.getLog(ExternalFileMenuItem.class);
    private final BibEntry entry;
    private final String link;
    private final BibDatabaseContext databaseContext;
    private Optional<ExternalFileType> fileType;
    private final JabRefFrame frame;
    private String fieldName;

    public ExternalFileMenuItem(JabRefFrame frame, BibEntry entry, String name, String link, Icon icon, BibDatabaseContext databaseContext, Optional<ExternalFileType> fileType) {
        super(name, icon);
        this.frame = frame;
        this.entry = entry;
        this.link = link;
        this.databaseContext = databaseContext;
        this.fileType = fileType;
        this.addActionListener(this);
    }

    public ExternalFileMenuItem(JabRefFrame frame, BibEntry entry, String name, String link, Icon icon, BibDatabaseContext databaseContext, String fieldName) {
        this(frame, entry, name, link, icon, databaseContext, Optional.empty());
        this.fieldName = fieldName;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        boolean success = this.openLink();
        if (!success) {
            this.frame.output(Localization.lang("Unable to open link.", new String[0]));
        }
    }

    public boolean openLink() {
        this.frame.output(Localization.lang("External viewer called", new String[0]) + ".");
        try {
            Optional<ExternalFileType> type = this.fileType;
            if (!this.fileType.isPresent()) {
                if (this.fieldName == null) {
                    File file = new File(this.link);
                    String name = file.getName();
                    int pos = name.indexOf(46);
                    String extension = pos >= 0 && pos < name.length() - 1 ? name.substring(pos + 1).trim().toLowerCase() : null;
                    this.fileType = type = ExternalFileTypes.getInstance().getExternalFileTypeByExt(extension);
                } else {
                    JabRefDesktop.openExternalViewer(this.databaseContext, this.link, this.fieldName);
                    return true;
                }
            }
            if (type.isPresent() && type.get() instanceof UnknownExternalFileType) {
                return JabRefDesktop.openExternalFileUnknown(this.frame, this.entry, this.databaseContext, this.link, (UnknownExternalFileType)type.get());
            }
            return JabRefDesktop.openExternalFileAnyFormat(this.databaseContext, this.link, type);
        }
        catch (IOException e1) {
            if (this.fileType.isPresent() && !this.fileType.get().getOpenWithApplication().isEmpty() && e1.getMessage().contains(this.fileType.get().getOpenWithApplication())) {
                JOptionPane.showMessageDialog(this.frame, Localization.lang("Unable to open link. The application '%0' associated with the file type '%1' could not be called.", this.fileType.get().getOpenWithApplication(), this.fileType.get().getName()), Localization.lang("Could not open link", new String[0]), 0);
                return false;
            }
            LOGGER.warn("Unable to open link", e1);
            return false;
        }
    }
}

