/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.gui.externalfiles;

import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.xml.transform.TransformerException;
import net.sf.jabref.Globals;
import net.sf.jabref.gui.BasePanel;
import net.sf.jabref.gui.IconTheme;
import net.sf.jabref.gui.entryeditor.EntryEditor;
import net.sf.jabref.gui.filelist.FileListEntry;
import net.sf.jabref.gui.filelist.FileListTableModel;
import net.sf.jabref.gui.worker.AbstractWorker;
import net.sf.jabref.logic.l10n.Localization;
import net.sf.jabref.logic.util.io.FileUtil;
import net.sf.jabref.logic.xmp.XMPUtil;
import net.sf.jabref.model.entry.BibEntry;

public class WriteXMPEntryEditorAction
extends AbstractAction {
    private final BasePanel panel;
    private final EntryEditor editor;
    private String message;

    public WriteXMPEntryEditorAction(BasePanel panel, EntryEditor editor) {
        this.panel = panel;
        this.editor = editor;
        this.putValue("Name", Localization.lang("Write XMP", new String[0]));
        this.putValue("SmallIcon", IconTheme.JabRefIcon.WRITE_XMP.getIcon());
        this.putValue("ShortDescription", Localization.lang("Write BibTeXEntry as XMP-metadata to PDF.", new String[0]));
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        this.setEnabled(false);
        this.panel.output(Localization.lang("Writing XMP-metadata...", new String[0]));
        this.panel.frame().setProgressBarIndeterminate(true);
        this.panel.frame().setProgressBarVisible(true);
        BibEntry entry = this.editor.getEntry();
        ArrayList<File> files = new ArrayList<File>();
        entry.getField("pdf").ifPresent(pdf -> FileUtil.expandFilename(pdf, this.panel.getBibDatabaseContext().getFileDirectory("pdf", Globals.prefs.getFileDirectoryPreferences())).ifPresent(files::add));
        List<String> dirs = this.panel.getBibDatabaseContext().getFileDirectory(Globals.prefs.getFileDirectoryPreferences());
        if (entry.hasField("file")) {
            FileListTableModel tm = new FileListTableModel();
            entry.getField("file").ifPresent(tm::setContent);
            for (int j = 0; j < tm.getRowCount(); ++j) {
                FileListEntry flEntry = tm.getEntry(j);
                if (!flEntry.type.isPresent() || !"pdf".equalsIgnoreCase(flEntry.type.get().getName())) continue;
                FileUtil.expandFilename(flEntry.link, dirs).ifPresent(files::add);
            }
        }
        WriteXMPWorker worker = new WriteXMPWorker(files, entry);
        worker.getWorker().run();
        this.panel.output(this.message);
        this.panel.frame().setProgressBarVisible(false);
        this.setEnabled(true);
    }

    class WriteXMPWorker
    extends AbstractWorker {
        private final List<File> files;
        private final BibEntry entry;

        public WriteXMPWorker(List<File> files, BibEntry entry) {
            this.files = files;
            this.entry = entry;
        }

        @Override
        public void run() {
            if (this.files.isEmpty()) {
                WriteXMPEntryEditorAction.this.message = Localization.lang("No PDF linked", new String[0]) + ".\n";
            } else {
                int written = 0;
                int error = 0;
                for (File file : this.files) {
                    if (!file.exists()) {
                        if (this.files.size() == 1) {
                            WriteXMPEntryEditorAction.this.message = Localization.lang("PDF does not exist", new String[0]);
                        }
                        ++error;
                        continue;
                    }
                    try {
                        XMPUtil.writeXMP(file, this.entry, WriteXMPEntryEditorAction.this.panel.getDatabase(), Globals.prefs.getXMPPreferences());
                        if (this.files.size() == 1) {
                            WriteXMPEntryEditorAction.this.message = Localization.lang("Wrote XMP-metadata", new String[0]);
                        }
                        ++written;
                    }
                    catch (IOException | TransformerException e) {
                        if (this.files.size() == 1) {
                            WriteXMPEntryEditorAction.this.message = Localization.lang("Error while writing", new String[0]) + " '" + file.getPath() + "'";
                        }
                        ++error;
                    }
                }
                if (this.files.size() > 1) {
                    StringBuilder sb = new StringBuilder();
                    sb.append(Localization.lang("Finished writing XMP-metadata. Wrote to %0 file(s).", String.valueOf(written)));
                    if (error > 0) {
                        sb.append(' ').append(Localization.lang("Error writing to %0 file(s).", String.valueOf(error)));
                    }
                    WriteXMPEntryEditorAction.this.message = sb.toString();
                }
            }
        }
    }
}

