/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.gui.externalfiles;

import com.jgoodies.forms.builder.ButtonBarBuilder;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import net.sf.jabref.Globals;
import net.sf.jabref.gui.BasePanel;
import net.sf.jabref.gui.filelist.FileListEntry;
import net.sf.jabref.gui.filelist.FileListTableModel;
import net.sf.jabref.gui.keyboard.KeyBinding;
import net.sf.jabref.gui.worker.AbstractWorker;
import net.sf.jabref.logic.l10n.Localization;
import net.sf.jabref.logic.util.io.FileUtil;
import net.sf.jabref.logic.xmp.XMPUtil;
import net.sf.jabref.model.database.BibDatabase;
import net.sf.jabref.model.entry.BibEntry;

public class WriteXMPAction
extends AbstractWorker {
    private final BasePanel panel;
    private Collection<BibEntry> entries;
    private BibDatabase database;
    private OptionsDialog optDiag;
    private boolean goOn = true;
    private int skipped;
    private int entriesChanged;
    private int errors;

    public WriteXMPAction(BasePanel panel) {
        this.panel = panel;
    }

    @Override
    public void init() {
        this.database = this.panel.getDatabase();
        this.entries = this.panel.getSelectedEntries();
        if (this.entries.isEmpty()) {
            this.entries = this.database.getEntries();
            if (this.entries.isEmpty()) {
                JOptionPane.showMessageDialog(this.panel, Localization.lang("This operation requires one or more entries to be selected.", new String[0]), Localization.lang("Write XMP-metadata", new String[0]), 0);
                this.goOn = false;
                return;
            }
            int response = JOptionPane.showConfirmDialog(this.panel, Localization.lang("Write XMP-metadata for all PDFs in current database?", new String[0]), Localization.lang("Write XMP-metadata", new String[0]), 1, 3);
            if (response != 0) {
                this.goOn = false;
                return;
            }
        }
        this.skipped = 0;
        this.entriesChanged = 0;
        this.errors = 0;
        if (this.optDiag == null) {
            this.optDiag = new OptionsDialog(this.panel.frame());
        }
        this.optDiag.open();
        this.panel.output(Localization.lang("Writing XMP-metadata...", new String[0]));
    }

    @Override
    public void run() {
        if (!this.goOn) {
            return;
        }
        for (BibEntry entry : this.entries) {
            ArrayList files = new ArrayList();
            entry.getField("pdf").ifPresent(pdf -> FileUtil.expandFilename(pdf, this.panel.getBibDatabaseContext().getFileDirectory("pdf", Globals.prefs.getFileDirectoryPreferences())).ifPresent(files::add));
            List<String> dirs = this.panel.getBibDatabaseContext().getFileDirectory(Globals.prefs.getFileDirectoryPreferences());
            if (entry.hasField("file")) {
                FileListTableModel tm = new FileListTableModel();
                entry.getField("file").ifPresent(tm::setContent);
                for (int j = 0; j < tm.getRowCount(); ++j) {
                    FileListEntry flEntry = tm.getEntry(j);
                    if (!flEntry.type.isPresent() || !"pdf".equalsIgnoreCase(flEntry.type.get().getName())) continue;
                    FileUtil.expandFilename(flEntry.link, dirs).ifPresent(files::add);
                }
            }
            SwingUtilities.invokeLater(() -> this.optDiag.getProgressArea().append(entry.getCiteKeyOptional().orElse(Localization.lang("undefined", new String[0])) + "\n"));
            if (files.isEmpty()) {
                ++this.skipped;
                SwingUtilities.invokeLater(() -> this.optDiag.getProgressArea().append("  " + Localization.lang("Skipped - No PDF linked", new String[0]) + ".\n"));
            } else {
                for (File file : files) {
                    if (file.exists()) {
                        try {
                            XMPUtil.writeXMP(file, entry, this.database, Globals.prefs.getXMPPreferences());
                            SwingUtilities.invokeLater(() -> this.optDiag.getProgressArea().append("  " + Localization.lang("OK", new String[0]) + ".\n"));
                            ++this.entriesChanged;
                        }
                        catch (Exception e) {
                            SwingUtilities.invokeLater(() -> {
                                this.optDiag.getProgressArea().append("  " + Localization.lang("Error while writing", new String[0]) + " '" + file.getPath() + "':\n");
                                this.optDiag.getProgressArea().append("    " + e.getLocalizedMessage() + "\n");
                            });
                            ++this.errors;
                        }
                        continue;
                    }
                    ++this.skipped;
                    SwingUtilities.invokeLater(() -> {
                        this.optDiag.getProgressArea().append("  " + Localization.lang("Skipped - PDF does not exist", new String[0]) + ":\n");
                        this.optDiag.getProgressArea().append("    " + file.getPath() + "\n");
                    });
                }
            }
            if (!this.optDiag.isCanceled()) continue;
            SwingUtilities.invokeLater(() -> this.optDiag.getProgressArea().append("\n" + Localization.lang("Operation canceled.", new String[0]) + "\n"));
            break;
        }
        SwingUtilities.invokeLater(() -> {
            this.optDiag.getProgressArea().append("\n" + Localization.lang("Finished writing XMP for %0 file (%1 skipped, %2 errors).", String.valueOf(this.entriesChanged), String.valueOf(this.skipped), String.valueOf(this.errors)));
            this.optDiag.done();
        });
    }

    @Override
    public void update() {
        if (!this.goOn) {
            return;
        }
        this.panel.output(Localization.lang("Finished writing XMP for %0 file (%1 skipped, %2 errors).", String.valueOf(this.entriesChanged), String.valueOf(this.skipped), String.valueOf(this.errors)));
    }

    class OptionsDialog
    extends JDialog {
        private final JButton okButton;
        private final JButton cancelButton;
        private boolean canceled;
        private final JTextArea progressArea;

        public OptionsDialog(JFrame parent) {
            super(parent, Localization.lang("Writing XMP-metadata for selected entries...", new String[0]), false);
            this.okButton = new JButton(Localization.lang("OK", new String[0]));
            this.cancelButton = new JButton(Localization.lang("Cancel", new String[0]));
            this.okButton.setEnabled(false);
            this.okButton.addActionListener(e -> this.dispose());
            AbstractAction cancel = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    OptionsDialog.this.canceled = true;
                }
            };
            this.cancelButton.addActionListener(cancel);
            InputMap im = this.cancelButton.getInputMap(2);
            ActionMap am = this.cancelButton.getActionMap();
            im.put(Globals.getKeyPrefs().getKey(KeyBinding.CLOSE_DIALOG), "close");
            am.put("close", cancel);
            this.progressArea = new JTextArea(15, 60);
            JScrollPane scrollPane = new JScrollPane(this.progressArea, 22, 31);
            Dimension d = this.progressArea.getPreferredSize();
            d.height += scrollPane.getHorizontalScrollBar().getHeight() + 15;
            d.width += scrollPane.getVerticalScrollBar().getWidth() + 15;
            WriteXMPAction.this.panel.setSize(d);
            this.progressArea.setBackground(Color.WHITE);
            this.progressArea.setEditable(false);
            this.progressArea.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
            this.progressArea.setText("");
            JPanel tmpPanel = new JPanel();
            tmpPanel.setBorder(BorderFactory.createEmptyBorder(3, 2, 3, 2));
            tmpPanel.add(scrollPane);
            ButtonBarBuilder bb = new ButtonBarBuilder();
            bb.addGlue();
            bb.addButton((JComponent)this.okButton);
            bb.addRelatedGap();
            bb.addButton((JComponent)this.cancelButton);
            bb.addGlue();
            JPanel bbPanel = bb.getPanel();
            bbPanel.setBorder(BorderFactory.createEmptyBorder(0, 3, 3, 3));
            this.getContentPane().add((Component)tmpPanel, "Center");
            this.getContentPane().add((Component)bbPanel, "South");
            this.pack();
            this.setResizable(false);
        }

        public void done() {
            this.okButton.setEnabled(true);
            this.cancelButton.setEnabled(false);
        }

        public void open() {
            this.progressArea.setText("");
            this.canceled = false;
            WriteXMPAction.this.optDiag.setLocationRelativeTo(WriteXMPAction.this.panel.frame());
            this.okButton.setEnabled(false);
            this.cancelButton.setEnabled(true);
            this.okButton.requestFocus();
            WriteXMPAction.this.optDiag.setVisible(true);
        }

        public boolean isCanceled() {
            return this.canceled;
        }

        public JTextArea getProgressArea() {
            return this.progressArea;
        }
    }
}

