/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.gui.externalfiles;

import com.jgoodies.forms.builder.ButtonBarBuilder;
import com.jgoodies.forms.builder.FormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import net.sf.jabref.Globals;
import net.sf.jabref.JabRefExecutorService;
import net.sf.jabref.gui.BasePanel;
import net.sf.jabref.gui.IconTheme;
import net.sf.jabref.gui.externalfiles.AutoSetLinks;
import net.sf.jabref.gui.externalfiletype.ExternalFileType;
import net.sf.jabref.gui.externalfiletype.ExternalFileTypeEntryEditor;
import net.sf.jabref.gui.externalfiletype.ExternalFileTypes;
import net.sf.jabref.gui.externalfiletype.UnknownExternalFileType;
import net.sf.jabref.gui.filelist.FileListEntry;
import net.sf.jabref.gui.filelist.FileListEntryEditor;
import net.sf.jabref.gui.filelist.FileListTableModel;
import net.sf.jabref.gui.keyboard.KeyBinding;
import net.sf.jabref.gui.undo.NamedCompound;
import net.sf.jabref.gui.undo.UndoableFieldChange;
import net.sf.jabref.gui.worker.AbstractWorker;
import net.sf.jabref.logic.l10n.Localization;
import net.sf.jabref.logic.util.io.FileUtil;
import net.sf.jabref.model.database.BibDatabaseContext;
import net.sf.jabref.model.entry.BibEntry;

public class SynchronizeFileField
extends AbstractWorker {
    private final BasePanel panel;
    private List<BibEntry> sel;
    private OptionsDialog optDiag;
    private int entriesChangedCount;
    private final Object[] brokenLinkOptions = new Object[]{Localization.lang("Ignore", new String[0]), Localization.lang("Assign new file", new String[0]), Localization.lang("Remove link", new String[0]), Localization.lang("Remove all broken links", new String[0]), Localization.lang("Quit synchronization", new String[0])};
    private boolean goOn = true;
    private boolean autoSet = true;
    private boolean checkExisting = true;

    public SynchronizeFileField(BasePanel panel) {
        this.panel = panel;
    }

    @Override
    public void init() {
        List<BibEntry> col = this.panel.getDatabase().getEntries();
        this.goOn = true;
        this.sel = new ArrayList<BibEntry>(col);
        if (this.optDiag == null) {
            this.optDiag = new OptionsDialog(this.panel.frame(), this.panel.getBibDatabaseContext());
        }
        this.optDiag.setLocationRelativeTo(this.panel.frame());
        this.optDiag.setVisible(true);
        if (this.optDiag.canceled()) {
            this.goOn = false;
            return;
        }
        this.autoSet = !this.optDiag.isAutoSetNone();
        this.checkExisting = this.optDiag.isCheckLinks();
        this.panel.output(Localization.lang("Synchronizing file links...", new String[0]));
    }

    @Override
    public void run() {
        if (!this.goOn) {
            this.panel.output(Localization.lang("This operation requires one or more entries to be selected.", new String[0]));
            return;
        }
        this.entriesChangedCount = 0;
        this.panel.frame().setProgressBarValue(0);
        this.panel.frame().setProgressBarVisible(true);
        int weightAutoSet = 10;
        int progressBarMax = (this.autoSet ? weightAutoSet * this.sel.size() : 0) + (this.checkExisting ? this.sel.size() : 0);
        this.panel.frame().setProgressBarMaximum(progressBarMax);
        int progress = 0;
        NamedCompound ce = new NamedCompound(Localization.lang("Automatically set file links", new String[0]));
        HashSet<BibEntry> changedEntries = new HashSet<BibEntry>();
        if (this.autoSet) {
            ArrayList<BibEntry> entries = new ArrayList<BibEntry>(this.sel);
            Runnable r = AutoSetLinks.autoSetLinks(entries, ce, changedEntries, null, this.panel.getBibDatabaseContext(), null, null);
            JabRefExecutorService.INSTANCE.executeAndWait(r);
        }
        this.panel.frame().setProgressBarValue(progress += this.sel.size() * weightAutoSet);
        if (this.checkExisting) {
            boolean removeAllBroken = false;
            block5: for (BibEntry aSel : this.sel) {
                this.panel.frame().setProgressBarValue(progress++);
                Optional<String> old = aSel.getField("file");
                if (!old.isPresent() || old.get().isEmpty()) continue;
                FileListTableModel tableModel = new FileListTableModel();
                tableModel.setContentDontGuessTypes(old.get());
                List<String> dirsS = this.panel.getBibDatabaseContext().getFileDirectory(Globals.prefs.getFileDirectoryPreferences());
                ArrayList<File> dirs = new ArrayList<File>();
                for (String dirs1 : dirsS) {
                    dirs.add(new File(dirs1));
                }
                for (int j = 0; j < tableModel.getRowCount(); ++j) {
                    FileListEntry flEntry = tableModel.getEntry(j);
                    boolean httpLink = flEntry.link.toLowerCase(Locale.ENGLISH).startsWith("http");
                    if (httpLink) continue;
                    boolean deleted = false;
                    Optional<File> file = FileUtil.expandFilename(flEntry.link, dirsS);
                    if (!file.isPresent() || !file.get().exists()) {
                        int answer = removeAllBroken ? 2 : JOptionPane.showOptionDialog(this.panel.frame(), Localization.lang("<HTML>Could not find file '%0'<BR>linked from entry '%1'</HTML>", flEntry.link, aSel.getCiteKeyOptional().orElse(Localization.lang("undefined", new String[0]))), Localization.lang("Broken link", new String[0]), 1, 3, null, this.brokenLinkOptions, this.brokenLinkOptions[0]);
                        switch (answer) {
                            case 1: {
                                FileListEntryEditor flEditor = new FileListEntryEditor(this.panel.frame(), flEntry, false, true, this.panel.getBibDatabaseContext());
                                flEditor.setVisible(true, true);
                                break;
                            }
                            case 2: {
                                tableModel.removeEntry(j);
                                deleted = true;
                                --j;
                                break;
                            }
                            case 3: {
                                tableModel.removeEntry(j);
                                deleted = true;
                                --j;
                                removeAllBroken = true;
                                break;
                            }
                            default: {
                                break block5;
                            }
                        }
                    }
                    if (deleted || !flEntry.type.isPresent() || !(flEntry.type.get() instanceof UnknownExternalFileType)) continue;
                    Object[] options = new String[]{Localization.lang("Define '%0'", flEntry.type.get().getName()), Localization.lang("Change file type", new String[0]), Localization.lang("Cancel", new String[0])};
                    String defOption = options[0];
                    int answer = JOptionPane.showOptionDialog(this.panel.frame(), Localization.lang("One or more file links are of the type '%0', which is undefined. What do you want to do?", flEntry.type.get().getName()), Localization.lang("Undefined file type", new String[0]), 1, 3, null, options, defOption);
                    if (answer == 2) continue;
                    if (answer == 0) {
                        ExternalFileType newType = new ExternalFileType(flEntry.type.get().getName(), "", "", "", "new", IconTheme.JabRefIcon.FILE.getSmallIcon());
                        ExternalFileTypeEntryEditor editor = new ExternalFileTypeEntryEditor(this.panel.frame(), newType);
                        editor.setVisible(true);
                        if (!editor.okPressed()) continue;
                        ArrayList<ExternalFileType> fileTypes = new ArrayList<ExternalFileType>(ExternalFileTypes.getInstance().getExternalFileTypeSelection());
                        fileTypes.add(newType);
                        Collections.sort(fileTypes);
                        ExternalFileTypes.getInstance().setExternalFileTypes(fileTypes);
                        this.panel.getMainTable().repaint();
                        continue;
                    }
                    FileListEntryEditor editor = new FileListEntryEditor(this.panel.frame(), flEntry, false, true, this.panel.getBibDatabaseContext());
                    editor.setVisible(true, false);
                }
                if (tableModel.getStringRepresentation().equals(old.orElse(null))) continue;
                String toSet = tableModel.getStringRepresentation();
                if (toSet.isEmpty()) {
                    ce.addEdit(new UndoableFieldChange(aSel, "file", old.orElse(null), null));
                    aSel.clearField("file");
                } else {
                    ce.addEdit(new UndoableFieldChange(aSel, "file", old.orElse(null), toSet));
                    aSel.setField("file", toSet);
                }
                changedEntries.add(aSel);
            }
        }
        if (!changedEntries.isEmpty()) {
            ce.end();
            this.panel.getUndoManager().addEdit(ce);
            this.panel.markBaseChanged();
            this.entriesChangedCount = changedEntries.size();
        }
    }

    @Override
    public void update() {
        if (!this.goOn) {
            return;
        }
        this.panel.output(Localization.lang("Finished synchronizing file links. Entries changed: %0.", String.valueOf(this.entriesChangedCount)));
        this.panel.frame().setProgressBarVisible(false);
        if (this.entriesChangedCount > 0) {
            this.panel.markBaseChanged();
        }
    }

    static class OptionsDialog
    extends JDialog {
        private final JButton ok = new JButton(Localization.lang("OK", new String[0]));
        private final JButton cancel = new JButton(Localization.lang("Cancel", new String[0]));
        private boolean canceled = true;
        private final BibDatabaseContext databaseContext;
        private final JRadioButton autoSetUnset = new JRadioButton(Localization.lang("Automatically set file links", new String[0]) + ". " + Localization.lang("Do not overwrite existing links.", new String[0]), true);
        private final JRadioButton autoSetAll = new JRadioButton(Localization.lang("Automatically set file links", new String[0]) + ". " + Localization.lang("Allow overwriting existing links.", new String[0]), false);
        private final JRadioButton autoSetNone = new JRadioButton(Localization.lang("Do not automatically set", new String[0]), false);
        private final JCheckBox checkLinks = new JCheckBox(Localization.lang("Check existing file links", new String[0]), true);

        public OptionsDialog(JFrame parent, BibDatabaseContext databaseContext) {
            super(parent, Localization.lang("Synchronize file links", new String[0]), true);
            this.databaseContext = databaseContext;
            this.ok.addActionListener(e -> {
                this.canceled = false;
                this.dispose();
            });
            AbstractAction closeAction = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    this.dispose();
                }
            };
            this.cancel.addActionListener(closeAction);
            InputMap im = this.cancel.getInputMap(2);
            ActionMap am = this.cancel.getActionMap();
            im.put(Globals.getKeyPrefs().getKey(KeyBinding.CLOSE_DIALOG), "close");
            am.put("close", closeAction);
            ButtonGroup bg = new ButtonGroup();
            bg.add(this.autoSetUnset);
            bg.add(this.autoSetNone);
            bg.add(this.autoSetAll);
            FormLayout layout = new FormLayout("fill:pref", "pref, 2dlu, pref, 2dlu, pref, pref, pref, 2dlu, pref, 2dlu, pref, 2dlu, pref, 2dlu, pref");
            FormBuilder builder = FormBuilder.create().layout(layout);
            JLabel description = new JLabel("<HTML>" + Localization.lang("Attempt to automatically set file links for your entries. Automatically setting works if a file in your file directory<BR>or a subdirectory is named identically to an entry's BibTeX key, plus extension.", new String[0]) + "</HTML>");
            builder.addSeparator(Localization.lang("Automatically set file links", new String[0]), new Object[0]).xy(1, 1);
            builder.add(description).xy(1, 3);
            builder.add(this.autoSetUnset).xy(1, 5);
            builder.add(this.autoSetAll).xy(1, 6);
            builder.add(this.autoSetNone).xy(1, 7);
            builder.addSeparator(Localization.lang("Check links", new String[0]), new Object[0]).xy(1, 9);
            description = new JLabel("<HTML>" + Localization.lang("This makes JabRef look up each file link and check if the file exists. If not, you will be given options<BR>to resolve the problem.", new String[0]) + "</HTML>");
            builder.add(description).xy(1, 11);
            builder.add(this.checkLinks).xy(1, 13);
            builder.addSeparator("", new Object[0]).xy(1, 15);
            JPanel main = builder.getPanel();
            main.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            ButtonBarBuilder bb = new ButtonBarBuilder();
            bb.addGlue();
            bb.addButton((JComponent)this.ok);
            bb.addButton((JComponent)this.cancel);
            bb.addGlue();
            this.getContentPane().add((Component)main, "Center");
            this.getContentPane().add((Component)bb.getPanel(), "South");
            this.pack();
        }

        @Override
        public void setVisible(boolean visible) {
            List<String> dirs;
            if (visible) {
                this.canceled = true;
            }
            if ((dirs = this.databaseContext.getFileDirectory(Globals.prefs.getFileDirectoryPreferences())).isEmpty()) {
                this.autoSetNone.setSelected(true);
                this.autoSetNone.setEnabled(false);
                this.autoSetAll.setEnabled(false);
                this.autoSetUnset.setEnabled(false);
            } else {
                this.autoSetNone.setEnabled(true);
                this.autoSetAll.setEnabled(true);
                this.autoSetUnset.setEnabled(true);
            }
            this.ok.requestFocus();
            super.setVisible(visible);
        }

        public boolean isAutoSetNone() {
            return this.autoSetNone.isSelected();
        }

        public boolean isCheckLinks() {
            return this.checkLinks.isSelected();
        }

        public boolean canceled() {
            return this.canceled;
        }
    }
}

