/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.gui.externalfiles;

import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import javax.swing.AbstractAction;
import javax.swing.JOptionPane;
import net.sf.jabref.Globals;
import net.sf.jabref.gui.FileDialog;
import net.sf.jabref.gui.JabRefFrame;
import net.sf.jabref.gui.entryeditor.EntryEditor;
import net.sf.jabref.gui.fieldeditors.FileListEditor;
import net.sf.jabref.gui.filelist.FileListEntry;
import net.sf.jabref.gui.util.component.CheckBoxMessage;
import net.sf.jabref.logic.l10n.Localization;
import net.sf.jabref.logic.util.io.FileUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MoveFileAction
extends AbstractAction {
    private static final Log LOGGER = LogFactory.getLog(MoveFileAction.class);
    private final JabRefFrame frame;
    private final EntryEditor eEditor;
    private final FileListEditor editor;
    private final boolean toFileDir;
    private static final String MOVE_RENAME = Localization.lang("Move/Rename file", new String[0]);

    public MoveFileAction(JabRefFrame frame, EntryEditor eEditor, FileListEditor editor, boolean toFileDir) {
        this.frame = frame;
        this.eEditor = eEditor;
        this.editor = editor;
        this.toFileDir = toFileDir;
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        block25: {
            int selected = this.editor.getSelectedRow();
            if (selected == -1) {
                return;
            }
            FileListEntry entry = this.editor.getTableModel().getEntry(selected);
            String ln = entry.link;
            boolean httpLink = ln.toLowerCase(Locale.ENGLISH).startsWith("http");
            if (httpLink) {
                return;
            }
            List<String> dirs = this.frame.getCurrentBasePanel().getBibDatabaseContext().getFileDirectory(Globals.prefs.getFileDirectoryPreferences());
            int found = -1;
            for (int i = 0; i < dirs.size(); ++i) {
                if (!new File(dirs.get(i)).exists()) continue;
                found = i;
                break;
            }
            if (found < 0) {
                JOptionPane.showMessageDialog(this.frame, Localization.lang("File_directory_is_not_set_or_does_not_exist!", new String[0]), MOVE_RENAME, 0);
                return;
            }
            File file = new File(ln);
            if (!file.isAbsolute()) {
                file = FileUtil.expandFilename(ln, dirs).orElse(null);
            }
            if (file != null && file.exists()) {
                File newFile = null;
                boolean repeat = true;
                while (repeat) {
                    String chosenFile;
                    repeat = false;
                    if (this.toFileDir) {
                        String suggName = FileUtil.createFileNameFromPattern(this.eEditor.getDatabase(), this.eEditor.getEntry(), Globals.prefs.get("importFileNamePattern"), Globals.prefs.getLayoutFormatterPreferences(Globals.journalAbbreviationLoader)).concat(entry.type.isPresent() ? "." + entry.type.get().getExtension() : "");
                        CheckBoxMessage cbm = new CheckBoxMessage(Localization.lang("Move file to file directory?", new String[0]), Localization.lang("Rename to '%0'", suggName), Globals.prefs.getBoolean("renameOnMoveFileToFileDir"));
                        int answer = suggName.equals(file.getName()) ? JOptionPane.showConfirmDialog(this.frame, Localization.lang("Move file to file directory?", new String[0]), MOVE_RENAME, 0) : JOptionPane.showConfirmDialog(this.frame, cbm, MOVE_RENAME, 0);
                        if (answer != 0) {
                            return;
                        }
                        Globals.prefs.putBoolean("renameOnMoveFileToFileDir", cbm.isSelected());
                        StringBuilder sb = new StringBuilder(dirs.get(found));
                        if (!dirs.get(found).endsWith(File.separator)) {
                            sb.append(File.separator);
                        }
                        if (cbm.isSelected()) {
                            sb.append(suggName);
                        } else {
                            sb.append(file.getName());
                        }
                        chosenFile = sb.toString();
                    } else {
                        Optional<Path> path = new FileDialog(this.frame, file.getPath()).saveNewFile();
                        if (path.isPresent()) {
                            chosenFile = path.get().toString();
                        } else {
                            return;
                        }
                    }
                    newFile = new File(chosenFile);
                }
                if (newFile != null && !newFile.equals(file)) {
                    try {
                        boolean success = file.renameTo(newFile);
                        if (!success) {
                            success = FileUtil.copyFile(Paths.get(file.toURI()), Paths.get(newFile.toURI()), true);
                        }
                        if (success) {
                            String newLink;
                            Files.deleteIfExists(file.toPath());
                            String canPath = new File(dirs.get(found)).getCanonicalPath();
                            if (newFile.getCanonicalPath().startsWith(canPath)) {
                                if (newFile.getCanonicalPath().length() > canPath.length() && newFile.getCanonicalPath().charAt(canPath.length()) == File.separatorChar) {
                                    newLink = newFile.getCanonicalPath().substring(1 + canPath.length());
                                    this.editor.getTableModel().setEntry(selected, new FileListEntry(entry.description, newLink, entry.type));
                                } else {
                                    newLink = newFile.getCanonicalPath().substring(canPath.length());
                                    this.editor.getTableModel().setEntry(selected, new FileListEntry(entry.description, newLink, entry.type));
                                }
                            } else {
                                newLink = newFile.getCanonicalPath();
                                this.editor.getTableModel().setEntry(selected, new FileListEntry(entry.description, newLink, entry.type));
                            }
                            this.eEditor.updateField(this.editor);
                            this.frame.output(Localization.lang("File moved", new String[0]));
                            break block25;
                        }
                        JOptionPane.showMessageDialog(this.frame, Localization.lang("Move file failed", new String[0]), MOVE_RENAME, 0);
                    }
                    catch (IOException | SecurityException ex) {
                        LOGGER.warn("Could not move file", ex);
                        JOptionPane.showMessageDialog(this.frame, Localization.lang("Could not move file '%0'.", file.getAbsolutePath()) + ex.getMessage(), MOVE_RENAME, 0);
                    }
                }
            } else {
                JOptionPane.showMessageDialog(this.frame, Localization.lang("Could not find file '%0'.", entry.link), Localization.lang("File not found", new String[0]), 0);
            }
        }
    }
}

