/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.gui.externalfiles;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import javax.swing.JOptionPane;
import net.sf.jabref.Globals;
import net.sf.jabref.gui.BasePanel;
import net.sf.jabref.gui.externalfiles.DownloadExternalFile;
import net.sf.jabref.gui.filelist.FileListTableModel;
import net.sf.jabref.gui.undo.UndoableFieldChange;
import net.sf.jabref.gui.worker.AbstractWorker;
import net.sf.jabref.logic.importer.FulltextFetchers;
import net.sf.jabref.logic.l10n.Localization;
import net.sf.jabref.model.entry.BibEntry;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FindFullTextAction
extends AbstractWorker {
    private static final Log LOGGER = LogFactory.getLog(FindFullTextAction.class);
    private static final int warningLimit = 10;
    private final BasePanel basePanel;
    private final Map<Optional<URL>, BibEntry> downloads = new ConcurrentHashMap<Optional<URL>, BibEntry>();

    public FindFullTextAction(BasePanel basePanel) {
        this.basePanel = basePanel;
    }

    @Override
    public void init() throws Throwable {
        this.basePanel.output(Localization.lang("Looking for full text document...", new String[0]));
    }

    @Override
    public void run() {
        if (this.basePanel.getSelectedEntries().size() >= 10) {
            Object[] options = new String[]{Localization.lang("Look up full text documents", new String[0]), Localization.lang("Cancel", new String[0])};
            int answer = JOptionPane.showOptionDialog(this.basePanel.frame(), Localization.lang("You are about to look up full text documents for %0 entries.", String.valueOf(this.basePanel.getSelectedEntries().size())) + "\n" + Localization.lang("Do you still want to continue?", new String[0]), Localization.lang("Look up full text documents", new String[0]), 2, 3, null, options, options[0]);
            if (answer != 0) {
                this.basePanel.output(Localization.lang("Operation canceled.", new String[0]));
                return;
            }
        }
        for (BibEntry entry : this.basePanel.getSelectedEntries()) {
            FulltextFetchers fft = new FulltextFetchers(Globals.prefs.getImportFormatPreferences());
            this.downloads.put(fft.findFullTextPDF(entry), entry);
        }
    }

    @Override
    public void update() {
        ArrayList<Optional<URL>> remove = new ArrayList<Optional<URL>>();
        for (Map.Entry<Optional<URL>, BibEntry> entry : this.downloads.entrySet()) {
            BibEntry entry2 = entry.getValue();
            Optional<URL> result = entry.getKey();
            if (result.isPresent()) {
                List<String> dirs = this.basePanel.getBibDatabaseContext().getFileDirectory(Globals.prefs.getFileDirectoryPreferences());
                if (dirs.isEmpty()) {
                    JOptionPane.showMessageDialog(this.basePanel.frame(), Localization.lang("Main file directory not set!", new String[0]) + " " + Localization.lang("Preferences", new String[0]) + " -> " + Localization.lang("File", new String[0]), Localization.lang("Directory not found", new String[0]), 0);
                    return;
                }
                DownloadExternalFile def = new DownloadExternalFile(this.basePanel.frame(), this.basePanel.getBibDatabaseContext(), entry2);
                try {
                    def.download(result.get(), file -> {
                        FileListTableModel tm = new FileListTableModel();
                        entry2.getField("file").ifPresent(tm::setContent);
                        tm.addEntry(tm.getRowCount(), file);
                        String newValue = tm.getStringRepresentation();
                        UndoableFieldChange edit = new UndoableFieldChange(entry2, "file", entry2.getField("file").orElse(null), newValue);
                        entry2.setField("file", newValue);
                        this.basePanel.getUndoManager().addEdit(edit);
                        this.basePanel.markBaseChanged();
                    });
                }
                catch (IOException e) {
                    LOGGER.warn("Problem downloading file", e);
                }
                this.basePanel.output(Localization.lang("Finished downloading full text document for entry %0.", entry2.getCiteKeyOptional().orElse(Localization.lang("undefined", new String[0]))));
            } else {
                String title = Localization.lang("Full text document download failed", new String[0]);
                String message = Localization.lang("Full text document download failed for entry %0.", entry2.getCiteKeyOptional().orElse(Localization.lang("undefined", new String[0])));
                this.basePanel.output(message);
                JOptionPane.showMessageDialog(this.basePanel.frame(), message, title, 0);
            }
            remove.add(result);
        }
        for (Optional optional : remove) {
            this.downloads.remove(optional);
        }
    }
}

