/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.gui.externalfiles;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Paths;
import java.util.List;
import java.util.Optional;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import net.sf.jabref.Globals;
import net.sf.jabref.JabRefExecutorService;
import net.sf.jabref.gui.JabRefFrame;
import net.sf.jabref.gui.externalfiletype.ExternalFileType;
import net.sf.jabref.gui.externalfiletype.ExternalFileTypes;
import net.sf.jabref.gui.filelist.FileListEntry;
import net.sf.jabref.gui.filelist.FileListEntryEditor;
import net.sf.jabref.gui.net.MonitoredURLDownload;
import net.sf.jabref.logic.l10n.Localization;
import net.sf.jabref.logic.net.URLDownload;
import net.sf.jabref.logic.util.OS;
import net.sf.jabref.logic.util.io.FileUtil;
import net.sf.jabref.model.database.BibDatabaseContext;
import net.sf.jabref.model.entry.BibEntry;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DownloadExternalFile {
    private static final Log LOGGER = LogFactory.getLog(DownloadExternalFile.class);
    private final JabRefFrame frame;
    private final BibDatabaseContext databaseContext;
    private final BibEntry entry;
    private FileListEntryEditor editor;
    private boolean downloadFinished;
    private boolean dontShowDialog;

    public DownloadExternalFile(JabRefFrame frame, BibDatabaseContext databaseContext, BibEntry entry) {
        this.frame = frame;
        this.databaseContext = databaseContext;
        this.entry = entry;
    }

    public void download(DownloadCallback callback) throws IOException {
        URL url;
        this.dontShowDialog = false;
        String res = JOptionPane.showInputDialog(this.frame, (Object)Localization.lang("Enter URL to download", new String[0]));
        if (res == null || res.trim().isEmpty()) {
            return;
        }
        try {
            url = new URL(res);
        }
        catch (MalformedURLException ex1) {
            JOptionPane.showMessageDialog(this.frame, Localization.lang("Invalid URL", new String[0]), Localization.lang("Download file", new String[0]), 0);
            return;
        }
        this.download(url, callback);
    }

    public void download(URL url, DownloadCallback callback) throws IOException {
        String suffix;
        String mimeType;
        String res = url.toString();
        File tmp = File.createTempFile("jabref_download", "tmp");
        tmp.deleteOnExit();
        URLDownload udl = MonitoredURLDownload.buildMonitoredDownload(this.frame, url);
        try {
            mimeType = udl.determineMimeType();
        }
        catch (IOException ex) {
            JOptionPane.showMessageDialog(this.frame, Localization.lang("Invalid URL", new String[0]) + ": " + ex.getMessage(), Localization.lang("Download file", new String[0]), 0);
            LOGGER.info("Error while downloading '" + res + "'", ex);
            return;
        }
        URL urlF = url;
        URLDownload udlF = udl;
        JabRefExecutorService.INSTANCE.execute(() -> {
            try {
                udlF.downloadToFile(tmp);
            }
            catch (IOException e2) {
                this.dontShowDialog = true;
                if (this.editor != null && this.editor.isVisible()) {
                    this.editor.setVisible(false, false);
                }
                JOptionPane.showMessageDialog(this.frame, Localization.lang("Invalid URL", new String[0]) + ": " + e2.getMessage(), Localization.lang("Download file", new String[0]), 0);
                LOGGER.info("Error while downloading '" + urlF + "'", e2);
                return;
            }
            SwingUtilities.invokeLater(this::downloadFinished);
        });
        Optional<ExternalFileType> suggestedType = Optional.empty();
        if (mimeType != null) {
            LOGGER.debug("MIME Type suggested: " + mimeType);
            suggestedType = ExternalFileTypes.getInstance().getExternalFileTypeByMimeType(mimeType);
        }
        if (suggestedType.isPresent()) {
            suffix = ((ExternalFileType)suggestedType.get()).getExtension();
        } else {
            suffix = this.getSuffix(res);
            if (suffix == null) {
                suffix = "";
            }
            suggestedType = ExternalFileTypes.getInstance().getExternalFileTypeByExt(suffix);
        }
        String suggestedName = this.getSuggestedFileName(suffix);
        List<String> fDirectory = this.databaseContext.getFileDirectory(Globals.prefs.getFileDirectoryPreferences());
        String directory = fDirectory.isEmpty() ? null : fDirectory.get(0);
        String suggestDir = directory == null ? System.getProperty("user.home") : directory;
        File file = new File(new File(suggestDir), suggestedName);
        FileListEntry fileListEntry = new FileListEntry("", file.getCanonicalPath(), suggestedType);
        this.editor = new FileListEntryEditor(this.frame, fileListEntry, true, false, this.databaseContext);
        this.editor.getProgressBar().setIndeterminate(true);
        this.editor.setOkEnabled(false);
        this.editor.setExternalConfirm(closeEntry -> {
            File f;
            File file = f = directory == null ? new File(closeEntry.link) : this.expandFilename(directory, closeEntry.link);
            if (f.isDirectory()) {
                JOptionPane.showMessageDialog(this.frame, Localization.lang("Target file cannot be a directory.", new String[0]), Localization.lang("Download file", new String[0]), 0);
                return false;
            }
            if (f.exists()) {
                return JOptionPane.showConfirmDialog(this.frame, Localization.lang("'%0' exists. Overwrite file?", f.getName()), Localization.lang("Download file", new String[0]), 2) == 0;
            }
            return true;
        });
        if (this.dontShowDialog) {
            return;
        }
        this.editor.setVisible(true, false);
        if (this.editor.okPressed()) {
            File toFile;
            File file2 = toFile = directory == null ? new File(fileListEntry.link) : this.expandFilename(directory, fileListEntry.link);
            String dirPrefix = directory == null ? null : (directory.endsWith(OS.FILE_SEPARATOR) ? directory : directory + OS.FILE_SEPARATOR);
            boolean success = FileUtil.copyFile(Paths.get(tmp.toURI()), Paths.get(toFile.toURI()), true);
            if (!success) {
                LOGGER.error("File already exists! DownloadExternalFile.download()");
            }
            if (dirPrefix != null && fileListEntry.link.startsWith(directory) && fileListEntry.link.length() > dirPrefix.length()) {
                fileListEntry = new FileListEntry(fileListEntry.description, fileListEntry.link.substring(dirPrefix.length()), fileListEntry.type);
            }
            callback.downloadComplete(fileListEntry);
            if (!tmp.delete()) {
                LOGGER.info("Cannot delete temporary file");
            }
        } else if (this.downloadFinished && !tmp.delete()) {
            LOGGER.info("Cannot delete temporary file");
        }
    }

    private File expandFilename(String directory, String link) {
        File toFile = new File(link);
        String dirPrefix = directory + OS.FILE_SEPARATOR;
        if (!toFile.isAbsolute()) {
            toFile = new File(dirPrefix + link);
        }
        return toFile;
    }

    private void downloadFinished() {
        this.downloadFinished = true;
        this.editor.getProgressBar().setVisible(false);
        this.editor.getProgressBarLabel().setVisible(false);
        this.editor.setOkEnabled(true);
        this.editor.getProgressBar().setValue(this.editor.getProgressBar().getMaximum());
    }

    private String getSuggestedFileName(String suffix) {
        String plannedName = FileUtil.createFileNameFromPattern(this.databaseContext.getDatabase(), this.entry, Globals.prefs.get("importFileNamePattern"), Globals.prefs.getLayoutFormatterPreferences(Globals.journalAbbreviationLoader));
        if (!suffix.isEmpty()) {
            plannedName = plannedName + "." + suffix;
        }
        if (OS.WINDOWS) {
            plannedName = plannedName.replaceAll("\\?|\\*|\\<|\\>|\\||\\\"|\\:|\\.$|\\[|\\]", "");
        } else if (OS.OS_X) {
            plannedName = plannedName.replace(":", "");
        }
        return plannedName;
    }

    private String getSuffix(String link) {
        String strippedLink = link;
        try {
            URL url = new URL(link);
            if (url.getQuery() != null && url.getQuery().length() < link.length() - 1) {
                strippedLink = link.substring(0, link.length() - url.getQuery().length() - 1);
            }
        }
        catch (MalformedURLException url) {
            // empty catch block
        }
        int strippedLinkIndex = strippedLink.lastIndexOf(46);
        String suffix = strippedLinkIndex <= 0 || strippedLinkIndex == strippedLink.length() - 1 ? null : strippedLink.substring(strippedLinkIndex + 1);
        if (!ExternalFileTypes.getInstance().isExternalFileTypeByExt(suffix)) {
            int index = link.lastIndexOf(46);
            if (index <= 0 || index == link.length() - 1) {
                if (strippedLink.substring(strippedLinkIndex + 1).indexOf(47) >= 1) {
                    return "";
                }
                return suffix;
            }
            if (link.substring(index + 1).indexOf(47) >= 1) {
                return "";
            }
            return link.substring(index + 1);
        }
        return suffix;
    }

    @FunctionalInterface
    public static interface DownloadCallback {
        public void downloadComplete(FileListEntry var1);
    }
}

