/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.gui.externalfiles;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.swing.BorderFactory;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import net.sf.jabref.Globals;
import net.sf.jabref.gui.externalfiletype.ExternalFileType;
import net.sf.jabref.gui.externalfiletype.ExternalFileTypes;
import net.sf.jabref.gui.externalfiletype.UnknownExternalFileType;
import net.sf.jabref.gui.filelist.FileListEntry;
import net.sf.jabref.gui.filelist.FileListTableModel;
import net.sf.jabref.gui.undo.NamedCompound;
import net.sf.jabref.gui.undo.UndoableFieldChange;
import net.sf.jabref.logic.l10n.Localization;
import net.sf.jabref.logic.util.io.FileUtil;
import net.sf.jabref.logic.util.io.RegExpFileSearch;
import net.sf.jabref.model.database.BibDatabaseContext;
import net.sf.jabref.model.entry.BibEntry;

public class AutoSetLinks {
    public static void autoSetLinks(List<BibEntry> entries, BibDatabaseContext databaseContext) {
        AutoSetLinks.autoSetLinks(entries, null, null, null, databaseContext, null, null);
    }

    public static Runnable autoSetLinks(final List<BibEntry> entries, final NamedCompound ce, final Set<BibEntry> changedEntries, final FileListTableModel singleTableModel, final BibDatabaseContext databaseContext, final ActionListener callback, final JDialog diag) {
        final Set<ExternalFileType> types = ExternalFileTypes.getInstance().getExternalFileTypeSelection();
        if (diag != null) {
            JProgressBar prog = new JProgressBar(0, 0, types.size() - 1);
            JLabel label = new JLabel(Localization.lang("Searching for files", new String[0]));
            prog.setIndeterminate(true);
            prog.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            diag.setTitle(Localization.lang("Automatically setting file links", new String[0]));
            diag.getContentPane().add((Component)prog, "Center");
            diag.getContentPane().add((Component)label, "South");
            diag.pack();
            diag.setLocationRelativeTo(diag.getParent());
        }
        Runnable r = new Runnable(){

            @Override
            public void run() {
                Map<BibEntry, List<File>> result;
                ArrayList<File> dirs = new ArrayList<File>();
                List<String> dirsS = databaseContext.getFileDirectory(Globals.prefs.getFileDirectoryPreferences());
                dirs.addAll(dirsS.stream().map(File::new).collect(Collectors.toList()));
                ArrayList<String> extensions = new ArrayList<String>();
                for (ExternalFileType type : types) {
                    extensions.add(type.getExtension());
                }
                if (Globals.prefs.getBoolean("useRegExpSearch")) {
                    String regExp = Globals.prefs.get("regExpSearchExpression");
                    result = RegExpFileSearch.findFilesForSet(entries, extensions, dirs, regExp, Globals.prefs.getKeywordDelimiter());
                } else {
                    boolean autoLinkExactKeyOnly = Globals.prefs.getBoolean("autolinkExactKeyOnly");
                    result = FileUtil.findAssociatedFiles(entries, extensions, dirs, autoLinkExactKeyOnly);
                }
                boolean foundAny = false;
                for (Map.Entry<BibEntry, List<File>> entryFilePair : result.entrySet()) {
                    FileListTableModel tableModel;
                    Optional<String> oldVal = entryFilePair.getKey().getField("file");
                    if (singleTableModel == null) {
                        tableModel = new FileListTableModel();
                        oldVal.ifPresent(tableModel::setContent);
                    } else {
                        assert (entries.size() == 1);
                        tableModel = singleTableModel;
                    }
                    List<File> files = entryFilePair.getValue();
                    for (File f : files) {
                        f = FileUtil.shortenFileName(f, dirsS);
                        boolean alreadyHas = false;
                        for (int j = 0; j < tableModel.getRowCount(); ++j) {
                            FileListEntry existingEntry = tableModel.getEntry(j);
                            if (!new File(existingEntry.link).equals(f)) continue;
                            alreadyHas = true;
                            foundAny = true;
                            break;
                        }
                        if (alreadyHas) continue;
                        foundAny = true;
                        Optional<String> extension = FileUtil.getFileExtension(f);
                        Optional<ExternalFileType> type = extension.isPresent() ? ExternalFileTypes.getInstance().getExternalFileTypeByExt(extension.get()) : Optional.of(new UnknownExternalFileType(""));
                        FileListEntry flEntry = new FileListEntry(f.getName(), f.getPath(), type);
                        tableModel.addEntry(tableModel.getRowCount(), flEntry);
                        String newVal = tableModel.getStringRepresentation();
                        if (newVal.isEmpty()) {
                            newVal = null;
                        }
                        if (ce != null) {
                            UndoableFieldChange change = new UndoableFieldChange(entryFilePair.getKey(), "file", oldVal.orElse(null), newVal);
                            ce.addEdit(change);
                        }
                        if (singleTableModel == null) {
                            entryFilePair.getKey().setField("file", newVal);
                        }
                        if (changedEntries == null) continue;
                        changedEntries.add(entryFilePair.getKey());
                    }
                }
                final int id = foundAny ? 1 : 0;
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (diag != null) {
                            diag.dispose();
                        }
                        if (callback != null) {
                            callback.actionPerformed(new ActionEvent(this, id, ""));
                        }
                    }
                });
            }
        };
        SwingUtilities.invokeLater(() -> {
            if (diag != null) {
                diag.setVisible(true);
            }
        });
        return r;
    }

    public static Runnable autoSetLinks(BibEntry entry, FileListTableModel singleTableModel, BibDatabaseContext databaseContext, ActionListener callback, JDialog diag) {
        return AutoSetLinks.autoSetLinks(Collections.singletonList(entry), null, null, singleTableModel, databaseContext, callback, diag);
    }
}

