/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.gui.exporter;

import com.jgoodies.forms.builder.FormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.UnsupportedCharsetException;
import java.nio.file.Path;
import java.util.Optional;
import javax.swing.JOptionPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import net.sf.jabref.Globals;
import net.sf.jabref.JabRefExecutorService;
import net.sf.jabref.collab.ChangeScanner;
import net.sf.jabref.collab.FileUpdatePanel;
import net.sf.jabref.gui.BasePanel;
import net.sf.jabref.gui.FileDialog;
import net.sf.jabref.gui.JabRefFrame;
import net.sf.jabref.gui.autosaveandbackup.AutosaveUIManager;
import net.sf.jabref.gui.worker.AbstractWorker;
import net.sf.jabref.gui.worker.CallBack;
import net.sf.jabref.gui.worker.Worker;
import net.sf.jabref.logic.autosaveandbackup.AutosaveManager;
import net.sf.jabref.logic.autosaveandbackup.BackupManager;
import net.sf.jabref.logic.exporter.BibtexDatabaseWriter;
import net.sf.jabref.logic.exporter.FileSaveSession;
import net.sf.jabref.logic.exporter.SaveException;
import net.sf.jabref.logic.exporter.SavePreferences;
import net.sf.jabref.logic.exporter.SaveSession;
import net.sf.jabref.logic.l10n.Encodings;
import net.sf.jabref.logic.l10n.Localization;
import net.sf.jabref.logic.util.FileExtensions;
import net.sf.jabref.logic.util.io.FileBasedLock;
import net.sf.jabref.model.database.BibDatabaseContext;
import net.sf.jabref.model.database.DatabaseLocation;
import net.sf.jabref.model.database.event.ChangePropagation;
import net.sf.jabref.model.entry.BibEntry;
import net.sf.jabref.shared.DBMSConnectionProperties;
import net.sf.jabref.shared.prefs.SharedDatabasePreferences;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SaveDatabaseAction
extends AbstractWorker {
    private static final Log LOGGER = LogFactory.getLog(SaveDatabaseAction.class);
    private final BasePanel panel;
    private final JabRefFrame frame;
    private boolean success;
    private boolean canceled;
    private boolean fileLockedError;
    private Optional<Path> filePath;

    public SaveDatabaseAction(BasePanel panel) {
        this.panel = panel;
        this.frame = panel.frame();
        this.filePath = Optional.empty();
    }

    public SaveDatabaseAction(BasePanel panel, Path filePath) {
        this(panel);
        this.filePath = Optional.ofNullable(filePath);
    }

    @Override
    public void init() throws Throwable {
        this.success = false;
        this.canceled = false;
        this.fileLockedError = false;
        if (this.panel.getBibDatabaseContext().getDatabaseFile().isPresent()) {
            if (this.checkExternalModification()) {
                return;
            }
            this.panel.frame().output(Localization.lang("Saving database", new String[0]) + "...");
            this.panel.setSaving(true);
        } else if (this.filePath.isPresent()) {
            this.saveAs(this.filePath.get().toFile());
        } else {
            this.saveAs();
        }
    }

    @Override
    public void update() {
        if (this.success) {
            this.frame.setTabTitle(this.panel, this.panel.getTabTitle(), this.panel.getBibDatabaseContext().getDatabaseFile().get().getAbsolutePath());
            this.frame.output(Localization.lang("Saved database", new String[0]) + " '" + this.panel.getBibDatabaseContext().getDatabaseFile().get().getPath() + "'.");
            this.frame.setWindowTitle();
            this.frame.updateAllTabTitles();
        } else if (!this.canceled) {
            if (this.fileLockedError) {
                this.frame.output(Localization.lang("Could not save, file locked by another JabRef instance.", new String[0]));
            } else {
                this.frame.output(Localization.lang("Save failed", new String[0]));
            }
        }
    }

    @Override
    public void run() {
        if (this.canceled || !this.panel.getBibDatabaseContext().getDatabaseFile().isPresent()) {
            return;
        }
        try {
            this.panel.storeCurrentEdit();
            this.panel.autoGenerateKeysBeforeSaving();
            if (FileBasedLock.waitForFileLock(this.panel.getBibDatabaseContext().getDatabaseFile().get().toPath())) {
                if (this.checkExternalModification()) {
                    return;
                }
                this.success = this.saveDatabase(this.panel.getBibDatabaseContext().getDatabaseFile().get(), false, this.panel.getBibDatabaseContext().getMetaData().getEncoding().orElse(Globals.prefs.getDefaultEncoding()));
                Globals.getFileUpdateMonitor().updateTimeStamp(this.panel.getFileMonitorHandle());
            } else {
                this.success = false;
                this.fileLockedError = true;
            }
            this.panel.setSaving(false);
            if (this.success) {
                this.panel.getUndoManager().markUnchanged();
                this.panel.setNonUndoableChange(false);
                this.panel.setBaseChanged(false);
                this.panel.setUpdatedExternally(false);
            }
        }
        catch (SaveException ex) {
            if (ex == SaveException.FILE_LOCKED) {
                this.success = false;
                this.fileLockedError = true;
                return;
            }
            LOGGER.error("Problem saving file", ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean saveDatabase(File file, boolean selectedOnly, Charset encoding) throws SaveException {
        Object session;
        this.frame.block();
        try {
            SavePreferences prefs = SavePreferences.loadForSaveFromPreferences(Globals.prefs).withEncoding(encoding);
            BibtexDatabaseWriter<SaveSession> databaseWriter = new BibtexDatabaseWriter<SaveSession>(FileSaveSession::new);
            session = selectedOnly ? databaseWriter.savePartOfDatabase(this.panel.getBibDatabaseContext(), this.panel.getSelectedEntries(), prefs) : databaseWriter.saveDatabase(this.panel.getBibDatabaseContext(), prefs);
            this.panel.registerUndoableChanges((SaveSession)session);
        }
        catch (UnsupportedCharsetException ex) {
            JOptionPane.showMessageDialog(this.frame, Localization.lang("Could not save file.", new String[0]) + Localization.lang("Character encoding '%0' is not supported.", encoding.displayName()), Localization.lang("Save database", new String[0]), 0);
            throw new SaveException("rt");
        }
        catch (SaveException ex) {
            if (ex == SaveException.FILE_LOCKED) {
                throw ex;
            }
            if (ex.specificEntry()) {
                BibEntry entry = ex.getEntry();
                this.panel.highlightEntry(entry);
            } else {
                LOGGER.error("A problem occured when trying to save the file", ex);
            }
            JOptionPane.showMessageDialog(this.frame, Localization.lang("Could not save file.", new String[0]) + ".\n" + ex.getMessage(), Localization.lang("Save database", new String[0]), 0);
            throw new SaveException("rt");
        }
        finally {
            this.frame.unblock();
        }
        boolean success = true;
        if (!((SaveSession)session).getWriter().couldEncodeAll()) {
            FormBuilder builder = FormBuilder.create().layout(new FormLayout("left:pref, 4dlu, fill:pref", "pref, 4dlu, pref"));
            JTextArea ta = new JTextArea(((SaveSession)session).getWriter().getProblemCharacters());
            ta.setEditable(false);
            builder.add(Localization.lang("The chosen encoding '%0' could not encode the following characters:", ((SaveSession)session).getEncoding().displayName()), new Object[0]).xy(1, 1);
            builder.add(ta).xy(3, 1);
            builder.add(Localization.lang("What do you want to do?", new String[0]), new Object[0]).xy(1, 3);
            String tryDiff = Localization.lang("Try different encoding", new String[0]);
            int answer = JOptionPane.showOptionDialog(this.frame, builder.getPanel(), Localization.lang("Save database", new String[0]), 1, 2, null, new String[]{Localization.lang("Save", new String[0]), tryDiff, Localization.lang("Cancel", new String[0])}, tryDiff);
            if (answer == 1) {
                Object choice = JOptionPane.showInputDialog(this.frame, Localization.lang("Select encoding", new String[0]), Localization.lang("Save database", new String[0]), 3, null, Encodings.ENCODINGS_DISPLAYNAMES, encoding);
                if (choice != null) {
                    Charset newEncoding = Charset.forName((String)choice);
                    return this.saveDatabase(file, selectedOnly, newEncoding);
                }
                success = false;
            } else if (answer == 2) {
                success = false;
            }
        }
        try {
            if (success) {
                ((SaveSession)session).commit(file.toPath());
                this.panel.getBibDatabaseContext().getMetaData().setEncoding(encoding, ChangePropagation.DO_NOT_POST_EVENT);
                return success;
            }
            ((SaveSession)session).cancel();
            return success;
        }
        catch (SaveException e) {
            int ans = JOptionPane.showConfirmDialog(null, Localization.lang("Save failed during backup creation", new String[0]) + ". " + Localization.lang("Save without backup?", new String[0]), Localization.lang("Unable to create backup", new String[0]), 0);
            if (ans != 0) return false;
            ((SaveSession)session).setUseBackup(false);
            ((SaveSession)session).commit(file.toPath());
            this.panel.getBibDatabaseContext().getMetaData().setEncoding(encoding, ChangePropagation.DO_NOT_POST_EVENT);
            return success;
        }
    }

    public void runCommand() throws Throwable {
        Worker worker = this.getWorker();
        CallBack callback = this.getCallBack();
        this.init();
        worker.run();
        callback.update();
    }

    public void save() throws Throwable {
        this.runCommand();
        this.frame.updateEnabledState();
    }

    public void saveAs() throws Throwable {
        FileDialog dialog = new FileDialog(this.frame);
        dialog.withExtension(FileExtensions.BIBTEX_DB);
        dialog.setDefaultExtension(FileExtensions.BIBTEX_DB);
        Optional<Path> path = dialog.saveNewFile();
        if (!path.isPresent()) {
            this.canceled = true;
            return;
        }
        this.saveAs(path.get().toFile());
    }

    public void saveAs(File file) throws Throwable {
        BibDatabaseContext context = this.panel.getBibDatabaseContext();
        if (context.getLocation() == DatabaseLocation.SHARED) {
            DBMSConnectionProperties properties = context.getDBMSSynchronizer().getDBProcessor().getDBMSConnectionProperties();
            new SharedDatabasePreferences(context.getDatabase().generateSharedDatabaseID()).putAllDBMSConnectionProperties(properties);
        }
        context.setDatabaseFile(file);
        Globals.prefs.put("workingDirectory", file.getParent());
        this.runCommand();
        if (!this.success) {
            return;
        }
        try {
            this.panel.setFileMonitorHandle(Globals.getFileUpdateMonitor().addUpdateListener(this.panel, context.getDatabaseFile().orElse(null)));
        }
        catch (IOException ex) {
            LOGGER.error("Problem registering file change notifications", ex);
        }
        if (this.readyForAutosave(context)) {
            AutosaveManager autosaver = AutosaveManager.start(context);
            autosaver.registerListener(new AutosaveUIManager(this.panel));
        }
        if (this.readyForBackup(context)) {
            BackupManager.start(context);
        }
        context.getDatabaseFile().ifPresent(presentFile -> this.frame.getFileHistory().newFile(presentFile.getPath()));
        this.frame.updateEnabledState();
    }

    private boolean readyForAutosave(BibDatabaseContext context) {
        return (context.getLocation() == DatabaseLocation.SHARED || context.getLocation() == DatabaseLocation.LOCAL && Globals.prefs.getBoolean("localAutoSave")) && context.getDatabaseFile().isPresent();
    }

    private boolean readyForBackup(BibDatabaseContext context) {
        return context.getLocation() == DatabaseLocation.LOCAL && context.getDatabaseFile().isPresent();
    }

    public boolean isSuccess() {
        return this.success;
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    private boolean checkExternalModification() {
        if (this.panel.isUpdatedExternally() || Globals.getFileUpdateMonitor().hasBeenModified(this.panel.getFileMonitorHandle())) {
            Object[] opts = new String[]{Localization.lang("Review changes", new String[0]), Localization.lang("Save", new String[0]), Localization.lang("Cancel", new String[0])};
            int answer = JOptionPane.showOptionDialog(this.panel.frame(), Localization.lang("File has been updated externally. What do you want to do?", new String[0]), Localization.lang("File updated externally", new String[0]), 1, 3, null, opts, opts[0]);
            if (answer == 2) {
                this.canceled = true;
                return true;
            }
            if (answer == 0) {
                this.canceled = true;
                JabRefExecutorService.INSTANCE.execute(() -> {
                    if (!FileBasedLock.waitForFileLock(this.panel.getBibDatabaseContext().getDatabaseFile().get().toPath())) {
                        LOGGER.error("File locked, this will be trouble.");
                    }
                    ChangeScanner scanner = new ChangeScanner(this.panel.frame(), this.panel, this.panel.getBibDatabaseContext().getDatabaseFile().get());
                    JabRefExecutorService.INSTANCE.executeWithLowPriorityInOwnThreadAndWait(scanner);
                    if (scanner.changesFound()) {
                        scanner.displayResult(resolved -> {
                            if (resolved) {
                                this.panel.setUpdatedExternally(false);
                                SwingUtilities.invokeLater(() -> this.panel.getSidePaneManager().hide(FileUpdatePanel.class));
                            } else {
                                this.canceled = true;
                            }
                        });
                    }
                });
                return true;
            }
            if (this.panel.getBibDatabaseContext().getMetaData().isProtected()) {
                JOptionPane.showMessageDialog(this.frame, Localization.lang("Database is protected. Cannot save until external changes have been reviewed.", new String[0]), Localization.lang("Protected database", new String[0]), 0);
                this.canceled = true;
            } else {
                this.panel.setUpdatedExternally(false);
                this.panel.getSidePaneManager().hide(FileUpdatePanel.class);
            }
        }
        return false;
    }
}

