/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.gui.exporter;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

class RtfSelection
implements Transferable {
    private static final Log LOGGER = LogFactory.getLog(RtfSelection.class);
    private DataFlavor rtfFlavor;
    private DataFlavor[] supportedFlavors;
    private final String content;

    public RtfSelection(String s) {
        this.content = s;
        try {
            this.rtfFlavor = new DataFlavor("text/rtf; class=java.io.InputStream");
            this.supportedFlavors = new DataFlavor[]{this.rtfFlavor, DataFlavor.stringFlavor};
        }
        catch (ClassNotFoundException ex) {
            LOGGER.warn("Cannot find class", ex);
        }
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor flavor) {
        return flavor.equals(this.rtfFlavor) || flavor.equals(DataFlavor.stringFlavor);
    }

    @Override
    public DataFlavor[] getTransferDataFlavors() {
        return this.supportedFlavors;
    }

    @Override
    public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
        if (flavor.equals(DataFlavor.stringFlavor)) {
            return this.content;
        }
        if (flavor.equals(this.rtfFlavor)) {
            byte[] byteArray = this.content.getBytes();
            return new ByteArrayInputStream(byteArray);
        }
        throw new UnsupportedFlavorException(flavor);
    }
}

