/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.gui.exporter;

import java.awt.Toolkit;
import java.awt.datatransfer.ClipboardOwner;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import javax.swing.BorderFactory;
import javax.swing.JList;
import javax.swing.JOptionPane;
import net.sf.jabref.Globals;
import net.sf.jabref.gui.BasePanel;
import net.sf.jabref.gui.JabRefFrame;
import net.sf.jabref.gui.exporter.RtfSelection;
import net.sf.jabref.gui.worker.AbstractWorker;
import net.sf.jabref.logic.exporter.ExportFormats;
import net.sf.jabref.logic.exporter.IExportFormat;
import net.sf.jabref.logic.l10n.Localization;
import net.sf.jabref.model.entry.BibEntry;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ExportToClipboardAction
extends AbstractWorker {
    private static final Log LOGGER = LogFactory.getLog(ExportToClipboardAction.class);
    private final JabRefFrame frame;
    private String message;

    public ExportToClipboardAction(JabRefFrame frame) {
        this.frame = Objects.requireNonNull(frame);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        BasePanel panel = this.frame.getCurrentBasePanel();
        if (panel == null) {
            return;
        }
        if (panel.getSelectedEntries().isEmpty()) {
            this.message = Localization.lang("This operation requires one or more entries to be selected.", new String[0]);
            this.getCallBack().update();
            return;
        }
        LinkedList<IExportFormat> exportFormats = new LinkedList<IExportFormat>(ExportFormats.getExportFormats().values());
        Collections.sort(exportFormats, (e1, e2) -> e1.getDisplayName().compareTo(e2.getDisplayName()));
        String[] exportFormatDisplayNames = new String[exportFormats.size()];
        for (int i = 0; i < exportFormats.size(); ++i) {
            IExportFormat exportFormat = (IExportFormat)exportFormats.get(i);
            exportFormatDisplayNames[i] = exportFormat.getDisplayName();
        }
        JList<String> list = new JList<String>(exportFormatDisplayNames);
        list.setBorder(BorderFactory.createEtchedBorder());
        list.setSelectionInterval(0, 0);
        list.setSelectionMode(0);
        int answer = JOptionPane.showOptionDialog(this.frame, list, Localization.lang("Select export format", new String[0]), 0, 3, null, new String[]{Localization.lang("Export", new String[0]), Localization.lang("Cancel", new String[0])}, Localization.lang("Export", new String[0]));
        if (answer == 1) {
            return;
        }
        IExportFormat format = (IExportFormat)exportFormats.get(list.getSelectedIndex());
        Globals.prefs.fileDirForDatabase = this.frame.getCurrentBasePanel().getBibDatabaseContext().getFileDirectory(Globals.prefs.getFileDirectoryPreferences());
        File tmp = null;
        try {
            tmp = File.createTempFile("jabrefCb", ".tmp");
            tmp.deleteOnExit();
            List<BibEntry> entries = panel.getSelectedEntries();
            format.performExport(panel.getBibDatabaseContext(), tmp.getPath(), panel.getBibDatabaseContext().getMetaData().getEncoding().orElse(Globals.prefs.getDefaultEncoding()), entries);
            StringBuilder sb = new StringBuilder();
            try (InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(tmp), panel.getBibDatabaseContext().getMetaData().getEncoding().orElse(Globals.prefs.getDefaultEncoding()));){
                int s;
                while ((s = ((Reader)reader).read()) != -1) {
                    sb.append((char)s);
                }
            }
            ClipboardOwner owner = (clipboard, content) -> {};
            RtfSelection rs = new RtfSelection(sb.toString());
            Toolkit.getDefaultToolkit().getSystemClipboard().setContents(rs, owner);
            this.message = Localization.lang("Entries exported to clipboard", new String[0]) + ": " + entries.size();
        }
        catch (Exception e) {
            LOGGER.error("Error exporting to clipboard", e);
            this.message = Localization.lang("Error exporting to clipboard", new String[0]);
        }
        finally {
            if (tmp != null && !tmp.delete()) {
                LOGGER.info("Cannot delete temporary clipboard file");
            }
        }
    }

    @Override
    public void update() {
        this.frame.output(this.message);
    }
}

