/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.gui.exporter;

import java.io.File;
import javax.swing.filechooser.FileFilter;
import net.sf.jabref.logic.exporter.IExportFormat;

public class ExportFileFilter
extends FileFilter
implements Comparable<ExportFileFilter> {
    private final IExportFormat format;
    private final String extension;
    private final String name;

    public ExportFileFilter(IExportFormat format) {
        this.format = format;
        this.extension = format.getExtension();
        this.name = format.getDisplayName() + " (*" + this.extension + ')';
    }

    public IExportFormat getExportFormat() {
        return this.format;
    }

    public String getExtension() {
        return this.extension;
    }

    @Override
    public boolean accept(File file) {
        if (file.isDirectory()) {
            return true;
        }
        return file.getPath().toLowerCase().endsWith(this.extension);
    }

    @Override
    public String getDescription() {
        return this.name;
    }

    @Override
    public int compareTo(ExportFileFilter o) {
        return this.name.compareTo(o.name);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof ExportFileFilter) {
            return this.name.equals(((ExportFileFilter)o).name);
        }
        return false;
    }

    public int hashCode() {
        return this.name.hashCode();
    }
}

