/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.gui.exporter;

import ca.odell.glazedlists.gui.TableFormat;
import ca.odell.glazedlists.swing.DefaultEventTableModel;
import com.jgoodies.forms.builder.ButtonBarBuilder;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.TableColumnModel;
import net.sf.jabref.Globals;
import net.sf.jabref.gui.JabRefFrame;
import net.sf.jabref.gui.exporter.CustomExportDialog;
import net.sf.jabref.gui.help.HelpAction;
import net.sf.jabref.gui.keyboard.KeyBinding;
import net.sf.jabref.gui.util.GUIUtil;
import net.sf.jabref.logic.exporter.SavePreferences;
import net.sf.jabref.logic.help.HelpFile;
import net.sf.jabref.logic.l10n.Localization;
import net.sf.jabref.logic.layout.LayoutFormatterPreferences;

public class ExportCustomizationDialog
extends JDialog {
    private static final int COL_0_WIDTH = 50;
    private static final int COL_1_WIDTH = 200;
    private static final int COL_2_WIDTH = 30;

    public ExportCustomizationDialog(JabRefFrame frame) {
        super(frame, Localization.lang("Manage custom exports", new String[0]), false);
        DefaultEventTableModel<List<String>> tableModel = new DefaultEventTableModel<List<String>>(Globals.prefs.customExports.getSortedList(), new ExportTableFormat());
        JTable table = new JTable(tableModel);
        TableColumnModel cm = table.getColumnModel();
        cm.getColumn(0).setPreferredWidth(50);
        cm.getColumn(1).setPreferredWidth(200);
        cm.getColumn(2).setPreferredWidth(30);
        JScrollPane sp = new JScrollPane(table, 20, 31);
        table.setSelectionMode(0);
        table.setPreferredScrollableViewportSize(new Dimension(500, 150));
        if (table.getRowCount() > 0) {
            table.setRowSelectionInterval(0, 0);
        }
        GUIUtil.correctRowHeight(table);
        JButton addExport = new JButton(Localization.lang("Add new", new String[0]));
        addExport.addActionListener(e -> {
            CustomExportDialog ecd = new CustomExportDialog(frame);
            ecd.setVisible(true);
            if (ecd.okPressed()) {
                List<String> newFormat = Arrays.asList(ecd.name(), ecd.layoutFile(), ecd.extension());
                Globals.prefs.customExports.addFormat(newFormat, Globals.prefs.getLayoutFormatterPreferences(Globals.journalAbbreviationLoader), SavePreferences.loadForExportFromPreferences(Globals.prefs));
                Globals.prefs.customExports.store(Globals.prefs);
            }
        });
        JButton modify = new JButton(Localization.lang("Modify", new String[0]));
        modify.addActionListener(e -> {
            int row = table.getSelectedRow();
            if (row == -1) {
                return;
            }
            List old = (List)Globals.prefs.customExports.getSortedList().get(row);
            CustomExportDialog ecd = new CustomExportDialog(frame, (String)old.get(0), (String)old.get(1), (String)old.get(2));
            ecd.setVisible(true);
            if (ecd.okPressed()) {
                old.set(0, ecd.name());
                old.set(1, ecd.layoutFile());
                old.set(2, ecd.extension());
                table.revalidate();
                table.repaint();
                Globals.prefs.customExports.store(Globals.prefs);
            }
        });
        JButton remove = new JButton(Localization.lang("Remove", new String[0]));
        remove.addActionListener(e -> {
            int[] rows = table.getSelectedRows();
            if (rows.length == 0) {
                return;
            }
            ArrayList<List> entries = new ArrayList<List>();
            for (int i = 0; i < rows.length; ++i) {
                entries.add((List)Globals.prefs.customExports.getSortedList().get(rows[i]));
            }
            LayoutFormatterPreferences layoutPreferences = Globals.prefs.getLayoutFormatterPreferences(Globals.journalAbbreviationLoader);
            SavePreferences savePreferences = SavePreferences.loadForExportFromPreferences(Globals.prefs);
            for (List list : entries) {
                Globals.prefs.customExports.remove(list, layoutPreferences, savePreferences);
            }
            Globals.prefs.customExports.store(Globals.prefs);
        });
        AbstractAction closeAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ExportCustomizationDialog.this.dispose();
            }
        };
        JButton close = new JButton(Localization.lang("Close", new String[0]));
        close.addActionListener(closeAction);
        JButton help = new HelpAction(HelpFile.CUSTOM_EXPORTS).getHelpButton();
        JPanel main = new JPanel();
        ActionMap am = main.getActionMap();
        InputMap im = main.getInputMap(2);
        im.put(Globals.getKeyPrefs().getKey(KeyBinding.CLOSE_DIALOG), "close");
        am.put("close", closeAction);
        main.setLayout(new BorderLayout());
        main.add((Component)sp, "Center");
        JPanel buttons = new JPanel();
        ButtonBarBuilder bb = new ButtonBarBuilder(buttons);
        buttons.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        bb.addGlue();
        bb.addButton((JComponent)addExport);
        bb.addButton((JComponent)modify);
        bb.addButton((JComponent)remove);
        bb.addButton((JComponent)close);
        bb.addUnrelatedGap();
        bb.addButton((JComponent)help);
        bb.addGlue();
        this.getContentPane().add((Component)main, "Center");
        this.getContentPane().add((Component)buttons, "South");
        this.pack();
        this.setLocationRelativeTo(frame);
        table.requestFocus();
    }

    private static class ExportTableFormat
    implements TableFormat<List<String>> {
        private ExportTableFormat() {
        }

        @Override
        public Object getColumnValue(List<String> strings, int i) {
            return strings.get(i);
        }

        @Override
        public int getColumnCount() {
            return 3;
        }

        @Override
        public String getColumnName(int col) {
            switch (col) {
                case 0: {
                    return Localization.lang("Export name", new String[0]);
                }
                case 1: {
                    return Localization.lang("Main layout file", new String[0]);
                }
            }
            return Localization.lang("Extension", new String[0]);
        }
    }
}

