/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.gui.exporter;

import java.awt.event.ActionEvent;
import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import javax.swing.AbstractAction;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;
import net.sf.jabref.Globals;
import net.sf.jabref.gui.JabRefFrame;
import net.sf.jabref.gui.actions.MnemonicAwareAction;
import net.sf.jabref.gui.exporter.ExportFileFilter;
import net.sf.jabref.gui.worker.AbstractWorker;
import net.sf.jabref.logic.exporter.ExportFormat;
import net.sf.jabref.logic.exporter.ExportFormats;
import net.sf.jabref.logic.exporter.IExportFormat;
import net.sf.jabref.logic.exporter.SavePreferences;
import net.sf.jabref.logic.l10n.Localization;
import net.sf.jabref.logic.layout.LayoutFormatterPreferences;
import net.sf.jabref.model.entry.BibEntry;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ExportAction {
    private static final Log LOGGER = LogFactory.getLog(ExportAction.class);

    public static AbstractAction getExportAction(JabRefFrame frame, boolean selectedOnly) {
        class InternalExportAction
        extends MnemonicAwareAction {
            private final JabRefFrame frame;
            private final boolean selectedOnly;

            public InternalExportAction(JabRefFrame frame, boolean selectedOnly) {
                this.frame = frame;
                this.selectedOnly = selectedOnly;
                this.putValue("Name", selectedOnly ? Localization.menuTitle("Export selected entries", new String[0]) : Localization.menuTitle("Export", new String[0]));
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                Map<String, ExportFormat> customFormats = Globals.prefs.customExports.getCustomExportFormats(Globals.prefs, Globals.journalAbbreviationLoader);
                LayoutFormatterPreferences layoutPreferences = Globals.prefs.getLayoutFormatterPreferences(Globals.journalAbbreviationLoader);
                SavePreferences savePreferences = SavePreferences.loadForExportFromPreferences(Globals.prefs);
                ExportFormats.initAllExports(customFormats, layoutPreferences, savePreferences);
                JFileChooser fc = ExportAction.createExportFileChooser(Globals.prefs.get("exportWorkingDirectory"));
                fc.showSaveDialog(this.frame);
                File file = fc.getSelectedFile();
                if (file == null) {
                    return;
                }
                FileFilter ff = fc.getFileFilter();
                if (ff instanceof ExportFileFilter) {
                    ExportFileFilter eff = (ExportFileFilter)ff;
                    String path = file.getPath();
                    if (!path.endsWith(eff.getExtension())) {
                        path = path + eff.getExtension();
                    }
                    if ((file = new File(path)).exists() && JOptionPane.showConfirmDialog(this.frame, Localization.lang("'%0' exists. Overwrite file?", file.getName()), Localization.lang("Export", new String[0]), 2) != 0) {
                        return;
                    }
                    final IExportFormat format = eff.getExportFormat();
                    List<BibEntry> entries = this.selectedOnly ? this.frame.getCurrentBasePanel().getSelectedEntries() : this.frame.getCurrentBasePanel().getDatabase().getEntries();
                    Globals.prefs.fileDirForDatabase = this.frame.getCurrentBasePanel().getBibDatabaseContext().getFileDirectory(Globals.prefs.getFileDirectoryPreferences());
                    Globals.prefs.put("lastUsedExport", format.getConsoleName());
                    Globals.prefs.put("exportWorkingDirectory", file.getParent());
                    final File finFile = file;
                    final List<BibEntry> finEntries = entries;
                    AbstractWorker exportWorker = new AbstractWorker(){
                        String errorMessage;

                        @Override
                        public void run() {
                            try {
                                format.performExport(frame.getCurrentBasePanel().getBibDatabaseContext(), finFile.getPath(), frame.getCurrentBasePanel().getBibDatabaseContext().getMetaData().getEncoding().orElse(Globals.prefs.getDefaultEncoding()), (List<BibEntry>)finEntries);
                            }
                            catch (Exception ex) {
                                LOGGER.warn("Problem exporting", ex);
                                this.errorMessage = ex.getMessage() == null ? ex.toString() : ex.getMessage();
                            }
                        }

                        @Override
                        public void update() {
                            if (this.errorMessage == null) {
                                frame.output(Localization.lang("%0 export successful", format.getDisplayName()));
                            } else {
                                frame.output(Localization.lang("Could not save file.", new String[0]) + " - " + this.errorMessage);
                                JOptionPane.showMessageDialog(frame, Localization.lang("Could not save file.", new String[0]) + "\n" + this.errorMessage, Localization.lang("Save database", new String[0]), 0);
                            }
                        }
                    };
                    exportWorker.getWorker().run();
                    exportWorker.update();
                }
            }
        }
        return new InternalExportAction(frame, selectedOnly);
    }

    private static JFileChooser createExportFileChooser(String currentDir) {
        String lastUsedFormat = Globals.prefs.get("lastUsedExport");
        ExportFileFilter defaultFilter = null;
        JFileChooser fc = new JFileChooser(currentDir);
        TreeSet<ExportFileFilter> filters = new TreeSet<ExportFileFilter>();
        for (Map.Entry<String, IExportFormat> entry : ExportFormats.getExportFormats().entrySet()) {
            String formatName = entry.getKey();
            IExportFormat format = entry.getValue();
            ExportFileFilter exportFileFilter = new ExportFileFilter(format);
            filters.add(exportFileFilter);
            if (!formatName.equals(lastUsedFormat)) continue;
            defaultFilter = exportFileFilter;
        }
        for (FileFilter fileFilter : filters) {
            fc.addChoosableFileFilter(fileFilter);
        }
        fc.setAcceptAllFileFilterUsed(false);
        if (defaultFilter != null) {
            fc.setFileFilter(defaultFilter);
        }
        return fc;
    }
}

