/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.gui.exporter;

import com.jgoodies.forms.builder.ButtonBarBuilder;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.nio.file.Path;
import java.nio.file.Paths;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import net.sf.jabref.Globals;
import net.sf.jabref.gui.FileDialog;
import net.sf.jabref.gui.JabRefFrame;
import net.sf.jabref.gui.keyboard.KeyBinding;
import net.sf.jabref.logic.l10n.Localization;
import net.sf.jabref.logic.util.FileExtensions;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

class CustomExportDialog
extends JDialog {
    private static final Log LOGGER = LogFactory.getLog(CustomExportDialog.class);
    private final JTextField name = new JTextField(60);
    private final JTextField layoutFile = new JTextField(60);
    private final JTextField extension = new JTextField(60);
    private JabRefFrame frame;
    private boolean okPressed;

    public CustomExportDialog(JabRefFrame parent, String exporterName, String layoutFileName, String extensionName) {
        this(parent);
        this.frame = parent;
        this.name.setText(exporterName);
        this.layoutFile.setText(layoutFileName);
        this.extension.setText(extensionName);
    }

    public CustomExportDialog(JabRefFrame parent) {
        super(parent, Localization.lang("Edit custom export", new String[0]), true);
        this.frame = parent;
        ActionListener okListener = e -> {
            Path layoutFileDir = Paths.get(this.layoutFile.getText(), new String[0]).getParent();
            if (layoutFileDir != null) {
                Globals.prefs.put("exportWorkingDirectory", layoutFileDir.toString());
            }
            if (this.layoutFile.getText().isEmpty() || this.name.getText().isEmpty() || this.extension.getText().isEmpty() || !this.layoutFile.getText().endsWith(".layout")) {
                LOGGER.info("One field is empty!");
                return;
            }
            this.okPressed = true;
            this.dispose();
        };
        this.layoutFile.setText(Globals.prefs.get("exportWorkingDirectory"));
        JButton ok = new JButton(Localization.lang("OK", new String[0]));
        ok.addActionListener(okListener);
        this.name.addActionListener(okListener);
        this.layoutFile.addActionListener(okListener);
        this.extension.addActionListener(okListener);
        JButton cancel = new JButton(Localization.lang("Cancel", new String[0]));
        cancel.addActionListener(e -> this.dispose());
        JButton browse = new JButton(Localization.lang("Browse", new String[0]));
        FileDialog dialog = new FileDialog(this.frame).withExtension(FileExtensions.LAYOUT);
        dialog.setDefaultExtension(FileExtensions.LAYOUT);
        browse.addActionListener(e -> dialog.showDialogAndGetSelectedFile().ifPresent(f -> this.layoutFile.setText(f.toAbsolutePath().toString())));
        AbstractAction cancelAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CustomExportDialog.this.dispose();
            }
        };
        JPanel main = new JPanel();
        ActionMap am = main.getActionMap();
        InputMap im = main.getInputMap(2);
        im.put(Globals.getKeyPrefs().getKey(KeyBinding.CLOSE_DIALOG), "close");
        am.put("close", cancelAction);
        GridBagLayout gbl = new GridBagLayout();
        main.setLayout(gbl);
        main.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), Localization.lang("Export properties", new String[0])));
        GridBagConstraints con = new GridBagConstraints();
        con.weightx = 0.0;
        con.gridwidth = 1;
        con.insets = new Insets(3, 5, 3, 5);
        con.anchor = 13;
        con.fill = 0;
        con.gridx = 0;
        con.gridy = 0;
        JLabel nl = new JLabel(Localization.lang("Export name", new String[0]) + ':');
        gbl.setConstraints(nl, con);
        main.add(nl);
        con.gridy = 1;
        JLabel nr = new JLabel(Localization.lang("Main layout file", new String[0]) + ':');
        gbl.setConstraints(nr, con);
        main.add(nr);
        con.gridy = 2;
        JLabel nf = new JLabel(Localization.lang("Extension", new String[0]) + ':');
        gbl.setConstraints(nf, con);
        main.add(nf);
        con.gridwidth = 2;
        con.weightx = 1.0;
        con.anchor = 17;
        con.fill = 2;
        con.gridy = 0;
        con.gridx = 1;
        gbl.setConstraints(this.name, con);
        main.add(this.name);
        con.gridy = 1;
        con.gridwidth = 1;
        gbl.setConstraints(this.layoutFile, con);
        main.add(this.layoutFile);
        con.gridx = 2;
        con.weightx = 0.0;
        gbl.setConstraints(browse, con);
        main.add(browse);
        con.weightx = 1.0;
        con.gridwidth = 2;
        con.gridx = 1;
        con.gridy = 2;
        gbl.setConstraints(this.extension, con);
        main.add(this.extension);
        JPanel buttons = new JPanel();
        ButtonBarBuilder bb = new ButtonBarBuilder(buttons);
        buttons.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        bb.addGlue();
        bb.addButton((JComponent)ok);
        bb.addButton((JComponent)cancel);
        bb.addGlue();
        this.getContentPane().add((Component)main, "Center");
        this.getContentPane().add((Component)buttons, "South");
        this.setSize(700, 200);
        this.setLocationRelativeTo(parent);
    }

    public boolean okPressed() {
        return this.okPressed;
    }

    public String layoutFile() {
        return this.layoutFile.getText();
    }

    public String name() {
        return this.name.getText();
    }

    public String extension() {
        String ext = this.extension.getText();
        if (ext.startsWith(".")) {
            return ext;
        }
        if (ext.startsWith("*.")) {
            return ext.substring(1);
        }
        return '.' + ext;
    }
}

