/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.gui.entryeditor;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.util.Optional;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;
import net.sf.jabref.Globals;
import net.sf.jabref.gui.BasePanel;
import net.sf.jabref.gui.date.DatePickerButton;
import net.sf.jabref.gui.desktop.JabRefDesktop;
import net.sf.jabref.gui.entryeditor.EntryEditor;
import net.sf.jabref.gui.fieldeditors.FieldEditor;
import net.sf.jabref.gui.mergeentries.FetchAndMergeEntry;
import net.sf.jabref.gui.undo.UndoableFieldChange;
import net.sf.jabref.logic.journals.JournalAbbreviationRepository;
import net.sf.jabref.logic.l10n.Localization;
import net.sf.jabref.logic.net.URLUtil;
import net.sf.jabref.logic.util.DOI;
import net.sf.jabref.logic.util.ISBN;
import net.sf.jabref.logic.util.date.EasyDateFormat;
import net.sf.jabref.model.database.BibDatabaseMode;
import net.sf.jabref.model.entry.BibEntry;
import net.sf.jabref.model.entry.FieldName;
import net.sf.jabref.model.entry.MonthUtil;

public class FieldExtraComponents {
    private static final String ABBREVIATION_TOOLTIP_TEXT = "<HTML>" + Localization.lang("Switches between full and abbreviated journal name if the journal name is known.", new String[0]) + "<BR>" + Localization.lang("To set up, go to", new String[0]) + " <B>" + Localization.lang("Options", new String[0]) + " -> " + Localization.lang("Manage journal abbreviations", new String[0]) + "</B></HTML>";

    public static Optional<JComponent> getJournalExtraComponent(BasePanel panel, FieldEditor editor, BibEntry entry, EntryEditor.StoreFieldAction storeFieldAction) {
        JPanel controls = new JPanel();
        controls.setLayout(new BorderLayout());
        JButton button = new JButton(Localization.lang("Toggle abbreviation", new String[0]));
        button.setToolTipText(ABBREVIATION_TOOLTIP_TEXT);
        button.addActionListener(actionEvent -> {
            String s;
            String text = editor.getText();
            JournalAbbreviationRepository abbreviationRepository = Globals.journalAbbreviationLoader.getRepository(Globals.prefs.getJournalAbbreviationPreferences());
            if (abbreviationRepository.isKnownName(text) && (s = abbreviationRepository.getNextAbbreviation(text).orElse(text)) != null) {
                editor.setText(s);
                storeFieldAction.actionPerformed(new ActionEvent(editor, 0, ""));
                panel.getUndoManager().addEdit(new UndoableFieldChange(entry, editor.getFieldName(), text, s));
            }
        });
        controls.add((Component)button, "South");
        return Optional.of(controls);
    }

    public static Optional<JComponent> getExternalExtraComponent(BasePanel panel, FieldEditor fieldEditor) {
        JPanel controls = new JPanel();
        controls.setLayout(new BorderLayout());
        final JButton button = new JButton(Localization.lang("Open", new String[0]));
        button.setEnabled(false);
        button.addActionListener(actionEvent -> {
            try {
                JabRefDesktop.openExternalViewer(panel.getBibDatabaseContext(), fieldEditor.getText(), fieldEditor.getFieldName());
            }
            catch (IOException ex) {
                panel.output(Localization.lang("Unable to open link.", new String[0]));
            }
        });
        controls.add((Component)button, "South");
        final JTextComponent url = (JTextComponent)((Object)fieldEditor);
        url.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                this.checkUrl();
            }

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                this.checkUrl();
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                this.checkUrl();
            }

            private void checkUrl() {
                if (URLUtil.isURL(url.getText())) {
                    button.setEnabled(true);
                } else {
                    button.setEnabled(false);
                }
            }
        });
        return Optional.of(controls);
    }

    public static Optional<JComponent> getDoiExtraComponent(BasePanel panel, EntryEditor entryEditor, FieldEditor fieldEditor) {
        JPanel controls = new JPanel();
        controls.setLayout(new BorderLayout());
        final JButton button = new JButton(Localization.lang("Open", new String[0]));
        button.setEnabled(false);
        button.addActionListener(actionEvent -> {
            try {
                JabRefDesktop.openExternalViewer(panel.getBibDatabaseContext(), fieldEditor.getText(), fieldEditor.getFieldName());
            }
            catch (IOException ex) {
                panel.output(Localization.lang("Unable to open link.", new String[0]));
            }
        });
        JButton doiButton = new JButton(Localization.lang("Lookup DOI", new String[0]));
        doiButton.addActionListener(actionEvent -> {
            Optional<DOI> doi = DOI.fromBibEntry(entryEditor.getEntry());
            if (doi.isPresent()) {
                entryEditor.getEntry().setField("doi", doi.get().getDOI());
            } else {
                panel.frame().setStatus(Localization.lang("No %0 found", FieldName.getDisplayName("doi")));
            }
        });
        final JButton fetchButton = new JButton(Localization.lang("Get BibTeX data from %0", FieldName.getDisplayName("doi")));
        fetchButton.setEnabled(false);
        fetchButton.addActionListener(actionEvent -> {
            BibEntry entry = entryEditor.getEntry();
            new FetchAndMergeEntry(entry, panel, "doi");
        });
        controls.add((Component)button, "North");
        controls.add((Component)doiButton, "Center");
        controls.add((Component)fetchButton, "South");
        final JTextComponent doi = (JTextComponent)((Object)fieldEditor);
        doi.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                this.checkDoi();
            }

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                this.checkDoi();
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                this.checkDoi();
            }

            private void checkDoi() {
                Optional<DOI> doiUrl = DOI.build(doi.getText());
                if (doiUrl.isPresent()) {
                    button.setEnabled(true);
                    fetchButton.setEnabled(true);
                } else {
                    button.setEnabled(false);
                    fetchButton.setEnabled(false);
                }
            }
        });
        return Optional.of(controls);
    }

    public static Optional<JComponent> getIsbnExtraComponent(BasePanel panel, EntryEditor entryEditor, FieldEditor fieldEditor) {
        final JButton fetchButton = new JButton(Localization.lang("Get BibTeX data from %0", FieldName.getDisplayName("isbn")));
        fetchButton.setEnabled(false);
        fetchButton.addActionListener(actionEvent -> {
            BibEntry entry = entryEditor.getEntry();
            new FetchAndMergeEntry(entry, panel, "isbn");
        });
        final JTextComponent isbn = (JTextComponent)((Object)fieldEditor);
        isbn.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                this.checkIsbn();
            }

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                this.checkIsbn();
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                this.checkIsbn();
            }

            private void checkIsbn() {
                ISBN isbnString = new ISBN(isbn.getText());
                if (isbnString.isValidFormat()) {
                    fetchButton.setEnabled(true);
                } else {
                    fetchButton.setEnabled(false);
                }
            }
        });
        return Optional.of(fetchButton);
    }

    public static Optional<JComponent> getEprintExtraComponent(BasePanel panel, EntryEditor entryEditor, FieldEditor fieldEditor) {
        final JButton fetchButton = new JButton(Localization.lang("Get BibTeX data from %0", FieldName.getDisplayName("eprint")));
        fetchButton.setEnabled(false);
        fetchButton.addActionListener(actionEvent -> {
            BibEntry entry = entryEditor.getEntry();
            new FetchAndMergeEntry(entry, panel, "eprint");
        });
        final JTextComponent eprint = (JTextComponent)((Object)fieldEditor);
        eprint.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                this.checkEprint();
            }

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                this.checkEprint();
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                this.checkEprint();
            }

            private void checkEprint() {
                if (eprint.getText() == null || eprint.getText().trim().isEmpty()) {
                    fetchButton.setEnabled(false);
                } else {
                    fetchButton.setEnabled(true);
                }
            }
        });
        return Optional.of(fetchButton);
    }

    public static Optional<JComponent> getYesNoExtraComponent(FieldEditor fieldEditor, EntryEditor entryEditor) {
        String[] options = new String[]{"", "Yes", "No"};
        JComboBox<String> yesno = new JComboBox<String>(options);
        yesno.addActionListener(actionEvent -> {
            fieldEditor.setText(((String)yesno.getSelectedItem()).toLowerCase());
            entryEditor.updateField(fieldEditor);
        });
        return Optional.of(yesno);
    }

    public static Optional<JComponent> getMonthExtraComponent(FieldEditor fieldEditor, EntryEditor entryEditor, BibDatabaseMode type) {
        String[] options = new String[13];
        options[0] = Localization.lang("Select", new String[0]);
        for (int i = 1; i <= 12; ++i) {
            options[i] = MonthUtil.getMonthByNumber((int)i).fullName;
        }
        JComboBox<String> month = new JComboBox<String>(options);
        month.addActionListener(actionEvent -> {
            int monthnumber = month.getSelectedIndex();
            if (monthnumber >= 1) {
                if (type == BibDatabaseMode.BIBLATEX) {
                    fieldEditor.setText(String.valueOf(monthnumber));
                } else {
                    fieldEditor.setText(MonthUtil.getMonthByNumber((int)monthnumber).bibtexFormat);
                }
            } else {
                fieldEditor.setText("");
            }
            entryEditor.updateField(fieldEditor);
            month.setSelectedIndex(0);
        });
        return Optional.of(month);
    }

    public static Optional<JComponent> getSetOwnerExtraComponent(FieldEditor fieldEditor, EntryEditor.StoreFieldAction storeFieldAction) {
        JButton button = new JButton(Localization.lang("Auto", new String[0]));
        button.addActionListener(actionEvent -> {
            fieldEditor.setText(Globals.prefs.get("defaultOwner"));
            storeFieldAction.actionPerformed(new ActionEvent(fieldEditor, 0, ""));
        });
        return Optional.of(button);
    }

    public static Optional<JComponent> getDateTimeExtraComponent(final FieldEditor editor, Boolean isDatePicker, Boolean isoFormat) {
        ((JTextArea)((Object)editor)).addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    String date = EasyDateFormat.isoDateFormat().getCurrentDate();
                    editor.setText(date);
                }
            }
        });
        if (isDatePicker.booleanValue()) {
            DatePickerButton datePicker = new DatePickerButton(editor, isoFormat);
            return Optional.of(datePicker.getDatePicker());
        }
        return Optional.empty();
    }

    public static Optional<JComponent> getEditorTypeExtraComponent(FieldEditor fieldEditor, EntryEditor entryEditor) {
        String[] optionValues = new String[]{"", "editor", "compiler", "founder", "continuator", "redactor", "reviser", "collaborator"};
        String[] optionDescriptions = new String[]{Localization.lang("Select", new String[0]), Localization.lang("Editor", new String[0]), Localization.lang("Compiler", new String[0]), Localization.lang("Founder", new String[0]), Localization.lang("Continuator", new String[0]), Localization.lang("Redactor", new String[0]), Localization.lang("Reviser", new String[0]), Localization.lang("Collaborator", new String[0])};
        JComboBox<String> editorType = new JComboBox<String>(optionDescriptions);
        editorType.addActionListener(actionEvent -> {
            fieldEditor.setText(optionValues[editorType.getSelectedIndex()]);
            entryEditor.updateField(fieldEditor);
        });
        return Optional.of(editorType);
    }

    public static Optional<JComponent> getPaginationExtraComponent(FieldEditor fieldEditor, EntryEditor entryEditor) {
        String[] optionValues = new String[]{"", "page", "column", "line", "verse", "section", "paragraph", "none"};
        String[] optionDescriptions = new String[]{Localization.lang("Select", new String[0]), Localization.lang("Page", new String[0]), Localization.lang("Column", new String[0]), Localization.lang("Line", new String[0]), Localization.lang("Verse", new String[0]), Localization.lang("Section", new String[0]), Localization.lang("Paragraph", new String[0]), Localization.lang("None", new String[0])};
        JComboBox<String> pagination = new JComboBox<String>(optionDescriptions);
        pagination.addActionListener(actionEvent -> {
            fieldEditor.setText(optionValues[pagination.getSelectedIndex()]);
            entryEditor.updateField(fieldEditor);
        });
        return Optional.of(pagination);
    }

    public static Optional<JComponent> getTypeExtraComponent(FieldEditor fieldEditor, EntryEditor entryEditor, boolean isPatent) {
        String[] optionDescriptions;
        String[] optionValues;
        if (isPatent) {
            optionValues = new String[]{"", "patent", "patentde", "patenteu", "patentfr", "patentuk", "patentus", "patreq", "patreqde", "patreqeu", "patreqfr", "patrequk", "patrequs"};
            optionDescriptions = new String[]{Localization.lang("Select", new String[0]), Localization.lang("Patent", new String[0]), Localization.lang("German patent", new String[0]), Localization.lang("European patent", new String[0]), Localization.lang("French patent", new String[0]), Localization.lang("British patent", new String[0]), Localization.lang("U.S. patent", new String[0]), Localization.lang("Patent request", new String[0]), Localization.lang("German patent request", new String[0]), Localization.lang("European patent request", new String[0]), Localization.lang("French patent request", new String[0]), Localization.lang("British patent request", new String[0]), Localization.lang("U.S. patent request", new String[0])};
        } else {
            optionValues = new String[]{"", "mathesis", "phdthesis", "candthesis", "techreport", "resreport", "software", "datacd", "audiocd"};
            optionDescriptions = new String[]{Localization.lang("Select", new String[0]), Localization.lang("Master's thesis", new String[0]), Localization.lang("PhD thesis", new String[0]), Localization.lang("Candidate thesis", new String[0]), Localization.lang("Technical report", new String[0]), Localization.lang("Research report", new String[0]), Localization.lang("Software", new String[0]), Localization.lang("Data CD", new String[0]), Localization.lang("Audio CD", new String[0])};
        }
        JComboBox<String> type = new JComboBox<String>(optionDescriptions);
        type.addActionListener(actionEvent -> {
            fieldEditor.setText(optionValues[type.getSelectedIndex()]);
            entryEditor.updateField(fieldEditor);
        });
        return Optional.of(type);
    }

    public static Optional<JComponent> getGenderExtraComponent(FieldEditor fieldEditor, EntryEditor entryEditor) {
        String[] optionValues = new String[]{"", "sf", "sm", "sp", "pf", "pm", "pn", "pp"};
        String[] optionDescriptions = new String[]{Localization.lang("Select", new String[0]), Localization.lang("Female name", new String[0]), Localization.lang("Male name", new String[0]), Localization.lang("Neuter name", new String[0]), Localization.lang("Female names", new String[0]), Localization.lang("Male names", new String[0]), Localization.lang("Neuter names", new String[0]), Localization.lang("Mixed names", new String[0])};
        JComboBox<String> gender = new JComboBox<String>(optionDescriptions);
        gender.addActionListener(actionEvent -> {
            fieldEditor.setText(optionValues[gender.getSelectedIndex()]);
            entryEditor.updateField(fieldEditor);
        });
        return Optional.of(gender);
    }
}

