/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.gui.entryeditor;

import java.awt.Container;
import java.awt.Rectangle;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;
import net.sf.jabref.gui.entryeditor.EntryEditorTab;
import net.sf.jabref.gui.fieldeditors.FieldEditor;

class EntryEditorTabFocusListener
implements FocusListener {
    private JTextComponent textComponent;
    private DocumentListener documentListener;
    private final EntryEditorTab entryEditorTab;

    public EntryEditorTabFocusListener(EntryEditorTab entryEditorTab) {
        this.entryEditorTab = entryEditorTab;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void focusGained(FocusEvent event) {
        EntryEditorTabFocusListener entryEditorTabFocusListener = this;
        synchronized (entryEditorTabFocusListener) {
            if (this.textComponent != null) {
                this.textComponent.getDocument().removeDocumentListener(this.documentListener);
                this.textComponent = null;
                this.documentListener = null;
            }
            if (event.getSource() instanceof JTextComponent) {
                JScrollPane scrollPane;
                Container scrollPaneParent;
                this.textComponent = (JTextComponent)event.getSource();
                this.documentListener = new DocumentListener(){

                    private void fire() {
                        if (EntryEditorTabFocusListener.this.textComponent.isFocusOwner()) {
                            EntryEditorTabFocusListener.this.entryEditorTab.markIfModified((FieldEditor)((Object)EntryEditorTabFocusListener.this.textComponent));
                        }
                    }

                    @Override
                    public void changedUpdate(DocumentEvent e) {
                        this.fire();
                    }

                    @Override
                    public void insertUpdate(DocumentEvent e) {
                        this.fire();
                    }

                    @Override
                    public void removeUpdate(DocumentEvent e) {
                        this.fire();
                    }
                };
                this.textComponent.getDocument().addDocumentListener(this.documentListener);
                Container component = this.textComponent.getParent().getParent();
                if (component instanceof JScrollPane && (scrollPaneParent = (scrollPane = (JScrollPane)component).getParent()) instanceof JPanel) {
                    JPanel panel = (JPanel)scrollPaneParent;
                    Rectangle bounds = scrollPane.getBounds();
                    panel.scrollRectToVisible(bounds);
                }
            }
        }
        this.entryEditorTab.setActive((FieldEditor)event.getSource());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void focusLost(FocusEvent event) {
        EntryEditorTabFocusListener entryEditorTabFocusListener = this;
        synchronized (entryEditorTabFocusListener) {
            if (this.textComponent != null) {
                this.textComponent.getDocument().removeDocumentListener(this.documentListener);
                this.textComponent = null;
                this.documentListener = null;
            }
        }
        if (!event.isTemporary()) {
            this.entryEditorTab.getParent().updateField(event.getSource());
        }
    }
}

