/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.gui.entryeditor;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.AWTKeyStroke;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.FocusListener;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.text.JTextComponent;
import net.sf.jabref.Globals;
import net.sf.jabref.gui.BasePanel;
import net.sf.jabref.gui.JabRefFrame;
import net.sf.jabref.gui.autocompleter.AutoCompleteListener;
import net.sf.jabref.gui.entryeditor.EntryEditor;
import net.sf.jabref.gui.entryeditor.EntryEditorTabFocusListener;
import net.sf.jabref.gui.fieldeditors.EntryLinkListEditor;
import net.sf.jabref.gui.fieldeditors.FieldEditor;
import net.sf.jabref.gui.fieldeditors.FileListEditor;
import net.sf.jabref.gui.fieldeditors.TextArea;
import net.sf.jabref.gui.fieldeditors.TextField;
import net.sf.jabref.gui.keyboard.KeyBinding;
import net.sf.jabref.gui.util.GUIUtil;
import net.sf.jabref.logic.autocompleter.AutoCompleter;
import net.sf.jabref.logic.l10n.Localization;
import net.sf.jabref.model.entry.BibEntry;
import net.sf.jabref.model.entry.FieldProperty;
import net.sf.jabref.model.entry.InternalBibtexFields;

class EntryEditorTab {
    private final JPanel panel = new JPanel();
    private final JScrollPane scrollPane = new JScrollPane(this.panel, 20, 31);
    private final List<String> fields;
    private final EntryEditor parent;
    private final Map<String, FieldEditor> editors = new HashMap<String, FieldEditor>();
    private FieldEditor activeField;
    public FileListEditor fileListEditor;
    private BibEntry entry;
    private final FocusListener fieldListener = new EntryEditorTabFocusListener(this);
    private final String tabTitle;
    private final JabRefFrame frame;
    private final BasePanel basePanel;
    private boolean updating;

    public EntryEditorTab(JabRefFrame frame, BasePanel panel, List<String> fields, EntryEditor parent, boolean addKeyField, boolean compressed, String tabTitle) {
        this.fields = fields == null ? Collections.emptyList() : fields;
        this.parent = parent;
        this.tabTitle = tabTitle;
        this.frame = frame;
        this.basePanel = panel;
        this.setupPanel(frame, panel, addKeyField, compressed, tabTitle);
        this.scrollPane.setFocusCycleRoot(true);
    }

    private void setupPanel(JabRefFrame frame, BasePanel bPanel, boolean addKeyField, boolean compressed, String title) {
        this.setupKeyBindings(this.panel.getInputMap(0), this.panel.getActionMap());
        this.panel.setName(title);
        this.scrollPane.setName(title);
        int fieldsPerRow = compressed ? 2 : 1;
        String colSpec = compressed ? "fill:pref, 1dlu, fill:10dlu:grow, 1dlu, fill:pref, 8dlu, fill:pref, 1dlu, fill:10dlu:grow, 1dlu, fill:pref" : "fill:pref, 1dlu, fill:pref:grow, 1dlu, fill:pref";
        StringBuilder stringBuilder = new StringBuilder();
        int rows = (int)Math.ceil((double)this.fields.size() / (double)fieldsPerRow);
        for (int i = 0; i < rows; ++i) {
            stringBuilder.append("fill:pref:grow, ");
        }
        if (addKeyField) {
            stringBuilder.append("4dlu, fill:pref");
        } else if (stringBuilder.length() >= 2) {
            stringBuilder.delete(stringBuilder.length() - 2, stringBuilder.length());
        }
        String rowSpec = stringBuilder.toString();
        DefaultFormBuilder builder = new DefaultFormBuilder(new FormLayout(colSpec, rowSpec), this.panel);
        for (int i = 0; i < this.fields.size(); ++i) {
            int defaultHeight;
            JComponent fieldEditor;
            String field = this.fields.get(i);
            int wHeight = (int)(50.0 * InternalBibtexFields.getFieldWeight(field));
            if (InternalBibtexFields.getFieldProperties(field).contains((Object)FieldProperty.FILE_EDITOR)) {
                fieldEditor = new FileListEditor(frame, bPanel.getBibDatabaseContext(), field, null, this.parent);
                this.fileListEditor = fieldEditor;
                GUIUtil.correctRowHeight(this.fileListEditor);
                defaultHeight = 0;
            } else if (InternalBibtexFields.getFieldProperties(field).contains((Object)FieldProperty.SINGLE_ENTRY_LINK)) {
                fieldEditor = new EntryLinkListEditor(frame, bPanel.getBibDatabaseContext(), field, null, this.parent, true);
                defaultHeight = 0;
            } else if (InternalBibtexFields.getFieldProperties(field).contains((Object)FieldProperty.MULTIPLE_ENTRY_LINK)) {
                fieldEditor = new EntryLinkListEditor(frame, bPanel.getBibDatabaseContext(), field, null, this.parent, false);
                defaultHeight = 0;
            } else {
                fieldEditor = new TextArea(field, null, this.getPrompt(field));
                this.parent.addSearchListener((TextArea)fieldEditor);
                defaultHeight = fieldEditor.getPane().getPreferredSize().height;
            }
            Optional<JComponent> extra = this.parent.getExtra((FieldEditor)((Object)fieldEditor));
            AutoCompleter autoCompleter = bPanel.getAutoCompleters().get(field);
            AutoCompleteListener autoCompleteListener = null;
            if (autoCompleter != null) {
                autoCompleteListener = new AutoCompleteListener(autoCompleter);
            }
            this.setupJTextComponent(fieldEditor.getTextComponent(), autoCompleteListener);
            fieldEditor.setAutoCompleteListener(autoCompleteListener);
            this.editors.put(field, (FieldEditor)((Object)fieldEditor));
            if (i == 0) {
                this.activeField = fieldEditor;
            }
            if (!compressed) {
                fieldEditor.getPane().setPreferredSize(new Dimension(100, Math.max(defaultHeight, wHeight)));
            }
            builder.append(fieldEditor.getLabel());
            if (extra.isPresent()) {
                builder.append(fieldEditor.getPane());
                JPanel pan = new JPanel();
                pan.setLayout(new BorderLayout());
                pan.add((Component)extra.get(), "North");
                builder.append(pan);
            } else {
                builder.append((Component)fieldEditor.getPane(), 3);
            }
            if ((i + 1) % fieldsPerRow != 0) continue;
            builder.nextLine();
        }
        if (addKeyField) {
            TextField textField = new TextField("bibtexkey", this.parent.getEntry().getCiteKeyOptional().orElse(""), true);
            this.setupJTextComponent(textField, null);
            this.editors.put("bibtexkey", textField);
            if (this.editors.size() == 1) {
                this.activeField = textField;
            }
            builder.nextLine();
            builder.append(textField.getLabel());
            builder.append((Component)textField, 3);
        }
    }

    private String getPrompt(String field) {
        Set<FieldProperty> fieldProperties = InternalBibtexFields.getFieldProperties(field);
        if (fieldProperties.contains((Object)FieldProperty.PERSON_NAMES)) {
            return String.format("%1$s and %1$s and others", Localization.lang("Firstname Lastname", new String[0]));
        }
        if (fieldProperties.contains((Object)FieldProperty.DOI)) {
            return "10.ORGANISATION/ID";
        }
        if (fieldProperties.contains((Object)FieldProperty.DATE)) {
            return "YYYY-MM-DD";
        }
        switch (field) {
            case "year": {
                return "YYYY";
            }
            case "month": {
                return "MM or #mmm#";
            }
            case "url": {
                return "https://";
            }
        }
        return "";
    }

    private BibEntry getEntry() {
        return this.entry;
    }

    private boolean isFieldModified(FieldEditor fieldEditor) {
        String text = fieldEditor.getText().trim();
        if (text.isEmpty()) {
            return this.getEntry().hasField(fieldEditor.getFieldName());
        }
        return !Optional.of(text).equals(this.getEntry().getField(fieldEditor.getFieldName()));
    }

    public void markIfModified(FieldEditor fieldEditor) {
        if (!this.updating && !this.basePanel.isModified() && this.isFieldModified(fieldEditor)) {
            this.markBaseChanged();
        }
    }

    private void markBaseChanged() {
        this.basePanel.markBaseChanged();
    }

    public void setActive(FieldEditor fieldEditor) {
        this.activeField = fieldEditor;
    }

    public void setActive(String fieldName) {
        if (this.editors.containsKey(fieldName)) {
            this.activeField = this.editors.get(fieldName);
        }
    }

    public FieldEditor getActive() {
        return this.activeField;
    }

    public List<String> getFields() {
        return this.fields;
    }

    public void focus() {
        if (this.activeField != null) {
            this.activeField.getTextComponent().requestFocus();
        }
    }

    public void updateAll() {
        this.setEntry(this.getEntry());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setEntry(BibEntry entry) {
        try {
            this.updating = true;
            for (FieldEditor editor : this.editors.values()) {
                String toSet = entry.getField(editor.getFieldName()).orElse("");
                if (toSet.equals(editor.getText())) continue;
                editor.setText(toSet);
            }
            this.entry = entry;
        }
        finally {
            this.updating = false;
        }
    }

    public boolean updateField(String field, String content) {
        if (!this.editors.containsKey(field)) {
            return false;
        }
        FieldEditor fieldEditor = this.editors.get(field);
        if (fieldEditor.getText().equals(content)) {
            return true;
        }
        if (fieldEditor.getTextComponent() instanceof JTextComponent) {
            int initialCaretPosition = ((JTextComponent)((Object)fieldEditor)).getCaretPosition();
            fieldEditor.setText(content);
            int textLength = fieldEditor.getText().length();
            if (initialCaretPosition < textLength) {
                ((JTextComponent)((Object)fieldEditor)).setCaretPosition(initialCaretPosition);
            } else {
                ((JTextComponent)((Object)fieldEditor)).setCaretPosition(textLength);
            }
        } else {
            fieldEditor.setText(content);
        }
        return true;
    }

    public void setEnabled(boolean enabled) {
        for (FieldEditor editor : this.editors.values()) {
            editor.setEnabled(enabled);
        }
    }

    public Component getPane() {
        return this.scrollPane;
    }

    public EntryEditor getParent() {
        return this.parent;
    }

    public String getTabTitle() {
        return this.tabTitle;
    }

    private void setupKeyBindings(InputMap inputMap, ActionMap actionMap) {
        inputMap.put(Globals.getKeyPrefs().getKey(KeyBinding.ENTRY_EDITOR_PREVIOUS_ENTRY), "prev");
        actionMap.put("prev", this.parent.getPrevEntryAction());
        inputMap.put(Globals.getKeyPrefs().getKey(KeyBinding.ENTRY_EDITOR_NEXT_ENTRY), "next");
        actionMap.put("next", this.parent.getNextEntryAction());
        inputMap.put(Globals.getKeyPrefs().getKey(KeyBinding.ENTRY_EDITOR_STORE_FIELD), "store");
        actionMap.put("store", this.parent.getStoreFieldAction());
        inputMap.put(Globals.getKeyPrefs().getKey(KeyBinding.ENTRY_EDITOR_NEXT_PANEL), "right");
        inputMap.put(Globals.getKeyPrefs().getKey(KeyBinding.ENTRY_EDITOR_NEXT_PANEL_2), "right");
        actionMap.put("left", this.parent.getSwitchLeftAction());
        inputMap.put(Globals.getKeyPrefs().getKey(KeyBinding.ENTRY_EDITOR_PREVIOUS_PANEL), "left");
        inputMap.put(Globals.getKeyPrefs().getKey(KeyBinding.ENTRY_EDITOR_PREVIOUS_PANEL_2), "left");
        actionMap.put("right", this.parent.getSwitchRightAction());
        inputMap.put(Globals.getKeyPrefs().getKey(KeyBinding.HELP), "help");
        actionMap.put("help", this.parent.getHelpAction());
        inputMap.put(Globals.getKeyPrefs().getKey(KeyBinding.SAVE_DATABASE), "save");
        actionMap.put("save", this.parent.getSaveDatabaseAction());
        inputMap.put(Globals.getKeyPrefs().getKey(KeyBinding.NEXT_TAB), "nexttab");
        actionMap.put("nexttab", this.frame.nextTab);
        inputMap.put(Globals.getKeyPrefs().getKey(KeyBinding.PREVIOUS_TAB), "prevtab");
        actionMap.put("prevtab", this.frame.prevTab);
    }

    private void setupJTextComponent(JComponent component, AutoCompleteListener autoCompleteListener) {
        if (autoCompleteListener == null) {
            component.addFocusListener(this.fieldListener);
        } else {
            component.addKeyListener(autoCompleteListener);
            component.addFocusListener(autoCompleteListener);
            autoCompleteListener.setNextFocusListener(this.fieldListener);
        }
        this.setupKeyBindings(component.getInputMap(0), component.getActionMap());
        HashSet<AWTKeyStroke> keys = new HashSet<AWTKeyStroke>(component.getFocusTraversalKeys(0));
        keys.clear();
        keys.add(AWTKeyStroke.getAWTKeyStroke("pressed TAB"));
        component.setFocusTraversalKeys(0, keys);
        keys = new HashSet<AWTKeyStroke>(component.getFocusTraversalKeys(1));
        keys.clear();
        keys.add(KeyStroke.getKeyStroke("shift pressed TAB"));
        component.setFocusTraversalKeys(1, keys);
    }
}

