/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.gui.entryeditor;

import com.google.common.eventbus.Subscribe;
import java.awt.AWTKeyStroke;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.JTextComponent;
import net.sf.jabref.Globals;
import net.sf.jabref.gui.BasePanel;
import net.sf.jabref.gui.EntryContainer;
import net.sf.jabref.gui.GUIGlobals;
import net.sf.jabref.gui.IconTheme;
import net.sf.jabref.gui.JabRefFrame;
import net.sf.jabref.gui.OSXCompatibleToolbar;
import net.sf.jabref.gui.entryeditor.EntryEditorTab;
import net.sf.jabref.gui.entryeditor.EntryEditorTabList;
import net.sf.jabref.gui.entryeditor.FieldExtraComponents;
import net.sf.jabref.gui.externalfiles.WriteXMPEntryEditorAction;
import net.sf.jabref.gui.fieldeditors.FieldEditor;
import net.sf.jabref.gui.fieldeditors.FieldEditorFocusListener;
import net.sf.jabref.gui.fieldeditors.FileListEditor;
import net.sf.jabref.gui.fieldeditors.JTextAreaWithHighlighting;
import net.sf.jabref.gui.fieldeditors.TextField;
import net.sf.jabref.gui.help.HelpAction;
import net.sf.jabref.gui.keyboard.KeyBinding;
import net.sf.jabref.gui.menus.ChangeEntryTypeMenu;
import net.sf.jabref.gui.specialfields.SpecialFieldUpdateListener;
import net.sf.jabref.gui.undo.NamedCompound;
import net.sf.jabref.gui.undo.UndoableChangeType;
import net.sf.jabref.gui.undo.UndoableFieldChange;
import net.sf.jabref.gui.undo.UndoableKeyChange;
import net.sf.jabref.gui.undo.UndoableRemoveEntry;
import net.sf.jabref.gui.util.component.CheckBoxMessage;
import net.sf.jabref.gui.util.component.VerticalLabelUI;
import net.sf.jabref.logic.TypedBibEntry;
import net.sf.jabref.logic.autocompleter.AutoCompleter;
import net.sf.jabref.logic.bibtex.BibEntryWriter;
import net.sf.jabref.logic.bibtex.LatexFieldFormatter;
import net.sf.jabref.logic.bibtexkeypattern.BibtexKeyPatternUtil;
import net.sf.jabref.logic.help.HelpFile;
import net.sf.jabref.logic.importer.ParserResult;
import net.sf.jabref.logic.importer.fileformat.BibtexParser;
import net.sf.jabref.logic.l10n.Localization;
import net.sf.jabref.logic.search.SearchQueryHighlightListener;
import net.sf.jabref.logic.util.UpdateField;
import net.sf.jabref.logic.util.date.EasyDateFormat;
import net.sf.jabref.model.EntryTypes;
import net.sf.jabref.model.FieldChange;
import net.sf.jabref.model.database.BibDatabase;
import net.sf.jabref.model.database.BibDatabaseMode;
import net.sf.jabref.model.entry.BibEntry;
import net.sf.jabref.model.entry.EntryConverter;
import net.sf.jabref.model.entry.EntryType;
import net.sf.jabref.model.entry.FieldProperty;
import net.sf.jabref.model.entry.InternalBibtexFields;
import net.sf.jabref.model.entry.event.FieldChangedEvent;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class EntryEditor
extends JPanel
implements EntryContainer {
    private static final Log LOGGER = LogFactory.getLog(EntryEditor.class);
    private BibEntry entry;
    private final String displayedBibEntryType;
    private final CloseAction closeAction = new CloseAction();
    private final DeleteAction deleteAction = new DeleteAction();
    private final AbstractAction nextEntryAction = new NextEntryAction();
    private final AbstractAction prevEntryAction = new PrevEntryAction();
    private final StoreFieldAction storeFieldAction = new StoreFieldAction();
    private final SwitchLeftAction switchLeftAction = new SwitchLeftAction();
    private final SwitchRightAction switchRightAction = new SwitchRightAction();
    private final GenerateKeyAction generateKeyAction = new GenerateKeyAction();
    private FileListEditor fileListEditor;
    private final AutoLinkAction autoLinkAction = new AutoLinkAction();
    private final AbstractAction writeXmp;
    private final SaveDatabaseAction saveDatabaseAction = new SaveDatabaseAction();
    private final JPanel srcPanel = new JPanel();
    private JTextArea source;
    private final JTabbedPane tabbed = new JTabbedPane();
    private final JabRefFrame frame;
    private final BasePanel panel;
    private boolean updateSource = true;
    private boolean movingToDifferentEntry;
    private boolean validEntry = true;
    private final List<Object> tabs = new ArrayList<Object>();
    private boolean lastFieldAccepted = true;
    private boolean lastSourceAccepted = true;
    private String lastSourceStringAccepted;
    private int sourceIndex = -1;
    private final HelpAction helpAction = new HelpAction(HelpFile.ENTRY_EDITOR, (Icon)IconTheme.JabRefIcon.HELP.getIcon());
    private final UndoAction undoAction = new UndoAction();
    private final RedoAction redoAction = new RedoAction();
    private final TabListener tabListener = new TabListener();
    private final List<SearchQueryHighlightListener> searchListeners = new ArrayList<SearchQueryHighlightListener>();

    public EntryEditor(JabRefFrame frame, BasePanel panel, BibEntry entry) {
        this.frame = frame;
        this.panel = panel;
        this.entry = entry;
        entry.registerListener(this);
        entry.registerListener(SpecialFieldUpdateListener.getInstance());
        this.displayedBibEntryType = entry.getType();
        this.writeXmp = new WriteXMPEntryEditorAction(panel, this);
        BorderLayout borderLayout = new BorderLayout();
        this.setLayout(borderLayout);
        this.setupToolBar();
        this.setupFieldPanels();
        this.setupSourcePanel();
        this.add((Component)this.tabbed, "Center");
        this.tabbed.addChangeListener(this.tabListener);
        if (Globals.prefs.getBoolean("defaultShowSource")) {
            this.tabbed.setSelectedIndex(this.sourceIndex);
        }
        this.updateAllFields();
        if (this.fileListEditor != null) {
            this.fileListEditor.adjustColumnWidth();
        }
    }

    private void setupFieldPanels() {
        this.tabbed.removeAll();
        this.tabs.clear();
        EntryType type = EntryTypes.getTypeOrDefault(this.entry.getType(), this.frame.getCurrentBasePanel().getBibDatabaseContext().getMode());
        this.addRequiredTab(type);
        HashSet<String> deprecatedFields = new HashSet<String>(EntryConverter.FIELD_ALIASES_TEX_TO_LTX.keySet());
        HashSet<String> usedOptionalFieldsDeprecated = new HashSet<String>(deprecatedFields);
        if (type.getOptionalFields() != null && !type.getOptionalFields().isEmpty()) {
            if (!this.frame.getCurrentBasePanel().getBibDatabaseContext().isBiblatexMode()) {
                this.addOptionalTab(type);
            } else {
                this.addOptionalTab(type);
                deprecatedFields.add("year");
                deprecatedFields.add("month");
                List<String> secondaryOptionalFields = type.getSecondaryOptionalFields();
                ArrayList<String> optionalFieldsNotPrimaryOrDeprecated = new ArrayList<String>(secondaryOptionalFields);
                optionalFieldsNotPrimaryOrDeprecated.removeAll(deprecatedFields);
                HashSet<String> optionalFieldsAndAliases = new HashSet<String>();
                for (String field : type.getOptionalFields()) {
                    optionalFieldsAndAliases.add(field);
                    if (!EntryConverter.FIELD_ALIASES_LTX_TO_TEX.containsKey(field)) continue;
                    optionalFieldsAndAliases.add(EntryConverter.FIELD_ALIASES_LTX_TO_TEX.get(field));
                }
                usedOptionalFieldsDeprecated.retainAll(optionalFieldsAndAliases);
                usedOptionalFieldsDeprecated.add("month");
                EntryEditorTab optPan2 = new EntryEditorTab(this.frame, this.panel, optionalFieldsNotPrimaryOrDeprecated, this, false, true, Localization.lang("Optional fields 2", new String[0]));
                if (optPan2.fileListEditor != null) {
                    this.fileListEditor = optPan2.fileListEditor;
                }
                this.tabbed.addTab(Localization.lang("Optional fields 2", new String[0]), IconTheme.JabRefIcon.OPTIONAL.getSmallIcon(), optPan2.getPane(), Localization.lang("Show optional fields", new String[0]));
                this.tabs.add(optPan2);
                if (!usedOptionalFieldsDeprecated.isEmpty()) {
                    EntryEditorTab optPan3 = new EntryEditorTab(this.frame, this.panel, new ArrayList<String>(usedOptionalFieldsDeprecated), this, false, true, Localization.lang("Deprecated fields", new String[0]));
                    if (optPan3.fileListEditor != null) {
                        this.fileListEditor = optPan3.fileListEditor;
                    }
                    this.tabbed.addTab(Localization.lang("Deprecated fields", new String[0]), IconTheme.JabRefIcon.OPTIONAL.getSmallIcon(), optPan3.getPane(), Localization.lang("Show deprecated BibTeX fields", new String[0]));
                    this.tabs.add(optPan3);
                }
            }
        }
        List displayedFields = type.getAllFields().stream().map(String::toLowerCase).collect(Collectors.toList());
        List<String> otherFields = this.entry.getFieldNames().stream().map(String::toLowerCase).filter(f -> !displayedFields.contains(f)).collect(Collectors.toList());
        if (!usedOptionalFieldsDeprecated.isEmpty()) {
            otherFields.removeAll(usedOptionalFieldsDeprecated);
        }
        otherFields.remove("bibtexkey");
        otherFields.removeAll(Globals.prefs.getCustomTabFieldNames());
        if (!otherFields.isEmpty()) {
            this.addOtherTab(otherFields);
        }
        this.addGeneralTabs();
        this.addSourceTab();
    }

    private void addGeneralTabs() {
        EntryEditorTabList tabList = Globals.prefs.getEntryEditorTabList();
        for (int i = 0; i < tabList.getTabCount(); ++i) {
            EntryEditorTab newTab = new EntryEditorTab(this.frame, this.panel, tabList.getTabFields(i), this, false, false, tabList.getTabName(i));
            if (newTab.fileListEditor != null) {
                this.fileListEditor = newTab.fileListEditor;
            }
            this.tabbed.addTab(tabList.getTabName(i), newTab.getPane());
            this.tabs.add(newTab);
        }
    }

    private void addSourceTab() {
        String panelName = Localization.lang("%0 source", this.panel.getBibDatabaseContext().getMode().getFormattedName());
        String toolTip = Localization.lang("Show/edit %0 source", this.panel.getBibDatabaseContext().getMode().getFormattedName());
        this.srcPanel.setName(panelName);
        this.tabbed.addTab(panelName, IconTheme.JabRefIcon.SOURCE.getSmallIcon(), this.srcPanel, toolTip);
        this.tabs.add(this.srcPanel);
        this.sourceIndex = this.tabs.size() - 1;
        this.srcPanel.setFocusCycleRoot(true);
    }

    private void addOtherTab(List<String> otherFields) {
        EntryEditorTab otherPanel = new EntryEditorTab(this.frame, this.panel, otherFields, this, false, false, Localization.lang("Other fields", new String[0]));
        if (otherPanel.fileListEditor != null) {
            this.fileListEditor = otherPanel.fileListEditor;
        }
        this.tabbed.addTab(Localization.lang("Other fields", new String[0]), IconTheme.JabRefIcon.OPTIONAL.getSmallIcon(), otherPanel.getPane(), Localization.lang("Show remaining fields", new String[0]));
        this.tabs.add(otherPanel);
    }

    private List<String> addRequiredTab(EntryType type) {
        List<String> requiredFields = type.getRequiredFieldsFlat();
        EntryEditorTab requiredPanel = new EntryEditorTab(this.frame, this.panel, requiredFields, this, true, false, Localization.lang("Required fields", new String[0]));
        if (requiredPanel.fileListEditor != null) {
            this.fileListEditor = requiredPanel.fileListEditor;
        }
        this.tabbed.addTab(Localization.lang("Required fields", new String[0]), IconTheme.JabRefIcon.REQUIRED.getSmallIcon(), requiredPanel.getPane(), Localization.lang("Show required fields", new String[0]));
        this.tabs.add(requiredPanel);
        return requiredFields;
    }

    private void addOptionalTab(EntryType type) {
        EntryEditorTab optionalPanel = new EntryEditorTab(this.frame, this.panel, type.getPrimaryOptionalFields(), this, false, true, Localization.lang("Optional fields", new String[0]));
        if (optionalPanel.fileListEditor != null) {
            this.fileListEditor = optionalPanel.fileListEditor;
        }
        this.tabbed.addTab(Localization.lang("Optional fields", new String[0]), IconTheme.JabRefIcon.OPTIONAL.getSmallIcon(), optionalPanel.getPane(), Localization.lang("Show optional fields", new String[0]));
        this.tabs.add(optionalPanel);
    }

    public String getDisplayedBibEntryType() {
        return this.displayedBibEntryType;
    }

    @Override
    public BibEntry getEntry() {
        return this.entry;
    }

    public BibDatabase getDatabase() {
        return this.panel.getDatabase();
    }

    private void setupToolBar() {
        Component[] comps;
        JPanel leftPan = new JPanel();
        leftPan.setLayout(new BorderLayout());
        OSXCompatibleToolbar toolBar = new OSXCompatibleToolbar(1);
        toolBar.setBorder(null);
        toolBar.setRollover(true);
        toolBar.setMargin(new Insets(0, 0, 0, 2));
        ActionMap actionMap = toolBar.getActionMap();
        InputMap inputMap = toolBar.getInputMap(2);
        inputMap.put(Globals.getKeyPrefs().getKey(KeyBinding.CLOSE_ENTRY_EDITOR), "close");
        actionMap.put("close", this.closeAction);
        inputMap.put(Globals.getKeyPrefs().getKey(KeyBinding.ENTRY_EDITOR_STORE_FIELD), "store");
        actionMap.put("store", this.getStoreFieldAction());
        inputMap.put(Globals.getKeyPrefs().getKey(KeyBinding.AUTOGENERATE_BIBTEX_KEYS), "generateKey");
        actionMap.put("generateKey", this.getGenerateKeyAction());
        inputMap.put(Globals.getKeyPrefs().getKey(KeyBinding.AUTOMATICALLY_LINK_FILES), "autoLink");
        actionMap.put("autoLink", this.autoLinkAction);
        inputMap.put(Globals.getKeyPrefs().getKey(KeyBinding.ENTRY_EDITOR_PREVIOUS_ENTRY), "prev");
        actionMap.put("prev", this.getPrevEntryAction());
        inputMap.put(Globals.getKeyPrefs().getKey(KeyBinding.ENTRY_EDITOR_NEXT_ENTRY), "next");
        actionMap.put("next", this.getNextEntryAction());
        inputMap.put(Globals.getKeyPrefs().getKey(KeyBinding.UNDO), "undo");
        actionMap.put("undo", this.undoAction);
        inputMap.put(Globals.getKeyPrefs().getKey(KeyBinding.REDO), "redo");
        actionMap.put("redo", this.redoAction);
        inputMap.put(Globals.getKeyPrefs().getKey(KeyBinding.HELP), "help");
        actionMap.put("help", this.getHelpAction());
        toolBar.setFloatable(false);
        JButton closeBut = new JButton(this.closeAction);
        closeBut.setText(null);
        closeBut.setBorder(null);
        closeBut.setMargin(new Insets(8, 0, 8, 0));
        leftPan.add((Component)closeBut, "North");
        TypedBibEntry typedEntry = new TypedBibEntry(this.entry, this.panel.getBibDatabaseContext().getMode());
        leftPan.add((Component)new TypeLabel(typedEntry.getTypeForDisplay()), "Center");
        TypeButton typeButton = new TypeButton();
        ((Container)toolBar).add(typeButton);
        toolBar.add(this.getGenerateKeyAction());
        toolBar.add(this.autoLinkAction);
        toolBar.add(this.writeXmp);
        toolBar.addSeparator();
        toolBar.add(this.deleteAction);
        toolBar.add(this.getPrevEntryAction());
        toolBar.add(this.getNextEntryAction());
        toolBar.addSeparator();
        toolBar.add(this.getHelpAction());
        for (Component comp : comps = toolBar.getComponents()) {
            ((JComponent)comp).setOpaque(false);
        }
        leftPan.add((Component)toolBar, "South");
        this.add((Component)leftPan, "West");
    }

    public Optional<JComponent> getExtra(FieldEditor editor) {
        String fieldName = editor.getFieldName();
        Set<FieldProperty> fieldExtras = InternalBibtexFields.getFieldProperties(fieldName);
        if (Globals.prefs.get("timeStampField").equals(fieldName) || fieldExtras.contains((Object)FieldProperty.DATE)) {
            return FieldExtraComponents.getDateTimeExtraComponent(editor, fieldExtras.contains((Object)FieldProperty.DATE), fieldExtras.contains((Object)FieldProperty.ISO_DATE));
        }
        if (fieldExtras.contains((Object)FieldProperty.EXTERNAL)) {
            return FieldExtraComponents.getExternalExtraComponent(this.panel, editor);
        }
        if (fieldExtras.contains((Object)FieldProperty.JOURNAL_NAME)) {
            return FieldExtraComponents.getJournalExtraComponent(this.panel, editor, this.entry, this.getStoreFieldAction());
        }
        if (fieldExtras.contains((Object)FieldProperty.DOI)) {
            return FieldExtraComponents.getDoiExtraComponent(this.panel, this, editor);
        }
        if (fieldExtras.contains((Object)FieldProperty.EPRINT)) {
            return FieldExtraComponents.getEprintExtraComponent(this.panel, this, editor);
        }
        if (fieldExtras.contains((Object)FieldProperty.ISBN)) {
            return FieldExtraComponents.getIsbnExtraComponent(this.panel, this, editor);
        }
        if (fieldExtras.contains((Object)FieldProperty.OWNER)) {
            return FieldExtraComponents.getSetOwnerExtraComponent(editor, this.getStoreFieldAction());
        }
        if (fieldExtras.contains((Object)FieldProperty.YES_NO)) {
            return FieldExtraComponents.getYesNoExtraComponent(editor, this);
        }
        if (fieldExtras.contains((Object)FieldProperty.MONTH)) {
            return FieldExtraComponents.getMonthExtraComponent(editor, this, this.frame.getCurrentBasePanel().getBibDatabaseContext().getMode());
        }
        if (fieldExtras.contains((Object)FieldProperty.GENDER)) {
            return FieldExtraComponents.getGenderExtraComponent(editor, this);
        }
        if (fieldExtras.contains((Object)FieldProperty.EDITOR_TYPE)) {
            return FieldExtraComponents.getEditorTypeExtraComponent(editor, this);
        }
        if (fieldExtras.contains((Object)FieldProperty.PAGINATION)) {
            return FieldExtraComponents.getPaginationExtraComponent(editor, this);
        }
        if (fieldExtras.contains((Object)FieldProperty.TYPE)) {
            return FieldExtraComponents.getTypeExtraComponent(editor, this, "patent".equalsIgnoreCase(this.entry.getType()));
        }
        return Optional.empty();
    }

    private void setupSourcePanel() {
        this.source = new JTextAreaWithHighlighting();
        this.addSearchListener((SearchQueryHighlightListener)((Object)this.source));
        this.source.setEditable(true);
        this.source.setLineWrap(true);
        this.source.addFocusListener(new FieldEditorFocusListener());
        this.source.addFocusListener(Globals.getFocusListener());
        this.source.setFont(new Font("Monospaced", 0, Globals.prefs.getInt("fontSize")));
        this.setupJTextComponent(this.source);
        this.updateSource();
        JScrollPane scrollPane = new JScrollPane(this.source, 20, 31);
        this.srcPanel.setLayout(new BorderLayout());
        this.srcPanel.add((Component)scrollPane, "Center");
    }

    void addSearchListener(SearchQueryHighlightListener listener) {
        this.searchListeners.add(listener);
        this.panel.frame().getGlobalSearchBar().getSearchQueryHighlightObservable().addSearchListener(listener);
    }

    private void removeSearchListeners() {
        for (SearchQueryHighlightListener listener : this.searchListeners) {
            this.panel.frame().getGlobalSearchBar().getSearchQueryHighlightObservable().removeSearchListener(listener);
        }
    }

    public void updateSource() {
        if (this.updateSource) {
            try {
                String srcString = EntryEditor.getSourceString(this.entry, this.panel.getBibDatabaseContext().getMode());
                this.source.setText(srcString);
                this.lastSourceStringAccepted = srcString;
                this.panel.highlightEntry(this.entry);
            }
            catch (IOException ex) {
                this.source.setText(ex.getMessage() + "\n\n" + Localization.lang("Correct the entry, and reopen editor to display/edit source.", new String[0]));
                this.source.setEditable(false);
                LOGGER.debug("Incorrect entry", ex);
            }
        }
    }

    private static String getSourceString(BibEntry entry, BibDatabaseMode type) throws IOException {
        StringWriter stringWriter = new StringWriter(200);
        LatexFieldFormatter formatter = LatexFieldFormatter.buildIgnoreHashes(Globals.prefs.getLatexFieldFormatterPreferences());
        new BibEntryWriter(formatter, false).writeWithoutPrependedNewlines(entry, stringWriter, type);
        return stringWriter.getBuffer().toString();
    }

    private void setupJTextComponent(JTextComponent textComponent) {
        InputMap inputMap = textComponent.getInputMap(0);
        ActionMap actionMap = textComponent.getActionMap();
        inputMap.put(Globals.getKeyPrefs().getKey(KeyBinding.ENTRY_EDITOR_STORE_FIELD), "store");
        actionMap.put("store", this.getStoreFieldAction());
        inputMap.put(Globals.getKeyPrefs().getKey(KeyBinding.ENTRY_EDITOR_NEXT_PANEL), "right");
        inputMap.put(Globals.getKeyPrefs().getKey(KeyBinding.ENTRY_EDITOR_NEXT_PANEL_2), "right");
        actionMap.put("right", this.getSwitchRightAction());
        inputMap.put(Globals.getKeyPrefs().getKey(KeyBinding.ENTRY_EDITOR_PREVIOUS_PANEL), "left");
        inputMap.put(Globals.getKeyPrefs().getKey(KeyBinding.ENTRY_EDITOR_PREVIOUS_PANEL_2), "left");
        actionMap.put("left", this.getSwitchLeftAction());
        inputMap.put(Globals.getKeyPrefs().getKey(KeyBinding.HELP), "help");
        actionMap.put("help", this.getHelpAction());
        inputMap.put(Globals.getKeyPrefs().getKey(KeyBinding.NEXT_TAB), "nexttab");
        actionMap.put("nexttab", this.frame.nextTab);
        inputMap.put(Globals.getKeyPrefs().getKey(KeyBinding.PREVIOUS_TAB), "prevtab");
        actionMap.put("prevtab", this.frame.prevTab);
        HashSet<AWTKeyStroke> keys = new HashSet<AWTKeyStroke>(textComponent.getFocusTraversalKeys(0));
        keys.clear();
        keys.add(AWTKeyStroke.getAWTKeyStroke("pressed TAB"));
        textComponent.setFocusTraversalKeys(0, keys);
        keys = new HashSet<AWTKeyStroke>(textComponent.getFocusTraversalKeys(1));
        keys.clear();
        keys.add(KeyStroke.getKeyStroke("shift pressed TAB"));
        textComponent.setFocusTraversalKeys(1, keys);
        textComponent.addFocusListener(new FieldListener());
    }

    @Override
    public void requestFocus() {
        this.activateVisible();
    }

    private void activateVisible() {
        Object activeTab = this.tabs.get(this.tabbed.getSelectedIndex());
        if (activeTab instanceof EntryEditorTab) {
            ((EntryEditorTab)activeTab).focus();
        } else {
            this.source.requestFocus();
        }
    }

    @Override
    public boolean isEnabled() {
        return this.source.isEnabled();
    }

    @Override
    public void setEnabled(boolean enabled) {
        for (Object tab : this.tabs) {
            if (!(tab instanceof EntryEditorTab)) continue;
            ((EntryEditorTab)tab).setEnabled(enabled);
        }
        this.source.setEnabled(enabled);
    }

    public void storeCurrentEdit() {
        JComponent comp = Globals.getFocusListener().getFocused();
        if (Objects.equals(comp, this.source) || comp instanceof FieldEditor && this.isAncestorOf(comp)) {
            if (comp instanceof FieldEditor) {
                ((FieldEditor)((Object)comp)).clearAutoCompleteSuggestion();
            }
            this.getStoreFieldAction().actionPerformed(new ActionEvent(comp, 0, ""));
        }
    }

    public String getVisiblePanelName() {
        return this.tabbed.getSelectedComponent().getName();
    }

    public void setVisiblePanel(String name) {
        for (int i = 0; i < this.tabbed.getTabCount(); ++i) {
            if (this.tabbed.getComponent(i).getName() == null || !this.tabbed.getComponent(i).getName().equals(name)) continue;
            this.tabbed.setSelectedIndex(i);
            return;
        }
        if (this.tabbed.getTabCount() > 0) {
            this.tabbed.setSelectedIndex(0);
        }
    }

    public void setFocusToField(String fieldName) {
        for (Object tab : this.tabs) {
            if (!(tab instanceof EntryEditorTab) || !((EntryEditorTab)tab).getFields().contains(fieldName)) continue;
            EntryEditorTab entryEditorTab = (EntryEditorTab)tab;
            this.setVisiblePanel(entryEditorTab.getTabTitle());
            entryEditorTab.setActive(fieldName);
            entryEditorTab.focus();
        }
    }

    private boolean storeSource() {
        BibtexParser bibtexParser = new BibtexParser(Globals.prefs.getImportFormatPreferences());
        try {
            String fieldName;
            boolean emptyWarning;
            ParserResult parserResult = bibtexParser.parse(new StringReader(this.source.getText()));
            BibDatabase database = parserResult.getDatabase();
            if (database.getEntryCount() > 1) {
                throw new IllegalStateException("More than one entry found.");
            }
            if (!database.hasEntries()) {
                if (parserResult.hasWarnings()) {
                    throw new IllegalStateException(parserResult.warnings().get(0));
                }
                throw new IllegalStateException("No entries found.");
            }
            NamedCompound compound = new NamedCompound(Localization.lang("source edit", new String[0]));
            BibEntry newEntry = database.getEntries().get(0);
            String newKey = newEntry.getCiteKeyOptional().orElse(null);
            boolean entryChanged = false;
            boolean bl = emptyWarning = newKey == null || newKey.isEmpty();
            if (newKey != null) {
                this.entry.setCiteKey(newKey);
            } else {
                this.entry.clearCiteKey();
            }
            for (Map.Entry<String, String> field : this.entry.getFieldMap().entrySet()) {
                fieldName = field.getKey();
                String fieldValue = field.getValue();
                if (!InternalBibtexFields.isDisplayableField(fieldName) || newEntry.hasField(fieldName)) continue;
                compound.addEdit(new UndoableFieldChange(this.entry, fieldName, fieldValue, null));
                this.entry.clearField(fieldName);
                entryChanged = true;
            }
            for (Map.Entry<String, String> field : newEntry.getFieldMap().entrySet()) {
                String newValue;
                fieldName = field.getKey();
                String oldValue = this.entry.getField(fieldName).orElse(null);
                if (Objects.equals(oldValue, newValue = field.getValue())) continue;
                new LatexFieldFormatter(Globals.prefs.getLatexFieldFormatterPreferences()).format(newValue, fieldName);
                compound.addEdit(new UndoableFieldChange(this.entry, fieldName, oldValue, newValue));
                this.entry.setField(fieldName, newValue);
                entryChanged = true;
            }
            if (!Objects.equals(newEntry.getType(), this.entry.getType())) {
                compound.addEdit(new UndoableChangeType(this.entry, this.entry.getType(), newEntry.getType()));
                this.entry.setType(newEntry.getType());
                entryChanged = true;
            }
            compound.end();
            if (!entryChanged) {
                return true;
            }
            this.panel.getUndoManager().addEdit(compound);
            if (this.panel.getDatabase().getDuplicationChecker().isDuplicateCiteKeyExisting(this.entry)) {
                this.warnDuplicateBibtexkey();
            } else if (emptyWarning) {
                this.warnEmptyBibtexkey();
            } else {
                this.panel.output(Localization.lang("Stored entry", new String[0]) + '.');
            }
            this.lastSourceStringAccepted = this.source.getText();
            this.panel.updateEntryEditorIfShowing();
            this.lastSourceAccepted = true;
            this.updateSource = true;
            this.panel.markBaseChanged();
            this.panel.highlightEntry(this.entry);
            return true;
        }
        catch (IOException | IllegalStateException ex) {
            int answer;
            this.updateSource = false;
            this.lastSourceAccepted = false;
            this.tabbed.setSelectedComponent(this.srcPanel);
            Object[] options = new Object[]{Localization.lang("Edit", new String[0]), Localization.lang("Revert to original source", new String[0])};
            if (!SwingUtilities.isEventDispatchThread() && (answer = JOptionPane.showOptionDialog(this.frame, Localization.lang("Error", new String[0]) + ": " + ex.getMessage(), Localization.lang("Problem with parsing entry", new String[0]), 0, 0, null, options, options[0])) != 0) {
                this.updateSource = true;
                this.lastSourceAccepted = true;
                this.updateSource();
            }
            LOGGER.debug("Incorrect source", ex);
            return false;
        }
    }

    private void setField(String fieldName, String newFieldData) {
        for (Object tab : this.tabs) {
            if (!(tab instanceof EntryEditorTab)) continue;
            ((EntryEditorTab)tab).updateField(fieldName, newFieldData);
        }
    }

    public void updateAllFields() {
        for (Object tab : this.tabs) {
            if (!(tab instanceof EntryEditorTab)) continue;
            ((EntryEditorTab)tab).setEntry(this.entry);
        }
    }

    @Subscribe
    public void listen(FieldChangedEvent fieldChangedEvent) {
        String newValue;
        String string = newValue = fieldChangedEvent.getNewValue() == null ? "" : fieldChangedEvent.getNewValue();
        if (SwingUtilities.isEventDispatchThread()) {
            this.setField(fieldChangedEvent.getFieldName(), newValue);
        } else {
            SwingUtilities.invokeLater(() -> this.setField(fieldChangedEvent.getFieldName(), newValue));
        }
    }

    public void updateField(Object sourceObject) {
        this.getStoreFieldAction().actionPerformed(new ActionEvent(sourceObject, 0, ""));
    }

    public void setMovingToDifferentEntry() {
        this.movingToDifferentEntry = true;
        this.unregisterListeners();
    }

    private void unregisterListeners() {
        this.entry.unregisterListener(this);
        this.removeSearchListeners();
    }

    private void showChangeEntryTypePopupMenu() {
        JPopupMenu typeMenu = new ChangeEntryTypeMenu().getChangeentryTypePopupMenu(this.panel);
        typeMenu.show(this, 0, 0);
    }

    public void close() {
        if (this.tabbed.getSelectedComponent() == this.srcPanel) {
            this.updateField(this.source);
            if (this.lastSourceAccepted) {
                this.panel.entryEditorClosing(this);
            } else {
                this.panel.runCommand("save");
                this.lastSourceAccepted = true;
            }
        } else if (this.lastFieldAccepted) {
            this.panel.entryEditorClosing(this);
        } else {
            this.panel.runCommand("save");
            this.lastFieldAccepted = true;
        }
    }

    private void warnDuplicateBibtexkey() {
        this.panel.output(Localization.lang("Duplicate BibTeX key", new String[0]) + ". " + Localization.lang("Grouping may not work for this entry.", new String[0]));
    }

    private void warnEmptyBibtexkey() {
        this.panel.output(Localization.lang("Empty BibTeX key", new String[0]) + ". " + Localization.lang("Grouping may not work for this entry.", new String[0]));
    }

    public AbstractAction getNextEntryAction() {
        return this.nextEntryAction;
    }

    public AbstractAction getPrevEntryAction() {
        return this.prevEntryAction;
    }

    public SwitchLeftAction getSwitchLeftAction() {
        return this.switchLeftAction;
    }

    public SwitchRightAction getSwitchRightAction() {
        return this.switchRightAction;
    }

    public SaveDatabaseAction getSaveDatabaseAction() {
        return this.saveDatabaseAction;
    }

    public HelpAction getHelpAction() {
        return this.helpAction;
    }

    public GenerateKeyAction getGenerateKeyAction() {
        return this.generateKeyAction;
    }

    public StoreFieldAction getStoreFieldAction() {
        return this.storeFieldAction;
    }

    private boolean updateTimeStampIsSet() {
        return Globals.prefs.getBoolean("useTimeStamp") && Globals.prefs.getBoolean("updateTimestamp");
    }

    private Optional<FieldChange> doUpdateTimeStamp() {
        String timeStampField = Globals.prefs.get("timeStampField");
        String timeStampFormat = Globals.prefs.get("timeStampFormat");
        String timestamp = EasyDateFormat.fromTimeStampFormat(timeStampFormat).getCurrentDate();
        return UpdateField.updateField(this.entry, timeStampField, timestamp);
    }

    private class AutoLinkAction
    extends AbstractAction {
        public AutoLinkAction() {
            this.putValue("SmallIcon", IconTheme.JabRefIcon.AUTO_FILE_LINK.getIcon());
            this.putValue("ShortDescription", Localization.lang("Automatically set file links for this entry", new String[0]) + " (Alt-F)");
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            FileListEditor localFileListEditor = EntryEditor.this.fileListEditor;
            if (localFileListEditor == null) {
                LOGGER.warn("No file list editor found.");
            } else {
                localFileListEditor.autoSetLinks();
            }
        }
    }

    class SaveDatabaseAction
    extends AbstractAction {
        public SaveDatabaseAction() {
            super("Save database");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Object activeTab = EntryEditor.this.tabs.get(EntryEditor.this.tabbed.getSelectedIndex());
            if (activeTab instanceof EntryEditorTab) {
                EntryEditorTab tab = (EntryEditorTab)activeTab;
                FieldEditor fieldEditor = tab.getActive();
                fieldEditor.clearAutoCompleteSuggestion();
                EntryEditor.this.updateField(fieldEditor);
            } else {
                EntryEditor.this.updateField(activeTab);
            }
            if (EntryEditor.this.validEntry) {
                EntryEditor.this.panel.runCommand("save");
            }
        }
    }

    class RedoAction
    extends AbstractAction {
        public RedoAction() {
            super("Redo", IconTheme.JabRefIcon.REDO.getIcon());
            this.putValue("ShortDescription", "Redo");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            EntryEditor.this.panel.runCommand("redo");
        }
    }

    class UndoAction
    extends AbstractAction {
        public UndoAction() {
            super("Undo", IconTheme.JabRefIcon.UNDO.getIcon());
            this.putValue("ShortDescription", "Undo");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            EntryEditor.this.panel.runCommand("undo");
        }
    }

    class GenerateKeyAction
    extends AbstractAction {
        public GenerateKeyAction() {
            super(Localization.lang("Generate BibTeX key", new String[0]), IconTheme.JabRefIcon.MAKE_KEY.getIcon());
            this.putValue("ShortDescription", Localization.lang("Generate BibTeX key", new String[0]));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            EntryEditor.this.storeCurrentEdit();
            Optional<String> oldValue = EntryEditor.this.entry.getCiteKeyOptional();
            if (oldValue.isPresent()) {
                if (Globals.prefs.getBoolean("avoidOverwritingKey")) {
                    EntryEditor.this.panel.output(Localization.lang("Not overwriting existing key. To change this setting, open Options -> Prefererences -> BibTeX key generator", new String[0]));
                    return;
                }
                if (Globals.prefs.getBoolean("warnBeforeOverwritingKey")) {
                    CheckBoxMessage cbm = new CheckBoxMessage(Localization.lang("The current BibTeX key will be overwritten. Continue?", new String[0]), Localization.lang("Disable this confirmation dialog", new String[0]), false);
                    int answer = JOptionPane.showConfirmDialog(EntryEditor.this.frame, cbm, Localization.lang("Overwrite key", new String[0]), 0);
                    if (cbm.isSelected()) {
                        Globals.prefs.putBoolean("warnBeforeOverwritingKey", false);
                    }
                    if (answer == 1) {
                        return;
                    }
                }
            }
            BibtexKeyPatternUtil.makeLabel(EntryEditor.this.panel.getBibDatabaseContext().getMetaData().getCiteKeyPattern(Globals.prefs.getBibtexKeyPatternPreferences().getKeyPattern()), EntryEditor.this.panel.getDatabase(), EntryEditor.this.entry, Globals.prefs.getBibtexKeyPatternPreferences());
            EntryEditor.this.panel.getUndoManager().addEdit(new UndoableKeyChange(EntryEditor.this.entry, oldValue.orElse(null), EntryEditor.this.entry.getCiteKeyOptional().get()));
            String bibtexKeyData = EntryEditor.this.entry.getCiteKeyOptional().get();
            EntryEditor.this.setField("bibtexkey", bibtexKeyData);
            EntryEditor.this.updateSource();
            EntryEditor.this.panel.markBaseChanged();
        }
    }

    class PrevEntryAction
    extends AbstractAction {
        public PrevEntryAction() {
            super(Localization.lang("Previous entry", new String[0]), IconTheme.JabRefIcon.UP.getIcon());
            this.putValue("ShortDescription", Localization.lang("Previous entry", new String[0]));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            EntryEditor.this.panel.selectPreviousEntry();
        }
    }

    class NextEntryAction
    extends AbstractAction {
        public NextEntryAction() {
            super(Localization.lang("Next entry", new String[0]), IconTheme.JabRefIcon.DOWN.getIcon());
            this.putValue("ShortDescription", Localization.lang("Next entry", new String[0]));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            EntryEditor.this.panel.selectNextEntry();
        }
    }

    class SwitchRightAction
    extends AbstractAction {
        public SwitchRightAction() {
            super("Switch to the panel to the right");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int i = EntryEditor.this.tabbed.getSelectedIndex();
            EntryEditor.this.tabbed.setSelectedIndex(i < EntryEditor.this.tabbed.getTabCount() - 1 ? i + 1 : 0);
            EntryEditor.this.activateVisible();
        }
    }

    class SwitchLeftAction
    extends AbstractAction {
        public SwitchLeftAction() {
            super("Switch to the panel to the left");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int i = EntryEditor.this.tabbed.getSelectedIndex();
            EntryEditor.this.tabbed.setSelectedIndex(i > 0 ? i - 1 : EntryEditor.this.tabbed.getTabCount() - 1);
            EntryEditor.this.activateVisible();
        }
    }

    class StoreFieldAction
    extends AbstractAction {
        public StoreFieldAction() {
            super("Store field value");
            this.putValue("ShortDescription", "Store field value");
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            boolean movingAway = EntryEditor.this.movingToDifferentEntry;
            EntryEditor.this.movingToDifferentEntry = false;
            if (event.getSource() instanceof TextField) {
                TextField textField = (TextField)event.getSource();
                String oldValue = EntryEditor.this.entry.getCiteKeyOptional().orElse(null);
                String newValue = textField.getText();
                if (newValue.isEmpty()) {
                    newValue = null;
                }
                if (oldValue == null && newValue == null || Objects.equals(oldValue, newValue)) {
                    return;
                }
                String cleaned = BibtexKeyPatternUtil.checkLegalKey(newValue, Globals.prefs.getBoolean("enforceLegalBibtexKey"));
                if (cleaned != null && !cleaned.equals(newValue)) {
                    EntryEditor.this.lastFieldAccepted = false;
                    textField.setInvalidBackgroundColor();
                    if (!SwingUtilities.isEventDispatchThread()) {
                        JOptionPane.showMessageDialog(EntryEditor.this.frame, Localization.lang("Invalid BibTeX key", new String[0]), Localization.lang("Error setting field", new String[0]), 0);
                        EntryEditor.this.requestFocus();
                    }
                    return;
                }
                textField.setValidBackgroundColor();
                if (newValue == null) {
                    EntryEditor.this.entry.clearCiteKey();
                    EntryEditor.this.warnEmptyBibtexkey();
                } else {
                    EntryEditor.this.entry.setCiteKey(newValue);
                    boolean isDuplicate = EntryEditor.this.panel.getDatabase().getDuplicationChecker().isDuplicateCiteKeyExisting(EntryEditor.this.entry);
                    if (isDuplicate) {
                        EntryEditor.this.warnDuplicateBibtexkey();
                    } else {
                        EntryEditor.this.panel.output(Localization.lang("BibTeX key is unique.", new String[0]));
                    }
                }
                UndoableKeyChange undoableKeyChange = new UndoableKeyChange(EntryEditor.this.entry, oldValue, newValue);
                if (EntryEditor.this.updateTimeStampIsSet()) {
                    NamedCompound ce = new NamedCompound(undoableKeyChange.getPresentationName());
                    ce.addEdit(undoableKeyChange);
                    EntryEditor.this.doUpdateTimeStamp().ifPresent(fieldChange -> ce.addEdit(new UndoableFieldChange((FieldChange)fieldChange)));
                    ce.end();
                    EntryEditor.this.panel.getUndoManager().addEdit(ce);
                } else {
                    EntryEditor.this.panel.getUndoManager().addEdit(undoableKeyChange);
                }
                textField.setValidBackgroundColor();
                if (textField.getTextComponent().hasFocus()) {
                    textField.setActiveBackgroundColor();
                }
                EntryEditor.this.updateSource();
                EntryEditor.this.panel.markBaseChanged();
            } else if (event.getSource() instanceof FieldEditor) {
                FieldEditor fieldEditor;
                block31: {
                    boolean set;
                    String toSet = null;
                    fieldEditor = (FieldEditor)event.getSource();
                    String currentText = fieldEditor.getText().trim();
                    if (!currentText.isEmpty()) {
                        toSet = currentText;
                    }
                    if (toSet == null) {
                        set = EntryEditor.this.entry.hasField(fieldEditor.getFieldName());
                    } else {
                        boolean bl = set = !EntryEditor.this.entry.hasField(fieldEditor.getFieldName()) || !toSet.equals(EntryEditor.this.entry.getField(fieldEditor.getFieldName()).orElse(null));
                    }
                    if (!set) {
                        fieldEditor.setValidBackgroundColor();
                    } else {
                        try {
                            if (toSet != null) {
                                new LatexFieldFormatter(Globals.prefs.getLatexFieldFormatterPreferences()).format(toSet, fieldEditor.getFieldName());
                            }
                            String oldValue = EntryEditor.this.entry.getField(fieldEditor.getFieldName()).orElse(null);
                            if (toSet == null) {
                                EntryEditor.this.entry.clearField(fieldEditor.getFieldName());
                            } else {
                                EntryEditor.this.entry.setField(fieldEditor.getFieldName(), toSet);
                            }
                            fieldEditor.setValidBackgroundColor();
                            AutoCompleter aComp = EntryEditor.this.panel.getAutoCompleters().get(fieldEditor.getFieldName());
                            if (aComp != null) {
                                aComp.addBibtexEntry(EntryEditor.this.entry);
                            }
                            UndoableFieldChange undoableFieldChange = new UndoableFieldChange(EntryEditor.this.entry, fieldEditor.getFieldName(), oldValue, toSet);
                            if (EntryEditor.this.updateTimeStampIsSet()) {
                                NamedCompound ce = new NamedCompound(undoableFieldChange.getPresentationName());
                                ce.addEdit(undoableFieldChange);
                                EntryEditor.this.doUpdateTimeStamp().ifPresent(fieldChange -> ce.addEdit(new UndoableFieldChange((FieldChange)fieldChange)));
                                ce.end();
                                EntryEditor.this.panel.getUndoManager().addEdit(ce);
                            } else {
                                EntryEditor.this.panel.getUndoManager().addEdit(undoableFieldChange);
                            }
                            EntryEditor.this.updateSource();
                            EntryEditor.this.panel.markBaseChanged();
                        }
                        catch (IllegalArgumentException ex) {
                            EntryEditor.this.lastFieldAccepted = false;
                            fieldEditor.setInvalidBackgroundColor();
                            if (SwingUtilities.isEventDispatchThread()) break block31;
                            JOptionPane.showMessageDialog(EntryEditor.this.frame, Localization.lang("Error", new String[0]) + ": " + ex.getMessage(), Localization.lang("Error setting field", new String[0]), 0);
                            LOGGER.debug("Error setting field", ex);
                            EntryEditor.this.requestFocus();
                        }
                    }
                }
                if (fieldEditor.getTextComponent().hasFocus()) {
                    fieldEditor.setBackground(GUIGlobals.ACTIVE_EDITOR_COLOR);
                }
            } else if (EntryEditor.this.source.isEditable() && !EntryEditor.this.source.getText().equals(EntryEditor.this.lastSourceStringAccepted)) {
                EntryEditor.this.validEntry = EntryEditor.this.storeSource();
            }
            if (!movingAway && EntryEditor.this.isShowing()) {
                EntryEditor.this.panel.highlightEntry(EntryEditor.this.entry);
            }
        }
    }

    class CloseAction
    extends AbstractAction {
        public CloseAction() {
            super(Localization.lang("Close window", new String[0]), IconTheme.JabRefIcon.CLOSE.getSmallIcon());
            this.putValue("ShortDescription", Localization.lang("Close window", new String[0]));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            EntryEditor.this.close();
        }
    }

    class DeleteAction
    extends AbstractAction {
        public DeleteAction() {
            super(Localization.lang("Delete", new String[0]), IconTheme.JabRefIcon.DELETE_ENTRY.getIcon());
            this.putValue("ShortDescription", Localization.lang("Delete entry", new String[0]));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            boolean goOn = EntryEditor.this.panel.showDeleteConfirmationDialog(1);
            if (!goOn) {
                return;
            }
            EntryEditor.this.panel.entryEditorClosing(EntryEditor.this);
            EntryEditor.this.panel.getDatabase().removeEntry(EntryEditor.this.entry);
            EntryEditor.this.panel.markBaseChanged();
            EntryEditor.this.panel.getUndoManager().addEdit(new UndoableRemoveEntry(EntryEditor.this.panel.getDatabase(), EntryEditor.this.entry, EntryEditor.this.panel));
            EntryEditor.this.panel.output(Localization.lang("Deleted entry", new String[0]));
        }
    }

    private class TabListener
    implements ChangeListener {
        private TabListener() {
        }

        @Override
        public void stateChanged(ChangeEvent event) {
            SwingUtilities.invokeLater(() -> {
                Object activeTab = EntryEditor.this.tabs.get(EntryEditor.this.tabbed.getSelectedIndex());
                if (activeTab instanceof EntryEditorTab) {
                    ((EntryEditorTab)activeTab).updateAll();
                    EntryEditor.this.activateVisible();
                }
            });
        }
    }

    private class FieldListener
    extends FocusAdapter {
        private FieldListener() {
        }

        @Override
        public void focusLost(FocusEvent event) {
            if (!event.isTemporary()) {
                EntryEditor.this.updateField(event.getSource());
            }
        }
    }

    private class TypeLabel
    extends JLabel {
        public TypeLabel(String type) {
            super(type);
            this.setUI(new VerticalLabelUI(false));
            this.setForeground(GUIGlobals.ENTRY_EDITOR_LABEL_COLOR);
            this.setHorizontalAlignment(4);
            this.setFont(new Font("dialog", 3, 18));
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseReleased(MouseEvent e) {
                    if (e.isPopupTrigger() || e.getButton() == 3) {
                        this.handleTypeChange();
                    }
                }

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (e.isPopupTrigger() || e.getButton() == 3) {
                        this.handleTypeChange();
                    }
                }

                private void handleTypeChange() {
                    EntryEditor.this.showChangeEntryTypePopupMenu();
                }
            });
        }

        @Override
        public void paintComponent(Graphics g) {
            Graphics2D g2 = (Graphics2D)g;
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            super.paintComponent(g2);
        }
    }

    private class TypeButton
    extends JButton {
        public TypeButton() {
            super(IconTheme.JabRefIcon.EDIT.getIcon());
            this.setToolTipText(Localization.lang("Change entry type", new String[0]));
            this.addActionListener(e -> EntryEditor.this.showChangeEntryTypePopupMenu());
        }
    }
}

