/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.gui.desktop;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.regex.Pattern;
import javax.swing.JOptionPane;
import net.sf.jabref.Globals;
import net.sf.jabref.JabRefGUI;
import net.sf.jabref.gui.ClipBoardManager;
import net.sf.jabref.gui.IconTheme;
import net.sf.jabref.gui.JabRefFrame;
import net.sf.jabref.gui.desktop.os.DefaultDesktop;
import net.sf.jabref.gui.desktop.os.Linux;
import net.sf.jabref.gui.desktop.os.NativeDesktop;
import net.sf.jabref.gui.desktop.os.OSX;
import net.sf.jabref.gui.desktop.os.Windows;
import net.sf.jabref.gui.externalfiletype.ExternalFileType;
import net.sf.jabref.gui.externalfiletype.ExternalFileTypeEntryEditor;
import net.sf.jabref.gui.externalfiletype.ExternalFileTypes;
import net.sf.jabref.gui.externalfiletype.UnknownExternalFileType;
import net.sf.jabref.gui.filelist.FileListEntry;
import net.sf.jabref.gui.filelist.FileListEntryEditor;
import net.sf.jabref.gui.filelist.FileListTableModel;
import net.sf.jabref.gui.undo.UndoableFieldChange;
import net.sf.jabref.logic.l10n.Localization;
import net.sf.jabref.logic.util.DOI;
import net.sf.jabref.logic.util.OS;
import net.sf.jabref.logic.util.io.FileUtil;
import net.sf.jabref.model.database.BibDatabaseContext;
import net.sf.jabref.model.entry.BibEntry;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JabRefDesktop {
    private static final NativeDesktop NATIVE_DESKTOP = JabRefDesktop.getNativeDesktop();
    private static final Log LOGGER = LogFactory.getLog(JabRefDesktop.class);
    private static final Pattern REMOTE_LINK_PATTERN = Pattern.compile("[a-z]+://.*");
    private static final String ARXIV_LOOKUP_PREFIX = "http://arxiv.org/abs/";

    public static void openExternalViewer(BibDatabaseContext databaseContext, String initialLink, String initialFieldName) throws IOException {
        String link = initialLink;
        String fieldName = initialFieldName;
        if ("ps".equals(fieldName) || "pdf".equals(fieldName)) {
            List<String> dir = databaseContext.getFileDirectory(fieldName, Globals.prefs.getFileDirectoryPreferences());
            Optional<File> file = FileUtil.expandFilename(link, dir);
            if (!file.isPresent() || !file.get().exists()) {
                throw new IOException("File not found (" + fieldName + "): '" + link + "'.");
            }
            link = file.get().getCanonicalPath();
            String[] split = file.get().getName().split("\\.");
            if (split.length >= 2) {
                if ("pdf".equalsIgnoreCase(split[split.length - 1])) {
                    fieldName = "pdf";
                } else if ("ps".equalsIgnoreCase(split[split.length - 1]) || split.length >= 3 && "ps".equalsIgnoreCase(split[split.length - 2])) {
                    fieldName = "ps";
                }
            }
        } else if ("doi".equals(fieldName)) {
            Optional<DOI> doiUrl = DOI.build(link);
            if (doiUrl.isPresent()) {
                link = doiUrl.get().getURIAsASCIIString();
            }
            fieldName = "url";
        } else if ("eprint".equals(fieldName)) {
            fieldName = "url";
            if (!link.startsWith("http://")) {
                link = ARXIV_LOOKUP_PREFIX + link;
            }
        }
        if ("url".equals(fieldName)) {
            try {
                JabRefDesktop.openBrowser(link);
            }
            catch (IOException e) {
                LOGGER.error("Error opening file '" + link + "'", e);
            }
        } else if ("ps".equals(fieldName)) {
            try {
                NATIVE_DESKTOP.openFile(link, "ps");
            }
            catch (IOException e) {
                LOGGER.error("An error occured on the command: " + link, e);
            }
        } else if ("pdf".equals(fieldName)) {
            try {
                NATIVE_DESKTOP.openFile(link, "pdf");
            }
            catch (IOException e) {
                LOGGER.error("An error occured on the command: " + link, e);
            }
        } else {
            LOGGER.info("Message: currently only PDF, PS and HTML files can be opened by double clicking");
        }
    }

    public static boolean openExternalFileAnyFormat(BibDatabaseContext databaseContext, String link, Optional<ExternalFileType> type) throws IOException {
        Optional<File> tmp;
        boolean httpLink = false;
        if (REMOTE_LINK_PATTERN.matcher(link.toLowerCase()).matches()) {
            httpLink = true;
        }
        File file = new File(link);
        if (!httpLink && (tmp = FileUtil.expandFilename(databaseContext, link, Globals.prefs.getFileDirectoryPreferences())).isPresent()) {
            file = tmp.get();
        }
        if ((httpLink || file.exists()) && type.isPresent()) {
            String filePath = httpLink ? link : file.getPath();
            JabRefDesktop.openExternalFilePlatformIndependent(type, filePath);
            return true;
        }
        return false;
    }

    private static void openExternalFilePlatformIndependent(Optional<ExternalFileType> fileType, String filePath) throws IOException {
        if (fileType.isPresent()) {
            String application = fileType.get().getOpenWithApplication();
            if (application.isEmpty()) {
                NATIVE_DESKTOP.openFile(filePath, fileType.get().getExtension());
            } else {
                NATIVE_DESKTOP.openFileWithApplication(filePath, application);
            }
        }
    }

    public static boolean openExternalFileUnknown(JabRefFrame frame, BibEntry entry, BibDatabaseContext databaseContext, String link, UnknownExternalFileType fileType) throws IOException {
        String cancelMessage = Localization.lang("Unable to open file.", new String[0]);
        Object[] options = new String[]{Localization.lang("Define '%0'", fileType.getName()), Localization.lang("Change file type", new String[0]), Localization.lang("Cancel", new String[0])};
        String defOption = options[0];
        int answer = JOptionPane.showOptionDialog(frame, Localization.lang("This external link is of the type '%0', which is undefined. What do you want to do?", fileType.getName()), Localization.lang("Undefined file type", new String[0]), 1, 3, null, options, defOption);
        if (answer == 2) {
            frame.output(cancelMessage);
            return false;
        }
        if (answer == 0) {
            ExternalFileType newType = new ExternalFileType(fileType.getName(), "", "", "", "new", IconTheme.JabRefIcon.FILE.getSmallIcon());
            ExternalFileTypeEntryEditor editor = new ExternalFileTypeEntryEditor(frame, newType);
            editor.setVisible(true);
            if (editor.okPressed()) {
                ArrayList<ExternalFileType> fileTypes = new ArrayList<ExternalFileType>(ExternalFileTypes.getInstance().getExternalFileTypeSelection());
                fileTypes.add(newType);
                Collections.sort(fileTypes);
                ExternalFileTypes.getInstance().setExternalFileTypes(fileTypes);
                return JabRefDesktop.openExternalFileAnyFormat(databaseContext, link, Optional.of(newType));
            }
            frame.output(cancelMessage);
            return false;
        }
        FileListTableModel tModel = new FileListTableModel();
        Optional<String> oldValue = entry.getField("file");
        oldValue.ifPresent(tModel::setContent);
        FileListEntry flEntry = null;
        for (int i = 0; i < tModel.getRowCount(); ++i) {
            FileListEntry iEntry = tModel.getEntry(i);
            if (!iEntry.link.equals(link)) continue;
            flEntry = iEntry;
            break;
        }
        if (flEntry == null) {
            throw new RuntimeException("Could not find the file list entry " + link + " in " + entry);
        }
        FileListEntryEditor editor = new FileListEntryEditor(frame, flEntry, false, true, databaseContext);
        editor.setVisible(true, false);
        if (editor.okPressed()) {
            String newValue = tModel.getStringRepresentation();
            UndoableFieldChange ce = new UndoableFieldChange(entry, "file", oldValue.orElse(null), newValue);
            entry.setField("file", newValue);
            frame.getCurrentBasePanel().getUndoManager().addEdit(ce);
            frame.getCurrentBasePanel().markBaseChanged();
            return JabRefDesktop.openExternalFileAnyFormat(databaseContext, flEntry.link, flEntry.type);
        }
        frame.output(cancelMessage);
        return false;
    }

    public static void openFolderAndSelectFile(String fileLink) throws IOException {
        NATIVE_DESKTOP.openFolderAndSelectFile(fileLink);
    }

    public static void openBrowser(String url) throws IOException {
        Optional<ExternalFileType> fileType = ExternalFileTypes.getInstance().getExternalFileTypeByExt("html");
        JabRefDesktop.openExternalFilePlatformIndependent(fileType, url);
    }

    public static void openBrowserShowPopup(String url) {
        try {
            JabRefDesktop.openBrowser(url);
        }
        catch (IOException exception) {
            new ClipBoardManager().setClipboardContents(url);
            LOGGER.error("Could not open browser", exception);
            String couldNotOpenBrowser = Localization.lang("Could not open browser.", new String[0]);
            String openManually = Localization.lang("Please open %0 manually.", url);
            String copiedToClipboard = Localization.lang("The_link_has_been_copied_to_the_clipboard.", new String[0]);
            JabRefGUI.getMainFrame().output(couldNotOpenBrowser);
            JOptionPane.showMessageDialog(JabRefGUI.getMainFrame(), couldNotOpenBrowser + "\n" + openManually + "\n" + copiedToClipboard, couldNotOpenBrowser, 0);
        }
    }

    public static void openConsole(File file) throws IOException {
        if (file == null) {
            return;
        }
        String absolutePath = file.toPath().toAbsolutePath().getParent().toString();
        boolean usingDefault = Globals.prefs.getBoolean("useDefaultConsoleApplication");
        if (usingDefault) {
            NATIVE_DESKTOP.openConsole(absolutePath);
        } else {
            String command = Globals.prefs.get("consoleCommand");
            if (!(command = command.trim()).isEmpty()) {
                command = command.replaceAll("\\s+", " ");
                String[] subcommands = command.split(" ");
                String commandLoggingText = command.replace("%DIR", absolutePath);
                JabRefGUI.getMainFrame().output(Localization.lang("Executing command \"%0\"...", commandLoggingText));
                LOGGER.info("Executing command \"" + commandLoggingText + "\"...");
                try {
                    new ProcessBuilder(subcommands).start();
                }
                catch (IOException exception) {
                    LOGGER.error("Open console", exception);
                    JOptionPane.showMessageDialog(JabRefGUI.getMainFrame(), Localization.lang("Error_occured_while_executing_the_command_\"%0\".", commandLoggingText), Localization.lang("Open console", new String[0]) + " - " + Localization.lang("Error", new String[0]), 0);
                    JabRefGUI.getMainFrame().output(null);
                }
            }
        }
    }

    public static NativeDesktop getNativeDesktop() {
        if (OS.WINDOWS) {
            return new Windows();
        }
        if (OS.OS_X) {
            return new OSX();
        }
        if (OS.LINUX) {
            return new Linux();
        }
        return new DefaultDesktop();
    }
}

