/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.gui.date;

import com.michaelbaranov.microba.calendar.DatePicker;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Date;
import javax.swing.JComponent;
import javax.swing.JPanel;
import net.sf.jabref.Globals;
import net.sf.jabref.gui.fieldeditors.FieldEditor;
import net.sf.jabref.logic.util.date.EasyDateFormat;

public class DatePickerButton
implements ActionListener {
    private final DatePicker datePicker = new DatePicker();
    private final JPanel panel = new JPanel();
    private final FieldEditor editor;
    private final boolean isoFormat;

    public DatePickerButton(FieldEditor pEditor, Boolean isoFormat) {
        this.isoFormat = isoFormat;
        this.datePicker.showButtonOnly(true);
        this.datePicker.addActionListener(this);
        this.datePicker.setShowTodayButton(true);
        this.panel.setLayout(new BorderLayout());
        this.panel.add((Component)this.datePicker, "West");
        this.editor = pEditor;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Date date = this.datePicker.getDate();
        if (date != null) {
            if (this.isoFormat) {
                this.editor.setText(EasyDateFormat.isoDateFormat().getDateAt(date));
            } else {
                this.editor.setText(EasyDateFormat.fromTimeStampFormat(Globals.prefs.get("timeStampFormat")).getDateAt(date));
            }
        } else {
            this.editor.setText("");
        }
        this.editor.getTextComponent().requestFocus();
    }

    public JComponent getDatePicker() {
        return this.panel;
    }
}

