/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.gui.bibtexkeypattern;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JCheckBox;
import net.sf.jabref.Globals;
import net.sf.jabref.gui.BasePanel;
import net.sf.jabref.gui.bibtexkeypattern.ResolveDuplicateLabelDialog;
import net.sf.jabref.gui.undo.NamedCompound;
import net.sf.jabref.gui.undo.UndoableKeyChange;
import net.sf.jabref.gui.worker.AbstractWorker;
import net.sf.jabref.logic.bibtexkeypattern.BibtexKeyPatternUtil;
import net.sf.jabref.logic.l10n.Localization;
import net.sf.jabref.model.database.BibDatabase;
import net.sf.jabref.model.entry.BibEntry;

public class SearchFixDuplicateLabels
extends AbstractWorker {
    private final BasePanel panel;
    private Map<String, List<BibEntry>> dupes;

    public SearchFixDuplicateLabels(BasePanel panel) {
        this.panel = panel;
    }

    @Override
    public void run() {
        this.dupes = new HashMap<String, List<BibEntry>>();
        HashMap foundKeys = new HashMap();
        BibDatabase db = this.panel.getDatabase();
        for (BibEntry entry : db.getEntries()) {
            entry.getCiteKeyOptional().filter(key -> !key.isEmpty()).ifPresent(key -> {
                if (foundKeys.containsKey(key)) {
                    if (this.dupes.containsKey(key)) {
                        this.dupes.get(key).add(entry);
                    } else {
                        ArrayList<BibEntry> al = new ArrayList<BibEntry>();
                        al.add((BibEntry)foundKeys.get(key));
                        al.add(entry);
                        this.dupes.put((String)key, (List<BibEntry>)al);
                    }
                } else {
                    foundKeys.put(key, entry);
                }
            });
        }
    }

    @Override
    public void init() throws Throwable {
        this.panel.output(Localization.lang("Resolving duplicate BibTeX keys...", new String[0]));
    }

    @Override
    public void update() {
        ArrayList<BibEntry> toGenerateFor = new ArrayList<BibEntry>();
        for (Map.Entry<String, List<BibEntry>> dupeEntry : this.dupes.entrySet()) {
            ResolveDuplicateLabelDialog rdld = new ResolveDuplicateLabelDialog(this.panel, dupeEntry.getKey(), dupeEntry.getValue());
            rdld.show();
            if (rdld.isOkPressed()) {
                List<JCheckBox> cbs = rdld.getCheckBoxes();
                for (int i = 0; i < cbs.size(); ++i) {
                    if (!cbs.get(i).isSelected()) continue;
                    toGenerateFor.add(dupeEntry.getValue().get(i));
                }
                continue;
            }
            if (!rdld.isCancelPressed()) continue;
            break;
        }
        if (!toGenerateFor.isEmpty()) {
            NamedCompound ce = new NamedCompound(Localization.lang("Resolve duplicate BibTeX keys", new String[0]));
            for (BibEntry entry : toGenerateFor) {
                String oldKey = entry.getCiteKeyOptional().orElse(null);
                BibtexKeyPatternUtil.makeLabel(this.panel.getBibDatabaseContext().getMetaData().getCiteKeyPattern(Globals.prefs.getBibtexKeyPatternPreferences().getKeyPattern()), this.panel.getDatabase(), entry, Globals.prefs.getBibtexKeyPatternPreferences());
                ce.addEdit(new UndoableKeyChange(entry, oldKey, entry.getCiteKeyOptional().get()));
            }
            ce.end();
            this.panel.getUndoManager().addEdit(ce);
            this.panel.markBaseChanged();
        }
        this.panel.output(Localization.lang("Finished resolving duplicate BibTeX keys. %0 entries modified.", String.valueOf(toGenerateFor.size())));
    }
}

