/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.gui.bibtexkeypattern;

import com.jgoodies.forms.builder.ButtonBarBuilder;
import com.jgoodies.forms.builder.FormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import net.sf.jabref.Globals;
import net.sf.jabref.gui.BasePanel;
import net.sf.jabref.gui.PreviewPanel;
import net.sf.jabref.gui.keyboard.KeyBinding;
import net.sf.jabref.logic.l10n.Localization;
import net.sf.jabref.model.entry.BibEntry;

class ResolveDuplicateLabelDialog {
    private final JDialog diag;
    private final List<JCheckBox> cbs = new ArrayList<JCheckBox>();
    private boolean okPressed;
    private boolean cancelPressed;

    public ResolveDuplicateLabelDialog(BasePanel panel, String key, List<BibEntry> entries) {
        this.diag = new JDialog(panel.frame(), Localization.lang("Duplicate BibTeX key", new String[0]), true);
        FormBuilder b = FormBuilder.create().layout(new FormLayout("left:pref, 4dlu, fill:pref", "p"));
        b.add(new JLabel(Localization.lang("Duplicate BibTeX key", new String[0]) + ": " + key)).xyw(1, 1, 3);
        b.getPanel().setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        boolean first = true;
        int row = 3;
        for (BibEntry entry : entries) {
            JCheckBox cb = new JCheckBox(Localization.lang("Generate BibTeX key", new String[0]), !first);
            b.appendRows("1dlu, p", new Object[0]);
            b.add(cb).xy(1, row);
            PreviewPanel pp = new PreviewPanel(null, entry, null);
            pp.setPreferredSize(new Dimension(800, 90));
            b.add(new JScrollPane(pp)).xy(3, row);
            row += 2;
            this.cbs.add(cb);
            first = false;
        }
        ButtonBarBuilder bb = new ButtonBarBuilder();
        bb.addGlue();
        JButton ok = new JButton(Localization.lang("OK", new String[0]));
        bb.addButton((JComponent)ok);
        JButton ignore = new JButton(Localization.lang("Ignore", new String[0]));
        bb.addButton((JComponent)ignore);
        JButton cancel = new JButton(Localization.lang("Cancel", new String[0]));
        bb.addButton((JComponent)cancel);
        bb.addGlue();
        bb.getPanel().setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.diag.getContentPane().add((Component)b.getPanel(), "Center");
        this.diag.getContentPane().add((Component)bb.getPanel(), "South");
        this.diag.pack();
        ok.addActionListener(e -> {
            this.okPressed = true;
            this.diag.dispose();
        });
        ignore.addActionListener(e -> this.diag.dispose());
        AbstractAction closeAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ResolveDuplicateLabelDialog.this.cancelPressed = true;
                ResolveDuplicateLabelDialog.this.diag.dispose();
            }
        };
        cancel.addActionListener(closeAction);
        ActionMap am = b.getPanel().getActionMap();
        InputMap im = b.getPanel().getInputMap(2);
        im.put(Globals.getKeyPrefs().getKey(KeyBinding.CLOSE_DIALOG), "close");
        am.put("close", closeAction);
    }

    public boolean isOkPressed() {
        return this.okPressed;
    }

    public List<JCheckBox> getCheckBoxes() {
        return this.cbs;
    }

    public void show() {
        this.okPressed = false;
        this.diag.setLocationRelativeTo(this.diag.getParent());
        this.diag.setVisible(true);
    }

    public boolean isCancelPressed() {
        return this.cancelPressed;
    }
}

