/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.gui.autocompleter;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import net.sf.jabref.gui.autocompleter.AutoCompleteRenderer;

public class ListAutoCompleteRenderer<E>
extends AutoCompleteRenderer<E> {
    private final DefaultListModel<E> model = new DefaultListModel();
    private final JList<E> list = new JList<E>(this.model);
    private Boolean interpretSelectionChangeAsAccept = true;

    @Override
    public void update(List<E> autoCompletions) {
        if (autoCompletions == null) {
            this.model.removeAllElements();
        } else {
            this.list.setListData(new Vector<E>(autoCompletions));
            this.list.clearSelection();
        }
    }

    @Override
    public Component init(ActionListener newAcceptAction) {
        this.list.setSelectionMode(0);
        this.list.setFocusable(false);
        this.list.setRequestFocusEnabled(false);
        this.list.setBorder(BorderFactory.createEmptyBorder(3, 5, 3, 5));
        this.list.addListSelectionListener(e -> {
            if (this.interpretSelectionChangeAsAccept.booleanValue() && newAcceptAction != null) {
                newAcceptAction.actionPerformed(new ActionEvent(this, 1001, null));
            }
        });
        JScrollPane scrollPane = new JScrollPane(this.list);
        scrollPane.setFocusable(false);
        scrollPane.setRequestFocusEnabled(false);
        scrollPane.setBorder(BorderFactory.createEmptyBorder());
        scrollPane.setVerticalScrollBarPolicy(21);
        scrollPane.setHorizontalScrollBarPolicy(31);
        return scrollPane;
    }

    @Override
    public E getSelectedItem() {
        return this.list.getSelectedValue();
    }

    @Override
    public void selectItem(int index) {
        this.interpretSelectionChangeAsAccept = false;
        if (index >= 0 && index < this.list.getModel().getSize()) {
            this.list.setSelectedIndex(index);
            this.list.ensureIndexIsVisible(index);
        } else {
            this.list.clearSelection();
        }
        this.interpretSelectionChangeAsAccept = true;
    }

    @Override
    public int getSelectedIndex() {
        return this.list.getSelectedIndex();
    }
}

