/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.gui.autocompleter;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.text.JTextComponent;
import net.sf.jabref.gui.autocompleter.AutoCompleteRenderer;
import net.sf.jabref.gui.autocompleter.ListAutoCompleteRenderer;
import net.sf.jabref.logic.autocompleter.AutoCompleter;

public class AutoCompleteSupport<E> {
    private final AutoCompleteRenderer<E> renderer;
    private AutoCompleter<E> autoCompleter;
    private final JTextComponent textComp;
    private final JPopupMenu popup = new JPopupMenu();
    private boolean selectsTextOnFocusGain = true;

    public AutoCompleteSupport(JTextComponent textComp, AutoCompleter<E> autoCompleter, AutoCompleteRenderer<E> renderer) {
        this.renderer = renderer;
        this.textComp = textComp;
        this.autoCompleter = autoCompleter;
    }

    public AutoCompleteSupport(JTextComponent textComp) {
        this(textComp, null, new ListAutoCompleteRenderer());
    }

    public AutoCompleteSupport(JTextComponent textComp, AutoCompleter<E> autoCompleter) {
        this(textComp, autoCompleter, new ListAutoCompleteRenderer());
    }

    public void install() {
        MoveAction upAction = new MoveAction(-1);
        MoveAction downAction = new MoveAction(1);
        ActionListener hidePopupAction = e -> this.popup.setVisible(false);
        final ActionListener acceptAction = e -> {
            E itemToInsert = this.renderer.getSelectedItem();
            if (itemToInsert == null) {
                return;
            }
            String toInsert = this.autoCompleter.getAutoCompleteText(itemToInsert);
            if (!this.autoCompleter.isSingleUnitField()) {
                int priv;
                for (priv = this.textComp.getText().length() - 1; priv >= 0 && !Character.isWhitespace(this.textComp.getText().charAt(priv)) && this.textComp.getText().charAt(priv) != ','; --priv) {
                }
                this.textComp.setText(this.textComp.getText().substring(0, priv + 1) + toInsert);
            } else {
                this.textComp.setText(toInsert);
            }
            this.textComp.setCaretPosition(this.textComp.getText().length());
            this.popup.setVisible(false);
        };
        this.popup.setBorder(BorderFactory.createMatteBorder(1, 1, 1, 1, Color.LIGHT_GRAY));
        this.popup.setPopupSize(this.textComp.getWidth(), 200);
        this.popup.setLayout(new BorderLayout());
        this.popup.setFocusable(false);
        this.popup.setRequestFocusEnabled(false);
        this.popup.add(this.renderer.init(acceptAction));
        this.textComp.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                AutoCompleteSupport.this.postProcessTextChange();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                AutoCompleteSupport.this.postProcessTextChange();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
            }
        });
        this.textComp.registerKeyboardAction(downAction, KeyStroke.getKeyStroke(40, 0), 0);
        this.textComp.registerKeyboardAction(upAction, KeyStroke.getKeyStroke(38, 0), 0);
        this.textComp.registerKeyboardAction(hidePopupAction, KeyStroke.getKeyStroke(27, 0), 2);
        this.textComp.addFocusListener(new ComboBoxEditorFocusHandler());
        this.popup.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                AutoCompleteSupport.this.textComp.registerKeyboardAction(acceptAction, KeyStroke.getKeyStroke(10, 0), 0);
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                AutoCompleteSupport.this.textComp.unregisterKeyboardAction(KeyStroke.getKeyStroke(10, 0));
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent e) {
            }
        });
    }

    public boolean isSelectsTextOnFocusGain() {
        return this.selectsTextOnFocusGain;
    }

    public void setSelectsTextOnFocusGain(boolean selectsTextOnFocusGain) {
        this.selectsTextOnFocusGain = selectsTextOnFocusGain;
    }

    private void postProcessTextChange() {
        if (this.autoCompleter == null) {
            this.popup.setVisible(false);
            return;
        }
        String text = this.textComp.getText();
        List<E> candidates = this.autoCompleter.complete(text);
        this.renderer.update(candidates);
        if (this.textComp.isEnabled() && !candidates.isEmpty()) {
            this.renderer.selectItem(0);
            this.popup.setPopupSize(this.textComp.getWidth(), 200);
            this.popup.show(this.textComp, 0, this.textComp.getHeight());
        } else {
            this.popup.setVisible(false);
        }
        if (!this.textComp.hasFocus()) {
            this.textComp.requestFocusInWindow();
        }
    }

    public void setAutoCompleter(AutoCompleter<E> autoCompleter) {
        this.autoCompleter = autoCompleter;
    }

    public void setVisible(boolean visible) {
        this.popup.setVisible(visible);
    }

    public boolean isVisible() {
        return this.popup.isVisible();
    }

    private class ComboBoxEditorFocusHandler
    extends FocusAdapter {
        private ComboBoxEditorFocusHandler() {
        }

        @Override
        public void focusGained(FocusEvent e) {
            if (AutoCompleteSupport.this.isSelectsTextOnFocusGain() && !e.isTemporary()) {
                AutoCompleteSupport.this.textComp.selectAll();
            }
        }

        @Override
        public void focusLost(FocusEvent e) {
        }
    }

    private class MoveAction
    extends AbstractAction {
        private final int offset;

        public MoveAction(int offset) {
            this.offset = offset;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (AutoCompleteSupport.this.popup.isVisible()) {
                AutoCompleteSupport.this.renderer.selectItemRelative(this.offset);
            } else {
                AutoCompleteSupport.this.popup.show(AutoCompleteSupport.this.textComp, 0, AutoCompleteSupport.this.textComp.getHeight());
            }
        }
    }
}

