/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.gui.autocompleter;

import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.List;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import net.sf.jabref.logic.autocompleter.AutoCompleter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AutoCompleteListener
extends KeyAdapter
implements FocusListener {
    private static final Log LOGGER = LogFactory.getLog(AutoCompleteListener.class);
    private final AutoCompleter<String> completer;
    private String toSetIn;
    private String lastBeginning;
    private int lastCaretPosition = -1;
    private List<String> lastCompletions;
    private int lastShownCompletion;
    private boolean consumeEnterKey = true;
    private FocusListener nextFocusListener;

    public AutoCompleteListener(AutoCompleter<String> completer) {
        this.completer = completer;
    }

    public void setNextFocusListener(FocusListener listener) {
        this.nextFocusListener = listener;
    }

    public void setConsumeEnterKey(boolean t) {
        this.consumeEnterKey = t;
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if (this.toSetIn != null && e.getKeyCode() == 10) {
            JTextComponent comp = (JTextComponent)e.getSource();
            this.lastBeginning = this.lastCompletions.get(this.lastShownCompletion);
            int end = comp.getSelectionEnd();
            comp.select(end, end);
            this.toSetIn = null;
            if (this.consumeEnterKey) {
                e.consume();
            }
        } else if (e.getKeyCode() == 34 && this.toSetIn != null) {
            this.cycle((JTextComponent)e.getSource(), 1);
            e.consume();
        } else if (e.getKeyCode() == 33 && this.toSetIn != null) {
            this.cycle((JTextComponent)e.getSource(), -1);
            e.consume();
        } else if (e.getKeyChar() == '\uffff') {
            if (e.getKeyCode() == 16) {
                LOGGER.debug("Special case: shift pressed. No action.");
            } else {
                this.resetAutoCompletion();
            }
        } else {
            LOGGER.debug("Special case: defined character, but not caught above");
        }
    }

    private void cycle(JTextComponent comp, int increment) {
        assert (this.lastCompletions != null);
        assert (!this.lastCompletions.isEmpty());
        this.lastShownCompletion += increment;
        if (this.lastShownCompletion >= this.lastCompletions.size()) {
            this.lastShownCompletion = 0;
        } else if (this.lastShownCompletion < 0) {
            this.lastShownCompletion = this.lastCompletions.size() - 1;
        }
        String sno = this.lastCompletions.get(this.lastShownCompletion);
        this.toSetIn = sno.substring(this.lastBeginning.length() - 1);
        StringBuilder alltext = new StringBuilder(comp.getText());
        int oldSelectionStart = comp.getSelectionStart();
        int oldSelectionEnd = comp.getSelectionEnd();
        int startPos = comp.getSelectionStart() - this.lastBeginning.length();
        alltext.delete(startPos, oldSelectionStart);
        alltext.insert(startPos, sno.subSequence(0, this.lastBeginning.length()));
        alltext.delete(oldSelectionStart, oldSelectionEnd);
        alltext.insert(oldSelectionStart, this.toSetIn.substring(1));
        LOGGER.debug(alltext.toString());
        comp.setText(alltext.toString());
        comp.select(oldSelectionStart, oldSelectionStart + this.toSetIn.length() - 1);
        this.lastCaretPosition = comp.getCaretPosition();
        LOGGER.debug("ToSetIn: '" + this.toSetIn + "'");
    }

    private boolean atEndOfWord(JTextComponent textField) {
        char nextChar;
        int nextCharPosition = textField.getCaretPosition();
        return nextCharPosition >= textField.getText().length() || Character.isWhitespace(nextChar = textField.getText().charAt(nextCharPosition));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void setUnmodifiedTypedLetters(JTextComponent comp, boolean lastBeginningContainsTypedCharacter, boolean wordSeperatorTyped) {
        if (this.lastBeginning == null) {
            LOGGER.debug("No last beginning found");
            return;
        }
        LOGGER.debug("lastBeginning: >" + this.lastBeginning + '<');
        if (comp.getSelectedText() == null) {
            if (!wordSeperatorTyped) return;
            LOGGER.debug("Replacing complete word");
        } else {
            LOGGER.debug("Selected text " + comp.getSelectedText() + " will be removed");
            comp.replaceSelection("");
        }
        this.lastCaretPosition = comp.getCaretPosition();
        int endIndex = this.lastCaretPosition - this.lastBeginning.length();
        if (lastBeginningContainsTypedCharacter) {
            ++endIndex;
        }
        String text = comp.getText();
        comp.setText(text.substring(0, endIndex).concat(this.lastBeginning).concat(text.substring(this.lastCaretPosition)));
        if (lastBeginningContainsTypedCharacter) {
            ++this.lastCaretPosition;
        }
        comp.setCaretPosition(this.lastCaretPosition);
        this.lastBeginning = null;
    }

    private void startCompletion(StringBuffer currentword, KeyEvent e) {
        JTextComponent comp = (JTextComponent)e.getSource();
        List<String> completed = this.findCompletions(currentword.toString());
        String prefix = this.completer.getPrefix();
        String cWord = prefix != null && !prefix.isEmpty() ? currentword.toString().substring(prefix.length()) : currentword.toString();
        LOGGER.debug("StartCompletion currentword: >" + currentword + "'<' prefix: >" + prefix + "'<' cword: >" + cWord + '<');
        int no = 0;
        if (completed != null && !completed.isEmpty()) {
            this.lastShownCompletion = 0;
            this.lastCompletions = completed;
            String sno = completed.get(no);
            this.toSetIn = sno.substring(cWord.length() - 1);
            LOGGER.debug("toSetIn: >" + this.toSetIn + '<');
            StringBuilder alltext = new StringBuilder(comp.getText());
            int cp = comp.getCaretPosition();
            alltext.insert(cp, this.toSetIn);
            comp.setText(alltext.toString());
            comp.setCaretPosition(cp);
            comp.select(cp + 1, cp + 1 + sno.length() - cWord.length());
            e.consume();
            this.lastCaretPosition = comp.getCaretPosition();
            char ch = e.getKeyChar();
            LOGGER.debug("Appending >" + ch + '<');
            this.lastBeginning = cWord.length() <= 1 ? Character.toString(ch) : cWord.substring(0, cWord.length() - 1).concat(Character.toString(ch));
        }
    }

    @Override
    public void keyTyped(KeyEvent e) {
        LOGGER.debug("key typed event caught " + e.getKeyCode());
        char ch = e.getKeyChar();
        if (ch == '\n') {
            return;
        }
        if (!this.atEndOfWord((JTextComponent)e.getSource())) {
            return;
        }
        if ((e.getModifiers() | 1) == 1) {
            if (Character.isLetter(ch) || Character.isDigit(ch) || Character.isWhitespace(ch) && this.completer.isSingleUnitField()) {
                JTextComponent comp = (JTextComponent)e.getSource();
                if (this.toSetIn == null) {
                    LOGGER.debug("toSetIn is null");
                } else {
                    LOGGER.debug("toSetIn: >" + this.toSetIn + '<');
                }
                if (this.toSetIn != null && this.toSetIn.length() > 1 && ch == this.toSetIn.charAt(1)) {
                    LOGGER.debug("cont");
                    this.toSetIn = this.toSetIn.substring(1);
                    if (!this.toSetIn.isEmpty()) {
                        int cp = comp.getCaretPosition();
                        comp.select(cp + 1 - this.toSetIn.length(), cp);
                        this.lastBeginning = this.lastBeginning + ch;
                        e.consume();
                        this.lastCaretPosition = comp.getCaretPosition();
                        this.lastCompletions = this.findCompletions(this.lastBeginning);
                        this.lastShownCompletion = 0;
                        for (int i = 0; i < this.lastCompletions.size(); ++i) {
                            String lastCompletion = this.lastCompletions.get(i);
                            if (!lastCompletion.endsWith(this.toSetIn)) continue;
                            this.lastShownCompletion = i;
                            break;
                        }
                        if (this.toSetIn.length() < 2) {
                            String text = comp.getText();
                            comp.setText(text.substring(0, this.lastCaretPosition - this.lastBeginning.length()) + this.lastBeginning + text.substring(this.lastCaretPosition));
                            this.toSetIn = null;
                        }
                        return;
                    }
                }
                if (this.toSetIn != null && (this.toSetIn.length() <= 1 || ch != this.toSetIn.charAt(1))) {
                    this.lastBeginning = this.lastBeginning + ch;
                    LOGGER.debug("discont toSetIn: >" + this.toSetIn + "'<' lastBeginning: >" + this.lastBeginning + '<');
                    List<String> completed = this.findCompletions(this.lastBeginning);
                    if (completed != null && !completed.isEmpty()) {
                        this.lastShownCompletion = 0;
                        this.lastCompletions = completed;
                        String sno = completed.get(0);
                        int lastLen = this.toSetIn.length() - 1;
                        this.toSetIn = sno.substring(this.lastBeginning.length() - 1);
                        String text = comp.getText();
                        comp.setText(text.substring(0, this.lastCaretPosition - lastLen - this.lastBeginning.length() + 1) + sno + text.substring(this.lastCaretPosition));
                        int startSelect = this.lastCaretPosition + 1 - lastLen;
                        int endSelect = this.lastCaretPosition + this.toSetIn.length() - lastLen;
                        comp.select(startSelect, endSelect);
                        this.lastCaretPosition = comp.getCaretPosition();
                        e.consume();
                        return;
                    }
                    this.setUnmodifiedTypedLetters(comp, true, false);
                    e.consume();
                    this.toSetIn = null;
                    return;
                }
                LOGGER.debug("case else");
                comp.replaceSelection("");
                StringBuffer currentword = this.getCurrentWord(comp);
                assert (!Character.isISOControl(ch));
                currentword.append(ch);
                this.startCompletion(currentword, e);
                return;
            }
            if (Character.isWhitespace(ch)) {
                assert (!this.completer.isSingleUnitField());
                LOGGER.debug("whitespace && !singleUnitField");
                this.setUnmodifiedTypedLetters((JTextComponent)e.getSource(), false, true);
                this.resetAutoCompletion();
                return;
            }
            LOGGER.debug("No letter/digit/whitespace or CHAR_UNDEFINED");
            this.setUnmodifiedTypedLetters((JTextComponent)e.getSource(), false, !Character.isISOControl(ch));
            this.resetAutoCompletion();
            return;
        }
        this.resetAutoCompletion();
    }

    private void resetAutoCompletion() {
        LOGGER.debug("Resetting autocompletion");
        this.toSetIn = null;
        this.lastBeginning = null;
    }

    private List<String> findCompletions(String beginning) {
        return this.completer.complete(beginning);
    }

    private StringBuffer getCurrentWord(JTextComponent comp) {
        StringBuffer res = new StringBuffer();
        try {
            String upToCaret = comp.getText(0, comp.getCaretPosition());
            if (!this.completer.isSingleUnitField()) {
                int piv;
                if (comp.getCaretPosition() < comp.getText().length() && Character.isWhitespace(comp.getText().charAt(comp.getCaretPosition()))) {
                    return new StringBuffer();
                }
                for (piv = upToCaret.length() - 1; piv >= 0 && !Character.isWhitespace(upToCaret.charAt(piv)); --piv) {
                }
                res.append(upToCaret.substring(piv + 1));
            } else {
                res.append(upToCaret);
            }
            LOGGER.debug("AutoCompListener: " + res);
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        return res;
    }

    @Override
    public void focusGained(FocusEvent event) {
        if (this.nextFocusListener != null) {
            this.nextFocusListener.focusGained(event);
        }
    }

    @Override
    public void focusLost(FocusEvent event) {
        if (this.toSetIn != null) {
            JTextComponent comp = (JTextComponent)event.getSource();
            this.clearCurrentSuggestion(comp);
        }
        if (this.nextFocusListener != null) {
            this.nextFocusListener.focusLost(event);
        }
    }

    public void clearCurrentSuggestion(JTextComponent comp) {
        if (this.toSetIn != null) {
            int selStart = comp.getSelectionStart();
            String text = comp.getText();
            comp.setText(text.substring(0, selStart) + text.substring(comp.getSelectionEnd()));
            comp.setCaretPosition(selStart);
            this.lastCompletions = null;
            this.lastShownCompletion = 0;
            this.lastCaretPosition = -1;
            this.toSetIn = null;
        }
    }
}

