/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.gui.actions;

import java.awt.Component;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.text.JTextComponent;
import net.sf.jabref.gui.ClipBoardManager;
import net.sf.jabref.gui.IconTheme;
import net.sf.jabref.logic.l10n.Localization;
import net.sf.jabref.logic.net.URLUtil;

public class PasteAction
extends AbstractAction {
    private final Component target;

    public PasteAction(Component target) {
        this.target = target;
        this.putValue("Name", Localization.lang("Paste from clipboard", new String[0]));
        this.putValue("ShortDescription", Localization.lang("Paste from clipboard", new String[0]));
        this.putValue("SmallIcon", IconTheme.JabRefIcon.PASTE.getSmallIcon());
        this.putValue("SwingLargeIconKey", IconTheme.JabRefIcon.PASTE.getIcon());
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        String data = new ClipBoardManager().getClipboardContents();
        if (data.isEmpty()) {
            return;
        }
        data = URLUtil.cleanGoogleSearchURL(data);
        if (this.target instanceof JTextComponent) {
            JTextComponent textField = (JTextComponent)this.target;
            textField.replaceSelection(data);
        }
    }
}

