/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.gui.actions;

import java.awt.event.ActionEvent;
import net.sf.jabref.Globals;
import net.sf.jabref.gui.BasePanel;
import net.sf.jabref.gui.IconTheme;
import net.sf.jabref.gui.JabRefFrame;
import net.sf.jabref.gui.actions.MnemonicAwareAction;
import net.sf.jabref.gui.auximport.FromAuxDialog;
import net.sf.jabref.logic.l10n.Localization;
import net.sf.jabref.model.Defaults;
import net.sf.jabref.model.database.BibDatabaseContext;
import net.sf.jabref.model.database.BibDatabaseMode;

public class NewSubDatabaseAction
extends MnemonicAwareAction {
    private final JabRefFrame jabRefFrame;

    public NewSubDatabaseAction(JabRefFrame jabRefFrame) {
        super(IconTheme.JabRefIcon.NEW.getIcon());
        this.jabRefFrame = jabRefFrame;
        this.putValue("Name", Localization.menuTitle("New subdatabase based on AUX file", new String[0]) + "...");
        this.putValue("ShortDescription", Localization.lang("New BibTeX subdatabase", new String[0]));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        FromAuxDialog dialog = new FromAuxDialog(this.jabRefFrame, "", true, this.jabRefFrame.getTabbedPane());
        dialog.setLocationRelativeTo(this.jabRefFrame);
        dialog.setVisible(true);
        if (dialog.generatePressed()) {
            Defaults defaults = new Defaults(BibDatabaseMode.fromPreference(Globals.prefs.getBoolean("biblatexMode")));
            BasePanel bp = new BasePanel(this.jabRefFrame, new BibDatabaseContext(dialog.getGenerateDB(), defaults));
            this.jabRefFrame.addTab(bp, true);
            this.jabRefFrame.output(Localization.lang("New database created.", new String[0]));
        }
    }
}

