/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.gui.actions;

import java.awt.event.ActionEvent;
import javax.swing.KeyStroke;
import net.sf.jabref.gui.EntryTypeDialog;
import net.sf.jabref.gui.IconTheme;
import net.sf.jabref.gui.JabRefFrame;
import net.sf.jabref.gui.actions.MnemonicAwareAction;
import net.sf.jabref.logic.l10n.Localization;
import net.sf.jabref.model.EntryTypes;
import net.sf.jabref.model.entry.EntryType;
import net.sf.jabref.model.strings.StringUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class NewEntryAction
extends MnemonicAwareAction {
    private static final Log LOGGER = LogFactory.getLog(NewEntryAction.class);
    private final JabRefFrame jabRefFrame;
    private String type;

    public NewEntryAction(JabRefFrame jabRefFrame, KeyStroke key) {
        super(IconTheme.JabRefIcon.ADD_ENTRY.getIcon());
        this.jabRefFrame = jabRefFrame;
        this.putValue("Name", Localization.menuTitle("New entry", new String[0]) + "...");
        this.putValue("AcceleratorKey", key);
        this.putValue("ShortDescription", Localization.lang("New BibTeX entry", new String[0]));
    }

    public NewEntryAction(JabRefFrame jabRefFrame, String type) {
        this.jabRefFrame = jabRefFrame;
        this.putValue("Name", StringUtil.capitalizeFirst(type));
        this.type = type;
    }

    public NewEntryAction(JabRefFrame jabRefFrame, String type, KeyStroke key) {
        this.jabRefFrame = jabRefFrame;
        this.putValue("Name", StringUtil.capitalizeFirst(type));
        this.putValue("AcceleratorKey", key);
        this.type = type;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String thisType = this.type;
        if (thisType == null) {
            EntryTypeDialog etd = new EntryTypeDialog(this.jabRefFrame);
            etd.setLocationRelativeTo(this.jabRefFrame);
            etd.setVisible(true);
            EntryType tp = etd.getChoice();
            if (tp == null) {
                return;
            }
            thisType = tp.getName();
        }
        if (this.jabRefFrame.getBasePanelCount() > 0) {
            this.jabRefFrame.getCurrentBasePanel().newEntry(EntryTypes.getType(thisType, this.jabRefFrame.getCurrentBasePanel().getBibDatabaseContext().getMode()).get());
        } else {
            LOGGER.info("Action 'New entry' must be disabled when no database is open.");
        }
    }
}

