/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.gui.actions;

import java.awt.event.ActionEvent;
import net.sf.jabref.gui.IconTheme;
import net.sf.jabref.gui.JabRefFrame;
import net.sf.jabref.gui.actions.MnemonicAwareAction;
import net.sf.jabref.logic.l10n.Localization;
import net.sf.jabref.model.Defaults;
import net.sf.jabref.model.database.BibDatabaseContext;
import net.sf.jabref.model.database.BibDatabaseMode;

public class NewDatabaseAction
extends MnemonicAwareAction {
    private final JabRefFrame jabRefFrame;
    private final BibDatabaseMode mode;

    public NewDatabaseAction(JabRefFrame jabRefFrame, BibDatabaseMode mode) {
        super(IconTheme.JabRefIcon.NEW.getIcon());
        this.jabRefFrame = jabRefFrame;
        this.mode = mode;
        this.putValue("Name", Localization.menuTitle("New %0 database", mode.getFormattedName()));
        this.putValue("ShortDescription", Localization.lang("New %0 database", mode.getFormattedName()));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        BibDatabaseContext bibDatabaseContext = new BibDatabaseContext(new Defaults(BibDatabaseMode.BIBTEX));
        bibDatabaseContext.setMode(this.mode);
        this.jabRefFrame.addTab(bibDatabaseContext, true);
        this.jabRefFrame.output(Localization.lang("New %0 database created.", this.mode.getFormattedName()));
    }
}

