/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.gui.actions;

import com.jgoodies.forms.builder.ButtonBarBuilder;
import com.jgoodies.forms.builder.FormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.undo.UndoableEdit;
import net.sf.jabref.Globals;
import net.sf.jabref.gui.BasePanel;
import net.sf.jabref.gui.JabRefFrame;
import net.sf.jabref.gui.actions.MnemonicAwareAction;
import net.sf.jabref.gui.keyboard.KeyBinding;
import net.sf.jabref.gui.undo.NamedCompound;
import net.sf.jabref.gui.undo.UndoableFieldChange;
import net.sf.jabref.logic.l10n.Localization;
import net.sf.jabref.model.entry.BibEntry;

public class MassSetFieldAction
extends MnemonicAwareAction {
    private final JabRefFrame frame;
    private JDialog diag;
    private JRadioButton all;
    private JRadioButton selected;
    private JRadioButton clear;
    private JRadioButton set;
    private JRadioButton rename;
    private JComboBox<String> field;
    private JTextField text;
    private JTextField renameTo;
    private boolean canceled = true;
    private JCheckBox overwrite;

    public MassSetFieldAction(JabRefFrame frame) {
        this.putValue("Name", Localization.menuTitle("Set/clear/rename fields", new String[0]) + "...");
        this.frame = frame;
    }

    private void createDialog() {
        this.diag = new JDialog(this.frame, Localization.lang("Set/clear/rename fields", new String[0]), true);
        this.field = new JComboBox();
        this.field.setEditable(true);
        this.text = new JTextField();
        this.text.setEnabled(false);
        this.renameTo = new JTextField();
        this.renameTo.setEnabled(false);
        JButton ok = new JButton(Localization.lang("OK", new String[0]));
        JButton cancel = new JButton(Localization.lang("Cancel", new String[0]));
        this.all = new JRadioButton(Localization.lang("All entries", new String[0]));
        this.selected = new JRadioButton(Localization.lang("Selected entries", new String[0]));
        this.clear = new JRadioButton(Localization.lang("Clear fields", new String[0]));
        this.set = new JRadioButton(Localization.lang("Set fields", new String[0]));
        this.rename = new JRadioButton(Localization.lang("Rename field to", new String[0]) + ":");
        this.rename.setToolTipText(Localization.lang("Move contents of a field into a field with a different name", new String[0]));
        Set<String> allFields = this.frame.getCurrentBasePanel().getDatabase().getAllVisibleFields();
        for (String f : allFields) {
            this.field.addItem(f);
        }
        this.set.addChangeListener(e -> this.text.setEnabled(this.set.isSelected()));
        this.clear.addChangeListener(e -> this.overwrite.setEnabled(!this.clear.isSelected()));
        this.rename.addChangeListener(e -> this.renameTo.setEnabled(this.rename.isSelected()));
        this.overwrite = new JCheckBox(Localization.lang("Overwrite existing field values", new String[0]), true);
        ButtonGroup bg = new ButtonGroup();
        bg.add(this.all);
        bg.add(this.selected);
        bg = new ButtonGroup();
        bg.add(this.clear);
        bg.add(this.set);
        bg.add(this.rename);
        FormBuilder builder = FormBuilder.create().layout(new FormLayout("left:pref, 4dlu, fill:100dlu:grow", "pref, 2dlu, pref, 2dlu, pref, 2dlu, pref, 2dlu, pref, 2dlu, pref, 2dlu, pref, 2dlu, pref, 2dlu, pref, 2dlu, pref"));
        builder.addSeparator(Localization.lang("Field name", new String[0]), new Object[0]).xyw(1, 1, 3);
        builder.add(Localization.lang("Field name", new String[0]), new Object[0]).xy(1, 3);
        builder.add(this.field).xy(3, 3);
        builder.addSeparator(Localization.lang("Include entries", new String[0]), new Object[0]).xyw(1, 5, 3);
        builder.add(this.all).xyw(1, 7, 3);
        builder.add(this.selected).xyw(1, 9, 3);
        builder.addSeparator(Localization.lang("New field value", new String[0]), new Object[0]).xyw(1, 11, 3);
        builder.add(this.set).xy(1, 13);
        builder.add(this.text).xy(3, 13);
        builder.add(this.clear).xyw(1, 15, 3);
        builder.add(this.rename).xy(1, 17);
        builder.add(this.renameTo).xy(3, 17);
        builder.add(this.overwrite).xyw(1, 19, 3);
        ButtonBarBuilder bb = new ButtonBarBuilder();
        bb.addGlue();
        bb.addButton((JComponent)ok);
        bb.addButton((JComponent)cancel);
        bb.addGlue();
        builder.getPanel().setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        bb.getPanel().setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.diag.getContentPane().add((Component)builder.getPanel(), "Center");
        this.diag.getContentPane().add((Component)bb.getPanel(), "South");
        this.diag.pack();
        ok.addActionListener(e -> {
            String[] fields;
            String fieldText = (String)this.field.getSelectedItem();
            if (fieldText == null || fieldText.trim().isEmpty()) {
                JOptionPane.showMessageDialog(this.diag, Localization.lang("You must enter at least one field name", new String[0]), "", 0);
                return;
            }
            if (this.rename.isSelected() && (fields = MassSetFieldAction.getFieldNames(fieldText)).length > 1) {
                JOptionPane.showMessageDialog(this.diag, Localization.lang("You can only rename one field at a time", new String[0]), "", 0);
                return;
            }
            this.canceled = false;
            this.diag.dispose();
        });
        AbstractAction cancelAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MassSetFieldAction.this.canceled = true;
                MassSetFieldAction.this.diag.dispose();
            }
        };
        cancel.addActionListener(cancelAction);
        ActionMap am = builder.getPanel().getActionMap();
        InputMap im = builder.getPanel().getInputMap(2);
        im.put(Globals.getKeyPrefs().getKey(KeyBinding.CLOSE_DIALOG), "close");
        am.put("close", cancelAction);
    }

    private void prepareDialog(boolean selection) {
        this.selected.setEnabled(selection);
        if (selection) {
            this.selected.setSelected(true);
        } else {
            this.all.setSelected(true);
        }
        if (!(this.set.isSelected() || this.clear.isSelected() || this.rename.isSelected())) {
            this.set.setSelected(true);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        BasePanel bp = this.frame.getCurrentBasePanel();
        if (bp == null) {
            return;
        }
        List<BibEntry> entries = bp.getSelectedEntries();
        if (this.diag == null) {
            this.createDialog();
        }
        this.canceled = true;
        this.prepareDialog(!entries.isEmpty());
        if (this.diag != null) {
            this.diag.setLocationRelativeTo(this.frame);
            this.diag.setVisible(true);
        }
        if (this.canceled) {
            return;
        }
        List<BibEntry> entryList = this.all.isSelected() ? bp.getDatabase().getEntries() : entries;
        String toSet = this.text.getText();
        if (toSet.isEmpty()) {
            toSet = null;
        }
        String[] fields = MassSetFieldAction.getFieldNames(((String)this.field.getSelectedItem()).trim().toLowerCase());
        NamedCompound ce = new NamedCompound(Localization.lang("Set field", new String[0]));
        if (this.rename.isSelected()) {
            if (fields.length > 1) {
                JOptionPane.showMessageDialog(this.diag, Localization.lang("You can only rename one field at a time", new String[0]), "", 0);
                return;
            }
            ce.addEdit(MassSetFieldAction.massRenameField(entryList, fields[0], this.renameTo.getText(), this.overwrite.isSelected()));
        } else {
            for (String field1 : fields) {
                ce.addEdit(MassSetFieldAction.massSetField(entryList, field1, this.set.isSelected() ? toSet : null, this.overwrite.isSelected()));
            }
        }
        ce.end();
        bp.getUndoManager().addEdit(ce);
        bp.markBaseChanged();
    }

    private static UndoableEdit massSetField(Collection<BibEntry> entries, String field, String text, boolean overwriteValues) {
        NamedCompound ce = new NamedCompound(Localization.lang("Set field", new String[0]));
        for (BibEntry entry : entries) {
            Optional<String> oldVal = entry.getField(field);
            if (!overwriteValues && oldVal.isPresent() && !oldVal.get().isEmpty()) continue;
            if (text == null) {
                entry.clearField(field);
            } else {
                entry.setField(field, text);
            }
            ce.addEdit(new UndoableFieldChange(entry, field, oldVal.orElse(null), text));
        }
        ce.end();
        return ce;
    }

    private static UndoableEdit massRenameField(Collection<BibEntry> entries, String field, String newField, boolean overwriteValues) {
        NamedCompound ce = new NamedCompound(Localization.lang("Rename field", new String[0]));
        for (BibEntry entry : entries) {
            Optional<String> valToMove = entry.getField(field);
            if (!valToMove.isPresent() || valToMove.get().isEmpty()) continue;
            Optional<String> valInNewField = entry.getField(newField);
            if (!overwriteValues && valInNewField.isPresent() && !valInNewField.get().isEmpty()) continue;
            entry.setField(newField, valToMove.get());
            ce.addEdit(new UndoableFieldChange(entry, newField, valInNewField.orElse(null), valToMove.get()));
            entry.clearField(field);
            ce.addEdit(new UndoableFieldChange(entry, field, valToMove.get(), null));
        }
        ce.end();
        return ce;
    }

    private static String[] getFieldNames(String s) {
        return s.split("[\\s;,]");
    }
}

