/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.gui.actions;

import com.jgoodies.forms.builder.FormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.event.ActionEvent;
import java.util.HashMap;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.RowFilter;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;
import net.sf.jabref.Globals;
import net.sf.jabref.gui.JabRefFrame;
import net.sf.jabref.gui.actions.MnemonicAwareAction;
import net.sf.jabref.gui.keyboard.KeyBinding;
import net.sf.jabref.gui.util.GUIUtil;
import net.sf.jabref.logic.integrity.IntegrityCheck;
import net.sf.jabref.logic.integrity.IntegrityMessage;
import net.sf.jabref.logic.l10n.Localization;

public class IntegrityCheckAction
extends MnemonicAwareAction {
    private static final String ELLIPSES = "...";
    private final JabRefFrame frame;

    public IntegrityCheckAction(JabRefFrame frame) {
        this.frame = frame;
        this.putValue("Name", Localization.menuTitle("Check integrity", new String[0]) + ELLIPSES);
        this.putValue("AcceleratorKey", Globals.getKeyPrefs().getKey(KeyBinding.CHECK_INTEGRITY));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        IntegrityCheck check = new IntegrityCheck(this.frame.getCurrentBasePanel().getBibDatabaseContext(), Globals.prefs.getFileDirectoryPreferences());
        List<IntegrityMessage> messages = check.checkBibtexDatabase();
        if (messages.isEmpty()) {
            JOptionPane.showMessageDialog(this.frame.getCurrentBasePanel(), Localization.lang("No problems found.", new String[0]));
        } else {
            final HashMap<String, Boolean> showMessage = new HashMap<String, Boolean>();
            Object[][] model = new Object[messages.size()][3];
            int i = 0;
            for (IntegrityMessage message : messages) {
                model[i][0] = message.getEntry().getCiteKeyOptional().orElse("");
                model[i][1] = message.getFieldName();
                model[i][2] = message.getMessage();
                showMessage.put(message.getMessage(), true);
                ++i;
            }
            JTable table = new JTable(model, new Object[]{Localization.lang("BibTeX key", new String[0]), Localization.lang("Field", new String[0]), Localization.lang("Message", new String[0])});
            RowFilter<Object, Object> filter = new RowFilter<Object, Object>(){

                @Override
                public boolean include(RowFilter.Entry<?, ?> entry) {
                    return (Boolean)showMessage.get(entry.getStringValue(2));
                }
            };
            TableRowSorter<TableModel> sorter = new TableRowSorter<TableModel>(table.getModel());
            sorter.setRowFilter(filter);
            table.setRowSorter(sorter);
            table.setSelectionMode(0);
            table.setDefaultEditor(Object.class, null);
            ListSelectionModel selectionModel = table.getSelectionModel();
            selectionModel.addListSelectionListener(event -> {
                if (!event.getValueIsAdjusting()) {
                    try {
                        String citeKey = (String)model[table.convertRowIndexToModel(table.getSelectedRow())][0];
                        String fieldName = (String)model[table.convertRowIndexToModel(table.getSelectedRow())][1];
                        this.frame.getCurrentBasePanel().editEntryByKeyAndFocusField(citeKey, fieldName);
                    }
                    catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                        // empty catch block
                    }
                }
            });
            GUIUtil.correctRowHeight(table);
            table.getColumnModel().getColumn(0).setPreferredWidth(100);
            table.getColumnModel().getColumn(1).setPreferredWidth(60);
            table.getColumnModel().getColumn(2).setPreferredWidth(400);
            table.setAutoResizeMode(3);
            JScrollPane scrollPane = new JScrollPane(table);
            String title = Localization.lang("%0 problem(s) found", String.valueOf(messages.size()));
            JDialog dialog = new JDialog(this.frame, title, false);
            JPopupMenu menu = new JPopupMenu();
            for (String messageString : showMessage.keySet()) {
                JCheckBoxMenuItem menuItem = new JCheckBoxMenuItem(messageString, true);
                menuItem.addActionListener(event -> {
                    showMessage.put(messageString, menuItem.isSelected());
                    ((AbstractTableModel)table.getModel()).fireTableDataChanged();
                });
                menu.add(menuItem);
            }
            JButton menuButton = new JButton(Localization.lang("Filter", new String[0]));
            menuButton.addActionListener(entry -> menu.show(menuButton, 0, menuButton.getHeight()));
            FormBuilder builder = FormBuilder.create().layout(new FormLayout("fill:pref:grow", "fill:pref:grow, 2dlu, pref"));
            builder.add(scrollPane).xy(1, 1);
            builder.add(menuButton).xy(1, 3, "c, b");
            dialog.add(builder.getPanel());
            dialog.setSize(600, 600);
            dialog.setVisible(true);
        }
    }
}

