/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.gui.actions;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import net.sf.jabref.logic.error.StreamEavesdropper;
import net.sf.jabref.logic.l10n.Localization;
import net.sf.jabref.logic.logging.Cache;

public class ErrorConsoleAction
extends AbstractAction {
    private final JFrame frame;
    private final StreamEavesdropper streamEavesdropper;
    private final Cache cache;

    public ErrorConsoleAction(JFrame frame, StreamEavesdropper streamEavesdropper, Cache cache) {
        super(Localization.menuTitle("Show error console", new String[0]));
        this.streamEavesdropper = streamEavesdropper;
        this.cache = cache;
        this.putValue("ShortDescription", Localization.lang("Display all error messages", new String[0]));
        this.frame = frame;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.displayErrorConsole(this.frame);
    }

    private void displayErrorConsole(JFrame parent) {
        JTabbedPane tabbed = new JTabbedPane();
        ErrorConsoleAction.addTextArea(tabbed, Localization.lang("Log", new String[0]), this.cache.get());
        ErrorConsoleAction.addTextArea(tabbed, Localization.lang("Exceptions", new String[0]), this.streamEavesdropper.getErrorMessages(), Localization.lang("No exceptions have occurred.", new String[0]));
        ErrorConsoleAction.addTextArea(tabbed, Localization.lang("Output", new String[0]), this.streamEavesdropper.getOutput());
        tabbed.setPreferredSize(new Dimension(500, 500));
        JOptionPane.showMessageDialog(parent, tabbed, Localization.lang("Program output", new String[0]), 0);
    }

    private static void addTextArea(JTabbedPane tabbed, String title, String output, String ifEmpty) {
        JTextArea ta = new JTextArea(output);
        ta.setEditable(false);
        if (ifEmpty != null && ta.getText().isEmpty()) {
            ta.setText(ifEmpty);
        }
        JScrollPane sp = new JScrollPane(ta);
        tabbed.addTab(title, sp);
    }

    private static void addTextArea(JTabbedPane tabbed, String title, String output) {
        ErrorConsoleAction.addTextArea(tabbed, title, output, null);
    }
}

