/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.gui.actions;

import java.util.List;
import java.util.stream.Collectors;
import net.sf.jabref.JabRefGUI;
import net.sf.jabref.gui.ClipBoardManager;
import net.sf.jabref.gui.actions.BaseAction;
import net.sf.jabref.gui.maintable.MainTable;
import net.sf.jabref.logic.l10n.Localization;
import net.sf.jabref.logic.util.OS;
import net.sf.jabref.model.entry.BibEntry;

public class CopyBibTeXKeyAndLinkAction
implements BaseAction {
    private final MainTable mainTable;

    public CopyBibTeXKeyAndLinkAction(MainTable mainTable) {
        this.mainTable = mainTable;
    }

    @Override
    public void action() throws Throwable {
        List<BibEntry> entries = this.mainTable.getSelectedEntries();
        if (!entries.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            List entriesWithKey = entries.stream().filter(BibEntry::hasCiteKey).collect(Collectors.toList());
            if (entriesWithKey.isEmpty()) {
                JabRefGUI.getMainFrame().output(Localization.lang("None of the selected entries have BibTeX keys.", new String[0]));
                return;
            }
            for (BibEntry entry : entriesWithKey) {
                String key = entry.getCiteKeyOptional().get();
                String url = entry.getField("url").orElse("");
                sb.append(url.isEmpty() ? key : String.format("<a href=\"%s\">%s</a>", url, key));
                sb.append(OS.NEWLINE);
            }
            ClipBoardManager clipboard = new ClipBoardManager();
            clipboard.setClipboardContents(sb.toString());
            int copied = entriesWithKey.size();
            int toCopy = entries.size();
            if (copied == toCopy) {
                JabRefGUI.getMainFrame().output((entries.size() > 1 ? Localization.lang("Copied keys", new String[0]) : Localization.lang("Copied key", new String[0])) + '.');
            } else {
                JabRefGUI.getMainFrame().output(Localization.lang("Warning: %0 out of %1 entries have undefined BibTeX key.", Long.toString(toCopy - copied), Integer.toString(toCopy)));
            }
        }
    }
}

