/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.gui.actions;

import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.text.JTextComponent;
import net.sf.jabref.gui.ClipBoardManager;
import net.sf.jabref.gui.IconTheme;
import net.sf.jabref.logic.l10n.Localization;

public class CopyAction
extends AbstractAction {
    private final JTextComponent field;

    public CopyAction(JTextComponent field) {
        this.field = field;
        this.putValue("Name", Localization.lang("Copy to clipboard", new String[0]));
        this.putValue("ShortDescription", Localization.lang("Copy to clipboard", new String[0]));
        this.putValue("SmallIcon", IconTheme.JabRefIcon.COPY.getSmallIcon());
        this.putValue("SwingLargeIconKey", IconTheme.JabRefIcon.COPY.getIcon());
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.field != null) {
            ClipBoardManager clipboard = new ClipBoardManager();
            String selectedText = this.field.getSelectedText();
            String allText = this.field.getText();
            if (selectedText != null && !selectedText.isEmpty()) {
                clipboard.setClipboardContents(selectedText);
            } else if (allText != null && !allText.isEmpty()) {
                clipboard.setClipboardContents(allText);
            }
        }
    }
}

