/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.gui.actions;

import java.util.List;
import java.util.Objects;
import javax.swing.JOptionPane;
import net.sf.jabref.Globals;
import net.sf.jabref.gui.BasePanel;
import net.sf.jabref.gui.JabRefFrame;
import net.sf.jabref.gui.cleanup.CleanupPresetPanel;
import net.sf.jabref.gui.undo.NamedCompound;
import net.sf.jabref.gui.undo.UndoableFieldChange;
import net.sf.jabref.gui.util.component.CheckBoxMessage;
import net.sf.jabref.gui.worker.AbstractWorker;
import net.sf.jabref.logic.cleanup.CleanupPreset;
import net.sf.jabref.logic.cleanup.CleanupWorker;
import net.sf.jabref.logic.l10n.Localization;
import net.sf.jabref.model.FieldChange;
import net.sf.jabref.model.entry.BibEntry;
import net.sf.jabref.preferences.JabRefPreferences;

public class CleanupAction
extends AbstractWorker {
    private final BasePanel panel;
    private final JabRefFrame frame;
    private int unsuccessfulRenames;
    private boolean canceled;
    private int modifiedEntriesCount;
    private final JabRefPreferences preferences;

    public CleanupAction(BasePanel panel, JabRefPreferences preferences) {
        this.panel = panel;
        this.frame = panel.frame();
        this.preferences = Objects.requireNonNull(preferences);
    }

    @Override
    public void init() {
        this.canceled = false;
        this.modifiedEntriesCount = 0;
        if (this.panel.getSelectedEntries().isEmpty()) {
            JOptionPane.showMessageDialog(this.frame, Localization.lang("First select entries to clean up.", new String[0]), Localization.lang("Cleanup entry", new String[0]), 1);
            this.canceled = true;
            return;
        }
        this.frame.block();
        this.panel.output(Localization.lang("Doing a cleanup for %0 entries...", Integer.toString(this.panel.getSelectedEntries().size())));
    }

    @Override
    public void run() {
        if (this.canceled) {
            return;
        }
        CleanupPresetPanel presetPanel = new CleanupPresetPanel(this.panel.getBibDatabaseContext(), CleanupPreset.loadFromPreferences(this.preferences));
        int choice = this.showDialog(presetPanel);
        if (choice != 0) {
            this.canceled = true;
            return;
        }
        CleanupPreset cleanupPreset = presetPanel.getCleanupPreset();
        cleanupPreset.storeInPreferences(this.preferences);
        if (cleanupPreset.isRenamePDF() && Globals.prefs.getBoolean("AskAutoNamingPDFsAgain")) {
            CheckBoxMessage cbm = new CheckBoxMessage(Localization.lang("Auto-generating PDF-Names does not support undo. Continue?", new String[0]), Localization.lang("Disable this confirmation dialog", new String[0]), false);
            int answer = JOptionPane.showConfirmDialog(this.frame, cbm, Localization.lang("Autogenerate PDF Names", new String[0]), 0);
            if (cbm.isSelected()) {
                Globals.prefs.putBoolean("AskAutoNamingPDFsAgain", false);
            }
            if (answer == 1) {
                this.canceled = true;
                return;
            }
        }
        for (BibEntry entry : this.panel.getSelectedEntries()) {
            NamedCompound ce = new NamedCompound(Localization.lang("Cleanup entry", new String[0]));
            this.doCleanup(cleanupPreset, entry, ce);
            ce.end();
            if (!ce.hasEdits()) continue;
            ++this.modifiedEntriesCount;
            this.panel.getUndoManager().addEdit(ce);
        }
    }

    @Override
    public void update() {
        String message;
        if (this.canceled) {
            this.frame.unblock();
            return;
        }
        if (this.unsuccessfulRenames > 0) {
            JOptionPane.showMessageDialog(this.frame, Localization.lang("File rename failed for %0 entries.", Integer.toString(this.unsuccessfulRenames)), Localization.lang("Autogenerate PDF Names", new String[0]), 1);
        }
        if (this.modifiedEntriesCount > 0) {
            this.panel.updateEntryEditorIfShowing();
            this.panel.markBaseChanged();
        }
        switch (this.modifiedEntriesCount) {
            case 0: {
                message = Localization.lang("No entry needed a clean up", new String[0]);
                break;
            }
            case 1: {
                message = Localization.lang("One entry needed a clean up", new String[0]);
                break;
            }
            default: {
                message = Localization.lang("%0 entries needed a clean up", Integer.toString(this.modifiedEntriesCount));
            }
        }
        this.panel.output(message);
        this.frame.unblock();
    }

    private int showDialog(CleanupPresetPanel presetPanel) {
        String dialogTitle = Localization.lang("Cleanup entries", new String[0]);
        Object[] messages = new Object[]{Localization.lang("What would you like to clean up?", new String[0]), presetPanel.getPanel()};
        return JOptionPane.showConfirmDialog(this.frame, messages, dialogTitle, 2, 3);
    }

    private void doCleanup(CleanupPreset preset, BibEntry entry, NamedCompound ce) {
        CleanupWorker cleaner = new CleanupWorker(this.panel.getBibDatabaseContext(), this.preferences.getCleanupPreferences(Globals.journalAbbreviationLoader));
        List<FieldChange> changes = cleaner.cleanup(preset, entry);
        this.unsuccessfulRenames = cleaner.getUnsuccessfulRenames();
        if (changes.isEmpty()) {
            return;
        }
        for (FieldChange change : changes) {
            ce.addEdit(new UndoableFieldChange(change));
        }
    }
}

