/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.gui;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.DefaultCellEditor;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.LayoutFocusTraversalPolicy;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumnModel;
import javax.swing.undo.CompoundEdit;
import net.sf.jabref.Globals;
import net.sf.jabref.gui.BasePanel;
import net.sf.jabref.gui.GUIGlobals;
import net.sf.jabref.gui.IconTheme;
import net.sf.jabref.gui.JabRefFrame;
import net.sf.jabref.gui.OSXCompatibleToolbar;
import net.sf.jabref.gui.help.HelpAction;
import net.sf.jabref.gui.keyboard.KeyBinding;
import net.sf.jabref.gui.undo.UndoableInsertString;
import net.sf.jabref.gui.undo.UndoableRemoveString;
import net.sf.jabref.gui.undo.UndoableStringChange;
import net.sf.jabref.gui.util.GUIUtil;
import net.sf.jabref.gui.util.WindowLocation;
import net.sf.jabref.logic.bibtex.LatexFieldFormatter;
import net.sf.jabref.logic.bibtex.comparator.BibtexStringComparator;
import net.sf.jabref.logic.help.HelpFile;
import net.sf.jabref.logic.l10n.Localization;
import net.sf.jabref.model.database.BibDatabase;
import net.sf.jabref.model.database.KeyCollisionException;
import net.sf.jabref.model.entry.BibtexString;
import net.sf.jabref.model.entry.IdGenerator;

class StringDialog
extends JDialog {
    private final BibDatabase base;
    private final BasePanel panel;
    private List<BibtexString> strings;
    private final StringTable table;
    private final HelpAction helpAction;
    private final SaveDatabaseAction saveAction = new SaveDatabaseAction(this);
    private final CloseAction closeAction = new CloseAction();
    private static final String STRINGS_TITLE = Localization.lang("Strings for database", new String[0]);

    public StringDialog(JabRefFrame frame, BasePanel panel, BibDatabase base) {
        super(frame);
        this.panel = panel;
        this.base = base;
        this.sortStrings();
        this.helpAction = new HelpAction(Localization.lang("Help", new String[0]), HelpFile.STRING_EDITOR);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                StringDialog.this.closeAction.actionPerformed(null);
            }
        });
        this.setFocusTraversalPolicy(new LayoutFocusTraversalPolicy(){

            @Override
            protected boolean accept(Component c) {
                return super.accept(c) && c instanceof StringTable;
            }
        });
        JPanel pan = new JPanel();
        GridBagLayout gbl = new GridBagLayout();
        pan.setLayout(gbl);
        GridBagConstraints con = new GridBagConstraints();
        con.fill = 1;
        con.weighty = 1.0;
        con.weightx = 1.0;
        StringTableModel stm = new StringTableModel(this, base);
        this.table = new StringTable(stm);
        if (!base.hasNoStrings()) {
            this.table.setRowSelectionInterval(0, 0);
        }
        GUIUtil.correctRowHeight(this.table);
        gbl.setConstraints(this.table.getPane(), con);
        pan.add(this.table.getPane());
        OSXCompatibleToolbar tlb = new OSXCompatibleToolbar();
        InputMap im = tlb.getInputMap(2);
        ActionMap am = tlb.getActionMap();
        im.put(Globals.getKeyPrefs().getKey(KeyBinding.STRING_DIALOG_ADD_STRING), "add");
        NewStringAction newStringAction = new NewStringAction(this);
        am.put("add", newStringAction);
        im.put(Globals.getKeyPrefs().getKey(KeyBinding.STRING_DIALOG_REMOVE_STRING), "remove");
        RemoveStringAction removeStringAction = new RemoveStringAction(this);
        am.put("remove", removeStringAction);
        im.put(Globals.getKeyPrefs().getKey(KeyBinding.SAVE_DATABASE), "save");
        am.put("save", this.saveAction);
        im.put(Globals.getKeyPrefs().getKey(KeyBinding.CLOSE_DIALOG), "close");
        am.put("close", this.closeAction);
        im.put(Globals.getKeyPrefs().getKey(KeyBinding.HELP), "help");
        am.put("help", this.helpAction);
        im.put(Globals.getKeyPrefs().getKey(KeyBinding.UNDO), "undo");
        UndoAction undoAction = new UndoAction();
        am.put("undo", undoAction);
        im.put(Globals.getKeyPrefs().getKey(KeyBinding.REDO), "redo");
        RedoAction redoAction = new RedoAction();
        am.put("redo", redoAction);
        tlb.add(newStringAction);
        tlb.add(removeStringAction);
        tlb.addSeparator();
        tlb.add(this.helpAction);
        Container conPane = this.getContentPane();
        conPane.add((Component)tlb, "North");
        conPane.add((Component)pan, "Center");
        this.setTitle(STRINGS_TITLE + ": " + panel.getBibDatabaseContext().getDatabaseFile().map(File::getName).orElse(GUIGlobals.UNTITLED_TITLE));
        WindowLocation pw = new WindowLocation(this, "stringsPosX", "stringsPosY", "stringsSizeX", "stringsSizeY");
        pw.displayWindowAtStoredLocation();
    }

    private void sortStrings() {
        this.strings = new ArrayList<BibtexString>();
        for (String s : this.base.getStringKeySet()) {
            this.strings.add(this.base.getString(s));
        }
        Collections.sort(this.strings, new BibtexStringComparator(false));
    }

    public void refreshTable() {
        this.sortStrings();
        this.table.revalidate();
        this.table.clearSelection();
        this.table.repaint();
    }

    public void saveDatabase() {
        this.panel.runCommand("save");
    }

    private static boolean isNumber(String name) {
        try {
            Integer.parseInt(name);
            return true;
        }
        catch (NumberFormatException ex) {
            return false;
        }
    }

    public void assureNotEditing() {
        if (this.table.isEditing()) {
            int col = this.table.getEditingColumn();
            int row = this.table.getEditingRow();
            this.table.getCellEditor(row, col).stopCellEditing();
        }
    }

    class RedoAction
    extends AbstractAction {
        public RedoAction() {
            super("Redo", IconTheme.JabRefIcon.REDO.getIcon());
            this.putValue("ShortDescription", Localization.lang("Redo", new String[0]));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            StringDialog.this.panel.runCommand("redo");
        }
    }

    class UndoAction
    extends AbstractAction {
        public UndoAction() {
            super("Undo", IconTheme.JabRefIcon.UNDO.getIcon());
            this.putValue("ShortDescription", Localization.lang("Undo", new String[0]));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            StringDialog.this.panel.runCommand("undo");
        }
    }

    class RemoveStringAction
    extends AbstractAction {
        private final StringDialog parent;

        public RemoveStringAction(StringDialog parent) {
            super("Remove selected strings", IconTheme.JabRefIcon.REMOVE.getIcon());
            this.putValue("ShortDescription", Localization.lang("Remove selected strings", new String[0]));
            this.parent = parent;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int[] sel = StringDialog.this.table.getSelectedRows();
            if (sel.length > 0) {
                StringDialog.this.assureNotEditing();
                String msg = sel.length > 1 ? Localization.lang("Really delete the %0 selected entries?", Integer.toString(sel.length)) : Localization.lang("Really delete the selected entry?", new String[0]);
                int answer = JOptionPane.showConfirmDialog(this.parent, msg, Localization.lang("Delete strings", new String[0]), 0, 3);
                if (answer == 0) {
                    CompoundEdit ce = new CompoundEdit();
                    for (int i = sel.length - 1; i >= 0; --i) {
                        BibtexString subject = (BibtexString)StringDialog.this.strings.get(sel[i]);
                        ce.addEdit(new UndoableRemoveString(StringDialog.this.panel, StringDialog.this.base, subject));
                        StringDialog.this.base.removeString(subject.getId());
                    }
                    ce.end();
                    StringDialog.this.panel.getUndoManager().addEdit(ce);
                    StringDialog.this.refreshTable();
                    if (!StringDialog.this.base.hasNoStrings()) {
                        StringDialog.this.table.setRowSelectionInterval(0, 0);
                    }
                }
            }
        }
    }

    static class SaveDatabaseAction
    extends AbstractAction {
        private final StringDialog parent;

        public SaveDatabaseAction(StringDialog parent) {
            super("Save database", IconTheme.JabRefIcon.SAVE.getIcon());
            this.putValue("ShortDescription", Localization.lang("Save database", new String[0]));
            this.parent = parent;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.parent.saveDatabase();
        }
    }

    class NewStringAction
    extends AbstractAction {
        private final StringDialog parent;

        public NewStringAction(StringDialog parent) {
            super("New string", IconTheme.JabRefIcon.ADD.getIcon());
            this.putValue("ShortDescription", Localization.lang("New string", new String[0]));
            this.parent = parent;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String name = JOptionPane.showInputDialog(this.parent, (Object)Localization.lang("Please enter the string's label", new String[0]));
            if (name == null) {
                return;
            }
            if (StringDialog.isNumber(name)) {
                JOptionPane.showMessageDialog(this.parent, Localization.lang("The label of the string cannot be a number.", new String[0]), Localization.lang("Label", new String[0]), 0);
                return;
            }
            if (name.contains("#")) {
                JOptionPane.showMessageDialog(this.parent, Localization.lang("The label of the string cannot contain the '#' character.", new String[0]), Localization.lang("Label", new String[0]), 0);
                return;
            }
            if (name.contains(" ")) {
                JOptionPane.showMessageDialog(this.parent, Localization.lang("The label of the string cannot contain spaces.", new String[0]), Localization.lang("Label", new String[0]), 0);
                return;
            }
            try {
                String newId = IdGenerator.next();
                BibtexString bs = new BibtexString(newId, name, "");
                StringDialog.this.panel.getUndoManager().addEdit(new UndoableInsertString(StringDialog.this.panel, StringDialog.this.panel.getDatabase(), bs));
                StringDialog.this.base.addString(bs);
                StringDialog.this.refreshTable();
                StringDialog.this.panel.markBaseChanged();
            }
            catch (KeyCollisionException ex) {
                JOptionPane.showMessageDialog(this.parent, Localization.lang("A string with that label already exists", new String[0]), Localization.lang("Label", new String[0]), 0);
            }
        }
    }

    class CloseAction
    extends AbstractAction {
        public CloseAction() {
            super("Close window");
            this.putValue("ShortDescription", Localization.lang("Close dialog", new String[0]));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            StringDialog.this.panel.stringsClosing();
            StringDialog.this.dispose();
        }
    }

    class StringTableModel
    extends AbstractTableModel {
        private final BibDatabase tbase;
        private final StringDialog parent;

        public StringTableModel(StringDialog parent, BibDatabase base) {
            this.parent = parent;
            this.tbase = base;
        }

        @Override
        public Object getValueAt(int row, int col) {
            return col == 0 ? ((BibtexString)StringDialog.this.strings.get(row)).getName() : ((BibtexString)StringDialog.this.strings.get(row)).getContent();
        }

        @Override
        public void setValueAt(Object value, int row, int col) {
            if (col == 0) {
                if (!value.equals(((BibtexString)StringDialog.this.strings.get(row)).getName())) {
                    if (this.tbase.hasStringLabel((String)value)) {
                        JOptionPane.showMessageDialog(this.parent, Localization.lang("A string with that label already exists", new String[0]), Localization.lang("Label", new String[0]), 0);
                    } else if (((String)value).contains(" ")) {
                        JOptionPane.showMessageDialog(this.parent, Localization.lang("The label of the string cannot contain spaces.", new String[0]), Localization.lang("Label", new String[0]), 0);
                    } else if (((String)value).contains("#")) {
                        JOptionPane.showMessageDialog(this.parent, Localization.lang("The label of the string cannot contain the '#' character.", new String[0]), Localization.lang("Label", new String[0]), 0);
                    } else if (StringDialog.isNumber((String)value)) {
                        JOptionPane.showMessageDialog(this.parent, Localization.lang("The label of the string cannot be a number.", new String[0]), Localization.lang("Label", new String[0]), 0);
                    } else {
                        BibtexString subject = (BibtexString)StringDialog.this.strings.get(row);
                        StringDialog.this.panel.getUndoManager().addEdit(new UndoableStringChange(StringDialog.this.panel, subject, true, subject.getName(), (String)value));
                        subject.setName((String)value);
                        StringDialog.this.panel.markBaseChanged();
                        StringDialog.this.refreshTable();
                    }
                }
            } else {
                BibtexString subject = (BibtexString)StringDialog.this.strings.get(row);
                if (!value.equals(subject.getContent())) {
                    try {
                        new LatexFieldFormatter(Globals.prefs.getLatexFieldFormatterPreferences()).format((String)value, "__dummy");
                    }
                    catch (IllegalArgumentException ex) {
                        return;
                    }
                    StringDialog.this.panel.getUndoManager().addEdit(new UndoableStringChange(StringDialog.this.panel, subject, false, subject.getContent(), (String)value));
                    subject.setContent((String)value);
                    StringDialog.this.panel.markBaseChanged();
                }
            }
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public int getRowCount() {
            return StringDialog.this.strings.size();
        }

        @Override
        public String getColumnName(int col) {
            return col == 0 ? Localization.lang("Label", new String[0]) : Localization.lang("Content", new String[0]);
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return true;
        }
    }

    class StringTable
    extends JTable {
        private final JScrollPane sp;

        public StringTable(StringTableModel stm) {
            super(stm);
            this.sp = new JScrollPane(this);
            this.setShowVerticalLines(true);
            this.setShowHorizontalLines(true);
            this.setColumnSelectionAllowed(true);
            DefaultCellEditor dce = new DefaultCellEditor(new JTextField());
            dce.setClickCountToStart(2);
            this.setDefaultEditor(String.class, dce);
            TableColumnModel cm = this.getColumnModel();
            cm.getColumn(0).setPreferredWidth(800);
            cm.getColumn(1).setPreferredWidth(2000);
            this.sp.getViewport().setBackground(Globals.prefs.getColor("tableBackground"));
            this.getInputMap().put(Globals.getKeyPrefs().getKey(KeyBinding.CLOSE_DIALOG), "close");
            this.getActionMap().put("close", StringDialog.this.closeAction);
            this.getInputMap().put(Globals.getKeyPrefs().getKey(KeyBinding.HELP), "help");
            this.getActionMap().put("help", StringDialog.this.helpAction);
        }

        public JComponent getPane() {
            return this.sp;
        }
    }
}

