/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.gui;

import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.KeyStroke;
import net.sf.jabref.gui.BasePanel;
import net.sf.jabref.gui.IconTheme;
import net.sf.jabref.gui.OSXCompatibleToolbar;
import net.sf.jabref.gui.SidePaneManager;
import net.sf.jabref.gui.actions.MnemonicAwareAction;
import org.jdesktop.swingx.JXTitledPanel;
import org.jdesktop.swingx.painter.MattePainter;

public abstract class SidePaneComponent
extends JXTitledPanel {
    protected final JButton close = new JButton(IconTheme.JabRefIcon.CLOSE.getSmallIcon());
    protected final SidePaneManager manager;
    protected BasePanel panel;

    public SidePaneComponent(SidePaneManager manager, Icon icon, String title) {
        super(title);
        this.manager = manager;
        this.add(new JLabel(icon));
        this.setTitleForeground(new Color(79, 95, 143));
        this.setBorder(BorderFactory.createEmptyBorder());
        this.close.setMargin(new Insets(0, 0, 0, 0));
        this.close.setBorder(null);
        this.close.addActionListener(e -> this.hideAway());
        JButton up = new JButton(IconTheme.JabRefIcon.UP.getSmallIcon());
        up.setMargin(new Insets(0, 0, 0, 0));
        up.setBorder(null);
        up.addActionListener(e -> this.moveUp());
        JButton down = new JButton(IconTheme.JabRefIcon.DOWN.getSmallIcon());
        down.setMargin(new Insets(0, 0, 0, 0));
        down.setBorder(null);
        down.addActionListener(e -> this.moveDown());
        OSXCompatibleToolbar tlb = new OSXCompatibleToolbar();
        ((Container)tlb).add(up);
        ((Container)tlb).add(down);
        ((Container)tlb).add(this.close);
        tlb.setOpaque(false);
        tlb.setFloatable(false);
        this.getUI().getTitleBar().add(tlb);
        this.setTitlePainter(new MattePainter(Color.lightGray));
    }

    private void hideAway() {
        this.manager.hideComponent(this);
    }

    private void moveUp() {
        this.manager.moveUp(this);
    }

    private void moveDown() {
        this.manager.moveDown(this);
    }

    public void setActiveBasePanel(BasePanel panel) {
        this.panel = panel;
    }

    public BasePanel getActiveBasePanel() {
        return this.panel;
    }

    public void componentClosing() {
    }

    public void componentOpening() {
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public abstract int getRescalingWeight();

    public abstract ToggleAction getToggleAction();

    public class ToggleAction
    extends MnemonicAwareAction {
        public ToggleAction(String text, String description, KeyStroke key, IconTheme.JabRefIcon icon) {
            super(icon.getIcon());
            this.putValue("Name", text);
            this.putValue("AcceleratorKey", key);
            this.putValue("ShortDescription", description);
        }

        public ToggleAction(String text, String description, KeyStroke key, Icon icon) {
            super(icon);
            this.putValue("Name", text);
            this.putValue("AcceleratorKey", key);
            this.putValue("ShortDescription", description);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!SidePaneComponent.this.manager.hasComponent(SidePaneComponent.this.getClass())) {
                SidePaneComponent.this.manager.register(SidePaneComponent.this);
            }
            if ((e.getModifiers() & 0x10) != 0) {
                SidePaneComponent.this.manager.toggle(SidePaneComponent.this.getClass());
            } else {
                SidePaneComponent.this.manager.toggleThreeWay(SidePaneComponent.this.getClass());
            }
            this.putValue("SwingSelectedKey", SidePaneComponent.this.manager.isComponentVisible(SidePaneComponent.this.getClass()));
        }

        public void setSelected(boolean selected) {
            this.putValue("SwingSelectedKey", selected);
        }

        public boolean isSelected() {
            return Boolean.TRUE.equals(this.getValue("SwingSelectedKey"));
        }
    }
}

