/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Collection;
import javax.swing.Box;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import net.sf.jabref.gui.SidePaneComponent;

public class SidePane
extends JPanel {
    private final Dimension PREFERRED_SIZE = new Dimension(175, 100);
    private final GridBagLayout gridBagLayout = new GridBagLayout();
    private final GridBagConstraints constraint = new GridBagConstraints();
    private final JPanel mainPanel = new JPanel();

    public SidePane() {
        this.setLayout(new BorderLayout());
        this.mainPanel.setLayout(this.gridBagLayout);
        this.constraint.anchor = 11;
        this.constraint.fill = 1;
        this.constraint.gridwidth = 0;
        this.constraint.insets = new Insets(1, 1, 1, 1);
        this.constraint.gridheight = 1;
        this.constraint.weightx = 1.0;
        JScrollPane sp = new JScrollPane(this.mainPanel, 20, 30);
        sp.setBorder(null);
        super.add(sp);
    }

    public void setComponents(Collection<SidePaneComponent> comps) {
        this.mainPanel.removeAll();
        int totalWeights = 0;
        for (SidePaneComponent c : comps) {
            this.constraint.weighty = c.getRescalingWeight();
            totalWeights += c.getRescalingWeight();
            this.gridBagLayout.setConstraints(c, this.constraint);
            this.mainPanel.add(c);
        }
        if (totalWeights <= 0) {
            this.constraint.weighty = 1.0;
            Component bx = Box.createVerticalGlue();
            this.gridBagLayout.setConstraints(bx, this.constraint);
            this.mainPanel.add(bx);
        }
        this.revalidate();
        this.repaint();
    }

    @Override
    public void remove(Component c) {
        this.mainPanel.remove(c);
    }

    @Override
    public Dimension getMaximumSize() {
        return this.getPreferredSize();
    }

    @Override
    public Dimension getPreferredSize() {
        return this.PREFERRED_SIZE;
    }
}

