/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.gui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import net.sf.jabref.Globals;
import net.sf.jabref.gui.JabRefFrame;
import net.sf.jabref.gui.keyboard.KeyBinding;
import net.sf.jabref.gui.undo.NamedCompound;
import net.sf.jabref.gui.undo.UndoableFieldChange;
import net.sf.jabref.logic.l10n.Localization;
import net.sf.jabref.model.entry.BibEntry;

class ReplaceStringDialog
extends JDialog {
    private final JTextField fieldsField = new JTextField("", 30);
    private final JTextField fromField = new JTextField("", 30);
    private final JTextField toField = new JTextField("", 30);
    private final JCheckBox selOnly = new JCheckBox(Localization.lang("Limit to selected entries", new String[0]), false);
    private final JRadioButton allFi = new JRadioButton(Localization.lang("All fields", new String[0]), true);
    private final JRadioButton field = new JRadioButton(Localization.lang("Limit to fields", new String[0]) + ":", false);
    private boolean okPressed;
    private String[] fieldStrings;
    private String fromString;
    private String toString;

    public ReplaceStringDialog(JabRefFrame parent) {
        super(parent, Localization.lang("Replace string", new String[0]), true);
        ButtonGroup bg = new ButtonGroup();
        bg.add(this.allFi);
        bg.add(this.field);
        ActionListener okListener = e -> {
            this.fromString = this.fromField.getText();
            this.toString = this.toField.getText();
            if ("".equals(this.fromString)) {
                return;
            }
            this.okPressed = true;
            this.fieldStrings = this.fieldsField.getText().toLowerCase().split(";");
            this.dispose();
        };
        JButton ok = new JButton(Localization.lang("OK", new String[0]));
        ok.addActionListener(okListener);
        this.toField.addActionListener(okListener);
        this.fieldsField.addActionListener(okListener);
        AbstractAction cancelAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ReplaceStringDialog.this.dispose();
            }
        };
        JButton cancel = new JButton(Localization.lang("Cancel", new String[0]));
        cancel.addActionListener(cancelAction);
        JPanel settings = new JPanel();
        ActionMap am = settings.getActionMap();
        InputMap im = settings.getInputMap(2);
        im.put(Globals.getKeyPrefs().getKey(KeyBinding.CLOSE_DIALOG), "close");
        am.put("close", cancelAction);
        GridBagLayout gbl = new GridBagLayout();
        settings.setLayout(gbl);
        JPanel opt = new JPanel();
        opt.setLayout(gbl);
        JPanel main = new JPanel();
        main.setLayout(gbl);
        settings.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), Localization.lang("Replace string", new String[0])));
        main.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), Localization.lang("Strings", new String[0])));
        GridBagConstraints con = new GridBagConstraints();
        con.fill = 2;
        con.gridwidth = 2;
        con.weightx = 0.0;
        con.anchor = 17;
        con.gridy = 0;
        con.gridx = 0;
        con.insets = new Insets(3, 5, 3, 5);
        gbl.setConstraints(this.selOnly, con);
        settings.add(this.selOnly);
        con.gridy = 1;
        con.insets = new Insets(13, 5, 3, 5);
        gbl.setConstraints(this.allFi, con);
        settings.add(this.allFi);
        con.gridwidth = 1;
        con.gridy = 2;
        con.gridx = 0;
        con.insets = new Insets(3, 5, 3, 5);
        gbl.setConstraints(this.field, con);
        settings.add(this.field);
        con.gridx = 1;
        con.weightx = 1.0;
        gbl.setConstraints(this.fieldsField, con);
        settings.add(this.fieldsField);
        con.weightx = 0.0;
        con.gridx = 0;
        con.gridy = 0;
        JLabel fl = new JLabel(Localization.lang("Search for", new String[0]) + ":");
        gbl.setConstraints(fl, con);
        main.add(fl);
        con.gridy = 1;
        JLabel tl = new JLabel(Localization.lang("Replace with", new String[0]) + ":");
        gbl.setConstraints(tl, con);
        main.add(tl);
        con.weightx = 1.0;
        con.gridx = 1;
        con.gridy = 0;
        gbl.setConstraints(this.fromField, con);
        main.add(this.fromField);
        con.gridy = 1;
        gbl.setConstraints(this.toField, con);
        main.add(this.toField);
        con.gridx = -1;
        con.gridy = -1;
        con.weightx = 1.0;
        con.gridwidth = 1;
        con.anchor = 13;
        con.fill = 0;
        gbl.setConstraints(ok, con);
        opt.add(ok);
        con.anchor = 17;
        con.gridwidth = 0;
        gbl.setConstraints(cancel, con);
        opt.add(cancel);
        this.getContentPane().add((Component)main, "North");
        this.getContentPane().add((Component)settings, "Center");
        this.getContentPane().add((Component)opt, "South");
        this.pack();
        this.setLocationRelativeTo(parent);
    }

    public boolean okPressed() {
        return this.okPressed;
    }

    private boolean allFields() {
        return this.allFi.isSelected();
    }

    public boolean selOnly() {
        return this.selOnly.isSelected();
    }

    public int replace(BibEntry be, NamedCompound ce) {
        int counter = 0;
        if (this.allFields()) {
            for (String s : be.getFieldNames()) {
                if (s.equals("bibtexkey")) continue;
                counter += this.replaceField(be, s, ce);
            }
        } else {
            for (String fld : this.fieldStrings) {
                if (fld.equals("bibtexkey")) continue;
                counter += this.replaceField(be, fld, ce);
            }
        }
        return counter;
    }

    private int replaceField(BibEntry be, String fieldname, NamedCompound ce) {
        int ind;
        if (!be.hasField(fieldname)) {
            return 0;
        }
        String txt = be.getField(fieldname).get();
        StringBuilder sb = new StringBuilder();
        int piv = 0;
        int counter = 0;
        int len1 = this.fromString.length();
        while ((ind = txt.indexOf(this.fromString, piv)) >= 0) {
            ++counter;
            sb.append(txt.substring(piv, ind));
            sb.append(this.toString);
            piv = ind + len1;
        }
        sb.append(txt.substring(piv));
        String newStr = sb.toString();
        be.setField(fieldname, newStr);
        ce.addEdit(new UndoableFieldChange(be, fieldname, txt, newStr));
        return counter;
    }
}

