/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.gui;

import com.google.common.eventbus.Subscribe;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.print.PrinterException;
import java.io.IOException;
import java.io.StringReader;
import java.util.Optional;
import java.util.regex.Pattern;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.standard.JobName;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.event.HyperlinkEvent;
import net.sf.jabref.Globals;
import net.sf.jabref.JabRefExecutorService;
import net.sf.jabref.gui.BasePanel;
import net.sf.jabref.gui.EntryContainer;
import net.sf.jabref.gui.IconTheme;
import net.sf.jabref.gui.JEditorPaneWithHighlighting;
import net.sf.jabref.gui.desktop.JabRefDesktop;
import net.sf.jabref.gui.fieldeditors.PreviewPanelTransferHandler;
import net.sf.jabref.gui.keyboard.KeyBinding;
import net.sf.jabref.gui.worker.CitationStyleWorker;
import net.sf.jabref.logic.citationstyle.CitationStyle;
import net.sf.jabref.logic.exporter.ExportFormats;
import net.sf.jabref.logic.l10n.Localization;
import net.sf.jabref.logic.layout.Layout;
import net.sf.jabref.logic.layout.LayoutHelper;
import net.sf.jabref.logic.search.SearchQueryHighlightListener;
import net.sf.jabref.model.database.BibDatabaseContext;
import net.sf.jabref.model.entry.BibEntry;
import net.sf.jabref.model.entry.event.FieldChangedEvent;
import net.sf.jabref.preferences.PreviewPreferences;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PreviewPanel
extends JPanel
implements SearchQueryHighlightListener,
EntryContainer {
    private static final Log LOGGER = LogFactory.getLog(PreviewPanel.class);
    private Optional<BibEntry> bibEntry = Optional.empty();
    private Optional<BibDatabaseContext> databaseContext = Optional.empty();
    private Optional<BasePanel> basePanel = Optional.empty();
    private boolean fixedLayout;
    private Optional<Layout> layout = Optional.empty();
    private JEditorPaneWithHighlighting previewPane;
    private final JScrollPane scrollPane;
    private final PrintAction printAction = new PrintAction();
    private final CloseAction closeAction = new CloseAction();
    private final CopyPreviewAction copyPreviewAction = new CopyPreviewAction();
    private Optional<Pattern> highlightPattern = Optional.empty();
    private Optional<CitationStyleWorker> citationStyleWorker = Optional.empty();

    public PreviewPanel(BibDatabaseContext databaseContext, BibEntry entry, BasePanel panel) {
        this(panel, databaseContext);
        this.setEntry(entry);
    }

    public PreviewPanel(BasePanel panel, BibDatabaseContext databaseContext) {
        super(new BorderLayout(), true);
        this.databaseContext = Optional.ofNullable(databaseContext);
        this.basePanel = Optional.ofNullable(panel);
        this.createPreviewPane();
        if (this.basePanel.isPresent()) {
            this.previewPane.setTransferHandler(new PreviewPanelTransferHandler(panel.frame(), this, this.previewPane.getTransferHandler()));
        }
        this.scrollPane = new JScrollPane(this.previewPane, 20, 31);
        this.scrollPane.setBorder(null);
        this.add((Component)this.scrollPane, "Center");
        this.createKeyBindings();
        this.updateLayout();
    }

    private void createKeyBindings() {
        ActionMap actionMap = this.getActionMap();
        InputMap inputMap = this.getInputMap(2);
        String close = "close";
        inputMap.put(Globals.getKeyPrefs().getKey(KeyBinding.CLOSE_DIALOG), "close");
        actionMap.put("close", this.closeAction);
        String copy = "copy";
        inputMap.put(Globals.getKeyPrefs().getKey(KeyBinding.COPY_PREVIEW), "copy");
        actionMap.put("copy", this.copyPreviewAction);
    }

    private JPopupMenu createPopupMenu() {
        JPopupMenu menu = new JPopupMenu();
        menu.add(this.printAction);
        menu.add(this.copyPreviewAction);
        this.basePanel.ifPresent(p -> menu.add(p.frame().getNextPreviewStyleAction()));
        this.basePanel.ifPresent(p -> menu.add(p.frame().getPreviousPreviewStyleAction()));
        return menu;
    }

    private void createPreviewPane() {
        this.previewPane = new JEditorPaneWithHighlighting(){

            @Override
            public Dimension getPreferredScrollableViewportSize() {
                return this.getPreferredSize();
            }
        };
        this.previewPane.setMargin(new Insets(3, 3, 3, 3));
        this.previewPane.setComponentPopupMenu(this.createPopupMenu());
        this.previewPane.setEditable(false);
        this.previewPane.setDragEnabled(true);
        this.previewPane.setContentType("text/html");
        this.previewPane.addHyperlinkListener(hyperlinkEvent -> {
            if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.ACTIVATED && this.databaseContext.isPresent()) {
                try {
                    String address = hyperlinkEvent.getURL().toString();
                    JabRefDesktop.openExternalViewer(this.databaseContext.get(), address, "url");
                }
                catch (IOException e) {
                    LOGGER.warn("Could not open external viewer", e);
                }
            }
        });
    }

    public void setDatabaseContext(BibDatabaseContext databaseContext) {
        this.databaseContext = Optional.ofNullable(databaseContext);
    }

    public Optional<BasePanel> getBasePanel() {
        return this.basePanel;
    }

    public void setBasePanel(BasePanel basePanel) {
        this.basePanel = Optional.ofNullable(basePanel);
    }

    public void updateLayout() {
        if (this.fixedLayout) {
            LOGGER.debug("cannot change the layout because the layout is fixed");
            return;
        }
        PreviewPreferences previewPreferences = Globals.prefs.getPreviewPreferences();
        String style = previewPreferences.getPreviewCycle().get(previewPreferences.getPreviewCyclePosition());
        if (CitationStyle.isCitationStyleFile(style)) {
            if (this.basePanel.isPresent()) {
                this.layout = Optional.empty();
                CitationStyle citationStyle = CitationStyle.createCitationStyleFromFile(style);
                if (citationStyle != null) {
                    this.basePanel.get().getCitationStyleCache().setCitationStyle(citationStyle);
                    this.basePanel.get().output(Localization.lang("Preview style changed to: %0", citationStyle.getTitle()));
                }
            }
        } else {
            this.updatePreviewLayout(previewPreferences.getPreviewStyle());
            if (this.basePanel.isPresent()) {
                this.basePanel.get().output(Localization.lang("Preview style changed to: %0", Localization.lang("Preview", new String[0])));
            }
        }
        this.update();
    }

    private void updatePreviewLayout(String layoutFile) {
        StringReader sr = new StringReader(layoutFile.replace("__NEWLINE__", "\n"));
        try {
            this.layout = Optional.of(new LayoutHelper(sr, Globals.prefs.getLayoutFormatterPreferences(Globals.journalAbbreviationLoader)).getLayoutFromText());
        }
        catch (IOException e) {
            this.layout = Optional.empty();
            LOGGER.debug("no layout could be set", e);
        }
    }

    public void setLayout(Layout layout) {
        this.layout = Optional.ofNullable(layout);
    }

    public void setEntry(BibEntry newEntry) {
        this.bibEntry.filter(e -> e != newEntry).ifPresent(e -> e.unregisterListener(this));
        this.bibEntry = Optional.ofNullable(newEntry);
        this.bibEntry.ifPresent(e -> e.registerListener(this));
        this.update();
    }

    @Subscribe
    public void listen(FieldChangedEvent fieldChangedEvent) {
        this.update();
    }

    @Override
    public BibEntry getEntry() {
        return this.bibEntry.orElse(null);
    }

    public void update() {
        ExportFormats.entryNumber = 1;
        if (this.citationStyleWorker.isPresent()) {
            this.citationStyleWorker.get().cancel(true);
            this.citationStyleWorker = Optional.empty();
        }
        if (this.layout.isPresent()) {
            StringBuilder sb = new StringBuilder();
            this.bibEntry.ifPresent(entry -> sb.append(this.layout.get().doLayout((BibEntry)entry, this.databaseContext.map(BibDatabaseContext::getDatabase).orElse(null))));
            this.setPreviewLabel(sb.toString());
            this.markHighlights();
        } else if (this.basePanel.isPresent()) {
            this.citationStyleWorker = Optional.of(new CitationStyleWorker(this, this.previewPane));
            this.citationStyleWorker.get().execute();
        }
    }

    public void markHighlights() {
        this.previewPane.highlightPattern(this.highlightPattern);
    }

    public void setPreviewLabel(String text) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.previewPane.setText(text);
            this.previewPane.revalidate();
        } else {
            SwingUtilities.invokeLater(() -> {
                this.previewPane.setText(text);
                this.previewPane.revalidate();
            });
        }
        this.scrollToTop();
    }

    private void scrollToTop() {
        SwingUtilities.invokeLater(() -> this.scrollPane.getVerticalScrollBar().setValue(0));
    }

    @Override
    public void highlightPattern(Optional<Pattern> newPattern) {
        this.highlightPattern = newPattern;
        this.update();
    }

    public Optional<Pattern> getHighlightPattern() {
        return this.highlightPattern;
    }

    public PreviewPanel setFixedLayout(Object parameter) {
        this.fixedLayout = true;
        if (parameter instanceof String) {
            this.updatePreviewLayout((String)parameter);
        } else if (parameter instanceof CitationStyle) {
            this.layout = Optional.empty();
            if (this.basePanel.isPresent()) {
                this.basePanel.get().getCitationStyleCache().setCitationStyle((CitationStyle)parameter);
            }
        } else {
            LOGGER.error("unknown style type");
        }
        this.update();
        return this;
    }

    public void close() {
        this.basePanel.ifPresent(BasePanel::hideBottomComponent);
    }

    public PrintAction getPrintAction() {
        return this.printAction;
    }

    class CopyPreviewAction
    extends AbstractAction {
        public CopyPreviewAction() {
            super(Localization.lang("Copy preview", new String[0]), IconTheme.JabRefIcon.COPY.getSmallIcon());
            this.putValue("ShortDescription", Localization.lang("Copy preview", new String[0]));
            this.putValue("AcceleratorKey", Globals.getKeyPrefs().getKey(KeyBinding.COPY_PREVIEW));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            PreviewPanel.this.previewPane.selectAll();
            PreviewPanel.this.previewPane.copy();
            PreviewPanel.this.previewPane.select(0, -1);
        }
    }

    class CloseAction
    extends AbstractAction {
        public CloseAction() {
            super(Localization.lang("Close window", new String[0]), IconTheme.JabRefIcon.CLOSE.getSmallIcon());
            this.putValue("ShortDescription", Localization.lang("Close window", new String[0]));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            PreviewPanel.this.close();
        }
    }

    class PrintAction
    extends AbstractAction {
        public PrintAction() {
            super(Localization.lang("Print entry preview", new String[0]), IconTheme.JabRefIcon.PRINTED.getIcon());
            this.putValue("ShortDescription", Localization.lang("Print entry preview", new String[0]));
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            JabRefExecutorService.INSTANCE.execute(() -> {
                try {
                    HashPrintRequestAttributeSet pras = new HashPrintRequestAttributeSet();
                    pras.add(new JobName(PreviewPanel.this.bibEntry.flatMap(BibEntry::getCiteKeyOptional).orElse("NO ENTRY"), null));
                    PreviewPanel.this.previewPane.print(null, null, true, null, pras, false);
                }
                catch (PrinterException e) {
                    JOptionPane.showMessageDialog(PreviewPanel.this, Localization.lang("Could not print preview", new String[0]) + ".\n" + e.getMessage(), Localization.lang("Print entry preview", new String[0]), 0);
                    LOGGER.info("Could not print preview", e);
                }
            });
        }
    }
}

