/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.gui;

import com.google.common.eventbus.Subscribe;
import com.jgoodies.looks.HeaderStyle;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.MouseAdapter;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JProgressBar;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JToggleButton;
import javax.swing.KeyStroke;
import javax.swing.MenuElement;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import net.sf.jabref.Globals;
import net.sf.jabref.JabRefExecutorService;
import net.sf.jabref.gui.BasePanel;
import net.sf.jabref.gui.DragDropPopupPane;
import net.sf.jabref.gui.EntryCustomizationDialog;
import net.sf.jabref.gui.FindUnlinkedFilesDialog;
import net.sf.jabref.gui.GUIGlobals;
import net.sf.jabref.gui.GenFieldsCustomizer;
import net.sf.jabref.gui.IconTheme;
import net.sf.jabref.gui.OSXCompatibleToolbar;
import net.sf.jabref.gui.SidePaneManager;
import net.sf.jabref.gui.WaitForSaveOperation;
import net.sf.jabref.gui.WrapLayout;
import net.sf.jabref.gui.actions.AutoLinkFilesAction;
import net.sf.jabref.gui.actions.ConnectToSharedDatabaseAction;
import net.sf.jabref.gui.actions.ErrorConsoleAction;
import net.sf.jabref.gui.actions.IntegrityCheckAction;
import net.sf.jabref.gui.actions.ManageKeywordsAction;
import net.sf.jabref.gui.actions.MassSetFieldAction;
import net.sf.jabref.gui.actions.MnemonicAwareAction;
import net.sf.jabref.gui.actions.NewDatabaseAction;
import net.sf.jabref.gui.actions.NewEntryAction;
import net.sf.jabref.gui.actions.NewSubDatabaseAction;
import net.sf.jabref.gui.actions.OpenBrowserAction;
import net.sf.jabref.gui.actions.SearchForUpdateAction;
import net.sf.jabref.gui.actions.SortTabsAction;
import net.sf.jabref.gui.autosaveandbackup.AutosaveUIManager;
import net.sf.jabref.gui.bibtexkeypattern.BibtexKeyPatternDialog;
import net.sf.jabref.gui.dbproperties.DatabasePropertiesDialog;
import net.sf.jabref.gui.exporter.ExportAction;
import net.sf.jabref.gui.exporter.ExportCustomizationDialog;
import net.sf.jabref.gui.exporter.SaveAllAction;
import net.sf.jabref.gui.exporter.SaveDatabaseAction;
import net.sf.jabref.gui.externalfiletype.ExternalFileTypeEditor;
import net.sf.jabref.gui.groups.EntryTableTransferHandler;
import net.sf.jabref.gui.groups.GroupSelector;
import net.sf.jabref.gui.help.AboutAction;
import net.sf.jabref.gui.help.HelpAction;
import net.sf.jabref.gui.importer.ImportCustomizationDialog;
import net.sf.jabref.gui.importer.ImportFormats;
import net.sf.jabref.gui.importer.ImportInspectionDialog;
import net.sf.jabref.gui.importer.actions.OpenDatabaseAction;
import net.sf.jabref.gui.importer.fetcher.GeneralFetcher;
import net.sf.jabref.gui.journals.ManageJournalsAction;
import net.sf.jabref.gui.keyboard.KeyBinding;
import net.sf.jabref.gui.keyboard.KeyBindingRepository;
import net.sf.jabref.gui.keyboard.KeyBindingsDialog;
import net.sf.jabref.gui.menus.ChangeEntryTypeMenu;
import net.sf.jabref.gui.menus.FileHistoryMenu;
import net.sf.jabref.gui.menus.RightClickMenu;
import net.sf.jabref.gui.openoffice.OpenOfficePanel;
import net.sf.jabref.gui.openoffice.OpenOfficeSidePanel;
import net.sf.jabref.gui.preftabs.PreferencesDialog;
import net.sf.jabref.gui.protectedterms.ProtectedTermsDialog;
import net.sf.jabref.gui.push.PushToApplicationButton;
import net.sf.jabref.gui.push.PushToApplications;
import net.sf.jabref.gui.search.GlobalSearchBar;
import net.sf.jabref.gui.specialfields.SpecialFieldDropDown;
import net.sf.jabref.gui.specialfields.SpecialFieldValueViewModel;
import net.sf.jabref.gui.util.WindowLocation;
import net.sf.jabref.gui.worker.MarkEntriesAction;
import net.sf.jabref.logic.CustomEntryTypesManager;
import net.sf.jabref.logic.autosaveandbackup.AutosaveManager;
import net.sf.jabref.logic.autosaveandbackup.BackupManager;
import net.sf.jabref.logic.help.HelpFile;
import net.sf.jabref.logic.importer.OutputPrinter;
import net.sf.jabref.logic.importer.ParserResult;
import net.sf.jabref.logic.l10n.Localization;
import net.sf.jabref.logic.logging.GuiAppender;
import net.sf.jabref.logic.search.SearchQuery;
import net.sf.jabref.logic.undo.AddUndoableActionEvent;
import net.sf.jabref.logic.undo.UndoChangeEvent;
import net.sf.jabref.logic.undo.UndoRedoEvent;
import net.sf.jabref.logic.util.OS;
import net.sf.jabref.logic.util.io.FileUtil;
import net.sf.jabref.model.database.BibDatabaseContext;
import net.sf.jabref.model.database.BibDatabaseMode;
import net.sf.jabref.model.database.DatabaseLocation;
import net.sf.jabref.model.entry.BibEntry;
import net.sf.jabref.model.entry.BibtexEntryTypes;
import net.sf.jabref.model.entry.EntryType;
import net.sf.jabref.model.entry.specialfields.SpecialField;
import net.sf.jabref.preferences.HighlightMatchingGroupPreferences;
import net.sf.jabref.preferences.JabRefPreferences;
import net.sf.jabref.preferences.LastFocusedTabPreferences;
import net.sf.jabref.preferences.SearchPreferences;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import osx.macadapter.MacAdapter;

public class JabRefFrame
extends JFrame
implements OutputPrinter {
    private static final Log LOGGER = LogFactory.getLog(JabRefFrame.class);
    private static final String FRAME_TITLE = "JabRef";
    private static final String ELLIPSES = "...";
    private final JSplitPane splitPane = new JSplitPane();
    private final JabRefPreferences prefs = Globals.prefs;
    private PreferencesDialog prefsDialog;
    private int lastTabbedPanelSelectionIndex = -1;
    private SidePaneManager sidePaneManager;
    private JTabbedPane tabbedPane;
    private final Insets marg = new Insets(1, 0, 2, 0);
    private final IntegrityCheckAction checkIntegrity = new IntegrityCheckAction(this);
    private final ToolBar tlb = new ToolBar();
    private final GlobalSearchBar globalSearchBar = new GlobalSearchBar(this);
    private final JMenuBar mb = new JMenuBar();
    private final JLabel statusLine = new JLabel("", 2);
    private final JLabel statusLabel = new JLabel(Localization.lang("Status", new String[0]) + ':', 2);
    private final JProgressBar progressBar = new JProgressBar();
    private final FileHistoryMenu fileHistory = new FileHistoryMenu(this.prefs, this);
    private JToggleButton previewToggle;
    private final OpenDatabaseAction open = new OpenDatabaseAction(this, true);
    private final EditModeAction editModeAction = new EditModeAction();
    private final AbstractAction quit = new CloseAction();
    private final AbstractAction selectKeys = new SelectKeysAction();
    private final AbstractAction newBibtexDatabaseAction = new NewDatabaseAction(this, BibDatabaseMode.BIBTEX);
    private final AbstractAction newBiblatexDatabaseAction = new NewDatabaseAction(this, BibDatabaseMode.BIBLATEX);
    private final AbstractAction connectToSharedDatabaseAction = new ConnectToSharedDatabaseAction(this);
    private final AbstractAction newSubDatabaseAction = new NewSubDatabaseAction(this);
    private final AbstractAction jabrefWebPageAction = new OpenBrowserAction("https://jabref.org", Localization.menuTitle("Website", new String[0]), Localization.lang("Opens JabRef's website", new String[0]), IconTheme.getImage("about"), IconTheme.getImage("about"));
    private final AbstractAction jabrefFacebookAction = new OpenBrowserAction("https://www.facebook.com/JabRef/", "Facebook", Localization.lang("Opens JabRef's Facebook page", new String[0]), IconTheme.JabRefIcon.FACEBOOK.getSmallIcon(), IconTheme.JabRefIcon.FACEBOOK.getIcon());
    private final AbstractAction jabrefBlogAction = new OpenBrowserAction("https://blog.jabref.org/", Localization.menuTitle("Blog", new String[0]), Localization.lang("Opens JabRef's blog", new String[0]), IconTheme.JabRefIcon.BLOG.getSmallIcon(), IconTheme.JabRefIcon.BLOG.getIcon());
    private final AbstractAction developmentVersionAction = new OpenBrowserAction("https://builds.jabref.org/master/", Localization.menuTitle("Development version", new String[0]), Localization.lang("Opens a link where the current development version can be downloaded", new String[0]));
    private final AbstractAction changeLogAction = new OpenBrowserAction("https://github.com/JabRef/jabref/blob/master/CHANGELOG.md", Localization.menuTitle("View change log", new String[0]), Localization.lang("See what has been changed in the JabRef versions", new String[0]));
    private final AbstractAction forkMeOnGitHubAction = new OpenBrowserAction("https://github.com/JabRef/jabref", Localization.menuTitle("Fork me on GitHub", new String[0]), Localization.lang("Opens JabRef's GitHub page", new String[0]), IconTheme.JabRefIcon.GITHUB.getSmallIcon(), IconTheme.JabRefIcon.GITHUB.getIcon());
    private final AbstractAction donationAction = new OpenBrowserAction("https://github.com/JabRef/jabref/wiki/Donations", Localization.menuTitle("Donate to JabRef", new String[0]), Localization.lang("Donate to JabRef", new String[0]), IconTheme.JabRefIcon.DONATE.getSmallIcon(), IconTheme.JabRefIcon.DONATE.getIcon());
    private final AbstractAction openForumAction = new OpenBrowserAction("http://discourse.jabref.org/", Localization.menuTitle("Online help forum", new String[0]), Localization.lang("Online help forum", new String[0]), IconTheme.JabRefIcon.FORUM.getSmallIcon(), IconTheme.JabRefIcon.FORUM.getIcon());
    private final AbstractAction help = new HelpAction(Localization.menuTitle("Online help", new String[0]), Localization.lang("Online help", new String[0]), HelpFile.CONTENTS, Globals.getKeyPrefs().getKey(KeyBinding.HELP));
    private final AbstractAction about = new AboutAction(Localization.menuTitle("About JabRef", new String[0]), this, Localization.lang("About JabRef", new String[0]), IconTheme.getImage("about"));
    private final AbstractAction editEntry = new GeneralAction("edit", Localization.menuTitle("Edit entry", new String[0]), Localization.lang("Edit entry", new String[0]), Globals.getKeyPrefs().getKey(KeyBinding.EDIT_ENTRY), IconTheme.JabRefIcon.EDIT_ENTRY.getIcon());
    private final AbstractAction focusTable = new GeneralAction("focusTable", Localization.menuTitle("Focus entry table", new String[0]), Localization.lang("Move the keyboard focus to the entry table", new String[0]), Globals.getKeyPrefs().getKey(KeyBinding.FOCUS_ENTRY_TABLE));
    private final AbstractAction save = new GeneralAction("save", Localization.menuTitle("Save database", new String[0]), Localization.lang("Save database", new String[0]), Globals.getKeyPrefs().getKey(KeyBinding.SAVE_DATABASE), IconTheme.JabRefIcon.SAVE.getIcon());
    private final AbstractAction saveAs = new GeneralAction("saveAs", Localization.menuTitle("Save database as...", new String[0]), Localization.lang("Save database as...", new String[0]), Globals.getKeyPrefs().getKey(KeyBinding.SAVE_DATABASE_AS));
    private final AbstractAction saveAll = new SaveAllAction(this);
    private final AbstractAction saveSelectedAs = new GeneralAction("saveSelectedAs", Localization.menuTitle("Save selected as...", new String[0]), Localization.lang("Save selected as...", new String[0]));
    private final AbstractAction saveSelectedAsPlain = new GeneralAction("saveSelectedAsPlain", Localization.menuTitle("Save selected as plain BibTeX...", new String[0]), Localization.lang("Save selected as plain BibTeX...", new String[0]));
    private final AbstractAction exportAll = ExportAction.getExportAction(this, false);
    private final AbstractAction exportSelected = ExportAction.getExportAction(this, true);
    private final AbstractAction importCurrent = ImportFormats.getImportAction(this, false);
    private final AbstractAction importNew = ImportFormats.getImportAction(this, true);
    public final AbstractAction nextTab = new ChangeTabAction(true);
    public final AbstractAction prevTab = new ChangeTabAction(false);
    private final AbstractAction sortTabs = new SortTabsAction(this);
    private final AbstractAction undo = new GeneralAction("undo", Localization.menuTitle("Undo", new String[0]), Localization.lang("Undo", new String[0]), Globals.getKeyPrefs().getKey(KeyBinding.UNDO), IconTheme.JabRefIcon.UNDO.getIcon());
    private final AbstractAction redo = new GeneralAction("redo", Localization.menuTitle("Redo", new String[0]), Localization.lang("Redo", new String[0]), Globals.getKeyPrefs().getKey(KeyBinding.REDO), IconTheme.JabRefIcon.REDO.getIcon());
    private final AbstractAction forward = new GeneralAction("forward", Localization.menuTitle("Forward", new String[0]), Localization.lang("Forward", new String[0]), Globals.getKeyPrefs().getKey(KeyBinding.FORWARD), IconTheme.JabRefIcon.RIGHT.getIcon());
    private final AbstractAction back = new GeneralAction("back", Localization.menuTitle("Back", new String[0]), Localization.lang("Back", new String[0]), Globals.getKeyPrefs().getKey(KeyBinding.BACK), IconTheme.JabRefIcon.LEFT.getIcon());
    private final AbstractAction deleteEntry = new GeneralAction("delete", Localization.menuTitle("Delete entry", new String[0]), Localization.lang("Delete entry", new String[0]), Globals.getKeyPrefs().getKey(KeyBinding.DELETE_ENTRY), IconTheme.JabRefIcon.DELETE_ENTRY.getIcon());
    private final AbstractAction copy = new EditAction("copy", Localization.menuTitle("Copy", new String[0]), Localization.lang("Copy", new String[0]), Globals.getKeyPrefs().getKey(KeyBinding.COPY), IconTheme.JabRefIcon.COPY.getIcon());
    private final AbstractAction paste = new EditAction("paste", Localization.menuTitle("Paste", new String[0]), Localization.lang("Paste", new String[0]), Globals.getKeyPrefs().getKey(KeyBinding.PASTE), IconTheme.JabRefIcon.PASTE.getIcon());
    private final AbstractAction cut = new EditAction("cut", Localization.menuTitle("Cut", new String[0]), Localization.lang("Cut", new String[0]), Globals.getKeyPrefs().getKey(KeyBinding.CUT), IconTheme.JabRefIcon.CUT.getIcon());
    private final AbstractAction openConsole = new GeneralAction("openConsole", Localization.menuTitle("Open terminal here", new String[0]), Localization.lang("Open terminal here", new String[0]), Globals.getKeyPrefs().getKey(KeyBinding.OPEN_CONSOLE), IconTheme.JabRefIcon.CONSOLE.getIcon());
    private final AbstractAction pullChangesFromSharedDatabase = new GeneralAction("pullChangesFromSharedDatabase", Localization.menuTitle("Pull_changes_from_shared_database", new String[0]), Localization.lang("Pull_changes_from_shared_database", new String[0]), Globals.getKeyPrefs().getKey(KeyBinding.PULL_CHANGES_FROM_SHARED_DATABASE), IconTheme.JabRefIcon.PULL.getIcon());
    private final AbstractAction mark = new GeneralAction("markEntries", Localization.menuTitle("Mark entries", new String[0]), Localization.lang("Mark entries", new String[0]), Globals.getKeyPrefs().getKey(KeyBinding.MARK_ENTRIES), IconTheme.JabRefIcon.MARK_ENTRIES.getIcon());
    private final JMenu markSpecific = JabRefFrame.subMenu(Localization.menuTitle("Mark specific color", new String[0]));
    private final AbstractAction unmark = new GeneralAction("unmarkEntries", Localization.menuTitle("Unmark entries", new String[0]), Localization.lang("Unmark entries", new String[0]), Globals.getKeyPrefs().getKey(KeyBinding.UNMARK_ENTRIES), IconTheme.JabRefIcon.UNMARK_ENTRIES.getIcon());
    private final AbstractAction unmarkAll = new GeneralAction("unmarkAll", Localization.menuTitle("Unmark all", new String[0]));
    private JMenu rankSubMenu;
    private final AbstractAction toggleRelevance = new GeneralAction(new SpecialFieldValueViewModel(SpecialField.RELEVANCE.getValues().get(0)).getActionName(), new SpecialFieldValueViewModel(SpecialField.RELEVANCE.getValues().get(0)).getMenuString(), new SpecialFieldValueViewModel(SpecialField.RELEVANCE.getValues().get(0)).getToolTipText(), IconTheme.JabRefIcon.RELEVANCE.getIcon());
    private final AbstractAction toggleQualityAssured = new GeneralAction(new SpecialFieldValueViewModel(SpecialField.QUALITY.getValues().get(0)).getActionName(), new SpecialFieldValueViewModel(SpecialField.QUALITY.getValues().get(0)).getMenuString(), new SpecialFieldValueViewModel(SpecialField.QUALITY.getValues().get(0)).getToolTipText(), IconTheme.JabRefIcon.QUALITY_ASSURED.getIcon());
    private final AbstractAction togglePrinted = new GeneralAction(new SpecialFieldValueViewModel(SpecialField.PRINTED.getValues().get(0)).getActionName(), new SpecialFieldValueViewModel(SpecialField.PRINTED.getValues().get(0)).getMenuString(), new SpecialFieldValueViewModel(SpecialField.PRINTED.getValues().get(0)).getToolTipText(), IconTheme.JabRefIcon.PRINTED.getIcon());
    private final AbstractAction normalSearch = new GeneralAction("search", Localization.menuTitle("Search", new String[0]), Localization.lang("Search", new String[0]), Globals.getKeyPrefs().getKey(KeyBinding.SEARCH), IconTheme.JabRefIcon.SEARCH.getIcon());
    private final AbstractAction copyKey = new GeneralAction("copyKey", Localization.menuTitle("Copy BibTeX key", new String[0]), Globals.getKeyPrefs().getKey(KeyBinding.COPY_BIBTEX_KEY));
    private final AbstractAction copyCiteKey = new GeneralAction("copyCiteKey", Localization.menuTitle("Copy \\cite{BibTeX key}", new String[0]), Globals.getKeyPrefs().getKey(KeyBinding.COPY_CITE_BIBTEX_KEY));
    private final AbstractAction copyKeyAndTitle = new GeneralAction("copyKeyAndTitle", Localization.menuTitle("Copy BibTeX key and title", new String[0]), Globals.getKeyPrefs().getKey(KeyBinding.COPY_BIBTEX_KEY_AND_TITLE));
    private final AbstractAction copyKeyAndLink = new GeneralAction("copyKeyAndLink", Localization.menuTitle("Copy BibTeX key and link", new String[0]), Globals.getKeyPrefs().getKey(KeyBinding.COPY_BIBTEX_KEY_AND_LINK));
    private final AbstractAction mergeDatabaseAction = new GeneralAction("mergeDatabase", Localization.menuTitle("Append database", new String[0]), Localization.lang("Append contents from a BibTeX database into the currently viewed database", new String[0]));
    private final AbstractAction selectAll = new GeneralAction("selectAll", Localization.menuTitle("Select all", new String[0]), Globals.getKeyPrefs().getKey(KeyBinding.SELECT_ALL));
    private final AbstractAction replaceAll = new GeneralAction("replaceAll", Localization.menuTitle("Replace string", new String[0]) + "...", Globals.getKeyPrefs().getKey(KeyBinding.REPLACE_STRING));
    private final AbstractAction editPreamble = new GeneralAction("editPreamble", Localization.menuTitle("Edit preamble", new String[0]), Localization.lang("Edit preamble", new String[0]));
    private final AbstractAction editStrings = new GeneralAction("editStrings", Localization.menuTitle("Edit strings", new String[0]), Localization.lang("Edit strings", new String[0]), Globals.getKeyPrefs().getKey(KeyBinding.EDIT_STRINGS), IconTheme.JabRefIcon.EDIT_STRINGS.getIcon());
    private final AbstractAction customizeAction = new CustomizeEntryTypeAction();
    private final Action toggleToolbar = JabRefFrame.enableToggle(new AbstractAction(Localization.menuTitle("Hide/show toolbar", new String[0])){
        {
            this.putValue("ShortDescription", Localization.lang("Hide/show toolbar", new String[0]));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JabRefFrame.this.tlb.setVisible(!JabRefFrame.this.tlb.isVisible());
        }
    });
    private final AbstractAction addToGroup = new GeneralAction("addToGroup", Localization.lang("Add to group", new String[0]) + "...");
    private final AbstractAction removeFromGroup = new GeneralAction("removeFromGroup", Localization.lang("Remove from group", new String[0]) + "...");
    private final AbstractAction moveToGroup = new GeneralAction("moveToGroup", Localization.lang("Move to group", new String[0]) + "...");
    private final Action togglePreview = JabRefFrame.enableToggle(new GeneralAction("togglePreview", Localization.menuTitle("Toggle entry preview", new String[0]), Localization.lang("Toggle entry preview", new String[0]), Globals.getKeyPrefs().getKey(KeyBinding.TOGGLE_ENTRY_PREVIEW), IconTheme.JabRefIcon.TOGGLE_ENTRY_PREVIEW.getIcon()));
    private final Action toggleHighlightAny = JabRefFrame.enableToggle(new GeneralAction("toggleHighlightGroupsMatchingAny", Localization.menuTitle("Highlight groups matching any selected entry", new String[0]), Localization.lang("Highlight groups matching any selected entry", new String[0])));
    private final Action toggleHighlightAll = JabRefFrame.enableToggle(new GeneralAction("toggleHighlightGroupsMatchingAll", Localization.menuTitle("Highlight groups matching all selected entries", new String[0]), Localization.lang("Highlight groups matching all selected entries", new String[0])));
    private final Action toggleHighlightDisable = JabRefFrame.enableToggle(new GeneralAction("toggleHighlightGroupsMatchingDisable", Localization.menuTitle("Disable highlight groups matching entries", new String[0]), Localization.lang("Disable highlight groups matching entries", new String[0])));
    private final AbstractAction nextPreviewStyle = new GeneralAction("nextPreviewStyle", Localization.menuTitle("Next preview layout", new String[0]), Globals.getKeyPrefs().getKey(KeyBinding.NEXT_PREVIEW_LAYOUT));
    private final AbstractAction previousPreviewStyle = new GeneralAction("previousPreviewStyle", Localization.menuTitle("Previous preview layout", new String[0]), Globals.getKeyPrefs().getKey(KeyBinding.PREVIOUS_PREVIEW_LAYOUT));
    private final AbstractAction makeKeyAction = new GeneralAction("makeKey", Localization.menuTitle("Autogenerate BibTeX keys", new String[0]), Localization.lang("Autogenerate BibTeX keys", new String[0]), Globals.getKeyPrefs().getKey(KeyBinding.AUTOGENERATE_BIBTEX_KEYS), IconTheme.JabRefIcon.MAKE_KEY.getIcon());
    private final AbstractAction writeXmpAction = new GeneralAction("writeXMP", Localization.menuTitle("Write XMP-metadata to PDFs", new String[0]), Localization.lang("Will write XMP-metadata to the PDFs linked from selected entries.", new String[0]), Globals.getKeyPrefs().getKey(KeyBinding.WRITE_XMP));
    private final AbstractAction openFolder = new GeneralAction("openFolder", Localization.menuTitle("Open folder", new String[0]), Localization.lang("Open folder", new String[0]), Globals.getKeyPrefs().getKey(KeyBinding.OPEN_FOLDER));
    private final AbstractAction openFile = new GeneralAction("openExternalFile", Localization.menuTitle("Open file", new String[0]), Localization.lang("Open file", new String[0]), Globals.getKeyPrefs().getKey(KeyBinding.OPEN_FILE), IconTheme.JabRefIcon.FILE.getIcon());
    private final AbstractAction openUrl = new GeneralAction("openUrl", Localization.menuTitle("Open URL or DOI", new String[0]), Localization.lang("Open URL or DOI", new String[0]), Globals.getKeyPrefs().getKey(KeyBinding.OPEN_URL_OR_DOI), IconTheme.JabRefIcon.WWW.getIcon());
    private final AbstractAction dupliCheck = new GeneralAction("dupliCheck", Localization.menuTitle("Find duplicates", new String[0]), IconTheme.JabRefIcon.FIND_DUPLICATES.getIcon());
    private final AbstractAction plainTextImport = new GeneralAction("plainTextImport", Localization.menuTitle("New entry from plain text", new String[0]) + "...", Globals.getKeyPrefs().getKey(KeyBinding.NEW_FROM_PLAIN_TEXT));
    private final AbstractAction customExpAction = new CustomizeExportsAction();
    private final AbstractAction customImpAction = new CustomizeImportsAction();
    private final AbstractAction customFileTypesAction = ExternalFileTypeEditor.getAction(this);
    private final AbstractAction exportToClipboard = new GeneralAction("exportToClipboard", Localization.menuTitle("Export selected entries to clipboard", new String[0]), IconTheme.JabRefIcon.EXPORT_TO_CLIPBOARD.getIcon());
    private final AbstractAction autoSetFile = new GeneralAction("autoSetFile", Localization.lang("Synchronize file links", new String[0]) + "...", Globals.getKeyPrefs().getKey(KeyBinding.SYNCHRONIZE_FILES));
    private final AbstractAction abbreviateMedline = new GeneralAction("abbreviateMedline", Localization.menuTitle("Abbreviate journal names (MEDLINE)", new String[0]), Localization.lang("Abbreviate journal names of the selected entries (MEDLINE abbreviation)", new String[0]));
    private final AbstractAction abbreviateIso = new GeneralAction("abbreviateIso", Localization.menuTitle("Abbreviate journal names (ISO)", new String[0]), Localization.lang("Abbreviate journal names of the selected entries (ISO abbreviation)", new String[0]), Globals.getKeyPrefs().getKey(KeyBinding.ABBREVIATE));
    private final AbstractAction unabbreviate = new GeneralAction("unabbreviate", Localization.menuTitle("Unabbreviate journal names", new String[0]), Localization.lang("Unabbreviate journal names of the selected entries", new String[0]), Globals.getKeyPrefs().getKey(KeyBinding.UNABBREVIATE));
    private final AbstractAction manageJournals = new ManageJournalsAction(this);
    private final AbstractAction databaseProperties = new DatabasePropertiesAction();
    private final AbstractAction bibtexKeyPattern = new BibtexKeyPatternAction();
    private final AbstractAction errorConsole = new ErrorConsoleAction(this, Globals.getStreamEavesdropper(), GuiAppender.CACHE);
    private final AbstractAction cleanupEntries = new GeneralAction("Cleanup", Localization.menuTitle("Cleanup entries", new String[0]) + "...", Localization.lang("Cleanup entries", new String[0]), Globals.getKeyPrefs().getKey(KeyBinding.CLEANUP), IconTheme.JabRefIcon.CLEANUP_ENTRIES.getIcon());
    private final AbstractAction mergeEntries = new GeneralAction("mergeEntries", Localization.menuTitle("Merge entries", new String[0]) + "...", Localization.lang("Merge entries", new String[0]), IconTheme.JabRefIcon.MERGE_ENTRIES.getIcon());
    private final AbstractAction downloadFullText = new GeneralAction("downloadFullText", Localization.menuTitle("Look up full text document", new String[0]), Localization.lang("Follow DOI or URL link and try to locate PDF full text document", new String[0]));
    private final AbstractAction increaseFontSize = new IncreaseTableFontSizeAction();
    private final AbstractAction decreseFontSize = new DecreaseTableFontSizeAction();
    private final AbstractAction resolveDuplicateKeys = new GeneralAction("resolveDuplicateKeys", Localization.menuTitle("Resolve duplicate BibTeX keys", new String[0]), Localization.lang("Find and remove duplicate BibTeX keys", new String[0]), Globals.getKeyPrefs().getKey(KeyBinding.RESOLVE_DUPLICATE_BIBTEX_KEYS));
    private final AbstractAction sendAsEmail = new GeneralAction("sendAsEmail", Localization.lang("Send as email", new String[0]), IconTheme.JabRefIcon.EMAIL.getIcon());
    private final MassSetFieldAction massSetField = new MassSetFieldAction(this);
    private final ManageKeywordsAction manageKeywords = new ManageKeywordsAction(this);
    private final GeneralAction findUnlinkedFiles = new GeneralAction("findUnlinkedFiles", FindUnlinkedFilesDialog.ACTION_MENU_TITLE, FindUnlinkedFilesDialog.ACTION_SHORT_DESCRIPTION, Globals.getKeyPrefs().getKey(KeyBinding.FIND_UNLINKED_FILES));
    private final AutoLinkFilesAction autoLinkFile = new AutoLinkFilesAction();
    private PushToApplicationButton pushExternalButton;
    private PushToApplications pushApplications;
    private GeneralFetcher generalFetcher;
    private OpenOfficePanel openOfficePanel;
    private GroupSelector groupSelector;
    private int previousTabCount = -1;
    private final NewEntryAction newEntryAction = new NewEntryAction(this, Globals.getKeyPrefs().getKey(KeyBinding.NEW_ENTRY));
    private JMenu newSpec;
    private final List<NewEntryAction> newSpecificEntryAction = this.getNewEntryActions();
    private final CloseDatabaseAction closeDatabaseAction = new CloseDatabaseAction();
    private final CloseAllDatabasesAction closeAllDatabasesAction = new CloseAllDatabasesAction();
    private final CloseOtherDatabasesAction closeOtherDatabasesAction = new CloseOtherDatabasesAction();
    private final AbstractAction showPrefs = new ShowPrefsAction();
    private final List<Object> specialFieldButtons = new LinkedList<Object>();
    private final List<Object> openDatabaseOnlyActions = new LinkedList<Object>();
    private final List<Object> severalDatabasesOnlyActions = new LinkedList<Object>();
    private final List<Object> openAndSavedDatabasesOnlyActions = new LinkedList<Object>();
    private final List<Object> sharedDatabaseOnlyActions = new LinkedList<Object>();
    private final List<Object> noSharedDatabaseActions = new LinkedList<Object>();
    private final List<Object> oneEntryOnlyActions = new LinkedList<Object>();
    private final List<Object> oneEntryWithFileOnlyActions = new LinkedList<Object>();
    private final List<Object> oneEntryWithURLorDOIOnlyActions = new LinkedList<Object>();
    private final List<Object> twoEntriesOnlyActions = new LinkedList<Object>();

    public JabRefFrame() {
        this.init();
        this.updateEnabledState();
    }

    private List<NewEntryAction> getNewEntryActions() {
        ArrayList<NewEntryAction> actions = new ArrayList<NewEntryAction>();
        for (EntryType type : BibtexEntryTypes.ALL) {
            KeyStroke keyStroke = new ChangeEntryTypeMenu().entryShortCuts.get(type.getName());
            if (keyStroke == null) {
                actions.add(new NewEntryAction(this, type.getName()));
                continue;
            }
            actions.add(new NewEntryAction(this, type.getName(), keyStroke));
        }
        return actions;
    }

    private JPopupMenu tabPopupMenu() {
        JPopupMenu popupMenu = new JPopupMenu();
        JMenuItem close = new JMenuItem(Localization.lang("Close", new String[0]));
        JMenuItem closeOthers = new JMenuItem(Localization.lang("Close others", new String[0]));
        JMenuItem closeAll = new JMenuItem(Localization.lang("Close all", new String[0]));
        close.addActionListener(this.closeDatabaseAction);
        closeOthers.addActionListener(this.closeOtherDatabasesAction);
        closeAll.addActionListener(this.closeAllDatabasesAction);
        popupMenu.add(close);
        popupMenu.add(closeOthers);
        popupMenu.add(closeAll);
        popupMenu.addSeparator();
        JMenuItem databasePropertiesMenu = new JMenuItem(Localization.lang("Database properties", new String[0]));
        databasePropertiesMenu.addActionListener(this.databaseProperties);
        popupMenu.add(databasePropertiesMenu);
        JMenuItem bibtexKeyPatternBtn = new JMenuItem(Localization.lang("BibTeX key patterns", new String[0]));
        bibtexKeyPatternBtn.addActionListener(this.bibtexKeyPattern);
        popupMenu.add(bibtexKeyPatternBtn);
        return popupMenu;
    }

    private void init() {
        this.tabbedPane = new DragDropPopupPane(this.tabPopupMenu());
        MyGlassPane glassPane = new MyGlassPane();
        this.setGlassPane(glassPane);
        this.setTitle(FRAME_TITLE);
        this.setIconImage(new ImageIcon(IconTheme.getIconUrl("jabrefIcon48")).getImage());
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                if (OS.OS_X) {
                    JabRefFrame.this.setVisible(false);
                } else {
                    new CloseAction().actionPerformed(null);
                }
            }
        });
        this.initSidePane();
        this.initLayout();
        this.initActions();
        this.tlb.setVisible(Globals.prefs.getBoolean("toolbarVisible"));
        this.setBounds(GraphicsEnvironment.getLocalGraphicsEnvironment().getMaximumWindowBounds());
        WindowLocation pw = new WindowLocation(this, "mainWindowPosX", "mainWindowPosY", "mainWindowSizeX", "mainWindowSizeY");
        pw.displayWindowAtStoredLocation();
        this.tabbedPane.setBorder(null);
        this.tabbedPane.setForeground(GUIGlobals.INACTIVE_TABBED_COLOR);
        this.tabbedPane.addChangeListener(e -> {
            this.markActiveBasePanel();
            BasePanel currentBasePanel = this.getCurrentBasePanel();
            if (currentBasePanel == null) {
                return;
            }
            if (new SearchPreferences(Globals.prefs).isGlobalSearch()) {
                this.globalSearchBar.performSearch();
            } else {
                String content = "";
                SearchQuery currentSearchQuery = currentBasePanel.getCurrentSearchQuery();
                if (currentSearchQuery != null && !currentSearchQuery.getQuery().trim().isEmpty()) {
                    content = currentSearchQuery.getQuery();
                }
                this.globalSearchBar.setSearchTerm(content, true);
            }
            currentBasePanel.getPreviewPanel().updateLayout();
            this.groupSelector.getToggleAction().setSelected(this.sidePaneManager.isComponentVisible(GroupSelector.class));
            this.previewToggle.setSelected(Globals.prefs.getPreviewPreferences().isPreviewPanelEnabled());
            this.generalFetcher.getToggleAction().setSelected(this.sidePaneManager.isComponentVisible(GeneralFetcher.class));
            this.openOfficePanel.getToggleAction().setSelected(this.sidePaneManager.isComponentVisible(OpenOfficeSidePanel.class));
            Globals.getFocusListener().setFocused(currentBasePanel.getMainTable());
            this.setWindowTitle();
            this.editModeAction.initName();
            currentBasePanel.updateSearchManager();
            currentBasePanel.setBackAndForwardEnabledState();
            currentBasePanel.getUndoManager().postUndoRedoEvent();
            currentBasePanel.getMainTable().requestFocus();
        });
        if (OS.OS_X) {
            try {
                new MacAdapter().registerMacEvents(this);
            }
            catch (Exception e2) {
                LOGGER.fatal("Could not interface with Mac OS X methods.", e2);
            }
        }
    }

    public void refreshTitleAndTabs() {
        this.setWindowTitle();
        this.updateAllTabTitles();
    }

    public void setWindowTitle() {
        BasePanel panel = this.getCurrentBasePanel();
        if (panel == null) {
            this.setTitle(FRAME_TITLE);
            return;
        }
        String mode = panel.getBibDatabaseContext().getMode().getFormattedName();
        String modeInfo = String.format(" (%s)", Localization.lang("%0 mode", mode));
        boolean isAutosaveEnabled = Globals.prefs.getBoolean("localAutoSave");
        if (panel.getBibDatabaseContext().getLocation() == DatabaseLocation.LOCAL) {
            String changeFlag = panel.isModified() && !isAutosaveEnabled ? "*" : "";
            String databaseFile = panel.getBibDatabaseContext().getDatabaseFile().map(File::getPath).orElse(GUIGlobals.UNTITLED_TITLE);
            this.setTitle("JabRef - " + databaseFile + changeFlag + modeInfo);
        } else if (panel.getBibDatabaseContext().getLocation() == DatabaseLocation.SHARED) {
            this.setTitle("JabRef - " + panel.getBibDatabaseContext().getDBMSSynchronizer().getDBName() + " [" + Localization.lang("shared", new String[0]) + "]" + modeInfo);
        }
    }

    private void initSidePane() {
        this.sidePaneManager = new SidePaneManager(this);
        this.groupSelector = new GroupSelector(this, this.sidePaneManager);
        this.openOfficePanel = new OpenOfficePanel(this, this.sidePaneManager);
        this.generalFetcher = new GeneralFetcher(this, this.sidePaneManager);
        this.sidePaneManager.register(this.groupSelector);
    }

    public void openAction(String filePath) {
        File file = new File(filePath);
        this.getOpenDatabaseAction().openFile(file, true);
    }

    public void about() {
        this.about.actionPerformed(null);
    }

    public void showPreferencesDialog() {
        this.output(Localization.lang("Opening preferences...", new String[0]));
        if (this.prefsDialog == null) {
            this.prefsDialog = new PreferencesDialog(this);
            this.prefsDialog.setLocationRelativeTo(this);
        } else {
            this.prefsDialog.setValues();
        }
        this.prefsDialog.setVisible(true);
        this.output("");
    }

    public JabRefPreferences prefs() {
        return this.prefs;
    }

    private void tearDownJabRef(List<String> filenames) {
        JabRefExecutorService.INSTANCE.shutdownEverything();
        this.dispose();
        this.prefs.putBoolean("windowMaximised", this.getExtendedState() == 6);
        this.prefs.putBoolean("toolbarVisible", this.tlb.isVisible());
        int width = this.splitPane.getDividerLocation();
        if (width > 0) {
            this.prefs.putInt("sidePaneWidth", width);
        }
        if (this.prefs.getBoolean("openLastEdited")) {
            if (filenames.isEmpty()) {
                this.prefs.remove("lastEdited");
            } else {
                this.prefs.putStringList("lastEdited", filenames);
                File focusedDatabase = this.getCurrentBasePanel().getBibDatabaseContext().getDatabaseFile().orElse(null);
                new LastFocusedTabPreferences(this.prefs).setLastFocusedTab(focusedDatabase);
            }
        }
        this.fileHistory.storeHistory();
        this.prefs.customExports.store(Globals.prefs);
        this.prefs.customImports.store();
        CustomEntryTypesManager.saveCustomEntryTypes(this.prefs);
        this.prefs.flush();
        for (Window window : Window.getWindows()) {
            window.dispose();
        }
    }

    public boolean quit() {
        int i;
        boolean close = true;
        ArrayList<String> filenames = new ArrayList<String>();
        if (this.tabbedPane.getTabCount() > 0) {
            for (i = 0; i < this.tabbedPane.getTabCount(); ++i) {
                BibDatabaseContext context = this.getBasePanelAt(i).getBibDatabaseContext();
                if (this.getBasePanelAt(i).isModified() && context.getLocation() == DatabaseLocation.LOCAL) {
                    this.tabbedPane.setSelectedIndex(i);
                    String filename = context.getDatabaseFile().map(File::getAbsolutePath).orElse(GUIGlobals.UNTITLED_TITLE);
                    int answer = this.showSaveDialog(filename);
                    if (answer == 2 || answer == -1) {
                        return false;
                    }
                    if (answer == 0) {
                        try {
                            SaveDatabaseAction saveAction = new SaveDatabaseAction(this.getCurrentBasePanel());
                            saveAction.runCommand();
                            if (saveAction.isCanceled() || !saveAction.isSuccess()) {
                                this.output(Localization.lang("Unable to save database", new String[0]));
                                close = false;
                            }
                        }
                        catch (Throwable ex) {
                            close = false;
                            break;
                        }
                    }
                } else if (context.getLocation() == DatabaseLocation.SHARED) {
                    context.convertToLocalDatabase();
                    context.getDBMSSynchronizer().closeSharedDatabase();
                    context.clearDBMSSynchronizer();
                }
                AutosaveManager.shutdown(context);
                BackupManager.shutdown(context);
                context.getDatabaseFile().map(File::getAbsolutePath).ifPresent(filenames::add);
            }
        }
        if (close) {
            for (i = 0; i < this.tabbedPane.getTabCount(); ++i) {
                if (!this.getBasePanelAt(i).isSaving()) continue;
                WaitForSaveOperation w = new WaitForSaveOperation(this);
                w.show();
                if (!w.canceled()) continue;
                return false;
            }
            this.tearDownJabRef(filenames);
            return true;
        }
        return false;
    }

    private void initLayout() {
        this.tabbedPane.putClientProperty("jgoodies.noContentBorder", Boolean.TRUE);
        this.setProgressBarVisible(false);
        this.pushApplications = new PushToApplications();
        this.pushExternalButton = new PushToApplicationButton(this, this.pushApplications.getApplications());
        this.fillMenu();
        this.createToolBar();
        this.setJMenuBar(this.mb);
        this.getContentPane().setLayout(new BorderLayout());
        JPanel toolbarPanel = new JPanel(new WrapLayout(0));
        toolbarPanel.add(this.tlb);
        toolbarPanel.add(this.globalSearchBar);
        this.getContentPane().add((Component)toolbarPanel, "First");
        this.splitPane.setDividerSize(2);
        this.splitPane.setBorder(null);
        this.splitPane.setRightComponent(this.tabbedPane);
        this.splitPane.setLeftComponent(this.sidePaneManager.getPanel());
        this.getContentPane().add((Component)this.splitPane, "Center");
        UIManager.put("TabbedPane.contentBorderInsets", new Insets(0, 0, 0, 0));
        this.sidePaneManager.updateView();
        GridBagLayout gbl = new GridBagLayout();
        GridBagConstraints con = new GridBagConstraints();
        con.fill = 1;
        con.anchor = 17;
        JPanel status = new JPanel();
        status.setLayout(gbl);
        con.weighty = 0.0;
        con.weightx = 0.0;
        con.gridwidth = 1;
        con.insets = new Insets(0, 2, 0, 0);
        gbl.setConstraints(this.statusLabel, con);
        status.add(this.statusLabel);
        con.weightx = 1.0;
        con.insets = new Insets(0, 4, 0, 0);
        con.gridwidth = 1;
        gbl.setConstraints(this.statusLine, con);
        status.add(this.statusLine);
        con.weightx = 0.0;
        con.gridwidth = 0;
        con.insets = new Insets(2, 4, 2, 2);
        gbl.setConstraints(this.progressBar, con);
        status.add(this.progressBar);
        this.statusLabel.setForeground(GUIGlobals.ENTRY_EDITOR_LABEL_COLOR.darker());
        this.getContentPane().add((Component)status, "Last");
        EntryTableTransferHandler xfer = new EntryTableTransferHandler(null, this, null);
        this.tabbedPane.setTransferHandler(xfer);
        this.tlb.setTransferHandler(xfer);
        this.mb.setTransferHandler(xfer);
        this.sidePaneManager.getPanel().setTransferHandler(xfer);
    }

    public BasePanel getBasePanelAt(int i) {
        return (BasePanel)this.tabbedPane.getComponentAt(i);
    }

    public List<BasePanel> getBasePanelList() {
        ArrayList<BasePanel> returnList = new ArrayList<BasePanel>();
        for (int i = 0; i < this.getBasePanelCount(); ++i) {
            returnList.add((BasePanel)this.tabbedPane.getComponentAt(i));
        }
        return returnList;
    }

    public void showBasePanelAt(int i) {
        this.tabbedPane.setSelectedIndex(i);
    }

    public void showBasePanel(BasePanel bp) {
        this.tabbedPane.setSelectedComponent(bp);
    }

    public BasePanel getCurrentBasePanel() {
        if (this.tabbedPane == null) {
            return null;
        }
        return (BasePanel)this.tabbedPane.getSelectedComponent();
    }

    public int getBasePanelCount() {
        return this.tabbedPane.getComponentCount();
    }

    private void markActiveBasePanel() {
        int now = this.tabbedPane.getSelectedIndex();
        int len = this.tabbedPane.getTabCount();
        if (this.lastTabbedPanelSelectionIndex > -1 && this.lastTabbedPanelSelectionIndex < len) {
            this.tabbedPane.setForegroundAt(this.lastTabbedPanelSelectionIndex, GUIGlobals.INACTIVE_TABBED_COLOR);
        }
        if (now > -1 && now < len) {
            this.tabbedPane.setForegroundAt(now, GUIGlobals.ACTIVE_TABBED_COLOR);
        }
        this.lastTabbedPanelSelectionIndex = now;
    }

    private int getTabIndex(JComponent comp) {
        for (int i = 0; i < this.tabbedPane.getTabCount(); ++i) {
            if (this.tabbedPane.getComponentAt(i) != comp) continue;
            return i;
        }
        return -1;
    }

    public JTabbedPane getTabbedPane() {
        return this.tabbedPane;
    }

    public void setTabTitle(JComponent comp, String title, String toolTip) {
        int index = this.getTabIndex(comp);
        this.tabbedPane.setTitleAt(index, title);
        this.tabbedPane.setToolTipTextAt(index, toolTip);
    }

    private static Action enableToggle(Action a, boolean initialValue) {
        a.putValue("SwingSelectedKey", String.valueOf(initialValue));
        return a;
    }

    private static Action enableToggle(Action a) {
        return JabRefFrame.enableToggle(a, false);
    }

    private void fillMenu() {
        this.mb.setBorder(null);
        JMenu file = JabRefFrame.subMenu(Localization.menuTitle("File", new String[0]));
        JMenu edit = JabRefFrame.subMenu(Localization.menuTitle("Edit", new String[0]));
        JMenu search = JabRefFrame.subMenu(Localization.menuTitle("Search", new String[0]));
        JMenu groups = JabRefFrame.subMenu(Localization.menuTitle("Groups", new String[0]));
        JMenu bibtex = JabRefFrame.subMenu("&BibTeX");
        JMenu quality = JabRefFrame.subMenu(Localization.menuTitle("Quality", new String[0]));
        JMenu view = JabRefFrame.subMenu(Localization.menuTitle("View", new String[0]));
        JMenu tools = JabRefFrame.subMenu(Localization.menuTitle("Tools", new String[0]));
        JMenu options = JabRefFrame.subMenu(Localization.menuTitle("Options", new String[0]));
        this.newSpec = JabRefFrame.subMenu(Localization.menuTitle("New entry by type...", new String[0]));
        JMenu helpMenu = JabRefFrame.subMenu(Localization.menuTitle("Help", new String[0]));
        file.add(this.newBibtexDatabaseAction);
        file.add(this.newBiblatexDatabaseAction);
        file.add(this.getOpenDatabaseAction());
        file.add(this.mergeDatabaseAction);
        file.add(this.save);
        file.add(this.saveAs);
        file.add(this.saveAll);
        file.add(this.saveSelectedAs);
        file.add(this.saveSelectedAsPlain);
        file.addSeparator();
        file.add(this.importNew);
        file.add(this.importCurrent);
        file.add(this.exportAll);
        file.add(this.exportSelected);
        file.addSeparator();
        file.add(this.connectToSharedDatabaseAction);
        file.add(this.pullChangesFromSharedDatabase);
        file.addSeparator();
        file.add(this.databaseProperties);
        file.add(this.editModeAction);
        file.addSeparator();
        file.add(this.fileHistory);
        file.addSeparator();
        file.add(this.closeDatabaseAction);
        file.add(this.quit);
        this.mb.add(file);
        edit.add(this.undo);
        edit.add(this.redo);
        edit.addSeparator();
        edit.add(this.cut);
        edit.add(this.copy);
        edit.add(this.paste);
        edit.addSeparator();
        edit.add(this.copyKey);
        edit.add(this.copyCiteKey);
        edit.add(this.copyKeyAndTitle);
        edit.add(this.copyKeyAndLink);
        edit.add(this.exportToClipboard);
        edit.add(this.sendAsEmail);
        edit.addSeparator();
        edit.add(this.mark);
        for (int i = 0; i < 5; ++i) {
            this.markSpecific.add(new MarkEntriesAction(this, i).getMenuItem());
        }
        edit.add(this.markSpecific);
        edit.add(this.unmark);
        edit.add(this.unmarkAll);
        edit.addSeparator();
        if (Globals.prefs.getBoolean("specialFieldsEnabled")) {
            boolean menuitem = false;
            if (Globals.prefs.getBoolean("showRankingColumn")) {
                this.rankSubMenu = new JMenu();
                RightClickMenu.populateSpecialFieldMenu(this.rankSubMenu, SpecialField.RANKING, this);
                edit.add(this.rankSubMenu);
                menuitem = true;
            }
            if (Globals.prefs.getBoolean("showRelevanceColumn")) {
                edit.add(this.toggleRelevance);
                menuitem = true;
            }
            if (Globals.prefs.getBoolean("showQualityColumn")) {
                edit.add(this.toggleQualityAssured);
                menuitem = true;
            }
            if (Globals.prefs.getBoolean("showPriorityColumn")) {
                this.rankSubMenu = new JMenu();
                RightClickMenu.populateSpecialFieldMenu(this.rankSubMenu, SpecialField.PRIORITY, this);
                edit.add(this.rankSubMenu);
                menuitem = true;
            }
            if (Globals.prefs.getBoolean("showPrintedColumn")) {
                edit.add(this.togglePrinted);
                menuitem = true;
            }
            if (Globals.prefs.getBoolean("showReadColumn")) {
                this.rankSubMenu = new JMenu();
                RightClickMenu.populateSpecialFieldMenu(this.rankSubMenu, SpecialField.READ_STATUS, this);
                edit.add(this.rankSubMenu);
                menuitem = true;
            }
            if (menuitem) {
                edit.addSeparator();
            }
        }
        edit.add(this.getManageKeywords());
        edit.add(this.getMassSetField());
        edit.addSeparator();
        edit.add(this.selectAll);
        this.mb.add(edit);
        search.add(this.normalSearch);
        search.add(this.replaceAll);
        search.addSeparator();
        search.add(new JCheckBoxMenuItem(this.generalFetcher.getToggleAction()));
        if (this.prefs.getBoolean("webSearchVisible")) {
            this.sidePaneManager.register(this.generalFetcher);
            this.sidePaneManager.show(GeneralFetcher.class);
        }
        this.mb.add(search);
        groups.add(new JCheckBoxMenuItem(this.groupSelector.getToggleAction()));
        if (this.prefs.getBoolean("groupSidepaneVisible")) {
            this.sidePaneManager.register(this.groupSelector);
            this.sidePaneManager.show(GroupSelector.class);
        }
        groups.addSeparator();
        groups.add(this.addToGroup);
        groups.add(this.removeFromGroup);
        groups.add(this.moveToGroup);
        groups.addSeparator();
        JRadioButtonMenuItem toggleHighlightAnyItem = new JRadioButtonMenuItem(this.toggleHighlightAny);
        groups.add(toggleHighlightAnyItem);
        JRadioButtonMenuItem toggleHighlightAllItem = new JRadioButtonMenuItem(this.toggleHighlightAll);
        groups.add(toggleHighlightAllItem);
        JRadioButtonMenuItem toggleHighlightDisableItem = new JRadioButtonMenuItem(this.toggleHighlightDisable);
        groups.add(toggleHighlightDisableItem);
        ButtonGroup highlightButtonGroup = new ButtonGroup();
        highlightButtonGroup.add(toggleHighlightDisableItem);
        highlightButtonGroup.add(toggleHighlightAnyItem);
        highlightButtonGroup.add(toggleHighlightAllItem);
        HighlightMatchingGroupPreferences highlightMatchingGroupPreferences = new HighlightMatchingGroupPreferences(Globals.prefs);
        if (highlightMatchingGroupPreferences.isAll()) {
            toggleHighlightAllItem.setSelected(true);
        } else if (highlightMatchingGroupPreferences.isAny()) {
            toggleHighlightAnyItem.setSelected(true);
        } else {
            toggleHighlightDisableItem.setSelected(true);
        }
        this.mb.add(groups);
        view.add(this.getBackAction());
        view.add(this.getForwardAction());
        view.add(this.focusTable);
        view.add(this.nextTab);
        view.add(this.prevTab);
        view.add(this.sortTabs);
        view.addSeparator();
        view.add(this.increaseFontSize);
        view.add(this.decreseFontSize);
        view.addSeparator();
        view.add(new JCheckBoxMenuItem(this.toggleToolbar));
        view.add(new JCheckBoxMenuItem(JabRefFrame.enableToggle(this.generalFetcher.getToggleAction())));
        view.add(new JCheckBoxMenuItem(this.groupSelector.getToggleAction()));
        view.add(new JCheckBoxMenuItem(this.togglePreview));
        view.add(this.getNextPreviewStyleAction());
        view.add(this.getPreviousPreviewStyleAction());
        this.mb.add(view);
        bibtex.add(this.newEntryAction);
        for (NewEntryAction a : this.newSpecificEntryAction) {
            this.newSpec.add(a);
        }
        bibtex.add(this.newSpec);
        bibtex.add(this.plainTextImport);
        bibtex.addSeparator();
        bibtex.add(this.editEntry);
        bibtex.add(this.editPreamble);
        bibtex.add(this.editStrings);
        bibtex.addSeparator();
        bibtex.add(this.customizeAction);
        bibtex.addSeparator();
        bibtex.add(this.deleteEntry);
        this.mb.add(bibtex);
        quality.add(this.dupliCheck);
        quality.add(this.mergeEntries);
        quality.addSeparator();
        quality.add(this.resolveDuplicateKeys);
        quality.add(this.checkIntegrity);
        quality.add(this.cleanupEntries);
        quality.add(this.massSetField);
        quality.add(this.makeKeyAction);
        quality.addSeparator();
        quality.add(this.autoSetFile);
        quality.add(this.findUnlinkedFiles);
        quality.add(this.autoLinkFile);
        quality.add(this.downloadFullText);
        this.mb.add(quality);
        tools.add(this.newSubDatabaseAction);
        tools.add(this.writeXmpAction);
        tools.add(new JCheckBoxMenuItem(this.openOfficePanel.getToggleAction()));
        tools.add(this.pushExternalButton.getMenuAction());
        tools.addSeparator();
        tools.add(this.openFolder);
        tools.add(this.openFile);
        tools.add(this.openUrl);
        tools.add(this.openConsole);
        tools.addSeparator();
        tools.add(this.abbreviateIso);
        tools.add(this.abbreviateMedline);
        tools.add(this.unabbreviate);
        this.mb.add(tools);
        options.add(this.showPrefs);
        GenFieldsCustomizationAction genFieldsCustomization = new GenFieldsCustomizationAction();
        ProtectedTermsAction protectTerms = new ProtectedTermsAction();
        options.add(genFieldsCustomization);
        options.add(this.customExpAction);
        options.add(this.customImpAction);
        options.add(this.customFileTypesAction);
        options.add(this.manageJournals);
        options.add(protectTerms);
        options.add(this.selectKeys);
        this.mb.add(options);
        helpMenu.add(this.help);
        helpMenu.add(this.openForumAction);
        helpMenu.addSeparator();
        helpMenu.add(this.errorConsole);
        helpMenu.addSeparator();
        helpMenu.add(new SearchForUpdateAction());
        JMenu webMenu = JabRefFrame.subMenu(Localization.menuTitle("JabRef resources", new String[0]));
        webMenu.add(this.jabrefWebPageAction);
        webMenu.add(this.jabrefBlogAction);
        webMenu.add(this.jabrefFacebookAction);
        webMenu.addSeparator();
        webMenu.add(this.forkMeOnGitHubAction);
        webMenu.add(this.developmentVersionAction);
        webMenu.add(this.changeLogAction);
        webMenu.addSeparator();
        webMenu.add(this.donationAction);
        helpMenu.add(webMenu);
        helpMenu.add(this.about);
        this.mb.add(helpMenu);
        this.createDisabledIconsForMenuEntries(this.mb);
    }

    public static JMenu subMenu(String name) {
        JMenu res;
        int i = name.indexOf(38);
        if (i >= 0) {
            res = new JMenu(name.substring(0, i) + name.substring(i + 1));
            char mnemonic = Character.toUpperCase(name.charAt(i + 1));
            res.setMnemonic((int)mnemonic);
        } else {
            res = new JMenu(name);
        }
        return res;
    }

    public void addParserResult(ParserResult pr, boolean focusPanel) {
        if (pr.toOpenTab()) {
            BasePanel panel = this.getCurrentBasePanel();
            if (panel == null) {
                this.addTab(pr.getDatabaseContext(), focusPanel);
            } else {
                ArrayList<BibEntry> entries = new ArrayList<BibEntry>(pr.getDatabase().getEntries());
                this.addImportedEntries(panel, entries, false);
            }
        } else {
            Optional<BasePanel> panel = this.getBasePanelList().stream().filter(p -> p.getBibDatabaseContext().getDatabaseFile().equals(pr.getFile())).findFirst();
            if (panel.isPresent()) {
                this.tabbedPane.setSelectedComponent(panel.get());
            } else {
                this.addTab(pr.getDatabaseContext(), focusPanel);
            }
        }
    }

    private void createToolBar() {
        this.tlb.putClientProperty("jgoodies.headerStyle", HeaderStyle.BOTH);
        this.tlb.setBorder(null);
        this.tlb.setRollover(true);
        this.tlb.setFloatable(false);
        if (Globals.prefs.getBoolean("biblatexMode")) {
            this.tlb.addAction(this.newBiblatexDatabaseAction);
        } else {
            this.tlb.addAction(this.newBibtexDatabaseAction);
        }
        this.tlb.addAction(this.getOpenDatabaseAction());
        this.tlb.addAction(this.save);
        this.tlb.addAction(this.saveAll);
        this.tlb.addSeparator();
        this.tlb.addAction(this.cut);
        this.tlb.addAction(this.copy);
        this.tlb.addAction(this.paste);
        this.tlb.addAction(this.undo);
        this.tlb.addAction(this.redo);
        this.tlb.addSeparator();
        this.tlb.addAction(this.getBackAction());
        this.tlb.addAction(this.getForwardAction());
        this.tlb.addSeparator();
        this.tlb.addAction(this.newEntryAction);
        this.tlb.addAction(this.editEntry);
        this.tlb.addAction(this.editStrings);
        this.tlb.addAction(this.deleteEntry);
        this.tlb.addSeparator();
        this.tlb.addAction(this.makeKeyAction);
        this.tlb.addAction(this.cleanupEntries);
        this.tlb.addAction(this.mergeEntries);
        this.tlb.addAction(this.pullChangesFromSharedDatabase);
        this.tlb.addAction(this.openConsole);
        this.tlb.addSeparator();
        this.tlb.addAction(this.mark);
        this.tlb.addAction(this.unmark);
        if (Globals.prefs.getBoolean("specialFieldsEnabled")) {
            JButton button;
            if (Globals.prefs.getBoolean("showRankingColumn")) {
                button = SpecialFieldDropDown.generateSpecialFieldButtonWithDropDown(SpecialField.RANKING, this);
                this.tlb.add(button);
                this.specialFieldButtons.add(button);
            }
            if (Globals.prefs.getBoolean("showRelevanceColumn")) {
                this.tlb.addAction(this.toggleRelevance);
            }
            if (Globals.prefs.getBoolean("showQualityColumn")) {
                this.tlb.addAction(this.toggleQualityAssured);
            }
            if (Globals.prefs.getBoolean("showPriorityColumn")) {
                button = SpecialFieldDropDown.generateSpecialFieldButtonWithDropDown(SpecialField.PRIORITY, this);
                this.tlb.add(button);
                this.specialFieldButtons.add(button);
            }
            if (Globals.prefs.getBoolean("showPrintedColumn")) {
                this.tlb.addAction(this.togglePrinted);
            }
            if (Globals.prefs.getBoolean("showReadColumn")) {
                button = SpecialFieldDropDown.generateSpecialFieldButtonWithDropDown(SpecialField.READ_STATUS, this);
                this.tlb.add(button);
                this.specialFieldButtons.add(button);
            }
        }
        this.tlb.addSeparator();
        this.tlb.addJToggleButton(new JToggleButton(this.generalFetcher.getToggleAction()));
        this.previewToggle = new JToggleButton(this.togglePreview);
        this.tlb.addJToggleButton(this.previewToggle);
        this.tlb.addJToggleButton(new JToggleButton(this.groupSelector.getToggleAction()));
        this.tlb.addSeparator();
        this.tlb.add(this.pushExternalButton.getComponent());
        this.tlb.addSeparator();
        this.tlb.add(this.donationAction);
        this.tlb.add(this.forkMeOnGitHubAction);
        this.createDisabledIconsForButtons(this.tlb);
    }

    public void output(String s) {
        SwingUtilities.invokeLater(() -> {
            this.statusLine.setText(s);
            this.statusLine.repaint();
        });
    }

    private void initActions() {
        this.openDatabaseOnlyActions.clear();
        this.openDatabaseOnlyActions.addAll(Arrays.asList(this.mergeDatabaseAction, this.newSubDatabaseAction, this.save, this.saveAs, this.saveSelectedAs, this.saveSelectedAsPlain, this.editModeAction, this.undo, this.redo, this.cut, this.deleteEntry, this.copy, this.paste, this.mark, this.markSpecific, this.unmark, this.unmarkAll, this.rankSubMenu, this.editEntry, this.selectAll, this.copyKey, this.copyCiteKey, this.copyKeyAndTitle, this.copyKeyAndLink, this.editPreamble, this.editStrings, this.groupSelector.getToggleAction(), this.makeKeyAction, this.normalSearch, this.generalFetcher.getToggleAction(), this.mergeEntries, this.cleanupEntries, this.exportToClipboard, this.replaceAll, this.sendAsEmail, this.downloadFullText, this.writeXmpAction, this.openOfficePanel.getToggleAction(), this.findUnlinkedFiles, this.addToGroup, this.removeFromGroup, this.moveToGroup, this.autoLinkFile, this.resolveDuplicateKeys, this.openUrl, this.openFolder, this.openFile, this.togglePreview, this.dupliCheck, this.autoSetFile, this.newEntryAction, this.newSpec, this.customizeAction, this.plainTextImport, this.getMassSetField(), this.getManageKeywords(), this.pushExternalButton.getMenuAction(), this.closeDatabaseAction, this.getNextPreviewStyleAction(), this.getPreviousPreviewStyleAction(), this.checkIntegrity, this.toggleHighlightAny, this.toggleHighlightAll, this.toggleHighlightDisable, this.databaseProperties, this.abbreviateIso, this.abbreviateMedline, this.unabbreviate, this.exportAll, this.exportSelected, this.importCurrent, this.saveAll, this.focusTable, this.increaseFontSize, this.decreseFontSize, this.toggleRelevance, this.toggleQualityAssured, this.togglePrinted, this.pushExternalButton.getComponent()));
        this.openDatabaseOnlyActions.addAll(this.newSpecificEntryAction);
        this.openDatabaseOnlyActions.addAll(this.specialFieldButtons);
        this.severalDatabasesOnlyActions.clear();
        this.severalDatabasesOnlyActions.addAll(Arrays.asList(this.nextTab, this.prevTab, this.sortTabs));
        this.openAndSavedDatabasesOnlyActions.addAll(Collections.singletonList(this.openConsole));
        this.sharedDatabaseOnlyActions.addAll(Collections.singletonList(this.pullChangesFromSharedDatabase));
        this.noSharedDatabaseActions.addAll(Arrays.asList(this.save, this.saveAll));
        this.oneEntryOnlyActions.clear();
        this.oneEntryOnlyActions.addAll(Arrays.asList(this.editEntry));
        this.oneEntryWithFileOnlyActions.clear();
        this.oneEntryWithFileOnlyActions.addAll(Arrays.asList(this.openFolder, this.openFile));
        this.oneEntryWithURLorDOIOnlyActions.clear();
        this.oneEntryWithURLorDOIOnlyActions.addAll(Arrays.asList(this.openUrl));
        this.twoEntriesOnlyActions.clear();
        this.twoEntriesOnlyActions.addAll(Arrays.asList(this.mergeEntries));
        this.tabbedPane.addChangeListener(event -> this.updateEnabledState());
    }

    private static void setEnabled(List<Object> list, boolean enabled) {
        for (Object actionOrComponent : list) {
            if (actionOrComponent instanceof Action) {
                ((Action)actionOrComponent).setEnabled(enabled);
            }
            if (!(actionOrComponent instanceof Component)) continue;
            ((Component)actionOrComponent).setEnabled(enabled);
            if (!(actionOrComponent instanceof JPanel)) continue;
            JPanel root = (JPanel)actionOrComponent;
            for (int index = 0; index < root.getComponentCount(); ++index) {
                root.getComponent(index).setEnabled(enabled);
            }
        }
    }

    public void updateEnabledState() {
        int tabCount = this.tabbedPane.getTabCount();
        if (tabCount != this.previousTabCount) {
            this.previousTabCount = tabCount;
            JabRefFrame.setEnabled(this.openDatabaseOnlyActions, tabCount > 0);
            JabRefFrame.setEnabled(this.severalDatabasesOnlyActions, tabCount > 1);
        }
        if (tabCount == 0) {
            this.getBackAction().setEnabled(false);
            this.getForwardAction().setEnabled(false);
            JabRefFrame.setEnabled(this.openAndSavedDatabasesOnlyActions, false);
            JabRefFrame.setEnabled(this.sharedDatabaseOnlyActions, false);
        }
        if (tabCount > 0) {
            BasePanel current = this.getCurrentBasePanel();
            boolean saved = current.getBibDatabaseContext().getDatabaseFile().isPresent();
            JabRefFrame.setEnabled(this.openAndSavedDatabasesOnlyActions, saved);
            boolean isShared = current.getBibDatabaseContext().getLocation() == DatabaseLocation.SHARED;
            JabRefFrame.setEnabled(this.sharedDatabaseOnlyActions, isShared);
            JabRefFrame.setEnabled(this.noSharedDatabaseActions, !isShared);
            boolean oneEntrySelected = current.getSelectedEntries().size() == 1;
            JabRefFrame.setEnabled(this.oneEntryOnlyActions, oneEntrySelected);
            JabRefFrame.setEnabled(this.oneEntryWithFileOnlyActions, this.isExistFile(current.getSelectedEntries()));
            JabRefFrame.setEnabled(this.oneEntryWithURLorDOIOnlyActions, this.isExistURLorDOI(current.getSelectedEntries()));
            boolean twoEntriesSelected = current.getSelectedEntries().size() == 2;
            JabRefFrame.setEnabled(this.twoEntriesOnlyActions, twoEntriesSelected);
        }
    }

    public void setupAllTables() {
        for (int i = 0; i < this.tabbedPane.getTabCount(); ++i) {
            BasePanel bf = this.getBasePanelAt(i);
            if (bf.getDatabase() == null) continue;
            bf.setupMainPanel();
        }
    }

    private List<String> collectDatabaseFilePaths() {
        ArrayList<String> dbPaths = new ArrayList<String>(this.getBasePanelCount());
        for (BasePanel basePanel : this.getBasePanelList()) {
            try {
                if (basePanel.getBibDatabaseContext().getDatabaseFile().isPresent()) {
                    dbPaths.add(basePanel.getBibDatabaseContext().getDatabaseFile().get().getCanonicalPath());
                    continue;
                }
                dbPaths.add("");
            }
            catch (IOException ex) {
                LOGGER.error("Invalid database file path: " + ex.getMessage());
            }
        }
        return dbPaths;
    }

    private List<String> getUniquePathParts() {
        List<String> dbPaths = this.collectDatabaseFilePaths();
        return FileUtil.uniquePathSubstrings(dbPaths);
    }

    public void updateAllTabTitles() {
        List<String> paths = this.getUniquePathParts();
        for (int i = 0; i < this.getBasePanelCount(); ++i) {
            String uniqPath = paths.get(i);
            Optional<File> file = this.getBasePanelAt(i).getBibDatabaseContext().getDatabaseFile();
            if (file.isPresent()) {
                if (!uniqPath.equals(file.get().getName())) {
                    uniqPath = uniqPath.substring(0, uniqPath.lastIndexOf(File.separator));
                    this.tabbedPane.setTitleAt(i, this.getBasePanelAt(i).getTabTitle() + " \u2014 " + uniqPath);
                } else {
                    this.tabbedPane.setTitleAt(i, this.getBasePanelAt(i).getTabTitle());
                }
            } else {
                this.tabbedPane.setTitleAt(i, this.getBasePanelAt(i).getTabTitle());
            }
            this.tabbedPane.setToolTipTextAt(i, file.map(File::getAbsolutePath).orElse(null));
        }
    }

    public void addTab(BasePanel basePanel, boolean raisePanel) {
        this.tabbedPane.add(basePanel.getTabTitle(), basePanel);
        this.updateAllTabTitles();
        if (raisePanel) {
            this.tabbedPane.setSelectedComponent(basePanel);
        }
        basePanel.getUndoManager().registerListener(new UndoRedoEventManager());
        BibDatabaseContext context = basePanel.getBibDatabaseContext();
        if (this.readyForAutosave(context)) {
            AutosaveManager autosaver = AutosaveManager.start(context);
            autosaver.registerListener(new AutosaveUIManager(basePanel));
        }
        if (this.readyForBackup(context)) {
            BackupManager.start(context);
        }
    }

    public BasePanel addTab(BibDatabaseContext databaseContext, boolean raisePanel) {
        Objects.requireNonNull(databaseContext);
        BasePanel bp = new BasePanel(this, databaseContext);
        this.addTab(bp, raisePanel);
        return bp;
    }

    private boolean readyForAutosave(BibDatabaseContext context) {
        return (context.getLocation() == DatabaseLocation.SHARED || context.getLocation() == DatabaseLocation.LOCAL && Globals.prefs.getBoolean("localAutoSave")) && context.getDatabaseFile().isPresent();
    }

    private boolean readyForBackup(BibDatabaseContext context) {
        return context.getLocation() == DatabaseLocation.LOCAL && context.getDatabaseFile().isPresent();
    }

    public void createDisabledIconsForMenuEntries(MenuElement menuElement) {
        for (MenuElement subElement : menuElement.getSubElements()) {
            JMenuItem item;
            if (subElement instanceof JMenu || subElement instanceof JPopupMenu) {
                this.createDisabledIconsForMenuEntries(subElement);
                continue;
            }
            if (!(subElement instanceof JMenuItem) || !((item = (JMenuItem)subElement).getIcon() instanceof IconTheme.FontBasedIcon)) continue;
            item.setDisabledIcon(((IconTheme.FontBasedIcon)item.getIcon()).createDisabledIcon());
        }
    }

    public void createDisabledIconsForButtons(Container container) {
        for (int index = 0; index < container.getComponentCount(); ++index) {
            Component component = container.getComponent(index);
            if (component instanceof JButton) {
                JButton button = (JButton)component;
                if (!(button.getIcon() instanceof IconTheme.FontBasedIcon)) continue;
                button.setDisabledIcon(((IconTheme.FontBasedIcon)button.getIcon()).createDisabledIcon());
                continue;
            }
            if (!(component instanceof JPanel)) continue;
            this.createDisabledIconsForButtons((JPanel)component);
        }
    }

    private void addImportedEntries(BasePanel panel, List<BibEntry> entries, boolean openInNew) {
        SwingUtilities.invokeLater(() -> {
            ImportInspectionDialog diag = new ImportInspectionDialog(this, panel, Localization.lang("Import", new String[0]), openInNew);
            diag.addEntries(entries);
            diag.entryListComplete();
            diag.setLocationRelativeTo(this);
            diag.setVisible(true);
            diag.toFront();
        });
    }

    public FileHistoryMenu getFileHistory() {
        return this.fileHistory;
    }

    public void block() {
        this.changeBlocking(true);
    }

    public void unblock() {
        this.changeBlocking(false);
    }

    private void changeBlocking(boolean blocked) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.getGlassPane().setVisible(blocked);
        } else {
            try {
                SwingUtilities.invokeAndWait(() -> this.getGlassPane().setVisible(blocked));
            }
            catch (InterruptedException | InvocationTargetException e) {
                LOGGER.error("Problem " + (blocked ? "" : "un") + "blocking UI", e);
            }
        }
    }

    public void setProgressBarVisible(boolean visible) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.progressBar.setVisible(visible);
        } else {
            SwingUtilities.invokeLater(() -> this.progressBar.setVisible(visible));
        }
    }

    public void setProgressBarValue(int value) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.progressBar.setValue(value);
        } else {
            SwingUtilities.invokeLater(() -> this.progressBar.setValue(value));
        }
    }

    public void setProgressBarIndeterminate(boolean value) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.progressBar.setIndeterminate(value);
        } else {
            SwingUtilities.invokeLater(() -> this.progressBar.setIndeterminate(value));
        }
    }

    public void setProgressBarMaximum(int value) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.progressBar.setMaximum(value);
        } else {
            SwingUtilities.invokeLater(() -> this.progressBar.setMaximum(value));
        }
    }

    private boolean isExistFile(List<BibEntry> selectEntryList) {
        if (selectEntryList.size() == 1) {
            BibEntry selectedEntry = selectEntryList.get(0);
            return selectedEntry.getField("file").isPresent();
        }
        return false;
    }

    private boolean isExistURLorDOI(List<BibEntry> selectEntryList) {
        if (selectEntryList.size() == 1) {
            BibEntry selectedEntry = selectEntryList.get(0);
            return selectedEntry.getField("url").isPresent() || selectedEntry.getField("doi").isPresent();
        }
        return false;
    }

    @Override
    public void showMessage(String message, String title, int msgType) {
        JOptionPane.showMessageDialog(this, message, title, msgType);
    }

    @Override
    public void setStatus(String s) {
        this.output(s);
    }

    @Override
    public void showMessage(String message) {
        JOptionPane.showMessageDialog(this, message);
    }

    private int showSaveDialog(String filename) {
        Object[] options = new Object[]{Localization.lang("Save changes", new String[0]), Localization.lang("Discard changes", new String[0]), Localization.lang("Return to JabRef", new String[0])};
        return JOptionPane.showOptionDialog(this, Localization.lang("Database '%0' has changed.", filename), Localization.lang("Save before closing", new String[0]), 1, 2, null, options, options[2]);
    }

    private void closeTab(BasePanel panel) {
        if (panel == null) {
            return;
        }
        BibDatabaseContext context = panel.getBibDatabaseContext();
        if (panel.isModified() && context.getLocation() == DatabaseLocation.LOCAL) {
            if (this.confirmClose(panel)) {
                this.removeTab(panel);
            }
        } else if (context.getLocation() == DatabaseLocation.SHARED) {
            context.convertToLocalDatabase();
            context.getDBMSSynchronizer().closeSharedDatabase();
            context.clearDBMSSynchronizer();
            this.removeTab(panel);
        } else {
            this.removeTab(panel);
        }
        AutosaveManager.shutdown(context);
        BackupManager.shutdown(context);
    }

    private boolean confirmClose(BasePanel panel) {
        boolean close = false;
        String filename = panel.getBibDatabaseContext().getDatabaseFile().map(File::getAbsolutePath).orElse(GUIGlobals.UNTITLED_TITLE);
        int answer = this.showSaveDialog(filename);
        if (answer == 0) {
            try {
                SaveDatabaseAction saveAction = new SaveDatabaseAction(panel);
                saveAction.runCommand();
                if (saveAction.isSuccess()) {
                    close = true;
                }
            }
            catch (Throwable throwable) {}
        } else if (answer == 1) {
            close = true;
        }
        return close;
    }

    private void removeTab(BasePanel panel) {
        panel.cleanUp();
        this.tabbedPane.remove(panel);
        if (this.tabbedPane.getTabCount() > 0) {
            this.markActiveBasePanel();
        }
        this.setWindowTitle();
        this.updateEnabledState();
        this.output(Localization.lang("Closed database", new String[0]) + '.');
        this.updateAllTabTitles();
    }

    public void closeCurrentTab() {
        this.removeTab(this.getCurrentBasePanel());
    }

    public ManageKeywordsAction getManageKeywords() {
        return this.manageKeywords;
    }

    public MassSetFieldAction getMassSetField() {
        return this.massSetField;
    }

    public OpenDatabaseAction getOpenDatabaseAction() {
        return this.open;
    }

    public String getStatusLineText() {
        return this.statusLine.getText();
    }

    public AbstractAction getForwardAction() {
        return this.forward;
    }

    public AbstractAction getBackAction() {
        return this.back;
    }

    public AbstractAction getNextPreviewStyleAction() {
        return this.nextPreviewStyle;
    }

    public AbstractAction getPreviousPreviewStyleAction() {
        return this.previousPreviewStyle;
    }

    public JSplitPane getSplitPane() {
        return this.splitPane;
    }

    public SidePaneManager getSidePaneManager() {
        return this.sidePaneManager;
    }

    public GroupSelector getGroupSelector() {
        return this.groupSelector;
    }

    public void setPreviewToggle(boolean enabled) {
        this.previewToggle.setSelected(enabled);
    }

    public PushToApplications getPushApplications() {
        return this.pushApplications;
    }

    public GlobalSearchBar getGlobalSearchBar() {
        return this.globalSearchBar;
    }

    private class UndoRedoEventManager {
        private UndoRedoEventManager() {
        }

        @Subscribe
        public void listen(UndoRedoEvent event) {
            this.updateTexts(event);
            JabRefFrame.this.getCurrentBasePanel().updateEntryEditorIfShowing();
        }

        @Subscribe
        public void listen(AddUndoableActionEvent event) {
            this.updateTexts(event);
        }

        private void updateTexts(UndoChangeEvent event) {
            SwingUtilities.invokeLater(() -> {
                JabRefFrame.this.undo.putValue("ShortDescription", event.getUndoDescription());
                JabRefFrame.this.undo.setEnabled(event.isCanUndo());
                JabRefFrame.this.redo.putValue("ShortDescription", event.getRedoDescription());
                JabRefFrame.this.redo.setEnabled(event.isCanRedo());
            });
        }
    }

    private class ToolBar
    extends OSXCompatibleToolbar {
        private ToolBar() {
        }

        public void addAction(Action a) {
            Object obj;
            JButton b = new JButton(a);
            b.setText(null);
            if (!OS.OS_X) {
                b.setMargin(JabRefFrame.this.marg);
            }
            if ((obj = a.getValue("SwingLargeIconKey")) instanceof IconTheme.FontBasedIcon) {
                b.setDisabledIcon(((IconTheme.FontBasedIcon)obj).createDisabledIcon());
            }
            this.add(b);
        }

        public void addJToggleButton(JToggleButton button) {
            Object obj;
            button.setText(null);
            if (!OS.OS_X) {
                button.setMargin(JabRefFrame.this.marg);
            }
            if ((obj = button.getAction().getValue("SwingLargeIconKey")) instanceof IconTheme.FontBasedIcon) {
                button.setDisabledIcon(((IconTheme.FontBasedIcon)obj).createDisabledIcon());
            }
            this.add(button);
        }
    }

    private class CloseOtherDatabasesAction
    extends MnemonicAwareAction {
        private CloseOtherDatabasesAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Component[] panels;
            BasePanel active = JabRefFrame.this.getCurrentBasePanel();
            for (Component p : panels = JabRefFrame.this.tabbedPane.getComponents()) {
                if (Objects.equals(p, active)) continue;
                JabRefFrame.this.closeTab((BasePanel)p);
            }
        }
    }

    private class CloseAllDatabasesAction
    extends MnemonicAwareAction {
        private CloseAllDatabasesAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Component[] panels;
            for (Component p : panels = JabRefFrame.this.tabbedPane.getComponents()) {
                JabRefFrame.this.closeTab((BasePanel)p);
            }
        }
    }

    private class CloseDatabaseAction
    extends MnemonicAwareAction {
        public CloseDatabaseAction() {
            super(IconTheme.JabRefIcon.CLOSE.getSmallIcon());
            this.putValue("Name", Localization.menuTitle("Close database", new String[0]));
            this.putValue("ShortDescription", Localization.lang("Close the current database", new String[0]));
            this.putValue("AcceleratorKey", Globals.getKeyPrefs().getKey(KeyBinding.CLOSE_DATABASE));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JabRefFrame.this.closeTab(JabRefFrame.this.getCurrentBasePanel());
        }
    }

    private static class MyGlassPane
    extends JPanel {
        public MyGlassPane() {
            this.addKeyListener(new KeyAdapter(){});
            this.addMouseListener(new MouseAdapter(){});
            super.setCursor(Cursor.getPredefinedCursor(3));
        }

        @Override
        public boolean isOpaque() {
            return false;
        }
    }

    private class DecreaseTableFontSizeAction
    extends MnemonicAwareAction {
        public DecreaseTableFontSizeAction() {
            this.putValue("Name", Localization.menuTitle("Decrease table font size", new String[0]));
            this.putValue("AcceleratorKey", Globals.getKeyPrefs().getKey(KeyBinding.DECREASE_TABLE_FONT_SIZE));
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            int currentSize = GUIGlobals.currentFont.getSize();
            if (currentSize < 2) {
                return;
            }
            GUIGlobals.currentFont = new Font(GUIGlobals.currentFont.getFamily(), GUIGlobals.currentFont.getStyle(), currentSize - 1);
            Globals.prefs.putInt("fontSize", currentSize - 1);
            for (BasePanel basePanel : JabRefFrame.this.getBasePanelList()) {
                basePanel.updateTableFont();
            }
            JabRefFrame.this.setStatus(Localization.lang("Table font size is %0", String.valueOf(GUIGlobals.currentFont.getSize())));
        }
    }

    private class IncreaseTableFontSizeAction
    extends MnemonicAwareAction {
        public IncreaseTableFontSizeAction() {
            this.putValue("Name", Localization.menuTitle("Increase table font size", new String[0]));
            this.putValue("AcceleratorKey", Globals.getKeyPrefs().getKey(KeyBinding.INCREASE_TABLE_FONT_SIZE));
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            int currentSize = GUIGlobals.currentFont.getSize();
            GUIGlobals.currentFont = new Font(GUIGlobals.currentFont.getFamily(), GUIGlobals.currentFont.getStyle(), currentSize + 1);
            Globals.prefs.putInt("fontSize", currentSize + 1);
            for (BasePanel basePanel : JabRefFrame.this.getBasePanelList()) {
                basePanel.updateTableFont();
            }
            JabRefFrame.this.setStatus(Localization.lang("Table font size is %0", String.valueOf(GUIGlobals.currentFont.getSize())));
        }
    }

    private class BibtexKeyPatternAction
    extends MnemonicAwareAction {
        private BibtexKeyPatternDialog bibtexKeyPatternDialog;

        public BibtexKeyPatternAction() {
            this.putValue("Name", Localization.lang("BibTeX key patterns", new String[0]));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JabRefPreferences.getInstance();
            if (this.bibtexKeyPatternDialog == null) {
                this.bibtexKeyPatternDialog = new BibtexKeyPatternDialog(JabRefFrame.this, JabRefFrame.this.getCurrentBasePanel());
            } else {
                this.bibtexKeyPatternDialog.setPanel(JabRefFrame.this.getCurrentBasePanel());
            }
            this.bibtexKeyPatternDialog.setLocationRelativeTo(JabRefFrame.this);
            this.bibtexKeyPatternDialog.setVisible(true);
        }
    }

    private class DatabasePropertiesAction
    extends MnemonicAwareAction {
        private DatabasePropertiesDialog propertiesDialog;

        public DatabasePropertiesAction() {
            this.putValue("Name", Localization.menuTitle("Database properties", new String[0]));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (this.propertiesDialog == null) {
                this.propertiesDialog = new DatabasePropertiesDialog(JabRefFrame.this);
            }
            this.propertiesDialog.setPanel(JabRefFrame.this.getCurrentBasePanel());
            this.propertiesDialog.updateEnableStatus();
            this.propertiesDialog.setLocationRelativeTo(JabRefFrame.this);
            this.propertiesDialog.setVisible(true);
        }
    }

    private class ProtectedTermsAction
    extends MnemonicAwareAction {
        public ProtectedTermsAction() {
            this.putValue("Name", Localization.menuTitle("Manage protected terms", new String[0]));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ProtectedTermsDialog protectTermsDialog = new ProtectedTermsDialog(JabRefFrame.this, Globals.protectedTermsLoader);
            protectTermsDialog.setVisible(true);
        }
    }

    private class GenFieldsCustomizationAction
    extends MnemonicAwareAction {
        public GenFieldsCustomizationAction() {
            this.putValue("Name", Localization.menuTitle("Set up general fields", new String[0]));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GenFieldsCustomizer gf = new GenFieldsCustomizer(JabRefFrame.this);
            gf.setLocationRelativeTo(JabRefFrame.this);
            gf.setVisible(true);
        }
    }

    private class CustomizeEntryTypeAction
    extends MnemonicAwareAction {
        public CustomizeEntryTypeAction() {
            this.putValue("Name", Localization.menuTitle("Customize entry types", new String[0]));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            EntryCustomizationDialog dl = new EntryCustomizationDialog(JabRefFrame.this);
            dl.setLocationRelativeTo(JabRefFrame.this);
            dl.setVisible(true);
        }
    }

    private class CustomizeImportsAction
    extends MnemonicAwareAction {
        public CustomizeImportsAction() {
            this.putValue("Name", Localization.menuTitle("Manage custom imports", new String[0]));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ImportCustomizationDialog ecd = new ImportCustomizationDialog(JabRefFrame.this);
            ecd.setVisible(true);
        }
    }

    private class CustomizeExportsAction
    extends MnemonicAwareAction {
        public CustomizeExportsAction() {
            this.putValue("Name", Localization.menuTitle("Manage custom exports", new String[0]));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ExportCustomizationDialog ecd = new ExportCustomizationDialog(JabRefFrame.this);
            ecd.setVisible(true);
        }
    }

    private class EditAction
    extends MnemonicAwareAction {
        private final String command;

        public EditAction(String command, String menuTitle, String description, KeyStroke key, Icon icon) {
            super(icon);
            this.command = command;
            this.putValue("Name", menuTitle);
            this.putValue("AcceleratorKey", key);
            this.putValue("ShortDescription", description);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            LOGGER.debug(Globals.getFocusListener().getFocused().toString());
            JComponent source = Globals.getFocusListener().getFocused();
            Action action = source.getActionMap().get(this.command);
            if (action != null) {
                action.actionPerformed(new ActionEvent(source, 0, this.command));
            }
        }
    }

    private class ChangeTabAction
    extends MnemonicAwareAction {
        private final boolean next;

        public ChangeTabAction(boolean next) {
            this.putValue("Name", next ? Localization.menuTitle("Next tab", new String[0]) : Localization.menuTitle("Previous tab", new String[0]));
            this.next = next;
            this.putValue("AcceleratorKey", next ? Globals.getKeyPrefs().getKey(KeyBinding.NEXT_TAB) : Globals.getKeyPrefs().getKey(KeyBinding.PREVIOUS_TAB));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int newI;
            int i = JabRefFrame.this.tabbedPane.getSelectedIndex();
            int n = newI = this.next ? i + 1 : i - 1;
            if (newI < 0) {
                newI = JabRefFrame.this.tabbedPane.getTabCount() - 1;
            }
            if (newI == JabRefFrame.this.tabbedPane.getTabCount()) {
                newI = 0;
            }
            JabRefFrame.this.tabbedPane.setSelectedIndex(newI);
        }
    }

    private class ShowPrefsAction
    extends MnemonicAwareAction {
        public ShowPrefsAction() {
            super(IconTheme.JabRefIcon.PREFERENCES.getIcon());
            this.putValue("Name", Localization.menuTitle("Preferences", new String[0]));
            this.putValue("ShortDescription", Localization.lang("Preferences", new String[0]));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JabRefFrame.this.showPreferencesDialog();
        }
    }

    private class CloseAction
    extends MnemonicAwareAction {
        public CloseAction() {
            this.putValue("Name", Localization.menuTitle("Quit", new String[0]));
            this.putValue("ShortDescription", Localization.lang("Quit JabRef", new String[0]));
            this.putValue("AcceleratorKey", Globals.getKeyPrefs().getKey(KeyBinding.QUIT_JABREF));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JabRefFrame.this.quit();
        }
    }

    private class SelectKeysAction
    extends AbstractAction {
        public SelectKeysAction() {
            super(Localization.lang("Customize key bindings", new String[0]));
            this.putValue("SmallIcon", IconTheme.JabRefIcon.KEY_BINDINGS.getSmallIcon());
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            KeyBindingsDialog d = new KeyBindingsDialog(new KeyBindingRepository(Globals.getKeyPrefs().getKeyBindings()));
            d.setDefaultCloseOperation(2);
            d.pack();
            d.setLocationRelativeTo(JabRefFrame.this);
            d.setVisible(true);
        }
    }

    private class GeneralAction
    extends MnemonicAwareAction {
        private final String command;

        public GeneralAction(String command, String text) {
            this.command = command;
            this.putValue("Name", text);
        }

        public GeneralAction(String command, String text, String description) {
            this.command = command;
            this.putValue("Name", text);
            this.putValue("ShortDescription", description);
        }

        public GeneralAction(String command, String text, Icon icon) {
            super(icon);
            this.command = command;
            this.putValue("Name", text);
        }

        public GeneralAction(String command, String text, String description, Icon icon) {
            super(icon);
            this.command = command;
            this.putValue("Name", text);
            this.putValue("ShortDescription", description);
        }

        public GeneralAction(String command, String text, KeyStroke key) {
            this.command = command;
            this.putValue("Name", text);
            this.putValue("AcceleratorKey", key);
        }

        public GeneralAction(String command, String text, String description, KeyStroke key) {
            this.command = command;
            this.putValue("Name", text);
            this.putValue("ShortDescription", description);
            this.putValue("AcceleratorKey", key);
        }

        public GeneralAction(String command, String text, String description, KeyStroke key, Icon icon) {
            super(icon);
            this.command = command;
            this.putValue("Name", text);
            this.putValue("ShortDescription", description);
            this.putValue("AcceleratorKey", key);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (JabRefFrame.this.tabbedPane.getTabCount() > 0) {
                try {
                    ((BasePanel)JabRefFrame.this.tabbedPane.getSelectedComponent()).runCommand(this.command);
                }
                catch (Throwable ex) {
                    LOGGER.error("Problem with executing command: " + this.command, ex);
                }
            } else {
                LOGGER.info("Action '" + this.command + "' must be disabled when no database is open.");
            }
        }
    }

    private class EditModeAction
    extends AbstractAction {
        public EditModeAction() {
            this.initName();
        }

        public void initName() {
            if (JabRefFrame.this.getCurrentBasePanel() == null) {
                this.putValue("Name", Localization.menuTitle("Switch to %0 mode", "BibTeX/BibLaTeX"));
            } else {
                BibDatabaseMode mode = JabRefFrame.this.getCurrentBasePanel().getBibDatabaseContext().getMode();
                String modeName = mode.getOppositeMode().getFormattedName();
                this.putValue("Name", Localization.menuTitle("Switch to %0 mode", modeName));
            }
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            if (JabRefFrame.this.getCurrentBasePanel() == null) {
                return;
            }
            BibDatabaseMode newMode = JabRefFrame.this.getCurrentBasePanel().getBibDatabaseContext().getMode().getOppositeMode();
            JabRefFrame.this.getCurrentBasePanel().getBibDatabaseContext().setMode(newMode);
            JabRefFrame.this.refreshTitleAndTabs();
            this.initName();
            JabRefFrame.this.getCurrentBasePanel().hideBottomComponent();
            JabRefFrame.this.getCurrentBasePanel().updateEntryEditorIfShowing();
        }
    }
}

