/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.gui;

import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JEditorPane;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultHighlighter;
import javax.swing.text.Document;
import javax.swing.text.Highlighter;
import javax.swing.text.LayeredHighlighter;
import net.sf.jabref.gui.fieldeditors.JTextAreaWithHighlighting;
import net.sf.jabref.logic.search.SearchQueryHighlightListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JEditorPaneWithHighlighting
extends JEditorPane
implements SearchQueryHighlightListener {
    private static final Log LOGGER = LogFactory.getLog(JTextAreaWithHighlighting.class);

    @Override
    public void highlightPattern(Optional<Pattern> highlightPattern) {
        Highlighter highlighter = this.getHighlighter();
        highlighter.removeAllHighlights();
        if (highlightPattern == null || !highlightPattern.isPresent()) {
            return;
        }
        String text = this.getDocumentText();
        Matcher matcher = highlightPattern.get().matcher(text);
        LayeredHighlighter.LayerPainter painter = DefaultHighlighter.DefaultPainter;
        while (matcher.find()) {
            try {
                highlighter.addHighlight(matcher.start(), matcher.end(), painter);
            }
            catch (BadLocationException ble) {
                LOGGER.warn("Highlighting not possible, bad location", ble);
            }
        }
    }

    private String getDocumentText() {
        String text;
        Document doc = this.getDocument();
        try {
            text = doc.getText(0, doc.getLength());
        }
        catch (Exception e) {
            LOGGER.error("Error while getting document text");
            text = "";
        }
        return text;
    }
}

